package com.elitesland.yst.production.sale.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.el.coordinator.core.common.utils.BeanCopyUtil;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;


import com.elitescloud.cloudt.system.dto.SysUdcDTO;

import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysTaxRateRpcService;
import com.elitescloud.cloudt.system.vo.SysUdcComboVO;
import com.elitesland.yst.production.order.param.*;
import com.elitesland.yst.production.order.service.SalSoRpcService;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.SalReceiptService;
import com.elitesland.yst.production.sale.api.service.shop.SalReceiptStateService;
import com.elitesland.yst.production.sale.api.vo.param.pri.RmiReSoDParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplyCheckParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplyPageParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalReceiptPageParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalReceiptSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.*;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.*;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoDRpcService;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoDService;

import com.elitesland.yst.production.sale.rmi.ystsupport.RmiBrandService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;

import com.elitesland.yst.production.support.provider.item.dto.ItmBrandRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmBrandRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.google.common.collect.Sets;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import com.elitescloud.boot.core.base.UdcProvider;

/**
 * @auther JinXK
 * @date 2021/6/12 9:10
 */
@Service
@RequiredArgsConstructor
@Slf4j
@Valid
public class SalReceiptServiceImpl extends BaseServiceImpl implements SalReceiptService {

    private final SalReceiptRepoProc salReceiptRepoProc;
    private final SalReceiptRepo salReceiptRepo;
    private final SalReceiptdRepoProc salReceiptdRepoProc;
    private final SalReceiptdRepo salReceiptdRepo;
    private final RmiOrderSalSoDService rmiOrderSalSoDService;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final SalSoaRepo salSoaRepo;
    private final RmiDoDRpcService rmiDoDRpcService;
    private final RmiOrgEmpService rmiOrgEmpService;
    private final RmiBrandService rmiBrandService;
    private final RmiCommonService rmiCommonService;
    private final SalReceiptStateService salReceiptStateService;
    private final RmiOrgOuService rmiOrgOuService;
    private final SalInvApplyRepoProc salInvApplyRepoProc;
    private final SalInvApplydRepoProc salInvApplydRepoProc;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final BipOrderRepo bipOrderRepo;
    private final BipOrderBackRepo bipOrderBackRepo;
    private final BipOrderDRepo bipOrderDRepo;
    private final SalSoRpcService salSoRpcService;
    private final SysCurrencyRpcService sysCurrencyRpcService;






    @Autowired
    protected UdcProvider udcProvider;
    @Autowired(required = false)
    private RedissonClient redissonClient;

    @Override
    @SysCodeProc
    public PagingVO<SalReceiptRespVO> query(SalReceiptPageParam pagingParam) {
        var jpaQuery = salReceiptRepoProc.select(pagingParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<SalReceiptRespVO>builder().build();
        }
        // 添加分页和排序
        PageRequest pageRequest = wrapperPageRequest(pagingParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, QSalReceiptDO.salReceiptDO);
        List<SalReceiptRespVO> result = jpaQuery.fetch();
        try {
            List<Long> agentEmpIds = result.stream().filter(dod->dod.getApprUserId()!=null).map(SalReceiptRespVO::getApprUserId).distinct().collect(Collectors.toList());
            if(agentEmpIds.size()>0){
                OrgEmpRpcDtoParam orgEmpRpcDtoParam1 = new OrgEmpRpcDtoParam();
                orgEmpRpcDtoParam1.setEmpIds(agentEmpIds);
                List<OrgEmpRpcDTO> empDtoByParam1 = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam1);
                result.forEach(r -> {
                    empDtoByParam1.forEach(l -> {
                        if(l.getId().equals(r.getApprUserId())){
                            r.setApprUserName(l.getEmpName());
                        }
                    });
                });
            }
            //收款/退款方式 收款/退款类型 赋值
            List<SysUdcDTO> receiptTypeList = udcProvider.listByUdcCode("SAL", Sets.newHashSet("RECEIPT_TYPE"));
            List<SysUdcDTO> payMethodList = udcProvider.listByUdcCode("COM",Sets.newHashSet("PAY_METHOD"));
            List<SysUdcDTO> refoundTypeList = udcProvider.listByUdcCode("SAL",Sets.newHashSet("REFOUND_TYPE"));
            List<SysUdcDTO> refoundMethodList = udcProvider.listByUdcCode("SAL",Sets.newHashSet("REFOUND_METHOD"));
            result.forEach(r -> {
                if(r.getDocType()!=null && r.getDocType().equals("RE")){
                    receiptTypeList.forEach(l -> {
                        if(l.getUdcCode().equals(r.getReceiptType())){
                            r.setReceiptTypeName(l.getUdcDescribe());
                        }
                    });
                    payMethodList.forEach(l -> {
                        if(l.getUdcCode().equals(r.getPayMethod())){
                            r.setPayMethodName(l.getUdcDescribe());
                        }
                    });
                }else {
                    refoundTypeList.forEach(l -> {
                        if(l.getUdcCode().equals(r.getReceiptType())){
                            r.setReceiptTypeName(l.getUdcDescribe());
                        }
                    });
                    refoundMethodList.forEach(l -> {
                        if(l.getUdcCode().equals(r.getPayMethod())){
                            r.setPayMethodName(l.getUdcDescribe());
                        }
                    });
                }
            });
        }catch (Exception e){
            log.error(e.getMessage());
            throw new BusinessException("操作失败:"+e.getMessage());
        }
        //添加明细信息(用于预收款单据的关联订单功能)
        List<Long> masIds = result.stream().map(SalReceiptRespVO::getId).collect(Collectors.toList());
        List<SalReceiptDDO> details = salReceiptdRepo.findByMasIdIn(masIds);
        result.forEach(r -> {
            List<SalReceiptdRespVO> dList = new ArrayList<>();
            details.forEach(d -> {
                SalReceiptdRespVO detail = new SalReceiptdRespVO();
                if(r.getId().equals(d.getMasId())){
                    BeanCopyUtil.beanCopy(d, detail);
                    dList.add(detail);
                }
            });
            r.setSalReceiptdRespVOS(dList);
        });
        PagingVO<SalReceiptRespVO> pageRespVO = PagingVO.<SalReceiptRespVO>builder()
                .total(total)
                .records(result).build();
        return pageRespVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> saveOrSubmit(SalReceiptSaveParam param) {
        log.info("收款/退款单保存入参:"+JSONUtil.toJsonStr(param));
        SalReceiptDO salReceiptDO;
        try {
            salReceiptDO = checkParam(param.getSalReceiptRespVO());
        }catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        //利用Redisson解决单据并发问题(key暂定为docNo)
        String docNo;
        if(StringUtils.isEmpty(salReceiptDO)){
            if(param.getSalReceiptRespVO().getDocType()!=null && param.getSalReceiptRespVO().getDocType().equals("RD")){
                docNo = rmiSysNextNumberService.generateCode(Application.NAME,"RETURN_NO", null);
            }else {
                docNo = rmiSysNextNumberService.generateCode(Application.NAME,"RE", null);
            }
        }else{
            docNo = salReceiptDO.getDocNo();
        }
        //insertOrUpdate(salReceiptDO,param.getSalReceiptRespVO(),param.getSaveFlag(),param.getOffFlag(),docNo);
        RLock rLock = redissonClient.getLock(docNo);
        try{
            boolean lock = rLock.tryLock(0, 5, TimeUnit.MINUTES);
            if (!lock){
                throw new BusinessException("订单"+docNo+"正在操作中");
            }
            insertOrUpdate(salReceiptDO,param.getSalReceiptRespVO(),param.getSaveFlag(),param.getOffFlag(),docNo);
        }catch (Exception e){
            log.error("收款/退款单保存异常:"+e.getMessage());
            throw new BusinessException(e.getMessage());
        }finally {
            if(rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
        return ApiResult.ok();
    }

    /**
     * 新建or修改收款单方法
     **/
    public ApiResult<Object> insertOrUpdate(SalReceiptDO salReceiptDO, SalReceiptRespVO salReceiptRespVO, String saveFlag, String offFlag, String docNo) {
        if(StringUtils.isEmpty(salReceiptDO)){
            //为空表示走新增逻辑
            salReceiptDO = new SalReceiptDO();
            BeanCopyUtil.beanCopy(salReceiptRespVO, salReceiptDO);
            salReceiptDO.setDocNo(docNo);
            salReceiptDO.setApplyDate(LocalDateTime.now());
        }else {
            //否则走修改逻辑
            BeanCopyUtil.beanCopy(salReceiptRespVO, salReceiptDO);//TODO 赋值操作，细节待修改
            //明细行批量删除
            salReceiptdRepo.deleteAllByMasId(salReceiptDO.getId());
        }
        //关联对账单列表查询
        List<SalSoaDO> soaList = new ArrayList<>();
        if(salReceiptRespVO.getSoaOrSo()!=null && salReceiptRespVO.getSoaOrSo().equals("SOA") && (offFlag==null || !offFlag.equals("R"))) {
            List<Long> soaId = salReceiptRespVO.getSalReceiptdRespVOS().stream().map(SalReceiptdRespVO::getSoaId).distinct().collect(Collectors.toList());
            soaList = salSoaRepo.findByIdIn(soaId);
            soaList.forEach(soa -> {
                if(!soa.getSoaReceiptStatus().equals(UdcEnum.SAL_SOA_RECEIPT_STATUS_10.getValueCode())) {
                    throw new BusinessException("对账单"+soa.getDocNo()+"的对账单收款状态不为待收款");
                }
            });
        }
        //增加收款类型为虚拟收款或预收转收款时，收款方式与收款类型的校验
        if((salReceiptRespVO.getReceiptType().equals("VIRTUAL") || salReceiptRespVO.getReceiptType().equals("DEP_PRE")) &&
                !salReceiptRespVO.getPayMethod().equals("VIRTUAL")){
            throw new BusinessException("虚拟收款或押金转预收类型的单子,收款方式必须为虚拟收款");
        }
        AtomicReference<BigDecimal> amt = new AtomicReference<>(new BigDecimal(0));
        if(salReceiptRespVO.getSalReceiptdRespVOS()!=null && salReceiptRespVO.getSalReceiptdRespVOS().size()>0){
            //预收收款有明细时的校验
            salReceiptRespVO.getSalReceiptdRespVOS().forEach(d -> {
                if(d.getReceiptAmt()==null || d.getReceiptAmt().compareTo(BigDecimal.ZERO)==0){
                    throw new BusinessException("本次收款金额不能等于0");
                }
                amt.set(amt.get().add(d.getReceiptAmt()));
                //收款单的金额校验
                if(salReceiptRespVO.getDocType()!=null && salReceiptRespVO.getDocType().equals("RE")
                        && !salReceiptRespVO.getReceiptType().equals("OFF_PRE") && !salReceiptRespVO.getReceiptType().equals("ONLINE_PRE")){
                    if(salReceiptRespVO.getReceiptType()!=null && salReceiptRespVO.getReceiptType().equals("AR")){
                        //应收款时本次收款金额不能大于应收款余额
                        if(d.getReceiptAmt().compareTo(d.getOpenAmt())>0){
                            throw new BusinessException("应收款时本次收款金额不能大于应收款余额");
                        }
                    }else{
                        //其他情况下是本次收款金额不能大于待收款金额
                        if(d.getReceiptAmt().compareTo(d.getApAmt())>0){
                            throw new BusinessException("本次收款金额不能大于待收款金额");
                        }
                    }
                }
            });
            if(amt.get().compareTo(salReceiptRespVO.getAmt())!=0 && salReceiptRespVO.getDocType().equals("RE")){
                throw new BusinessException("收款金额必须和明细的本次收款金额的合计值相等");
            }
        }
        if("SAVE".equals(saveFlag)){
            salReceiptDO.setDocStatus(UdcEnum.SAL_RECEIPT_STATUS_DRAFT.getValueCode());
        }else{
            salReceiptDO.setDocStatus(UdcEnum.SAL_RECEIPT_STATUS_APPROVING.getValueCode());
        }
        if(StringUtils.isEmpty(salReceiptRespVO.getRelateDocNo())) {
            if(salReceiptRespVO.getReceiptType().equals("AR")
                    && salReceiptRespVO.getReceiptType().equals("VIRTUAL")) {
                throw new BusinessException("当收款类型为账期收款、虚拟收款时，必须关联订单");
            }
            salReceiptDO.setDocStatus2(UdcEnum.SAL_RECEIPT_WRITEOFF_10.getValueCode());
        }
        if("DEPOSIT".equals(salReceiptRespVO.getReceiptType())) {
            //新建押金单时赋初始值操作
            if(StringUtils.isEmpty(salReceiptDO.getTransferAmt())) {
                salReceiptDO.setTransferAmt(BigDecimal.ZERO);
            }
            if(StringUtils.isEmpty(salReceiptDO.getTransferingAmt())) {
                salReceiptDO.setTransferingAmt(BigDecimal.ZERO);
            }
            if(StringUtils.isEmpty(salReceiptDO.getOpenAmt())) {
                salReceiptDO.setOpenAmt(salReceiptDO.getAmt());
            }
        }
        if(salReceiptRespVO.getDocType().equals("RE") && !salReceiptRespVO.getReceiptType().equals("PRE")
                && !salReceiptRespVO.getReceiptType().equals("RED") && salReceiptRespVO.getSalReceiptdRespVOS().size()>0){
            SalSoDetailQueryDTO searchParam = new SalSoDetailQueryDTO();
            searchParam.setDocNo(salReceiptRespVO.getSalReceiptdRespVOS().get(0).getSoNo());
            ApiResult<PagingVO<SalSoDetailRespDTO>> apiResult = salSoRpcService.querySalSoDetail(searchParam);

            if(apiResult.getCode()!=200){
                throw new BusinessException(apiResult.getMsg());
            }
            List<SalSoDetailRespDTO> sodList = apiResult.getData().getRecords();
            if(sodList.size()==0){
                throw new BusinessException("查询不到销售单号信息:"+salReceiptRespVO.getSalReceiptdRespVOS().get(0).getSoNo());
            }else if(sodList.get(0).getDocType().equals("SE")){
                throw new BusinessException("购物卡订单"+sodList.get(0).getDocNo()+"的收款类型必须是预收收款");
            }else if(sodList.get(0).getDocType().equals("SH")){
                throw new BusinessException("提货券订单"+sodList.get(0).getDocNo()+"的收款类型必须是预收收款");
            }
        }
        if(salReceiptRespVO.getReceiptType().equals("ONLINE_PRE") || salReceiptRespVO.getReceiptType().equals("40")){
            //内部调用的单据类型，缺少部分字段，反查补充操作
            Set<String> currCodes = new HashSet<>();
            currCodes.add(salReceiptRespVO.getCurrCode());


            ApiResult<List<SysCurrencyRespDTO>> sysCurrencyRespDTOListApiResult = sysCurrencyRpcService.listByCodes(currCodes);
            Assert.notNull(sysCurrencyRespDTOListApiResult,"查询币种失败");
            Assert.isTrue(sysCurrencyRespDTOListApiResult.isSuccess(),"查询币种失败");

            if(sysCurrencyRespDTOListApiResult.getData().size()>0){
                salReceiptRespVO.setCurrName(sysCurrencyRespDTOListApiResult.getData().get(0).getCurrName());
            }
        }
        if(offFlag != null || salReceiptRespVO.getReceiptType().equals("DEP_PRE")){
            //关联单据操作
            if(StringUtils.isEmpty(salReceiptRespVO.getRelateDocId()) || StringUtils.isEmpty(salReceiptRespVO.getRelateDocNo())) {
                throw new BusinessException("关联单号与ID不能为空");
            }
            Optional<SalReceiptDO> oldOp = salReceiptRepo.findById(salReceiptRespVO.getRelateDocId());
            if(oldOp.isEmpty()){
                throw new BusinessException("关联单据不存在");
            }
            if(oldOp.get().getId().equals(salReceiptDO.getId())) {
                throw new BusinessException("不能关联自己");
            }
            SalReceiptDO oldSa = new SalReceiptDO();
            if(offFlag != null && offFlag.equals("R")) {
                //原单为红冲类单据
                salReceiptDO.setReceiptType("RED");
                oldSa = oldOp.get();
//            if(!oldSa.getDocStatus().equals(UdcEnum.SAL_RECEIPT_STATUS_RECEIVED.getValueCode())) {  todo 暂时注释
//                throw new BusinessException("原单据状态应为已收款");
//            }
                oldSa.setOffFlag("R");
            }
            if(salReceiptRespVO.getReceiptType().equals("DEP_PRE") && "SUBMIT".equals(saveFlag)) {
                //原单为押金类单据
                oldSa = oldOp.get();
                if(salReceiptRespVO.getAmt().compareTo(oldSa.getOpenAmt())>0 || salReceiptRespVO.getAmt().compareTo(BigDecimal.ZERO)<0) {
                    throw new BusinessException("收款金额不能大于押金余额且不能小于0");
                }
                //已转货款金额=已转货款金额+新的货款单的收款金额
                oldSa.setTransferingAmt((oldSa.getTransferingAmt()==null?BigDecimal.ZERO:oldSa.getTransferingAmt()).add(salReceiptRespVO.getAmt()));
                //押金单的押金余额=押金单收款金额-退款金额-已转货款金额-退款中金额
                oldSa.setOpenAmt(oldSa.getAmt().subtract(oldSa.getReturnAmt()==null?BigDecimal.ZERO:oldSa.getReturnAmt())
                        .subtract(oldSa.getTransferingAmt()).subtract(oldSa.getTransferAmt()==null?BigDecimal.ZERO:oldSa.getTransferAmt())
                        .subtract(oldSa.getReturningAmt()==null?BigDecimal.ZERO:oldSa.getReturningAmt()));
            }
            if(offFlag != null && offFlag.equals("T") && "SUBMIT".equals(saveFlag)) {
                //退押金类型单据提交时
                oldSa = oldOp.get();
                BigDecimal absAmt = (salReceiptRespVO.getAmt()==null?BigDecimal.ZERO:salReceiptRespVO.getAmt().abs());//退款金额的绝对值
                if(oldSa.getOpenAmt().compareTo(BigDecimal.ZERO)==0) {
                    throw new BusinessException("押金已退款或在退款中，请勿重复提交");
                }
                if(oldSa.getOpenAmt().compareTo(absAmt)<0){
                    throw new BusinessException("退押金金额大于押金余额，不可提交");
                }
                oldSa.setReturningAmt((oldSa.getReturningAmt()==null?BigDecimal.ZERO:oldSa.getReturningAmt()).add(absAmt));
                oldSa.setOpenAmt((oldSa.getOpenAmt()==null?BigDecimal.ZERO:oldSa.getOpenAmt()).subtract(absAmt));
            }
            salReceiptRepo.save(oldSa);
        }
        //获取当前登录人信息
        if(salReceiptRespVO.getCreateUserId()==null && salReceiptRespVO.getCreator()==null){
            CurrentUserDTO currentUserDTO = UserService.currentUser();
            if(currentUserDTO==null){
                throw new BusinessException("当前登录信息异常");
            }
            log.info("收款单当前登录人信息："+JSONUtil.toJsonStr(currentUserDTO));
            salReceiptDO.setCreateUserId(currentUserDTO.getDetail().getId());
            salReceiptDO.setCreator(currentUserDTO.getDetail().getUsername());
        }
        //数据权限数据赋值
        salReceiptDO.setSecOuId(salReceiptRespVO.getOuId());
        salReceiptDO.setSecBuId(salReceiptRespVO.getBuId());
        salReceiptDO.setSecUserId(salReceiptRespVO.getApplyEmpId());
        salReceiptRepo.save(salReceiptDO);
        log.info("收款/退款单保存成功:"+JSONUtil.toJsonStr(salReceiptDO));
        //明细行批量新增
        Long masId = salReceiptDO.getId();
        List<SalReceiptDDO> detailList = new ArrayList<>();
        AtomicReference<BigDecimal> receiptAmt = new AtomicReference<>(new BigDecimal(0));
        AtomicReference<BigDecimal> receiptTax = new AtomicReference<>(new BigDecimal(0));
        if(salReceiptRespVO.getSalReceiptdRespVOS()!=null && salReceiptRespVO.getSalReceiptdRespVOS().size()>0) {
            salReceiptRespVO.getSalReceiptdRespVOS().forEach(detail ->{
                if(!"SAVE".equals(saveFlag) && detail.getApAmt()!=null && offFlag!=null && !offFlag.equals("R")){
                    if(detail.getReceiptAmt().abs().compareTo(detail.getApAmt().abs())>0){
                        if(salReceiptRespVO.getDocType().equals("RD")){
                            throw new BusinessException("本次退款金额不可大于待退款金额");
                        }else{
                            throw new BusinessException("本次收款金额不可大于待收款金额");
                        }
                    }
                }
                SalReceiptDDO salReceiptDDO = new SalReceiptDDO();
                BeanCopyUtil.beanCopy(detail, salReceiptDDO);
                //数据权限数据赋值
                salReceiptDDO.setSecOuId(salReceiptRespVO.getOuId());
                salReceiptDDO.setSecBuId(salReceiptRespVO.getBuId());
                salReceiptDDO.setSecUserId(salReceiptRespVO.getApplyEmpId());
                salReceiptDDO.setMasId(masId);
                if(offFlag != null && offFlag.equals("R")){
                    //红冲类单据
                    if(detail.getOffAmt().abs().compareTo(detail.getReceiptAmt().abs())==1){
                        throw new BusinessException("红冲金额不可大于本次收款金额");
                    }
                    receiptAmt.set(receiptAmt.get().add(detail.getOffAmt()));
                    receiptTax.set(receiptTax.get().add(detail.getOffTax()));
                    salReceiptDDO.setReceiptAmt(detail.getOffAmt());
                    salReceiptDDO.setReceiptTax(detail.getOffTax());
                }
                detailList.add(salReceiptDDO);
            });
        }else {
            salReceiptDO.setDocStatus2(UdcEnum.SAL_RECEIPT_WRITEOFF_10.getValueCode());
            if(salReceiptRespVO.getAmt().compareTo(BigDecimal.ZERO)==0) {
                throw new BusinessException("收款金额为0时,明细不能为空");
            }
        }
        salReceiptdRepo.saveAll(detailList);
        //明细行保存结束，更新表头部分信息
        if(offFlag != null && offFlag.equals("R")){
            salReceiptDO.setAmt(receiptAmt.get());
            salReceiptDO.setTax(receiptTax.get());
        }
        salReceiptDO.setWriteoffAmt(amt.get());
        if(amt.get().compareTo(salReceiptDO.getAmt()) == 0) {
            salReceiptDO.setDocStatus2(UdcEnum.SAL_RECEIPT_WRITEOFF_30.getValueCode());
        }else if(amt.get().compareTo(BigDecimal.ZERO) != 0) {
            salReceiptDO.setDocStatus2(UdcEnum.SAL_RECEIPT_WRITEOFF_20.getValueCode());
        }
        salReceiptRepo.save(salReceiptDO);
        // 保存附件
        if(salReceiptRespVO.getAttachFiles()!=null&&salReceiptRespVO.getAttachFiles().size()>0){
            comSaleFileInfoService.comSaleFileHardSave("SAL_RECEIPT", salReceiptDO.getId(), salReceiptRespVO.getAttachFiles());
        }
        if(!"SAVE".equals(saveFlag)){
            if(salReceiptRespVO.getDocType()!=null && salReceiptRespVO.getDocType().equals("RD")) {
                if(!(salReceiptRespVO.getReceiptType()!=null && salReceiptRespVO.getReceiptType().equals("30"))){
                    //当为退款单且不为预收退款时
                    Map<Long, BigDecimal> IdAndAmt = new HashMap<>();
                    detailList.forEach(d -> {
                        if(d.getSoDId()!=null && d.getReceiptAmt()!=null) {
                            IdAndAmt.put(d.getSoDId(),d.getReceiptAmt().abs());
                        }
                    });
                    if(IdAndAmt.size()>0){
                        rmiOrderSalSoDService.submitRefund(IdAndAmt);
                    }
                }
            }else {
                if(salReceiptRespVO.getSoaOrSo()!=null && salReceiptRespVO.getSoaOrSo().equals("SOA")) {
                    Long receiptId = salReceiptDO.getId();
                    String receiptDocNo = salReceiptDO.getDocNo();
                    soaList.forEach(soa -> {
                        soa.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_20.getValueCode());
                        soa.setReceiptId(receiptId);
                        soa.setReceiptNo(receiptDocNo);
                    });
                    salSoaRepo.saveAll(soaList);
                }
                //提交成功,反写销售单
                List<Long> sodIdList = detailList.stream().filter(s->s.getSoDId()!=null).map(SalReceiptDDO::getSoDId).collect(Collectors.toList());
                List<SalSoDetailRespDTO> sodList = new ArrayList<>();
                if(sodIdList.size()>0) {
                    sodList = getSodListBySodId(sodIdList);
                    //12/2日新增逻辑-商城线下类型的单子反写bipOrder的已支付金额、支付时间及状态
                    if(salReceiptRespVO.getReceiptType().equals("OFF_PRE")){
                        List<Long> bipOrderDids = sodList.stream().filter(a->a.getRelateDocDid()!=null)
                                .map(SalSoDetailRespDTO::getRelateDocDid).distinct().collect(Collectors.toList());
                        List<BipOrderDDO> orderDs = bipOrderDRepo.findByIdIn(bipOrderDids);
                        if(sodList.size()!=orderDs.size()){
                            log.info("查找商城单子异常:sodList-"+JSONUtil.toJsonStr(sodList)+";orderDList-"+JSONUtil.toJsonStr(orderDs));
                            throw new BusinessException("查找商城单子异常");
                        }
                        List<Long> orderIds = orderDs.stream().map(BipOrderDDO::getOrderId).distinct().collect(Collectors.toList());
                        List<BipOrderDO> orders = bipOrderRepo.findByIdIn(orderIds);
                        Map<Long,BigDecimal> amtMap = new HashMap<>();
                        List<SalSoDetailRespDTO> finalSodList = sodList;
                        detailList.forEach(d -> {
                            finalSodList.forEach(sod -> {
                                if(d.getSoDId().equals(sod.getSoDId())){
                                    amtMap.put(sod.getRelateDocDid(),d.getReceiptAmt());
                                }
                            });
                        });
                        for (Map.Entry<Long,BigDecimal> m : amtMap.entrySet()) {
                            orderDs.forEach(od -> {
                                if(m.getKey().equals(od.getId())){
                                    od.setPayDoneAmt(od.getPayDoneAmt().add(m.getValue()));
                                    orders.forEach(o -> {
                                        if(od.getOrderId().equals(o.getId())){
                                            o.setPayDoneAmt(o.getPayDoneAmt().add(m.getValue()));
                                            o.setPayTime(LocalDateTime.now());
                                            if(o.getPayAmt().compareTo(o.getPayDoneAmt())<=0){
                                                o.setStatus("shipping");
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        bipOrderRepo.saveAll(orders);
                        bipOrderDRepo.saveAll(orderDs);
                    }
                }
                List<SalSoDUpdateDTO> sodUpList = new ArrayList<>();
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setPayingAmt(sod.getPayingAmt()==null?BigDecimal.ZERO:sod.getPayingAmt());
                    salSoDUpdateDTO.setOpenAmt(sod.getOpenAmt()==null?BigDecimal.ZERO:sod.getOpenAmt());
                    salSoDUpdateDTO.setPayedAmt(sod.getPayedAmt()==null?BigDecimal.ZERO:sod.getPayedAmt());
                    detailList.forEach(d -> {
                        if(sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setPayingAmt(salSoDUpdateDTO.getPayingAmt().add(d.getReceiptAmt()));
                            //如果金额为0
                            if(salSoDUpdateDTO.getOpenAmt().compareTo(BigDecimal.ZERO) == 0){
                                salSoDUpdateDTO.setOpenAmt(d.getReceiptAmt());
                            }else {
                                salSoDUpdateDTO.setOpenAmt(salSoDUpdateDTO.getOpenAmt().subtract(d.getReceiptAmt()));
                            }
                        }
                    });
                    if(sod.getConfirmQty().compareTo(BigDecimal.ZERO) == 0){
                        salSoDUpdateDTO.setApAmt((sod.getQty().multiply(sod.getPrice()))
                                .subtract(salSoDUpdateDTO.getPayedAmt()).subtract(salSoDUpdateDTO.getPayingAmt()));
                    }else {
                        salSoDUpdateDTO.setApAmt((sod.getConfirmQty().multiply(sod.getPrice()))
                                .subtract(salSoDUpdateDTO.getPayedAmt()).subtract(salSoDUpdateDTO.getPayingAmt()));
                    }
//                    salSoDUpdateDTO.setApAmt((sod.getConfirmQty().multiply(sod.getPrice()))
//                            .subtract(salSoDUpdateDTO.getPayedAmt()).subtract(salSoDUpdateDTO.getPayingAmt()));
                    sodUpList.add(salSoDUpdateDTO);
                });
                if(sodUpList.size()>0){
                    log.info("收款传OMS数据:"+ JSONUtil.toJsonStr(sodUpList));
                    rmiOrderSalSoDService.bcQuerySalSoDetail(sodUpList);
                }
            }
            //B端商城线上收款和退款，反写商城订单退款是否成功状态
//            if(salReceiptRespVO.getSalReceiptdRespVOS().size()>0 &&
//                    (salReceiptRespVO.getReceiptType().equals("ONLINE_PRE") || salReceiptRespVO.getReceiptType().equals("40"))){
//                bipOrderRepo.updateIsCreateReceipt(salReceiptRespVO.getSalReceiptdRespVOS().get(0).getSoNo());
//            }
            try {
                //调用收款结算单生成功能
                SalReceiptRespVO respVO = BeanUtil.copyProperties(salReceiptDO, SalReceiptRespVO.class);
                List<SalReceiptdRespVO> list = new ArrayList<>();
                detailList.forEach(ddo -> {
                    SalReceiptdRespVO dvo = BeanUtil.copyProperties(ddo, SalReceiptdRespVO.class);
                    list.add(dvo);
                });
                String docType = null;
                if(detailList.stream().filter(a -> a!=null).collect(Collectors.toList()).size() > 0) {
                    SalSoDetailQueryDTO salSoDetailQueryDTO = new SalSoDetailQueryDTO();
                    salSoDetailQueryDTO.setDocNo(detailList.get(0).getSoNo());
                    ApiResult<PagingVO<SalSoDetailRespDTO>> apiResult = salSoRpcService.querySalSoDetail(salSoDetailQueryDTO);
                    if(apiResult.getCode() == 200 && apiResult.getData().getRecords().size()>0) {
                        SalSoDetailRespDTO salSoDetailRespDTO = apiResult.getData().getRecords().get(0);
                        docType = salSoDetailRespDTO.getDocType();
                    }
                }
                salReceiptStateService.createStatement(docType, respVO, list, salReceiptRespVO.getReceiptSerial());
            }catch (Exception e){
                log.error(e.getMessage());
                throw new BusinessException(e.getMessage());
            }
        }
        //throw new BusinessException("调试收款单负数");
        return ApiResult.ok();
    }

    /**
     * 根据明细id获取销售单明细
     */
    private List<SalSoDetailRespDTO> getSodListBySodId(List<Long> sodIds){
        List<SalSoDetailRespDTO> sodList = new ArrayList<>();
        if(sodIds.size()>0){
            SalSoDetailQueryDTO salSoDetailQueryDTO = new SalSoDetailQueryDTO();
            salSoDetailQueryDTO.setSoDIdList(sodIds);
            salSoDetailQueryDTO.setSize(10000);
            ApiResult<PagingVO<SalSoDetailRespDTO>> apiResult = salSoRpcService.querySalSoDetail(salSoDetailQueryDTO);
            if(apiResult.getCode()!=200){
                throw new BusinessException(apiResult.getMsg());
            }
            sodList = apiResult.getData().getRecords();
        }
        return sodList;
    }


    /**
     * 入参校验--非空校验
     */
    private SalReceiptDO checkParam(SalReceiptRespVO param) {
        if(StringUtils.isEmpty(param.getOuId())){
            throw new BusinessException("公司id不能为空");
        }
        if(StringUtils.isEmpty(param.getBuId())){
            throw new BusinessException("销售组织id不能为空");
        }
        if(StringUtils.isEmpty(param.getApplyEmpId())){
            throw new BusinessException("申请人id不能为空");
        }
        // 查询销售开票申请单
        if(StringUtils.isEmpty(param.getId())){
            return null;
        }else{
            Optional<SalReceiptDO> salReceiptDO = salReceiptRepo.findById(param.getId());
            if(salReceiptDO.isEmpty()){
                throw new BusinessException("修改失败,查询不到该id数据");
            }
            return salReceiptDO.get();
        }
    }

    @Override
    @SysCodeProc
    public SalReceiptRespVO getById(Long id) {
        SalReceiptPageParam pagingParam = new SalReceiptPageParam();
        pagingParam.setId(id);
        SalReceiptRespVO salReceiptRespVO = new SalReceiptRespVO();
        List<SalReceiptRespVO> list = salReceiptRepoProc.select(pagingParam).fetch();
        if(list.size()>0){
            salReceiptRespVO = list.get(0);
            try {
                if (!StringUtils.isEmpty(salReceiptRespVO.getApprUserId()) && StringUtils.isEmpty(salReceiptRespVO.getApprUserName())){
                    OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
                    List<Long> agentEmpIds = new ArrayList<>();
                    agentEmpIds.add(salReceiptRespVO.getApprUserId());
                    orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
                    List<OrgEmpRpcDTO> empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
                    if(empDtoByParam.size()>0){
                        salReceiptRespVO.setApprUserName(empDtoByParam.get(0).getEmpName());
                    }
                }
                //收款/退款方式 收款/退款类型 赋值
                String receiptType = salReceiptRespVO.getReceiptType();
                String payMethod = salReceiptRespVO.getPayMethod();
                AtomicReference<String> receiptTypeName = new AtomicReference<>("");
                AtomicReference<String> payMethodName = new AtomicReference<>("");
                if(salReceiptRespVO.getDocType()!=null && salReceiptRespVO.getDocType().equals("RE")){


                    List<SysUdcDTO> receiptTypeList = udcProvider.listByUdcCode("SAL",Sets.newHashSet("RECEIPT_TYPE"));
                    List<SysUdcDTO> payMethodList = udcProvider.listByUdcCode("COM",Sets.newHashSet("PAY_METHOD"));

                    receiptTypeList.forEach(l -> {
                        if(l.getUdcCode().equals(receiptType)){
                            receiptTypeName.set(l.getUdcDescribe());
                        }
                    });
                    payMethodList.forEach(l -> {
                        if(l.getUdcCode().equals(payMethod)){
                            payMethodName.set(l.getUdcDescribe());
                        }
                    });
                }else {
                    List<SysUdcDTO> refoundTypeList = udcProvider.listByUdcCode("SAL",Sets.newHashSet("REFOUND_TYPE"));
                    List<SysUdcDTO> refoundMethodList = udcProvider.listByUdcCode("SAL",Sets.newHashSet("REFOUND_METHOD"));

                    refoundTypeList.forEach(l -> {
                        if(l.getUdcCode().equals(receiptType)){
                            receiptTypeName.set(l.getUdcDescribe());
                        }
                    });
                    refoundMethodList.forEach(l -> {
                        if(l.getUdcCode().equals(payMethod)){
                            payMethodName.set(l.getUdcDescribe());
                        }
                    });
                }
                if(receiptTypeName.get()!=null){
                    salReceiptRespVO.setReceiptTypeName(receiptTypeName.get());
                }
                if(payMethodName.get()!=null){
                    salReceiptRespVO.setPayMethodName(payMethodName.get());
                }
            }catch (Exception e){
                log.error(e.getMessage());
                throw new BusinessException("操作失败:"+e.getMessage());
            }
            //塞入附件信息
            List<ComSaleFileComVO> comSFCList = comSaleFileInfoService.findFileByBusinessId("SAL_RECEIPT", salReceiptRespVO.getId());
            salReceiptRespVO.setAttachFiles(comSFCList);
            List<SalReceiptdRespVO> ddos = salReceiptdRepoProc.findBymasId(salReceiptRespVO.getId()).fetch();
            //反查相关单据的红冲金额,红冲税额
            if("RED".equals(salReceiptRespVO.getReceiptType())) {
                List<SalReceiptdRespVO> relateddos = salReceiptdRepoProc.findBymasId(salReceiptRespVO.getRelateDocId()==null?0:salReceiptRespVO.getRelateDocId()).fetch();
                Map<Long,List<SalReceiptdRespVO>> relateMap = relateddos.stream().collect(Collectors.groupingBy(SalReceiptdRespVO::getSoDId));
                for (Map.Entry<Long,List<SalReceiptdRespVO>> m : relateMap.entrySet()) {
                    ddos.forEach(d -> {
                        if(d.getSoDId().equals(m.getKey())){
                            d.setOffAmt(d.getReceiptAmt()==null? BigDecimal.ZERO:d.getReceiptAmt());
                            d.setOffTax(d.getReceiptTax()==null?BigDecimal.ZERO:d.getReceiptTax());
                            d.setReceiptAmt(m.getValue().get(0).getReceiptAmt()==null? BigDecimal.ZERO:m.getValue().get(0).getReceiptAmt());
                            d.setReceiptTax(m.getValue().get(0).getReceiptTax()==null?BigDecimal.ZERO:m.getValue().get(0).getReceiptTax());
                        }
                    });
                }
            }
            if(salReceiptRespVO.getRelateDocId()!=null) {
                Optional<SalReceiptDO> srdo = salReceiptRepo.findById(salReceiptRespVO.getRelateDocId());
                if(!srdo.isEmpty()){
                    salReceiptRespVO.setRelateReceiptType(srdo.get().getReceiptType());
                    salReceiptRespVO.setRelateOpenAmt(srdo.get().getOpenAmt());
                }
            }
            if(salReceiptRespVO.getDocType()!=null && salReceiptRespVO.getDocType().equals("RD")
                    && !salReceiptRespVO.getReceiptType().equals("30")){
                //根据sodid反查退货单
                List<Long> sodid = ddos.stream().filter(sod->sod.getSoDId()!=null).map(SalReceiptdRespVO::getSoDId).distinct().collect(Collectors.toList());
                if(sodid.size()>0){
                    SalSoDQueryDTO salSoDQueryDTO = new SalSoDQueryDTO();
                    salSoDQueryDTO.setSodIds(sodid);
                    salSoDQueryDTO.setSize(10000);
                    ApiResult<PagingVO<SalSoDRefundRespDTO>> apiResult = rmiOrderSalSoDService.queryRefund(salSoDQueryDTO);
                    if(apiResult.getCode()!=200){
                        throw new BusinessException(apiResult.getMsg());
                    }
                    List<SalSoDRefundRespDTO> sodList = apiResult.getData().getRecords();
                    ddos.forEach(receiptd -> {
                        sodList.forEach(sod -> {
                            if(receiptd.getSoDId()!=null && receiptd.getSoDId().equals(sod.getSodId())){
                                receiptd.setQty(sod.getQty()==null? BigDecimal.ZERO:sod.getQty());
                                receiptd.setConfirmQty(sod.getConfirmQty()==null?BigDecimal.ZERO:sod.getConfirmQty());
                                receiptd.setAmt(sod.getAmt()==null?BigDecimal.ZERO:sod.getAmt());
                                receiptd.setConfirmAmt(sod.getConfirmAmt()==null? BigDecimal.ZERO:sod.getConfirmAmt());
                                receiptd.setRefundAmt(sod.getRefundAmt()==null?BigDecimal.ZERO:sod.getRefundAmt());
                                receiptd.setPayingAmt(sod.getPayingAmt()==null?BigDecimal.ZERO:sod.getPayingAmt());
                                receiptd.setPayedAmt(sod.getPayedAmt()==null? BigDecimal.ZERO:sod.getPayedAmt());
                                receiptd.setOpenAmt(sod.getOpenAmt()==null? BigDecimal.ZERO:sod.getOpenAmt());
                                receiptd.setLineNo(sod.getLineNo()==null?BigDecimal.ZERO:sod.getLineNo());
                                receiptd.setPrice(sod.getPrice()==null?BigDecimal.ZERO:sod.getPrice());
                                receiptd.setNetPrice(sod.getNetPrice()==null?BigDecimal.ZERO:sod.getNetPrice());
                                if(sod.getDocCls()!=null && sod.getDocCls().equals("RSO")){
                                    receiptd.setDocCls(sod.getDocCls());
                                    receiptd.setQty(receiptd.getQty().abs().negate());
                                    receiptd.setConfirmQty(receiptd.getConfirmQty().abs().negate());
                                    receiptd.setAmt(receiptd.getAmt().abs().negate());
                                    receiptd.setConfirmAmt(receiptd.getConfirmAmt().abs().negate());
                                    receiptd.setRefundAmt(receiptd.getRefundAmt().abs().negate());
                                    receiptd.setPayingAmt(receiptd.getPayingAmt().abs().negate());
                                    receiptd.setPayedAmt(receiptd.getPayedAmt().abs().negate());
                                    receiptd.setOpenAmt(receiptd.getOpenAmt().abs().negate());
                                }
                            }
                        });
                    });
                }
            }else{
                //根据sodid反查销售单数据
                List<Long> sodid = ddos.stream().filter(sod->sod.getSoDId()!=null).map(SalReceiptdRespVO::getSoDId).distinct().collect(Collectors.toList());
                if(sodid.size()>0){
                    List<SalSoDetailRespDTO> sodList = getSodListBySodId(sodid);
                    ddos.forEach(receiptd -> {
                        sodList.forEach(sod -> {
                            if(receiptd.getSoDId()!=null && receiptd.getSoDId().equals(sod.getSoDId())){
                                receiptd.setPayedAmt(sod.getPayedAmt()==null? BigDecimal.ZERO:sod.getPayedAmt());
                                receiptd.setPayingAmt(sod.getPayingAmt()==null?BigDecimal.ZERO:sod.getPayingAmt());
                                receiptd.setOpenAmt(sod.getOpenAmt()==null?BigDecimal.ZERO:sod.getOpenAmt());
                                receiptd.setApAmt(sod.getApAmt()==null?BigDecimal.ZERO:sod.getApAmt());
                                receiptd.setPrice(sod.getPrice()==null?BigDecimal.ZERO:sod.getPrice());
                                receiptd.setNetPrice(sod.getNetPrice()==null?BigDecimal.ZERO:sod.getNetPrice());
                                if(sod.getDocCls()!=null && sod.getDocCls().equals("RSO")){
                                    receiptd.setDocCls(sod.getDocCls());
                                    receiptd.setPayedAmt(receiptd.getPayedAmt().abs().negate());
                                    receiptd.setPayingAmt(receiptd.getPayingAmt().abs().negate());
                                    receiptd.setOpenAmt(receiptd.getOpenAmt().abs().negate());
                                    receiptd.setApAmt(receiptd.getApAmt().abs().negate());
                                }
                            }
                        });
                    });
                }
            }
            //根据dodid反查发货单数据
            List<Long> dodIds = ddos.stream().filter(dod->dod.getDodId()!=null).map(SalReceiptdRespVO::getDodId).distinct().collect(Collectors.toList());
            if(dodIds.size()>0){
                SalDoDQueryDTO salDoDQueryDTO = new SalDoDQueryDTO();
                salDoDQueryDTO.setIds(dodIds);
                salDoDQueryDTO.setSize(10000);
                PagingVO<SalDoDRPCRespDTO> salDoDRPCRespDTOPagingVO = rmiDoDRpcService.queryDodForInvoice(salDoDQueryDTO);

                List<SalDoDRPCRespDTO> dodList = salDoDRPCRespDTOPagingVO.getRecords();
                ddos.forEach(receiptd -> {
                    dodList.forEach(dod -> {
                        if(receiptd.getDodId()!=null && receiptd.getDodId().equals(dod.getId())){
                            receiptd.setConfirmAmt(dod.getConfirmAmt()==null?BigDecimal.ZERO:dod.getConfirmAmt());
                        }
                    });
                });
            }
            //根据品牌code反查name
            List<String> brands = ddos.stream().filter(d->d.getItemBrand()!=null&&!d.getItemBrand().equals("")).map(SalReceiptdRespVO::getItemBrand).distinct().collect(Collectors.toList());
            if(brands.size()>0){
                ItmBrandRpcDtoParam brandRpcDtoParam = new ItmBrandRpcDtoParam();
                brandRpcDtoParam.setBrandCodes(brands);
                List<ItmBrandRpcDTO> dtoList = rmiBrandService.findBrandDtoByParam(brandRpcDtoParam);
                ddos.forEach(d -> {
                    dtoList.forEach(dto -> {
                        if(d.getItemBrand().equals(dto.getBrandCode())){
                            d.setItemBrandName(dto.getBrandName());
                        }
                    });
                });
            }
            //根据税率反查税率编码
            Set<BigDecimal> taxRates = ddos.stream().filter(d->d.getSoTaxRate()!=null).map(d->{
                return d.getSoTaxRate();
            }).distinct().collect(Collectors.toSet());
            if(taxRates.size()>0){
                SysTaxRateQueryDTO sysTaxRateQueryDTO=new SysTaxRateQueryDTO();
                sysTaxRateQueryDTO.setTaxRates(taxRates);
                List<SysTaxRateRespDTO> sysTaxRateRespDTOList= rmiCommonService.queryList(sysTaxRateQueryDTO);


                ddos.forEach(d -> {
                    sysTaxRateRespDTOList.forEach(dto -> {
                        if(d.getSoTaxRate().compareTo(dto.getTaxRateValue())==0){
                            d.setSoTaxRateNo(dto.getTaxRateNo());
                        }
                    });
                });
            }
            salReceiptRespVO.setSalReceiptdRespVOS(ddos);
        }else {
            throw new BusinessException("查询订单Id不存在");
        }
        return salReceiptRespVO;
    }
}
