package com.elitesland.yst.production.sale.service;

import com.elitesland.yst.production.sale.api.service.TaskInfoService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.dataturbo.annotation.DataTurboTransfer;
import com.elitesland.yst.dataturbo.service.DataTurboTransferService;
import com.elitesland.yst.dataturbo.service.param.DataTurboProcessParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 功能说明:任务重复设置定时任务
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/17
 * @Version 1.0
 * @Content:
 */
@Service
@Slf4j
@DataTurboTransfer("sale_task_repeat_set")
public class TaskRepeatSetTransferServiceImpl implements DataTurboTransferService {

    @Autowired
    private TaskInfoService taskInfoService;

    @Override
    public Object transfer(DataTurboProcessParam param) {
        log.info("任务重复设置DataTurbo参数,时间：{},信息：{}", param);
        TaskInfoQueryVO queryVO = new TaskInfoQueryVO();
        taskInfoService.setTaskDuplication(queryVO);
        return new Object();
    }

}
