package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.IterUtil;
import com.elitesland.yst.production.sale.api.service.ZoneSettingDService;
import com.elitesland.yst.production.sale.api.vo.param.zone.ZoneSettingDetailPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingDVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingSaveDVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BusFirstMenuConfDDO;
import com.elitesland.yst.production.sale.entity.QBusFirstMenuConfDDO;
import com.elitesland.yst.production.sale.entity.QZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.ZoneSettingDDO;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepoProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;

import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgBuRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
@Slf4j
@RequiredArgsConstructor
public class ZoneSettingDServiceImpl implements ZoneSettingDService {

    private final OrgBuRpcService orgBuRpcService;

    private final ZoneSettingDRepoProc zoneSettingDRepoProc;

    private final ZoneSettingDRepo zoneSettingDRepo;

    private final OrgEmpRpcService orgEmpRpcService;

    private final BusFirstMenuConfDRepo busFirstMenuConfDRepo;


    @Override
    public PagingVO<ZoneSettingDVO> findPagingResult(ZoneSettingDetailPageParam param) {
        //获取当前用户的ou
        if(null == param.getOuId()){
            OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
            if(null == empInfo.getOuId()){
                return new PagingVO<>();
            }
            param.setOuId(empInfo.getOuId());
        }
        PagingVO<ZoneSettingDVO> list = zoneSettingDRepoProc.findPagingResult(param);
        return list;
    }

    @Override
    public ApiResult<Object> addZoneDetail(List<ZoneSettingSaveDVO> param) {
        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
        List<ZoneSettingDDO> list = new ArrayList<>();
        param.stream().forEach(p ->{
            ZoneSettingDDO zoneSettingDDO = new ZoneSettingDDO();
            BeanUtils.copyProperties(p,zoneSettingDDO);
            zoneSettingDDO.setOuId(empInfo.getOuId());
            zoneSettingDDO.setOuName(empInfo.getOuName());
            list.add(zoneSettingDDO);
        });
        if(!list.isEmpty()){
            zoneSettingDRepo.saveAll(list);
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> delZoneDetail(List<Long> ids) {
        ids.stream().forEach(id ->{
            Optional<ZoneSettingDDO> optional = zoneSettingDRepo.findById(id);
            if(optional.isPresent()){
                ZoneSettingDDO zoneSettingDDO = optional.get();
                zoneSettingDDO.setDeleteFlag(1);
                zoneSettingDRepo.save(zoneSettingDDO);
            }
        });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> updateItemState(Long itemId, Long ouId,String state) {
        //修改专区商品上架状态
        QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
        BooleanExpression zoneExpr = qZoneSettingDDO.itemId.eq(itemId).and(qZoneSettingDDO.ouId.eq(ouId)).and(qZoneSettingDDO.deleteFlag.eq(0));
        Iterable<ZoneSettingDDO> zoneIterables = zoneSettingDRepo.findAll(zoneExpr);
        if(!IterUtil.isEmpty(zoneIterables)){
            List<ZoneSettingDDO> zoneList = Lists.newArrayList(zoneIterables);
            zoneList.stream().forEach(z ->{
                z.setState(state);
                zoneSettingDRepo.save(z);
            });
        }
        //修改菜单商品详情 商品上架状态
        QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
        BooleanExpression menuExpr = qBusFirstMenuConfDDO.itemId.eq(itemId).and(qBusFirstMenuConfDDO.ouId.eq(ouId)).and(qBusFirstMenuConfDDO.deleteFlag.eq(0));
        Iterable<BusFirstMenuConfDDO> menuIterables = busFirstMenuConfDRepo.findAll(menuExpr);
        if(!IterUtil.isEmpty(menuIterables)){
            List<BusFirstMenuConfDDO> menuList = Lists.newArrayList(menuIterables);
            menuList.stream().forEach(m ->{
                m.setState(state);
                busFirstMenuConfDRepo.save(m);
            });
        }
        return ApiResult.ok();
    }


    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }



}
