package com.elitesland.yst.production.sale.service.common;

import com.elitescloud.cloudt.core.verifycode.model.VerifyCodeMessengerBO;
import com.elitescloud.cloudt.core.verifycode.support.content.CarrierContentProvider;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/4/11 11:56
 */
//@Service
public class DefaultCarrierContentProvider implements CarrierContentProvider {

    private final static String BUSINESS_TYPE_RETRIEVE_PWD = "yst_sale_retrieve_pwd";

    @Override
    public String produceContent(VerifyCodeMessengerBO param) {
        String verifyCode = param.getVerifyCode();
        switch (param.getBusinessType()) {
            case BUSINESS_TYPE_RETRIEVE_PWD:
                return "您的验证码是：" + verifyCode + "，仅用于找回登录密码，请不要将验证码透漏于他人！";
            default:
                throw new IllegalArgumentException("暂不支持的业务类型：" + param.getBusinessType());
        }
    }

    @Override
    public String produceSubject(VerifyCodeMessengerBO param) {
        switch (param.getBusinessType()) {
            case BUSINESS_TYPE_RETRIEVE_PWD:
                return "密码找回";
            default:
                throw new IllegalArgumentException("暂不支持的业务类型：" + param.getBusinessType());
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }
}
