package com.elitesland.yst.production.sale.service.component;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.component.SalesmanParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.component.SalesmanPageRespVO;
import com.elitesland.yst.production.sale.repo.SalesmanComponentRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysOrgService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: ryan.xu
 * @since 2023/6/25
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SalesmanComponentServiceImpl implements SalesmanComponentService {

    private final RmiOrgOuService rmiOrgOuService;
    private final RmiSysOrgService rmiSysOrgService;
    private final SalesmanComponentRepoProc salesmanComponentRepoProc;


    @Override
    public PagingVO<SalesmanPageRespVO> querySalesmanList(SalesmanParamVO paramVO) {
        long count = salesmanComponentRepoProc.countSalesMan(paramVO);
        if (count > 0) {
            var salesmanPageRespVOS = salesmanComponentRepoProc.querySalesMan(paramVO);
            this.translateSalesman(salesmanPageRespVOS);
            return new PagingVO<>(count, salesmanPageRespVOS);
        }
        return new PagingVO<>();
    }

    private void translateSalesman(List<SalesmanPageRespVO> salesmanPageRespVOS) {
        var empCodes = salesmanPageRespVOS.stream().map(SalesmanPageRespVO::getEmpCode).collect(Collectors.toList());
        var sysEmpList = rmiSysOrgService.findEmpByCode(empCodes);
        var ouCodes = salesmanPageRespVOS.stream().map(SalesmanPageRespVO::getOuCode).collect(Collectors.toList());
        var orgOuList = rmiOrgOuService.findOuDtoListByOuCodes(ouCodes);
        if (CollUtil.isNotEmpty(sysEmpList)) {
            salesmanPageRespVOS.forEach(row -> {
                sysEmpList.stream().filter(emp -> row.getEmpCode().equals(emp.getCode())).findAny().ifPresent(emp -> {
                    row.setBuId(CollUtil.isNotEmpty(emp.getOrgList()) ? emp.getOrgList().get(0).getOrgId() : null);
                    row.setBuName(CollUtil.isNotEmpty(emp.getOrgList()) ? emp.getOrgList().get(0).getOrgName() : null);
                    row.setUserId(emp.getUserId());
                    row.setUserName(emp.getFullName());
                });
                orgOuList.stream().filter(ou -> row.getOuCode().equals(ou.getOuCode())).findAny().ifPresent(ou -> {
                    row.setOuId(ou.getId());
                    row.setCurrCode(ou.getOuCurr());
                    row.setAddrNo(ou.getAddrNo());
                });
            });
        }
    }
}
