package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipCrmCustService;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCrmCustInfoVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipCustQualifyRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipCustQualifySaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCrmCustSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.CrmCustConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysOauth2RpcService;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.boot.exception.BusinessException;


import com.elitescloud.cloudt.system.param.SysUserNewParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrQualifyRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrQualifyRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.gson.Gson;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Shadow（li qun）
 * @since 2021-09-01 15:02
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class BipCrmCustServiceImpl extends BaseServiceImpl implements BipCrmCustService {

    private final static String REGISTER_ERROR_INFO = "客户：【%s】,手机号：【%s】,账户创建失败,原因：%s";
    private final static String REGISTER_DEFAULT_PWD = "123456";

    private final CrmCustRepo crmCustRepo;
    private final RmiOrgAddrService rmiOrgAddrService;
    private final RmiSysOauth2RpcService rmiSysOauth2RpcService;

    private final ComSaleFileInfoService comSaleFileInfoService;
    private final BipCustUserBindRepo bipCustUserBindRepo;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipCompanyManageService bipCompanyManageService;


    @Override
    public ApiResult<BipCrmCustInfoVO> searchInfoCurrent() {

        CurrentUserDTO currentUserDTO = UserService.currentUser();

        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;

        if (currentUserDTO == null) {
            throw new BusinessException("请先登录!");
        }
        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
            if (bipCustUserBindDO == null) {
                return ApiResult.ok();
            }
        } else {
            throw new BusinessException("请先登录!");
        }
        // 获取客户
        Long custId = bipCustUserBindDO.getCustId();
        CrmCustDO custDO = crmCustRepo.findById(custId).orElseThrow(() -> new BusinessException(ApiCode.BUSINESS_EXCEPTION, "客户信息不存在"));

        log.info("账户信息设置custDO" + new Gson().toJson(custDO));

        BipCrmCustInfoVO infoVO = CrmCustConvert.INSTANCE.doToBaseInfoVO(custDO);

        // 证件信息数据补充
        if (!StringUtils.isEmpty(custDO.getAddrNo())) {

            ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo = rmiOrgAddrService.findAddrByAddrNo(custDO.getAddrNo());
            Assert.isFalse(!rpcDtoByAddrNo.isSuccess(), rpcDtoByAddrNo.getMsg());
            OrgAddrDetailsRpcDTO orgAddr = rpcDtoByAddrNo.getData();

            if (!ObjectUtils.isEmpty(orgAddr) && !CollectionUtils.isEmpty(orgAddr.getOrgAddrQualifyVos())) {
                // 账户信息补充

                // 地址ID
                infoVO.setAddrId(orgAddr.getId());
                // 证件编号
                List<String> qualifyFileNos = orgAddr.getOrgAddrQualifyVos().stream().map(OrgAddrQualifyRpcDTO::getQualifyNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                // 图片集合
                List<ComSaleFileComVO> comSaleFileComVOS = comSaleFileInfoService.findFileByBusinessId("BIP_IMAGE", custDO.getId());
                log.info("账户信息设置comSaleFileComVOS" + comSaleFileComVOS);
                // 证件列表
                List<BipCustQualifyRespVO> custQualifyRespVOS = orgAddr.getOrgAddrQualifyVos().stream().map(qualify -> {
                    BipCustQualifyRespVO bipCustQualifyRespVO = CrmCustConvert.INSTANCE.qualifyRpcToBipAddrVo(qualify);
                    if (!CollectionUtils.isEmpty(qualifyFileNos)) {
                        List<ComSaleFileComVO> pictures = comSaleFileComVOS.stream().filter(cust -> cust.getQualifyNo().equals(qualify.getQualifyNo())).collect(Collectors.toList());
                        log.info("账户信息设置pictures" + pictures);
                        bipCustQualifyRespVO.setEnclosure(pictures);
                    }
                    return bipCustQualifyRespVO;
                }).collect(Collectors.toList());
                infoVO.setQualifyList(custQualifyRespVOS);
            }
        }

        return ApiResult.ok(infoVO);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCurrent(BipCrmCustSaveVO saveVO) {

        CrmCustDO custDO = currentCust();

        //批量处理账户证件信息
        OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
        List<ComSaleFileComVO> filesWithId = new ArrayList<>();
        if (!CollectionUtils.isEmpty(saveVO.getQualifyList())) {
            // 设置主表参数字段
            param.setId(saveVO.getAddrId());
            param.setAddrNo(custDO.getAddrNo());
            param.setAddrName(custDO.getCustName());
            param.setAddrType(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());

            List<BipCustQualifySaveVO> crmCustQualifySaveVOS = saveVO.getQualifyList();
            List<OrgAddrQualifyRpcSaveParam> addrQualifyRpcSaveParams = crmCustQualifySaveVOS.stream().map(qualify -> {
                OrgAddrQualifyRpcSaveParam orgAddrQualify = CrmCustConvert.INSTANCE.bipSaveVoToQualifyRpc(qualify);
                orgAddrQualify.setQualifyFileId(qualify.getQualifyOuId());

                for (ComSaleFileComVO fileComVO : qualify.getEnclosure()) {
                    ComSaleFileComVO comSaleFileComVO = new ComSaleFileComVO();
                    comSaleFileComVO.setQualifyNo(qualify.getQualifyNo());
                    comSaleFileComVO.setFileCode(fileComVO.getFileCode());
                    comSaleFileComVO.setOriginalName(fileComVO.getOriginalName());
                    filesWithId.add(comSaleFileComVO);
                }

                return orgAddrQualify;
            }).collect(Collectors.toList());
            param.setOrgAddrQualifySaveParams(addrQualifyRpcSaveParams);
        }
        // 支撑域保存证件信息
        log.info("账户信息修改param" + new Gson().toJson(param));
        ApiResult<Long> addrRes = rmiOrgAddrService.orgAddrSaveOrUpdate(param);
//        Assert.isTrue(addrRes.isSuccess(), addrRes.getMsg());
        // 本域保存信息

        alterDO(saveVO, custDO);
        log.info("账户信息修改userDO" + new Gson().toJson(custDO));

        crmCustRepo.save(custDO);
        // 本地保存图片信息
        if (!CollectionUtils.isEmpty(filesWithId)) {
            filesWithId.forEach(k -> k.setBusinessId(saveVO.getId()));
            comSaleFileInfoService.comSaleFileHardSave("BIP_IMAGE", saveVO.getId(), filesWithId);
        }
    }

    private void alterDO(BipCrmCustSaveVO source, CrmCustDO target) {
        if (!StringUtils.isEmpty(source.getCustCode())) {
            target.setCustCode(source.getCustCode());
        }
        if (!StringUtils.isEmpty(source.getCustCode())) {
            target.setCustCode(source.getCustCode());
        }
        if (!StringUtils.isEmpty(source.getInvAddress())) {
            target.setInvAddress(source.getInvAddress());
        }
        if (!StringUtils.isEmpty(source.getInvTel())) {
            target.setInvTel(source.getInvTel());
        }
        if (!StringUtils.isEmpty(source.getInvBankName())) {
            target.setInvBankName(source.getInvBankName());
        }
        if (!StringUtils.isEmpty(source.getInvBankBranch())) {
            target.setInvBankBranch(source.getInvBankBranch());
        }
        if (!StringUtils.isEmpty(source.getInvBankAcc())) {
            target.setInvBankAcc(source.getInvBankAcc());
        }
        if (!StringUtils.isEmpty(source.getInvPicName())) {
            target.setInvPicName(source.getInvPicName());
        }
        if (!StringUtils.isEmpty(source.getInvPicPhone())) {
            target.setInvPicPhone(source.getInvPicPhone());
        }
    }

    @Override
    public String createUserAccount(List<Long> ids) {
        // 获取当前业务员信息
        CurrentUserDTO currentUser = getCurrentUser();
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        List<BipCompanyManageRespVO> manageByOuIds = bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
        if (CollectionUtils.isEmpty(manageByOuIds)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户公司信息为空");
        }
        // 账户校验返回信息
        StringBuffer resultSB = new StringBuffer();
        Assert.isFalse(CollectionUtil.isEmpty(ids), "[客户创建账户]操作数据为空");

        List<CrmCustDO> crmCustDOList = crmCustRepo.findAllById(ids);
        // 校验crmCust数据
        crmCustDOList.forEach(i -> {
            if (StringUtils.isEmpty(i.getContactPhone()) && i.getIsCreatedAccount()) {
                resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), "", "账户信息异常:账户登陆手机号未设置，但已注册。请联系管理员。\n"));
            } else if (StringUtils.isEmpty(i.getContactPhone())) {
                resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), "", "账户登陆手机号未设置;\n"));
            } else if (i.getIsCreatedAccount()) {
                resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), i.getContactPhone(), "账户已注册;\n"));
            }
        });
        Assert.isTrue(StringUtils.isEmpty(resultSB.toString()), resultSB.toString());
        // 校验custUserBind 数据
        List<BipCustUserBindDO> bipCustUserBindDOS = bipCustUserBindRepoProc.getAllByEmpIds(ids);
        bipCustUserBindDOS.forEach(i -> {
            if (Objects.nonNull(i.getUserId())) {
                crmCustDOList.stream().filter(c -> c.getId().equals(i.getCustId())).findAny()
                        .ifPresent(c ->
                                resultSB.append(String.format(REGISTER_ERROR_INFO, c.getCustName(), c.getContactPhone(), "账户绑定信息异常:账户已注册。请联系管理员。\n"))
                        );
            }
        });
        Assert.isTrue(StringUtils.isEmpty(resultSB.toString()), resultSB.toString());
        // 遍历 注册账户
        crmCustDOList.forEach(i -> {
            SysUserNewParam user = new SysUserNewParam();
            user.setMobile(i.getContactPhone());
            user.setUsername(i.getCustName());
            user.setEnabled(true);
            user.setOuId(i.getOuId());

            Set<Terminal> terminals = new HashSet<>(4);
            terminals.add(Terminal.APPLET);
            user.setTerminals(terminals);

            ApiResult<Long> longApiResult = rmiSysOauth2RpcService.sysUserCreate(user, REGISTER_DEFAULT_PWD);

            ApiResult<OrgAddrDetailsRpcDTO> orgAddrDetailsRpcDTOApiResult = rmiOrgAddrService.findAddrByAddrNo(i.getAddrNo());

            if (ApiCode.SUCCESS.getCode() == longApiResult.getCode() && ApiCode.SUCCESS.getCode() == orgAddrDetailsRpcDTOApiResult.getCode()) {
                // 设置隔离级别
                DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
                transactionDefinition.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
                TransactionStatus transactionStatus = transactionManager.getTransaction(transactionDefinition);
                try {
                    String certFileCode = Optional.ofNullable(orgAddrDetailsRpcDTOApiResult.getData())
                            .map(o -> o.getOrgAddrQualifyVos())
                            .flatMap(o -> o.stream().filter(q -> UdcEnum.ORG_ADDR_QUALIFY_TYPE_10.getValueCode().equals(q.getQualifyType())).findAny())
                            .map(o -> o.getQualifyFileCode()).orElse(null);

                    // 更新绑定关系表
                    BipCustUserBindDO bipCustUserBindDO = bipCustUserBindDOS.stream()
                            .filter(b -> i.getId().equals(b.getCustId()))
                            .findAny().orElse(new BipCustUserBindDO());
                    bipCustUserBindDO.setSecOuId(userEmpInfo.getOuId());
                    bipCustUserBindDO.setSecUserId(userEmpInfo.getUserId());
                    bipCustUserBindDO.setSecBuId(manageByOuIds.get(0).getBuId());
                    bipCustUserBindDO.setUserId(longApiResult.getData());
                    bipCustUserBindDO.setUsername(i.getCustName());
                    bipCustUserBindDO.setCustId(i.getId());
                    bipCustUserBindDO.setCustCode(i.getCustCode());
                    bipCustUserBindDO.setCustName(i.getCustName());
                    bipCustUserBindDO.setOuId(i.getOuId());
                    bipCustUserBindDO.setTaxRegNo(i.getTaxRegNo());
                    bipCustUserBindDO.setCertFileCode(certFileCode);
                    bipCustUserBindDO.setContactName(i.getContactName());
                    bipCustUserBindDO.setContactPhone(i.getContactPhone());
                    bipCustUserBindDO.setState(UdcEnum.BIP_CUST_USER_STATE_ACTIVE.getValueCode());
                    bipCustUserBindDO.setStateApply(UdcEnum.BIP_CUST_USER_APPLY_PASSED.getValueCode());
                    bipCustUserBindDO.setTimeRegister(LocalDateTime.now());
                    bipCustUserBindDO.setTimeApply(LocalDateTime.now());
                    bipCustUserBindDO.setAgentEmpId(currentUser.getUserId());
                    bipCustUserBindRepo.save(bipCustUserBindDO);
                    // 更新crmCust 表
                    i.setIsCreatedAccount(true);
                    crmCustRepo.save(i);
                    transactionManager.commit(transactionStatus);
                } catch (Exception e) {
                    log.error("客户信息-创建客户登陆账户异常：{}", e);
                    transactionManager.rollback(transactionStatus);
                }
            } else {
                if (ApiCode.SUCCESS.getCode() == longApiResult.getCode() && ApiCode.SUCCESS.getCode() != orgAddrDetailsRpcDTOApiResult.getCode()) {
                    resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), i.getContactPhone(), orgAddrDetailsRpcDTOApiResult.getMsg()));
                } else if (ApiCode.SUCCESS.getCode() != longApiResult.getCode() && ApiCode.SUCCESS.getCode() == orgAddrDetailsRpcDTOApiResult.getCode()) {
                    resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), i.getContactPhone(), longApiResult.getMsg()));
                } else {
                    resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), i.getContactPhone(),
                            longApiResult.getMsg() + "|" + orgAddrDetailsRpcDTOApiResult.getMsg()
                    ));
                }
            }
        });
        return resultSB.toString();
    }

    /**
     * 获取当前登陆人信息
     *
     * @return 当前登陆人信息
     */
    private CurrentUserDTO getCurrentUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        return currentUser;
    }

    private CrmCustDO currentCust() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();

        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;

        if (currentUserDTO == null) {
            throw new BusinessException("请先登录!");
        }
        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        } else {
            throw new BusinessException("请先登录!");
        }
        if (bipCustUserBindDO == null) {
            throw new BusinessException("请绑定公司信息!");
        }
        Long custId = bipCustUserBindDO.getCustId();

        return crmCustRepo.findById(custId).orElseThrow(() -> new BusinessException(ApiCode.BUSINESS_EXCEPTION, "客户信息不存在"));
    }
}
