package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipFeedBackService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFeedBackParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFeedBackQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipFeedBackRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipFeedBackSaveVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipFeedBackCovert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipFeedBackDO;
import com.elitesland.yst.production.sale.entity.QBipFeedBackDO;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipFeedBackRepo;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-08-11 13:23
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class BipFeedBackServiceImpl extends BaseServiceImpl implements BipFeedBackService {


    private final BipFeedBackRepo bipFeedBackRepo;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipCompanyManageService bipCompanyManageService;
    private static final QBipFeedBackDO qbipFeedBackDO = QBipFeedBackDO.bipFeedBackDO;
    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;
    @Override
    public Long addFeedBack(BipFeedBackParam param) {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
//        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
//        if (userEmpInfo == null) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
//        }
//        List<BipCompanyManageRespVO> manageByOuIds = bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
//        if (CollectionUtils.isEmpty(manageByOuIds)) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户公司信息为空");
//        }
        String mobile = currentUser.getDetail().getMobile();
        Assert.isFalse(!Validator.isNotEmpty(mobile), "手机号为空请完善个人信息");
        Assert.isFalse(!Validator.isMobile(mobile), "手机号格式错误");
        //将文件编码的list转换为string
        BipFeedBackCovert bipFeedBackCovert = BipFeedBackCovert.INSTANCE;
        BipFeedBackDO bipFeedBackDo = bipFeedBackCovert.paramToDO(param);
        bipFeedBackDo.setCustAccountId(currentUser.getUserId().toString());
        bipFeedBackDo.setCustAccountName(currentUser.getDetail().getUsername());
//        BipCustUserBindDO bipCustUserBindDO=bipCustUserBindRepoProc.getByUserId(currentUser.getUserId());
//        bipFeedBackDo.setCustAccountName(bipCustUserBindDO.getCustName());
        bipFeedBackDo.setCreateTime(LocalDateTime.now());
        bipFeedBackDo.setTel(mobile);
        if (!CollectionUtils.isEmpty(param.getFileCodeList())) {
            String fileCodes = listToString(param.getFileCodeList());
            bipFeedBackDo.setFileCodes(fileCodes);
        }
        bipFeedBackDo.setReplay(UdcEnum.COM_YESNO_NO.getValueCode());
//        bipFeedBackDo.setSecOuId(userEmpInfo.getOuId());
//        bipFeedBackDo.setSecUserId(userEmpInfo.getUserId());
//        bipFeedBackDo.setSecBuId(manageByOuIds.get(0).getBuId());
        return bipFeedBackRepo.save(bipFeedBackDo).getId();
    }

    @Override
    public List<BipFeedBackRespVO> getFeedBackAllById() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
        }
        Long userId = currentUser.getUserId();
        return this.findFeedBackByUserId(userId.toString()).fetch();
    }

    @Override
    @SysCodeProc
    public PagingVO<BipFeedBackRespVO> query(BipFeedBackQueryParamVO searchParam) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(BipFeedBackRespVO.class,
                qbipFeedBackDO.id, qbipFeedBackDO.custAccountId, qbipFeedBackDO.custAccountName, qbipFeedBackDO.tel,
                qbipFeedBackDO.replay, qbipFeedBackDO.replayAccountId, qbipFeedBackDO.replayAccountName, qbipFeedBackDO.replayContext,
                qbipFeedBackDO.replayTime, qbipFeedBackDO.context, qbipFeedBackDO.createTime
        ))
                .from(qbipFeedBackDO)
                .where(buildPageSearchCondition(searchParam));

        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<BipFeedBackRespVO>builder().build();
        }
        var pageRequest = wrapperPageRequest(searchParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qbipFeedBackDO);
        List<BipFeedBackRespVO> pageResult = jpaQuery.fetch();

        return PagingVO.<BipFeedBackRespVO>builder().total(total).records(pageResult).build();
    }

    @Override
    @SysCodeProc
    public BipFeedBackRespVO findOneById(Long id) {
        BipFeedBackRespVO bipFeedBackRespVO = this.findInfoJpaQuery()
                .where(qbipFeedBackDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO))
                .where(qbipFeedBackDO.id.eq(id))
                .fetchOne();
        Assert.isFalse(Validator.isNull(bipFeedBackRespVO), "[意见反馈]没有查到数据");
        String fileCodes = bipFeedBackRespVO.getFileCodes();
        if (!StringUtils.isEmpty(fileCodes)) {
            List<String> fileCodeList = stringToList(fileCodes);
            bipFeedBackRespVO.setFileCodeList(fileCodeList);
        }
        return bipFeedBackRespVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reply(BipFeedBackSaveVO saveVO) {
        Assert.isFalse(Validator.isNull(saveVO), "[意见反馈]操作数据为空");
        Assert.isFalse(Validator.isNull(saveVO.getId()), "[意见反馈]数据ID为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getReplayContext()), "反馈意见为空");
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        jpaQueryFactory.update(qbipFeedBackDO)
                .set(qbipFeedBackDO.replayContext, saveVO.getReplayContext())
                .set(qbipFeedBackDO.replayTime, saveVO.getReplayTime())
                .set(qbipFeedBackDO.replay, UdcEnum.COM_YESNO_YES.getValueCode())
                .set(qbipFeedBackDO.replayAccountId, String.valueOf(currentUser.getUserId()))
                .set(qbipFeedBackDO.replayAccountName, currentUser.getDetail().getUsername())
                .where(qbipFeedBackDO.id.eq(saveVO.getId())).execute();
    }

    /**
     * 查询信息jpaQuery主体
     *
     * @return BipFeedBackRespVO
     */
    private JPAQuery<BipFeedBackRespVO> findInfoJpaQuery() {
        return jpaQueryFactory.select(Projections.bean(BipFeedBackRespVO.class,
                qbipFeedBackDO.id, qbipFeedBackDO.custAccountId, qbipFeedBackDO.custAccountName, qbipFeedBackDO.tel,
                qbipFeedBackDO.replay, qbipFeedBackDO.replayAccountId, qbipFeedBackDO.replayAccountName, qbipFeedBackDO.replayContext,
                qbipFeedBackDO.replayTime, qbipFeedBackDO.context, qbipFeedBackDO.createTime , qbipFeedBackDO.fileCodes
        ))
                .from(qbipFeedBackDO);
    }

    private JPAQuery<BipFeedBackRespVO> findFeedBackByUserId(String id) {
        return jpaQueryFactory.select(Projections.bean(BipFeedBackRespVO.class,
                qbipFeedBackDO.id,
                qbipFeedBackDO.custAccountName,
                qbipFeedBackDO.replayContext,
                qbipFeedBackDO.replayAccountName,
                qbipFeedBackDO.context,
                qbipFeedBackDO.createTime
                )
        ).from(qbipFeedBackDO).where(qbipFeedBackDO.custAccountId.eq(id));
    }

    private Predicate buildPageSearchCondition(BipFeedBackQueryParamVO param) {
        Predicate predicate = qbipFeedBackDO.isNotNull();
        if (Objects.nonNull(param)) {
            if (!StringUtils.isEmpty(param.getCustAccountName())) {
                predicate = ExpressionUtils.and(predicate, qbipFeedBackDO.custAccountName.like("%" + param.getCustAccountName() + "%"));
            }
            if (!StringUtils.isEmpty(param.getTel())) {
                predicate = ExpressionUtils.and(predicate, qbipFeedBackDO.tel.like("%" + param.getTel() + "%"));
            }
            if (Objects.nonNull(param.getCreateTime())) {
                predicate = ExpressionUtils.and(predicate, qbipFeedBackDO.createTime.after(LocalDateTime.of(param.getCreateTime().toLocalDate(), LocalTime.MIN)));
                predicate = ExpressionUtils.and(predicate, qbipFeedBackDO.createTime.before(LocalDateTime.of(param.getCreateTime().toLocalDate(), LocalTime.MAX)));
            }
            if (!StringUtils.isEmpty(param.getReplay())) {
                predicate = ExpressionUtils.and(predicate, qbipFeedBackDO.replay.eq(param.getReplay()));
            }
        }
         //权限条件查询
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qbipFeedBackDO.getMetadata()));
        log.info("客户反馈意见查询权限" + predicate);
        return predicate;
    }
    private String listToString(List<String> fileCodeList) {
        StringBuilder fileCodeString = new StringBuilder();
        for (String s : fileCodeList) {
            fileCodeString.append(s).append("|");
        }
        return fileCodeString.toString();
    }
    private List<String> stringToList(String fileCodes) {
        String[] split = fileCodes.split("\\|");
        return Arrays.stream(split).collect(Collectors.toList());
    }
}
