/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.event.listener;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.api.dto.BipCartDTO;
import com.elitesland.yst.production.sale.api.service.shop.BipMessageService;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipMessageConvert;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.BipMessageDO;
import com.elitesland.yst.production.sale.entity.QBipCartDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.entity.QBipItemSkuDO;
import com.elitesland.yst.production.sale.event.ItemStockUpdateEvent;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class CreateMessageAfterChangeListener
implements ApplicationListener<ItemStockUpdateEvent> {
    private static final Logger log = LoggerFactory.getLogger(CreateMessageAfterChangeListener.class);
    @Autowired
    private BipCartRepoProc bipCartRepoProc;
    @Autowired
    private BipMessageRepo bipMessageRepo;
    private final BipMessageService bipMessageService;
    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
    private QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
    private QBipCartDO qBipCartDO = QBipCartDO.bipCartDO;

    public void onApplicationEvent(ItemStockUpdateEvent event) {
        log.info("\u76d1\u542c\u5230\u5e93\u5b58\u8c03\u6574\u4e8b\u4ef6\uff1a{}, {}", (Object)event.getBipItemSkuId(), (Object)event.getIncrement());
        CompletableFuture.runAsync(() -> this.update(event)).exceptionally(e -> {
            log.error("\u5e93\u5b58\u8c03\u6574\u4e8b\u4ef6\u901a\u77e5\u8d2d\u7269\u8f66\u7684\u7528\u6237\u6d88\u606f\u5931\u8d25\u3010" + event.getBipItemSkuId() + "\u3011", e);
            return null;
        });
    }

    private void update(ItemStockUpdateEvent event) {
        log.info("\u5e93\u5b58\u8c03\u6574\u4e8b\u4ef6\u5165\u53c2\uff1a" + JSON.toJSONString((Object)((Object)event)));
        if (!event.getIncrement().booleanValue()) {
            return;
        }
        List<BipCartDTO> carts = this.bipCartRepoProc.searchCart(event.getBipItemSkuId());
        log.info("\u5e93\u5b58\u8c03\u6574\u4e8b\u4ef6\u8d2d\u7269\u8f66\uff1a" + JSON.toJSONString(carts));
        for (BipCartDTO cart : carts) {
            BipItemSkuDO sku = (BipItemSkuDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qBipItemSkuDO).from((EntityPath)this.qBipItemSkuDO)).where((Predicate)this.qBipItemSkuDO.id.eq((Object)event.getBipItemSkuId()))).fetchOne();
            BipItemDO itemDO = (BipItemDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qBipItemDO).from((EntityPath)this.qBipItemDO)).where((Predicate)this.qBipItemDO.id.eq((Object)sku.getBipItemId()))).fetchOne();
            BipMessageSaveVO param = new BipMessageSaveVO();
            param.setTitle("\u3010\u5230\u8d27\u901a\u77e5\u3011");
            param.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            param.setToCustId(cart.getUserId());
            param.setContext("\u60a8\u6dfb\u52a0\u5230\u8d2d\u7269\u8f66\u7684\u5546\u54c1" + itemDO.getTitle() + "\u5df2\u7ecf\u6709\u8d27\u5566\uff0c\u8bf7\u5c3d\u5feb\u4e0b\u5355\u3002");
            BipMessageDO bipMessageDO = BipMessageConvert.INSTANCE.voToDo(param);
            BipMessageDO save = (BipMessageDO)this.bipMessageRepo.saveAndFlush(bipMessageDO);
            log.info("\u5e93\u5b58\u8c03\u6574\u4e8b\u4ef6\u6d88\u606fID\uff1a" + JSON.toJSONString((Object)save));
            this.jpaQueryFactory.update((EntityPath)this.qBipCartDO).set((Path)this.qBipCartDO.stockEnough, (Object)true).where(new Predicate[]{this.qBipCartDO.id.eq((Object)cart.getId())}).execute();
        }
    }

    public CreateMessageAfterChangeListener(BipMessageService bipMessageService, JPAQueryFactory jpaQueryFactory) {
        this.bipMessageService = bipMessageService;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

