/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustPageRespVO;
import com.elitesland.yst.production.sale.entity.QCrmScustDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class CrmScustRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QCrmScustDO qCrmScustDO = QCrmScustDO.crmScustDO;

    public Boolean exists(String custName, Long id) {
        BooleanExpression predicate = this.qCrmScustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmScustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)custName) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.custName.eq((Object)custName));
        predicate = StringUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.id.ne((Object)id));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmScustDO).from((EntityPath)this.qCrmScustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsTaxRegNo(String taxRegNo, Long id) {
        BooleanExpression predicate = this.qCrmScustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmScustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)taxRegNo) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.taxRegNo.eq((Object)taxRegNo));
        predicate = StringUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.id.ne((Object)id));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmScustDO).from((EntityPath)this.qCrmScustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsCode(String custCode, Long id) {
        BooleanExpression predicate = this.qCrmScustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmScustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)custCode) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.custCode.eq((Object)custCode));
        predicate = StringUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.id.ne((Object)id));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmScustDO).from((EntityPath)this.qCrmScustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public List<CrmScustPageRespVO> findIdByNameAndTaxRegNo(String custName, String taxRegNo) {
        BooleanExpression predicate = this.qCrmScustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmScustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)custName) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.custName.eq((Object)custName));
        predicate = StringUtils.isEmpty((Object)taxRegNo) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.taxRegNo.eq((Object)taxRegNo));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qCrmScustDO.id, this.qCrmScustDO.custCode, this.qCrmScustDO.addrNo}).from((EntityPath)this.qCrmScustDO)).where((Predicate)predicate)).fetch().stream().map(tuple -> {
            CrmScustPageRespVO dto = new CrmScustPageRespVO();
            dto.setId((Long)tuple.get(this.qCrmScustDO.id));
            dto.setCustCode((String)tuple.get((Expression)this.qCrmScustDO.custCode));
            dto.setAddrNo((Long)tuple.get(this.qCrmScustDO.addrNo));
            return dto;
        }).collect(Collectors.toList());
    }

    public List<CrmScustPageRespVO> getScustByCodes(List<String> custCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qCrmScustDO.custCode, this.qCrmScustDO.id, this.qCrmScustDO.custName, this.qCrmScustDO.custAbbr}).from((EntityPath)this.qCrmScustDO)).where((Predicate)this.qCrmScustDO.custCode.in(custCodes).and((Predicate)this.qCrmScustDO.deleteFlag.ne((Object)1)))).fetch().parallelStream().map(tuple -> {
            CrmScustPageRespVO crmScustPageRespVO = new CrmScustPageRespVO();
            crmScustPageRespVO.setId((Long)tuple.get(this.qCrmScustDO.id));
            crmScustPageRespVO.setCustName((String)tuple.get((Expression)this.qCrmScustDO.custName));
            crmScustPageRespVO.setCustCode((String)tuple.get((Expression)this.qCrmScustDO.custCode));
            crmScustPageRespVO.setCustAbbr((String)tuple.get((Expression)this.qCrmScustDO.custAbbr));
            return crmScustPageRespVO;
        }).collect(Collectors.toList());
    }
}

