/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCompanyManageParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCompanyManageSwitchParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.convert.shop.BipCompanyManageConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.BipCompanyManageDO;
import com.elitesland.yst.production.sale.entity.QBipCompanyManageDO;
import com.elitesland.yst.production.sale.repo.shop.BipCompanyManageRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCompanyManageRepoProc;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BipCompanyManageServiceImpl
extends BaseServiceImpl
implements BipCompanyManageService {
    private static final Logger log = LoggerFactory.getLogger(BipCompanyManageServiceImpl.class);
    private final QBipCompanyManageDO qBipCompanyManageDO = QBipCompanyManageDO.bipCompanyManageDO;
    private final BipCompanyManageRepo bipCompanyManageRepo;
    private final BipCompanyManageRepoProc bipCompanyManageRepoProc;

    @Transactional(rollbackFor={Exception.class})
    public void deleteCompanyManage(List<Long> ids) {
        this.bipCompanyManageRepo.updateCompanyDeleteFlag(1L, ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createCompanyManage(BipCompanyManageRespVO bipCompanyManageRespVO) {
        if (ObjectUtils.isEmpty((Object)bipCompanyManageRespVO)) {
            return null;
        }
        Boolean exists = this.bipCompanyManageRepoProc.exists(bipCompanyManageRespVO.getOuId(), bipCompanyManageRespVO.getId());
        Assert.isFalse((boolean)exists, (String)("\u516c\u53f8id\u4e3a\u3010" + bipCompanyManageRespVO.getOuId() + "\u3011\u7684\u6570\u636e\u5df2\u7ecf\u5728\u6570\u636e\u5e93\u4e2d\u5b58\u5728,\u8bf7\u68c0\u67e5."), (Object[])new Object[0]);
        Boolean exists1 = this.bipCompanyManageRepoProc.exists(bipCompanyManageRespVO.getViewOuName(), bipCompanyManageRespVO.getId());
        Assert.isFalse((boolean)exists1, (String)("\u516c\u53f8id\u4e3a\u3010" + bipCompanyManageRespVO.getOuId() + "\u3011\u7684\u6570\u636e\u5546\u57ce\u663e\u793a\u540d\u79f0\u5df2\u7ecf\u5728\u6570\u636e\u5e93\u4e2d\u5b58\u5728,\u8bf7\u68c0\u67e5."), (Object[])new Object[0]);
        Assert.notNull((Object)bipCompanyManageRespVO.getServiceTel(), (String)("\u516c\u53f8\u4e3a\u3010" + bipCompanyManageRespVO.getOuName() + "\u3011\u7684\u6570\u636e\u672a\u586b\u5199\u5ba2\u670d\u7535\u8bdd,\u8bf7\u68c0\u67e5."), (Object[])new Object[0]);
        if (ObjectUtils.isEmpty((Object)bipCompanyManageRespVO.getCustServiceSource()) || bipCompanyManageRespVO.getCustServiceSource().contains("|")) {
            throw new BusinessException("\u5ba2\u670d\u6765\u6e90\u5fc5\u586b,\u4e14\u4e0d\u80fd\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3010|\u3011");
        }
        BipCompanyManageConvert bipCompanyManageConvert = BipCompanyManageConvert.INSTANCE;
        BipCompanyManageDO bipCompanyManageDO = bipCompanyManageConvert.respVoToDo(bipCompanyManageRespVO);
        BipCompanyManageDO companyManageDO = (BipCompanyManageDO)this.bipCompanyManageRepo.save(bipCompanyManageDO);
        return companyManageDO.getId();
    }

    public PagingVO<BipCompanyManageRespVO> search(BipCompanyManageParamVO searchParam) {
        JPAQuery<BipCompanyManageRespVO> jpaQuery = this.select(searchParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(searchParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, this.qBipCompanyManageDO);
        List respVOS = jpaQuery.fetch();
        return PagingVO.builder().total(total).records(respVOS).build();
    }

    public BipCompanyManageRespVO findCompanyManageById(Long id) {
        BipCompanyManageConvert bipCompanyManageConvert = BipCompanyManageConvert.INSTANCE;
        Optional companyManageDOOptional = this.bipCompanyManageRepo.findById(id);
        if (companyManageDOOptional.isPresent()) {
            BipCompanyManageDO bipCompanyManageDO = (BipCompanyManageDO)companyManageDOOptional.get();
            return bipCompanyManageConvert.doToRespVO(bipCompanyManageDO);
        }
        throw new BusinessException("\u8be5\u516c\u53f8\u4e0d\u5b58\u5728\u4e8e\u5546\u57ce\u516c\u53f8\u8868");
    }

    @Transactional(rollbackFor={Exception.class})
    public void approveCompanyManage(BipCompanyManageSwitchParamVO bipCompanyManageSwitchParamVO) {
        if (ObjectUtils.isEmpty((Object)bipCompanyManageSwitchParamVO)) {
            throw new BusinessException("\u6ca1\u6709\u9009\u62e9\u64cd\u4f5c\u7684\u516c\u53f8");
        }
        this.bipCompanyManageRepo.updateCompanyStatus(bipCompanyManageSwitchParamVO.getViewOuStatus(), bipCompanyManageSwitchParamVO.getIds());
    }

    public static Map<String, Object> px(List<BipCompanyManageRespVO> list) {
        Collator com = Collator.getInstance(Locale.CHINA);
        List list1 = list.stream().sorted((x, y) -> com.compare(x.getViewOuName(), y.getViewOuName())).collect(Collectors.toList());
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (int i = 1; i <= 26; ++i) {
            String word = String.valueOf((char)(96 + i));
            ArrayList<BipCompanyManageRespVO> letter = new ArrayList<BipCompanyManageRespVO>();
            for (BipCompanyManageRespVO respVO : list1) {
                String zm = PinyinUtil.getFirstLetter((String)respVO.getViewOuName(), (String)"").substring(0, 1);
                if (!word.equals(zm)) continue;
                letter.add(respVO);
            }
            map.put(word.toUpperCase(), letter);
        }
        return map;
    }

    public Map<String, Object> searchForWx(BipCompanyManageParamVO searchParam) {
        JPAQuery<BipCompanyManageRespVO> jpaQuery = this.select(searchParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return new HashMap<String, Object>();
        }
        List bipCompanyManageRespVOS = jpaQuery.fetch();
        Map<String, Object> map = BipCompanyManageServiceImpl.px(bipCompanyManageRespVOS);
        return map;
    }

    public List<BipCompanyManageRespVO> findCompanyManageByOuIds(List<Long> ouIds) {
        if (CollectionUtils.isEmpty(ouIds)) {
            return new ArrayList<BipCompanyManageRespVO>();
        }
        JPAQuery<BipCompanyManageRespVO> jpaQuery = this.selectByOuIds(ouIds);
        return jpaQuery.fetch();
    }

    public Long searchFirst() {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBipCompanyManageDO.ouId).from((EntityPath)this.qBipCompanyManageDO)).where((Predicate)this.qBipCompanyManageDO.viewOuStatus.eq(Boolean.valueOf(true)))).limit(1L)).fetchOne();
    }

    public JPAQuery<BipCompanyManageRespVO> select(BipCompanyManageParamVO searchParam) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipCompanyManageRespVO.class, (Expression[])new Expression[]{this.qBipCompanyManageDO.id, this.qBipCompanyManageDO.ouId, this.qBipCompanyManageDO.ouCode, this.qBipCompanyManageDO.ouName, this.qBipCompanyManageDO.buId, this.qBipCompanyManageDO.buName, this.qBipCompanyManageDO.buCode, this.qBipCompanyManageDO.viewOuName, this.qBipCompanyManageDO.viewOuStatus, this.qBipCompanyManageDO.custServiceSource, this.qBipCompanyManageDO.serviceTel, this.qBipCompanyManageDO.custServiceSource.as("source")})).from((EntityPath)this.qBipCompanyManageDO);
        if (searchParam != null) {
            jpaQuery.where(this.where(searchParam));
        }
        return jpaQuery;
    }

    public JPAQuery<BipCompanyManageRespVO> selectByOuIds(List<Long> ids) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipCompanyManageRespVO.class, (Expression[])new Expression[]{this.qBipCompanyManageDO.id, this.qBipCompanyManageDO.ouId, this.qBipCompanyManageDO.ouCode, this.qBipCompanyManageDO.ouName, this.qBipCompanyManageDO.buId, this.qBipCompanyManageDO.buName, this.qBipCompanyManageDO.buCode, this.qBipCompanyManageDO.viewOuName, this.qBipCompanyManageDO.viewOuStatus, this.qBipCompanyManageDO.custServiceSource, this.qBipCompanyManageDO.serviceTel})).from((EntityPath)this.qBipCompanyManageDO);
        if (!CollectionUtils.isEmpty(ids)) {
            jpaQuery.where((Predicate)this.qBipCompanyManageDO.ouId.in(ids));
        }
        return jpaQuery;
    }

    public Predicate where(BipCompanyManageParamVO searchParam) {
        BooleanExpression predicate = this.qBipCompanyManageDO.isNotNull();
        if (!StringUtils.isEmpty((Object)searchParam.getOuId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipCompanyManageDO.ouId.eq((Object)searchParam.getOuId()));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getOuCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipCompanyManageDO.ouCode.like("%" + searchParam.getOuCode() + "%"));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getOuName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipCompanyManageDO.ouName.like("%" + searchParam.getOuName() + "%"));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getViewOuName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipCompanyManageDO.viewOuName.like("%" + searchParam.getViewOuName() + "%"));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getViewOuStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipCompanyManageDO.viewOuStatus.eq(searchParam.getViewOuStatus()));
        }
        return predicate;
    }

    public BipCompanyManageServiceImpl(BipCompanyManageRepo bipCompanyManageRepo, BipCompanyManageRepoProc bipCompanyManageRepoProc) {
        this.bipCompanyManageRepo = bipCompanyManageRepo;
        this.bipCompanyManageRepoProc = bipCompanyManageRepoProc;
    }
}

