/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.config.cas;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.cas.UserSourceProvider;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.Result;
import java.util.Map;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class CasUserClientHelper {
    private static final Logger log = LogManager.getLogger(CasUserClientHelper.class);
    private final AuthorizationSdkProperties sdkProperties;
    private final UserSourceProvider userSourceProvider;
    private final TaskExecutor taskExecutor;
    private final UserTransferHelper userTransferHelper;

    public CasUserClientHelper(AuthorizationSdkProperties sdkProperties, UserSourceProvider userSourceProvider, TaskExecutor taskExecutor) {
        this.sdkProperties = sdkProperties;
        this.userSourceProvider = userSourceProvider;
        this.taskExecutor = taskExecutor;
        this.userTransferHelper = UserTransferHelper.getInstance((String)sdkProperties.getAuthServer());
    }

    public Long onUpsert(@NotNull AuthUserDTO userDTO) {
        if (!this.sdkProperties.getCasClient().getEnabled().booleanValue()) {
            log.warn("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u5ba2\u6237\u7aef\u5df2\u7981\u7528");
            return null;
        }
        return this.execute(() -> {
            Result syncResult = this.userTransferHelper.upsertUser(userDTO);
            if (!syncResult.getSuccess().booleanValue() || syncResult.getData() == null) {
                log.error("CAS\u540c\u6b65\u7528\u6237\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff1a{}, {}", (Object)userDTO, (Object)syncResult);
                return null;
            }
            if (ObjectUtil.equals((Object)userDTO.getId(), (Object)syncResult.getData())) {
                return (Long)syncResult.getData();
            }
            this.userSourceProvider.successCallback(Map.of(userDTO.getUsername(), (Long)syncResult.getData()));
            return (Long)syncResult.getData();
        });
    }

    public void updateMobile(Long userId, String mobile) {
        this.userTransferHelper.updateMobile(userId.longValue(), mobile);
    }

    public Result<AuthUserDTO> getAuthByMobile(String mobile) {
        return this.userTransferHelper.getUserByMobile(mobile);
    }

    public Long onEnabled(long id, boolean enabled) {
        if (!this.sdkProperties.getCasClient().getEnabled().booleanValue()) {
            log.warn("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u5ba2\u6237\u7aef\u5df2\u7981\u7528");
            return null;
        }
        return this.execute(() -> {
            this.userTransferHelper.updateEnabled(id, enabled);
            return id;
        });
    }

    public Long onUpdatePassword(long id, @NotBlank String password) {
        if (!this.sdkProperties.getCasClient().getEnabled().booleanValue()) {
            log.warn("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u5ba2\u6237\u7aef\u5df2\u7981\u7528");
            return null;
        }
        return this.execute(() -> {
            this.userTransferHelper.updatePassword(id, password);
            return id;
        });
    }

    public Long onDelete(long id) {
        if (!this.sdkProperties.getCasClient().getEnabled().booleanValue()) {
            log.warn("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u5ba2\u6237\u7aef\u5df2\u7981\u7528");
            return null;
        }
        return this.execute(() -> {
            this.userTransferHelper.delete(id);
            return id;
        });
    }

    private <T> T execute(Supplier<T> supplier) {
        return supplier.get();
    }
}

