/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerAppSumRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsDealerDtlDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SaleStatisticsDealerRepoProc
extends BaseRepoProc<SaleStatisticsDealerDO> {
    private static final QSaleStatisticsDealerDO qSaleStatisticsDealerDO = QSaleStatisticsDealerDO.saleStatisticsDealerDO;
    private static final QSaleStatisticsDealerDtlDO qSaleStatisticsDealerDtlDO = QSaleStatisticsDealerDtlDO.saleStatisticsDealerDtlDO;
    private final String YEAR_MONTH = "yearMonth";
    private final String DOC_TIME_YEAR_MONTH = "docMonth";
    private final String SHIP_TOTAL_QTY = "shipTotalQty";
    private final String ORDER_TOTAL_QTY = "orderTotalQty";
    private final String DEALER_TOTAL_QTY = "dealerTotalQty";
    private final String AGENT_EMP_CODE = "agentEmpCode";

    protected SaleStatisticsDealerRepoProc() {
        super((EntityPathBase)qSaleStatisticsDealerDO);
    }

    public List<Long> findIdsByCustCode(String custCode, Long minId, int limit) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id).from((EntityPath)qSaleStatisticsDealerDO)).where((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.eq((Object)custCode))).orderBy(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id.asc())).limit((long)limit);
        if (minId != null) {
            jpaQuery.where((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id.gt((Number)minId));
        }
        return jpaQuery.fetch();
    }

    public List<SaleStatisticsDealerRespVO> selectByQueryVO(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where(queryVO);
        JPAQuery jpaQuery = (JPAQuery)this.select(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public SaleStatisticsDealerRespVO selectOneByQueryVO(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where(queryVO);
        JPAQuery jpaQuery = (JPAQuery)this.select(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        return (SaleStatisticsDealerRespVO)jpaQuery.fetchFirst();
    }

    public List<SaleStatisticsDealerRespVO> selectOldByQueryVO(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where(queryVO);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleStatisticsDealerRespVO.class, (Expression[])new Expression[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id})).from((EntityPath)qSaleStatisticsDealerDO)).where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public List<SaleStatisticsDealerRespVO> selectPageByQueryVO(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where(queryVO);
        JPAQuery jpaQuery = (JPAQuery)this.select(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        queryVO.setPaging(jpaQuery);
        queryVO.fillOrders(jpaQuery, (EntityPathBase)qSaleStatisticsDealerDO);
        return jpaQuery.fetch();
    }

    public StatisticsDealerSumRespVO pageSum(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where(queryVO);
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(StatisticsDealerSumRespVO.class, (Expression[])new Expression[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().as("shipTotalQty"), SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().as("orderTotalQty"), SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.countDistinct().as("dealerTotalQty")})).from((EntityPath)qSaleStatisticsDealerDO)).where(ExpressionUtils.allOf(where));
        return (StatisticsDealerSumRespVO)query.fetchFirst();
    }

    public PagingVO<SaleStatisticsDealerRespVO> page(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where2(queryVO);
        JPAQuery query = (JPAQuery)this.pageSelect(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        query.groupBy(new Expression[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime});
        if (!Objects.isNull(queryVO.getShipTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().goe((Number)queryVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getShipTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().loe((Number)queryVO.getShipTotalQtyTo()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().goe((Number)queryVO.getOrderTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().loe((Number)queryVO.getOrderTotalQtyTo()));
        }
        queryVO.setPaging(query);
        if (CollectionUtils.isNotEmpty((Collection)queryVO.getOrders())) {
            for (OrderItem orderItem : queryVO.getOrders()) {
                if (!StringUtils.isNotBlank((CharSequence)orderItem.getColumn())) continue;
                Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
                OrderSpecifier orderSpecifier3 = new OrderSpecifier(order, (Expression)Expressions.stringTemplate((String)orderItem.getColumn(), (Object[])new Object[0]));
                query.orderBy(orderSpecifier3);
            }
        }
        query.orderBy(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.desc());
        query.orderBy(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.createTime.desc());
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public PagingVO<SaleStatisticsDealerRespVO> appPage(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where2(queryVO);
        JPAQuery query = (JPAQuery)this.pageSelect(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        query.groupBy(new Expression[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime});
        if (!Objects.isNull(queryVO.getShipTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().goe((Number)queryVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getShipTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().loe((Number)queryVO.getShipTotalQtyTo()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().goe((Number)queryVO.getOrderTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().loe((Number)queryVO.getOrderTotalQtyTo()));
        }
        if (CollectionUtils.isNotEmpty((Collection)queryVO.getOrders())) {
            for (OrderItem orderItem : queryVO.getOrders()) {
                if (!StringUtils.isNotBlank((CharSequence)orderItem.getColumn())) continue;
                Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
                OrderSpecifier orderSpecifier3 = new OrderSpecifier(order, (Expression)Expressions.stringTemplate((String)orderItem.getColumn(), (Object[])new Object[0]));
                query.orderBy(orderSpecifier3);
            }
        }
        query.orderBy(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.desc());
        query.orderBy(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.createTime.desc());
        queryVO.setPaging(query);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<SaleStatisticsDealerRespVO> dealerQuery(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where(queryVO);
        JPAQuery query = (JPAQuery)this.pageSelect(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        query.groupBy(new Expression[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime});
        if (!Objects.isNull(queryVO.getShipTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().goe((Number)queryVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getShipTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().loe((Number)queryVO.getShipTotalQtyTo()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyFrom())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().goe((Number)queryVO.getOrderTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyTo())) {
            query.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().loe((Number)queryVO.getOrderTotalQtyTo()));
        }
        return query.fetch();
    }

    public PagingVO<SaleStatisticsDealerRespVO> appDetailsPage(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where2(queryVO);
        JPAQuery jpaQuery = (JPAQuery)this.pageSelect(SaleStatisticsDealerRespVO.class).where(ExpressionUtils.allOf(where));
        jpaQuery.groupBy(new Expression[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.itemType3, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime});
        if (!Objects.isNull(queryVO.getShipTotalQtyFrom())) {
            jpaQuery.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().goe((Number)queryVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getShipTotalQtyTo())) {
            jpaQuery.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().loe((Number)queryVO.getShipTotalQtyTo()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyFrom())) {
            jpaQuery.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().goe((Number)queryVO.getOrderTotalQtyFrom()));
        }
        if (!Objects.isNull(queryVO.getOrderTotalQtyTo())) {
            jpaQuery.having((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().loe((Number)queryVO.getOrderTotalQtyTo()));
        }
        queryVO.setPaging(jpaQuery);
        queryVO.fillOrders(jpaQuery, (EntityPathBase)qSaleStatisticsDealerDO);
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    private <T> JPAQuery<T> pageSelect(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerName, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerSerialNo, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().as("shipTotalQty"), SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().as("orderTotalQty"), SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.custType, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.itemType3, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.remark, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.createTime, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.updateRegionFailureReason, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.updateSalesmanFailureReason})).from((EntityPath)qSaleStatisticsDealerDO);
    }

    public List<StatisticsDealerAppSumRespVO> appSumByEmpCode(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> where = this.where(queryVO);
        List<Predicate> dtlWhere = this.dtlWhere(queryVO);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(StatisticsDealerAppSumRespVO.class, (Expression[])new Expression[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDtlDO.code.as("agentEmpCode"), SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.sum().as("shipTotalQty"), SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.sum().as("orderTotalQty"), SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.countDistinct().as("dealerTotalQty")})).from((EntityPath)qSaleStatisticsDealerDO)).leftJoin((EntityPath)qSaleStatisticsDealerDtlDO)).on((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id.eq(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDtlDO.masId))).where(ExpressionUtils.allOf(where))).where(ExpressionUtils.allOf(dtlWhere));
        jpaQuery.groupBy((Expression)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDtlDO.code);
        return jpaQuery.fetch();
    }

    private List<Predicate> dtlWhere(SaleStatisticsDealerQueryVO queryVO) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!CollectionUtils.isEmpty((Collection)queryVO.getAgentEmpList())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDtlDO.code.in((Collection)queryVO.getAgentEmpList()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getLevel())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDtlDO.level.eq((Object)queryVO.getLevel()));
        }
        return predicates;
    }

    private List<Predicate> where(SaleStatisticsDealerQueryVO queryVO) {
        BooleanExpression booleanTemplate;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (Objects.equals(queryVO.getRegionFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (!Objects.isNull(queryVO.getId())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id.eq((Object)queryVO.getId()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getIds())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id.in((Collection)queryVO.getIds()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.eq((Object)queryVO.getDealerCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getDealerCodeList())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.in((Collection)queryVO.getDealerCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerCodeKeyword())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerCodeKeyword() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerName())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerName() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerKeyword())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerKeyword() + "%").or((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getKeyword())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getKeyword() + "%").or((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerSerialNo())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerSerialNo.like("%" + queryVO.getDealerSerialNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerSerialNo1())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerSerialNo.eq((Object)queryVO.getDealerSerialNo1()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getRegion())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.eq((Object)queryVO.getRegion()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getRegionList())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.in((Collection)queryVO.getRegionList()));
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.isNotNull());
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getType())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.type.eq((Object)queryVO.getType()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getTypeList())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.type.in((Collection)queryVO.getTypeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getSalesmanPath())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath.eq((Object)queryVO.getSalesmanPath()));
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath.isNotNull());
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getVehicleType())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType.eq((Object)queryVO.getVehicleType()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getVehicleTypeList())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType.in((Collection)queryVO.getVehicleTypeList()));
        }
        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.between((Comparable)queryVO.getDocTimeStart(), (Comparable)queryVO.getDocTimeEnd()));
        } else {
            if (queryVO.getDocTimeStart() != null) {
                predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.goe((Comparable)queryVO.getDocTimeStart()));
            }
            if (queryVO.getDocTimeEnd() != null) {
                predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.loe((Comparable)queryVO.getDocTimeEnd()));
            }
        }
        if (Objects.nonNull(queryVO.getDocTimeItStart())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.yearMonth().goe((Number)queryVO.getDocTimeItStart()));
        }
        if (Objects.nonNull(queryVO.getDocTimeItEnd())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.yearMonth().loe((Number)queryVO.getDocTimeItEnd()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m')", (Object[])new Object[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime}).eq((Object)queryVO.getDocMonth());
            predicates.add((Predicate)booleanTemplate);
        }
        if (Objects.nonNull(queryVO.getDocTime())) {
            booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m-%d')", (Object[])new Object[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime}).eq((Object)queryVO.getDocTime().toLocalDate().toString());
            predicates.add((Predicate)booleanTemplate);
        }
        if (!Objects.isNull(queryVO.getShipQty())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.eq((Object)queryVO.getShipQty()));
        }
        if (!Objects.isNull(queryVO.getOrderQty())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.eq((Object)queryVO.getOrderQty()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getCustType())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.custType.eq((Object)queryVO.getCustType()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getCustTypes())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.custType.in((Collection)queryVO.getCustTypes()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getItemType3())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.itemType3.eq((Object)queryVO.getItemType3()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getItemType3List())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.itemType3.in((Collection)queryVO.getItemType3List()));
        }
        return predicates;
    }

    private List<Predicate> where2(SaleStatisticsDealerQueryVO queryVO) {
        BooleanExpression booleanTemplate;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (Objects.equals(queryVO.getRegionFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (!Objects.isNull(queryVO.getId())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id.eq((Object)queryVO.getId()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getIds())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id.in((Collection)queryVO.getIds()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.eq((Object)queryVO.getDealerCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getDealerCodeList())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.in((Collection)queryVO.getDealerCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerCodeKeyword())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerCodeKeyword() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerName())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerName() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerKeyword())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerKeyword() + "%").or((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getKeyword())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getKeyword() + "%").or((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerSerialNo())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerSerialNo.like("%" + queryVO.getDealerSerialNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerSerialNo1())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerSerialNo.eq((Object)queryVO.getDealerSerialNo1()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getRegion())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.eq((Object)queryVO.getRegion()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getRegionList())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.in((Collection)queryVO.getRegionList()));
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.isNotNull());
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getType())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.type.eq((Object)queryVO.getType()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getTypeList())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.type.in((Collection)queryVO.getTypeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getSalesmanPath())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath.eq((Object)queryVO.getSalesmanPath()));
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath.isNotNull());
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getVehicleType())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType.eq((Object)queryVO.getVehicleType()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getVehicleTypeList())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType.in((Collection)queryVO.getVehicleTypeList()));
        }
        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.between((Comparable)queryVO.getDocTimeStart(), (Comparable)queryVO.getDocTimeEnd()));
        } else {
            if (queryVO.getDocTimeStart() != null) {
                predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.goe((Comparable)queryVO.getDocTimeStart()));
            }
            if (queryVO.getDocTimeEnd() != null) {
                predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.loe((Comparable)queryVO.getDocTimeEnd()));
            }
        }
        if (Objects.nonNull(queryVO.getDocTimeItStart())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.yearMonth().goe((Number)queryVO.getDocTimeItStart()));
        }
        if (Objects.nonNull(queryVO.getDocTimeItEnd())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.yearMonth().loe((Number)queryVO.getDocTimeItEnd()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m')", (Object[])new Object[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime}).eq((Object)queryVO.getDocMonth());
            predicates.add((Predicate)booleanTemplate);
        }
        if (Objects.nonNull(queryVO.getDocTime())) {
            booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m-%d')", (Object[])new Object[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime}).eq((Object)queryVO.getDocTime().toLocalDate().toString());
            predicates.add((Predicate)booleanTemplate);
        }
        if (!Objects.isNull(queryVO.getShipQty())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty.eq((Object)queryVO.getShipQty()));
        }
        if (!Objects.isNull(queryVO.getOrderQty())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty.eq((Object)queryVO.getOrderQty()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getCustType())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.custType.eq((Object)queryVO.getCustType()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getCustTypes())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.custType.in((Collection)queryVO.getCustTypes()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getItemType3())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.itemType3.eq((Object)queryVO.getItemType3()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getItemType3List())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.itemType3.in((Collection)queryVO.getItemType3List()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryVO.getAgentEmp())) {
            predicates.add((Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id.in((SubQueryExpression)JPAExpressions.select(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDtlDO.masId).from(new EntityPath[]{qSaleStatisticsDealerDtlDO}).where(new Predicate[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDtlDO.code.eq((Object)queryVO.getAgentEmp())})));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerName, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerSerialNo, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.type, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.shipQty, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.orderQty, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.custType, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.itemType3, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.updateRegionFailureReason, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.updateSalesmanFailureReason, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.remark, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.createTime, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.createUserId, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.creator, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.modifyTime, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.modifyUserId, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.updater, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.tenantId, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.deleteFlag, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.belongOrgId, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.tenantOrgId, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.auditDataVersion, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.secBuId, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.secUserId, SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.secOuId})).from((EntityPath)qSaleStatisticsDealerDO);
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)qSaleStatisticsDealerDO).set(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.deleteFlag, (Object)deleteFlag).where(new Predicate[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.id.in(ids)}).execute();
    }

    @Transactional(rollbackOn={Exception.class})
    public void updateDeleteFlagByDocTime(Integer deleteFlag, LocalDate docTime) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qSaleStatisticsDealerDO);
        update.set(SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.deleteFlag, (Object)deleteFlag);
        update.where(new Predicate[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.goe((Comparable)LocalDateTime.of(docTime, LocalTime.MIN))}).where(new Predicate[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.loe((Comparable)LocalDateTime.of(docTime, ConstantsSale.LOCAL_TIME_MAX))}).execute();
    }

    public Predicate selectRegionOrSalesmanPathWhere(SaleStatisticsDealerQueryVO queryVO) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.dealerCode.eq((Object)queryVO.getDealerCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getRegion())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.region.eq((Object)queryVO.getRegion()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getSalesmanPath())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.salesmanPath.eq((Object)queryVO.getSalesmanPath()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getVehicleType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.vehicleType.eq((Object)queryVO.getVehicleType()));
        }
        if (Objects.nonNull(queryVO.getDocTime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime.eq((Object)queryVO.getDocTime()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m')", (Object[])new Object[]{SaleStatisticsDealerRepoProc.qSaleStatisticsDealerDO.docTime}).eq((Object)queryVO.getDocMonth());
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)booleanTemplate);
        }
        return predicate;
    }
}

