/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.SalAcceptanceService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalAcceptancePagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalAcceptanceSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalAcceptanceDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalAcceptancePageRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.SalAcceptanceConvert;
import com.elitesland.yst.production.sale.convert.SalAcceptanceDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.QSalAcceptanceDO;
import com.elitesland.yst.production.sale.entity.SalAcceptanceDDO;
import com.elitesland.yst.production.sale.entity.SalAcceptanceDO;
import com.elitesland.yst.production.sale.repo.SalAcceptanceDRepo;
import com.elitesland.yst.production.sale.repo.SalAcceptanceRepo;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoDService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.workflow.ProcDefKey;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;

@Service
public class SalAcceptanceServiceImpl
extends BaseServiceImpl
implements SalAcceptanceService {
    private static final Logger log = LoggerFactory.getLogger(SalAcceptanceServiceImpl.class);
    private final QSalAcceptanceDO qalAcceptanceDO = QSalAcceptanceDO.salAcceptanceDO;
    private final SalAcceptanceRepo salAcceptanceRepo;
    private final SalAcceptanceDRepo salAcceptanceDRepo;
    private final UserService userService;
    private final RmiSysNextNumberService nextNumberService;
    private final RmiOrderSalSoDService rmiOrderSalSoDService;
    private static final String DOC_STATUS_DONE = "DONE";
    private final RmiOrgEmpService rmiOrgEmpService;
    private final RmiOrgBuService rmiOrgBuService;
    private final RmiOrgOuService rmiOrgOuService;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final RmiCommonService rmiCommonService;
    private final TransactionTemplate transactionTemplate;
    @Autowired
    private WorkflowService workflowService;

    @SysCodeProc
    public PagingVO<SalAcceptancePageRespVO> query(SalAcceptancePagingParam pageParam) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qalAcceptanceDO).where(this.buildPageSearchCondition(pageParam));
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(pageParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, this.qalAcceptanceDO);
        List queryResult = jpaQuery.fetch();
        List<SalAcceptancePageRespVO> pageResult = queryResult.stream().map(SalAcceptanceConvert.INSTANCE::doToPageRespVo).collect(Collectors.toList());
        this.translationPage(pageResult);
        return PagingVO.builder().total(total).records(pageResult).build();
    }

    private void translationPage(List<SalAcceptancePageRespVO> pageRespVOS) {
        List applyEmpIds = pageRespVOS.stream().map(SalAcceptancePageRespVO::getApplyEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Object> empListByParam = new ArrayList();
        if (!ObjectUtils.isEmpty(applyEmpIds)) {
            OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
            orgEmpRpcDtoParam.setEmpIds(applyEmpIds);
            empListByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        List<Long> ouIds = pageRespVOS.stream().map(SalAcceptancePageRespVO::getOuId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Object> ouListByParam = new ArrayList();
        if (!ObjectUtils.isEmpty(ouIds)) {
            ouListByParam = this.rmiOrgOuService.findOuDtoList(ouIds, null);
        }
        List<Object> finalEmpListByParam = empListByParam;
        ArrayList finalOuListByParam = ouListByParam;
        pageRespVOS.forEach(page -> {
            finalEmpListByParam.stream().filter(emp -> emp.getId().equals(page.getApplyEmpId())).findFirst().ifPresent(resp -> page.setApplyEmpName(resp.getEmpName()));
            finalOuListByParam.stream().filter(ou -> ou.getId().equals(page.getOuId())).findFirst().ifPresent(resp -> page.setOuName(resp.getOuName()));
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public JSONObject saveOrSubmit(SalAcceptanceSaveParam param, String operation) {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        this.transactionTemplate.setPropagationBehavior(3);
        SalAcceptanceDO salAcceptanceDO1 = (SalAcceptanceDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                if (Objects.isNull(param.getId())) {
                    String docNO = this.nextNumberService.generateCode("yst-sale", "SAL_AC_NO", new ArrayList<String>());
                    param.setDocNo(docNO);
                } else {
                    SalAcceptanceDO salAcceptanceDO = this.findSalAcceptanceDO(param.getId());
                    String acStatus = salAcceptanceDO.getAcStatus();
                    if (!UdcEnum.SAL_AC_STATUS_DRAFT.getValueCode().equals(acStatus) && !UdcEnum.SAL_AC_STATUS_REJECTED.getValueCode().equals(acStatus)) {
                        throw new BusinessException("\u5f53\u524d\u9a8c\u6536\u5355\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u8be5\u64cd\u4f5c");
                    }
                    param.setDocNo(salAcceptanceDO.getDocNo());
                }
                SalAcceptanceDetailRespVO salAcceptanceDetailRespVO = SalAcceptanceConvert.INSTANCE.paramToDetailVo(param);
                SalAcceptanceDO salAcceptanceDO = SalAcceptanceConvert.INSTANCE.detailVoDo(salAcceptanceDetailRespVO);
                salAcceptanceDO.setDeleteFlag(0);
                if ("SAVE".equals(operation)) {
                    salAcceptanceDO.setAcStatus(UdcEnum.SAL_AC_STATUS_DRAFT.getValueCode());
                }
                salAcceptanceDO.setSecBuId(param.getBuId());
                salAcceptanceDO.setSecOuId(param.getOuId());
                salAcceptanceDO.setSecUserId(param.getApplyEmpId());
                this.salAcceptanceRepo.save(salAcceptanceDO);
                this.comSaleFileInfoService.comSaleFileHardSave("SAL_ACC", salAcceptanceDO.getId(), param.getFileComVOS());
                this.salAcceptanceDRepo.deleteAllByMasId(salAcceptanceDO.getId());
                List paramDetails = salAcceptanceDetailRespVO.getDetails();
                log.info("\u62a5\u4ef7\u5355\u4fdd\u5b58\u660e\u7ec6\u6253\u5370{}", (Object)JSON.toJSONString((Object)paramDetails));
                if (CollUtil.isNotEmpty((Collection)paramDetails)) {
                    paramDetails.forEach(detail -> {
                        detail.setMasId(salAcceptanceDO.getId());
                        if ((detail.getAcQty().abs() == null ? BigDecimal.ZERO : detail.getAcQty()).compareTo(detail.getAeQty().abs()) > 0) {
                            throw new BusinessException("\u53d1\u8d27\u5355\u53f7\uff1a" + detail.getSoNo() + "\uff0c\u672c\u6b21\u9a8c\u6536\u6570\u91cf\u5927\u4e8e\u5f85\u9a8c\u6536\u6570\u91cf");
                        }
                    });
                    List salAcceptanceDDOList = paramDetails.stream().map(SalAcceptanceDConvert.INSTANCE::detailVoToDo).collect(Collectors.toList());
                    this.salAcceptanceDRepo.saveAll(salAcceptanceDDOList);
                }
                return salAcceptanceDO;
            }
            catch (Exception e) {
                transactionStatus.setRollbackOnly();
                throw e;
            }
        });
        if ("SUBMIT".equals(operation)) {
            salAcceptanceDO1.setAcStatus(UdcEnum.SAL_AC_STATUS_APPROVING.getValueCode());
            this.salAcceptanceRepo.save(salAcceptanceDO1);
            List<SalAcceptanceDDO> salAcceptanceDDOS = this.salAcceptanceDRepo.findAllByMasId(salAcceptanceDO1.getId());
            log.info("\u62a5\u4ef7\u5355\u63d0\u4ea4\u5f00\u542f\u5de5\u4f5c\u6d41{}", (Object)JSON.toJSONString((Object)salAcceptanceDO1));
            if (param.getId() == null || salAcceptanceDO1.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(salAcceptanceDO1.getProcInstStatus())) {
                String procInstName = null;
                ProcDefKey procDefKey = null;
                procInstName = "B\u7aef\u5408\u540c\u9a8c\u6536\u5355";
                procDefKey = ProcDefKey.SAL_ACCEPTANCE;
                WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)procDefKey.name(), (String)(procInstName + "-" + salAcceptanceDO1.getDocNo()), (String)("" + salAcceptanceDO1.getId()), null));
                if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                    throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
                }
                log.info("\u62a5\u4ef7\u5355\u5de5\u4f5c\u6d41\u5f00\u542f\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)processInfoWorkflowResult.getData()));
                QSalAcceptanceDO qSalAcceptanceDO = QSalAcceptanceDO.salAcceptanceDO;
                JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qSalAcceptanceDO).set((Path)qSalAcceptanceDO.procInstId, (Object)((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstId()).set(qSalAcceptanceDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qSalAcceptanceDO.id.eq((Object)salAcceptanceDO1.getId())});
                if (!Objects.equals(((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstStatus(), ProcInstStatus.APPROVED)) {
                    jpaUpdateClause.set(qSalAcceptanceDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                    jpaUpdateClause.set((Path)qSalAcceptanceDO.acStatus, (Object)UdcEnum.SAL_AC_STATUS_APPROVING.getValueCode());
                }
                jpaUpdateClause.execute();
            }
        }
        JSONObject result = new JSONObject();
        result.put("id", (Object)salAcceptanceDO1.getId());
        result.put("docNo", (Object)salAcceptanceDO1.getDocNo());
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitOne(Long id) {
        SalAcceptanceDO salAcceptanceDO = this.findSalAcceptanceDO(id);
        if (!UdcEnum.SAL_CONTRACT_STATUS_DRAFT.getValueCode().equals(salAcceptanceDO.getAcStatus())) {
            throw new BusinessException("\u5f53\u524d\u9a8c\u6536\u5355\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        salAcceptanceDO.setAcStatus(UdcEnum.SAL_AC_STATUS_APPROVING.getValueCode());
        this.salAcceptanceRepo.save(salAcceptanceDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteAc(Long id) {
        SalAcceptanceDO salAcceptanceDO = this.findSalAcceptanceDO(id);
        salAcceptanceDO.setDeleteFlag(1);
        this.salAcceptanceRepo.save(salAcceptanceDO);
        List<SalAcceptanceDDO> details = this.salAcceptanceDRepo.findAllByMasId(id);
        details.forEach(d -> d.setDeleteFlag(1));
        this.salAcceptanceDRepo.saveAll(details);
    }

    @SysCodeProc
    public SalAcceptanceDetailRespVO findOneDetail(Long id) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void apprAcc(Long id, String apprStatus) {
    }

    private SalAcceptanceDO findSalAcceptanceDO(Long id) {
        return (SalAcceptanceDO)this.salAcceptanceRepo.findById(id).orElseThrow(new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5b58\u5728"));
    }

    private Predicate buildPageSearchCondition(SalAcceptancePagingParam pageParam) {
        BooleanExpression predicate = this.qalAcceptanceDO.isNotNull();
        if (Objects.nonNull(pageParam)) {
            if (StrUtil.isNotBlank((CharSequence)pageParam.getDocNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.docNo.like("%" + pageParam.getDocNo() + "%"));
            }
            if (Objects.nonNull(pageParam.getOuId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.ouId.eq((Object)pageParam.getOuId()));
            }
            if (Objects.nonNull(pageParam.getCustId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.custId.eq((Object)pageParam.getCustId()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.contractNo.like("%" + pageParam.getContractNo() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.contractName.like("%" + pageParam.getContractName() + "%"));
            }
            if (Objects.nonNull(pageParam.getApplyDate())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.applyDate.eq((Object)pageParam.getApplyDate()));
            }
            if (Objects.nonNull(pageParam.getAcDate())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.acDate.eq((Object)pageParam.getAcDate()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getAcStatus())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.acStatus.eq((Object)pageParam.getAcStatus()));
            }
            if (Objects.nonNull(pageParam.getApplyEmpId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.applyEmpId.eq((Object)pageParam.getApplyEmpId()));
            }
            if (Objects.nonNull(pageParam.getProjName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qalAcceptanceDO.projName.like("%" + pageParam.getProjName() + "%"));
            }
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qalAcceptanceDO.getMetadata()));
        return predicate;
    }

    public SalAcceptanceServiceImpl(SalAcceptanceRepo salAcceptanceRepo, SalAcceptanceDRepo salAcceptanceDRepo, UserService userService, RmiSysNextNumberService nextNumberService, RmiOrderSalSoDService rmiOrderSalSoDService, RmiOrgEmpService rmiOrgEmpService, RmiOrgBuService rmiOrgBuService, RmiOrgOuService rmiOrgOuService, ComSaleFileInfoService comSaleFileInfoService, RmiCommonService rmiCommonService, TransactionTemplate transactionTemplate) {
        this.salAcceptanceRepo = salAcceptanceRepo;
        this.salAcceptanceDRepo = salAcceptanceDRepo;
        this.userService = userService;
        this.nextNumberService = nextNumberService;
        this.rmiOrderSalSoDService = rmiOrderSalSoDService;
        this.rmiOrgEmpService = rmiOrgEmpService;
        this.rmiOrgBuService = rmiOrgBuService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.comSaleFileInfoService = comSaleFileInfoService;
        this.rmiCommonService = rmiCommonService;
        this.transactionTemplate = transactionTemplate;
    }
}

