/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.order.param.SalSoDUpdateDTO;
import com.elitesland.yst.production.order.param.SalSoDetailRespDTO;
import com.elitesland.yst.production.order.param.SalSoReceiptSaveDTO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalInvApplydRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptdRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.query.SalInvApplyCheckDTO;
import com.elitesland.yst.production.sale.dto.query.SalReceiptCheckDTO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.SalInvApplyDO;
import com.elitesland.yst.production.sale.entity.SalInvSerialDO;
import com.elitesland.yst.production.sale.entity.SalReceiptDO;
import com.elitesland.yst.production.sale.repo.SalInvApplyRepo;
import com.elitesland.yst.production.sale.repo.SalInvApplydRepoProc;
import com.elitesland.yst.production.sale.repo.SalInvSerialRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptdRepoProc;
import com.elitesland.yst.production.sale.repo.SalSoaRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoDService;
import com.elitesland.yst.production.sale.service.SalReceiptRpcService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/sale/receipt"})
public class SalReceiptRpcServiceImpl
extends BaseServiceImpl
implements SalReceiptRpcService {
    private static final Logger log = LoggerFactory.getLogger(SalReceiptRpcServiceImpl.class);
    @Autowired
    private SalReceiptRepo salReceiptRepo;
    @Autowired
    private SalReceiptdRepoProc salReceiptdRepoProc;
    @Autowired
    private RmiOrderSalSoDService rmiOrderSalSoDService;
    @Autowired
    private SalSoaRepo salSoaRepo;
    @Autowired
    private SalInvApplyRepo salInvApplyRepo;
    @Autowired
    private SalInvApplydRepoProc salInvApplydRepoProc;
    @Autowired
    private SalInvSerialRepo salInvSerialRepo;
    @Autowired
    private BipOrderRepo bipOrderRepo;

    /*
     * Enabled aggressive block sorting
     */
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> updateReceiptStatus(SalReceiptCheckDTO param) {
        List<Long> sodid;
        List details;
        HashMap IdAndAmt;
        List ddos;
        Optional relaOp;
        Optional optional = this.salReceiptRepo.findById(param.getId());
        if (optional.isEmpty()) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        SalReceiptDO salReceiptDO = (SalReceiptDO)optional.get();
        if (!salReceiptDO.getDocStatus().equals(UdcEnum.SAL_RECEIPT_STATUS_APPROVING.getValueCode())) {
            throw new BusinessException("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u5ba1\u6279\u7684\u624d\u80fd\u5ba1\u6279");
        }
        SalReceiptDO relaSal = new SalReceiptDO();
        if (!StringUtils.isEmpty((Object)salReceiptDO.getRelateDocId()) && !(relaOp = this.salReceiptRepo.findById(salReceiptDO.getRelateDocId())).isEmpty()) {
            relaSal = (SalReceiptDO)relaOp.get();
        }
        List<Object> soaList = new ArrayList();
        if (salReceiptDO.getSoaOrSo() != null && "SOA".equals(salReceiptDO.getSoaOrSo())) {
            List invDs = this.salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
            List<Long> soaId = invDs.stream().map(SalReceiptdRespVO::getSoaId).distinct().collect(Collectors.toList());
            soaList = this.salSoaRepo.findByIdIn(soaId);
            if (!salReceiptDO.getReceiptType().equals("RED")) {
                soaList.forEach(soa -> {
                    if (!soa.getSoaReceiptStatus().equals(UdcEnum.SAL_SOA_RECEIPT_STATUS_20.getValueCode())) {
                        throw new BusinessException("\u5bf9\u8d26\u5355" + soa.getDocNo() + "\u7684\u5bf9\u8d26\u5355\u6536\u6b3e\u72b6\u6001\u4e0d\u4e3a\u6536\u6b3e\u4e2d");
                    }
                });
            }
        }
        if ("approve".equals(param.getType())) {
            salReceiptDO.setDocStatus(UdcEnum.SAL_RECEIPT_STATUS_APPROVED.getValueCode());
            if (relaSal != null && "DEPOSIT".equals(relaSal.getReceiptType())) {
                if (salReceiptDO.getReceiptType().equals("20")) {
                    amt = salReceiptDO.getAmt() == null ? BigDecimal.ZERO : salReceiptDO.getAmt().abs();
                    relaSal.setReturningAmt((relaSal.getReturningAmt() == null ? BigDecimal.ZERO : relaSal.getReturningAmt()).subtract(amt));
                    relaSal.setReturnAmt((relaSal.getReturnAmt() == null ? BigDecimal.ZERO : relaSal.getReturnAmt()).add(amt));
                } else {
                    amt = salReceiptDO.getAmt() == null ? BigDecimal.ZERO : salReceiptDO.getAmt().abs();
                    relaSal.setTransferAmt(relaSal.getTransferAmt().add(amt));
                    relaSal.setTransferingAmt(relaSal.getTransferingAmt().subtract(amt));
                }
                this.salReceiptRepo.save(relaSal);
            }
            if (salReceiptDO.getSoaOrSo() != null && "SOA".equals(salReceiptDO.getSoaOrSo())) {
                if (salReceiptDO.getReceiptType() != null && salReceiptDO.getReceiptType().equals("RED")) {
                    soaList.forEach(soa -> soa.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_10.getValueCode()));
                } else {
                    soaList.forEach(soa -> soa.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_30.getValueCode()));
                }
                this.salSoaRepo.saveAll(soaList);
            }
        } else {
            if (!"reject".equals(param.getType())) throw new BusinessException("\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
            salReceiptDO.setDocStatus(UdcEnum.SAL_RECEIPT_STATUS_REJECTED.getValueCode());
            if (relaSal != null && "DEPOSIT".equals(relaSal.getReceiptType())) {
                if (salReceiptDO.getReceiptType().equals("20")) {
                    amt = salReceiptDO.getAmt() == null ? BigDecimal.ZERO : salReceiptDO.getAmt().abs();
                    relaSal.setReturningAmt((relaSal.getReturningAmt() == null ? BigDecimal.ZERO : relaSal.getReturningAmt()).subtract(amt));
                    relaSal.setOpenAmt((relaSal.getOpenAmt() == null ? BigDecimal.ZERO : relaSal.getOpenAmt()).add(amt));
                } else {
                    amt = salReceiptDO.getAmt() == null ? BigDecimal.ZERO : salReceiptDO.getAmt().abs();
                    relaSal.setOpenAmt(relaSal.getOpenAmt().add(amt));
                    relaSal.setTransferingAmt(relaSal.getTransferingAmt().subtract(amt));
                }
                this.salReceiptRepo.save(relaSal);
            }
            if ("RED".equals(salReceiptDO.getReceiptType())) {
                SalReceiptDO salRDO = (SalReceiptDO)this.salReceiptRepo.findById(salReceiptDO.getRelateDocId()).get();
                salRDO.setOffFlag(null);
                this.salReceiptRepo.save(salRDO);
            }
            if (salReceiptDO.getSoaOrSo() != null && "SOA".equals(salReceiptDO.getSoaOrSo())) {
                soaList.forEach(soa -> {
                    soa.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_10.getValueCode());
                    soa.setReceiptId(null);
                    soa.setReceiptNo(null);
                });
                this.salSoaRepo.saveAll(soaList);
            }
        }
        salReceiptDO.setApprTime(LocalDateTime.now());
        if (param.getApprComment() != null) {
            salReceiptDO.setApprComment(param.getApprComment());
        }
        if (param.getApprUserId() != null) {
            salReceiptDO.setApprUserId(param.getApprUserId());
        }
        if (param.getApprUserName() != null) {
            salReceiptDO.setApprUserName(param.getApprUserName());
        }
        this.salReceiptRepo.save(salReceiptDO);
        if ("reject".equals(param.getType())) {
            if (salReceiptDO.getDocType() != null && salReceiptDO.getDocType().equals("RD")) {
                if (salReceiptDO.getReceiptType() != null) {
                    if (salReceiptDO.getReceiptType().equals("30")) return ApiResult.ok();
                }
                if ((ddos = this.salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch()).size() <= 0) return ApiResult.ok();
                IdAndAmt = new HashMap();
                ddos.forEach(ddo -> {
                    if (ddo.getSoDId() != null && ddo.getReceiptAmt() != null) {
                        IdAndAmt.put(ddo.getSoDId(), ddo.getReceiptAmt().abs());
                    }
                });
                if (IdAndAmt.size() <= 0) return ApiResult.ok();
                return ApiResult.ok();
            } else {
                details = this.salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
                sodid = details.stream().map(SalReceiptdRespVO::getSoDId).collect(Collectors.toList());
                List<SalSoDetailRespDTO> sodList = this.getSodListBySodId(sodid);
                ArrayList<SalSoDUpdateDTO> sodUpList = new ArrayList<SalSoDUpdateDTO>();
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setPayingAmt(sod.getPayingAmt() == null ? BigDecimal.ZERO : sod.getPayingAmt());
                    salSoDUpdateDTO.setOpenAmt(sod.getOpenAmt() == null ? BigDecimal.ZERO : sod.getOpenAmt());
                    salSoDUpdateDTO.setPayedAmt(sod.getPayedAmt() == null ? BigDecimal.ZERO : sod.getPayedAmt());
                    details.forEach(d -> {
                        if (sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setPayingAmt(salSoDUpdateDTO.getPayingAmt().subtract(d.getReceiptAmt()));
                            salSoDUpdateDTO.setOpenAmt(salSoDUpdateDTO.getOpenAmt().add(d.getReceiptAmt()));
                        }
                    });
                    salSoDUpdateDTO.setApAmt(sod.getConfirmQty().multiply(sod.getPrice()).subtract(salSoDUpdateDTO.getPayedAmt()).subtract(salSoDUpdateDTO.getPayingAmt()));
                    sodUpList.add(salSoDUpdateDTO);
                });
                if (sodUpList.size() <= 0) return ApiResult.ok();
                this.rmiOrderSalSoDService.querySalSoDetail(sodUpList);
                return ApiResult.ok();
            }
        }
        if (salReceiptDO.getDocType() != null && salReceiptDO.getDocType().equals("RD")) {
            if (salReceiptDO.getReceiptType() != null && salReceiptDO.getReceiptType().equals("30")) {
                List detailList = this.salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
                List<Long> sodIdList = detailList.stream().filter(s -> s.getSoDId() != null).map(SalReceiptdRespVO::getSoDId).collect(Collectors.toList());
                List<Object> sodList = new ArrayList();
                if (sodIdList.size() > 0) {
                    sodList = this.getSodListBySodId(sodIdList);
                }
                ArrayList<SalSoDUpdateDTO> sodUpList = new ArrayList<SalSoDUpdateDTO>();
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setPayingAmt(sod.getPayingAmt() == null ? BigDecimal.ZERO : sod.getPayingAmt());
                    salSoDUpdateDTO.setOpenAmt(sod.getOpenAmt() == null ? BigDecimal.ZERO : sod.getOpenAmt());
                    salSoDUpdateDTO.setPayedAmt(sod.getPayedAmt() == null ? BigDecimal.ZERO : sod.getPayedAmt());
                    detailList.forEach(d -> {
                        if (sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setPayedAmt(salSoDUpdateDTO.getPayedAmt().add(d.getReceiptAmt()));
                            salSoDUpdateDTO.setOpenAmt(salSoDUpdateDTO.getOpenAmt().subtract(d.getReceiptAmt()));
                        }
                    });
                    salSoDUpdateDTO.setApAmt(sod.getConfirmQty().multiply(sod.getPrice()).subtract(salSoDUpdateDTO.getPayedAmt()).subtract(salSoDUpdateDTO.getPayingAmt()));
                    sodUpList.add(salSoDUpdateDTO);
                });
                if (sodUpList.size() <= 0) return ApiResult.ok();
                this.rmiOrderSalSoDService.querySalSoDetail(sodUpList);
                return ApiResult.ok();
            }
            ddos = this.salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
            if (ddos.size() <= 0) return ApiResult.ok();
            IdAndAmt = new HashMap();
            ddos.forEach(ddo -> {
                if (ddo.getSoDId() != null && ddo.getReceiptAmt() != null) {
                    IdAndAmt.put(ddo.getSoDId(), ddo.getReceiptAmt().abs());
                }
            });
            if (IdAndAmt.size() <= 0) return ApiResult.ok();
            return ApiResult.ok();
        } else {
            details = this.salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
            sodid = details.stream().map(SalReceiptdRespVO::getSoDId).collect(Collectors.toList());
            List<SalSoDetailRespDTO> sodList = this.getSodListBySodId(sodid);
            ArrayList<SalSoDUpdateDTO> sodUpList = new ArrayList<SalSoDUpdateDTO>();
            sodList.forEach(sod -> {
                SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                salSoDUpdateDTO.setSodId(sod.getSoDId());
                salSoDUpdateDTO.setPayingAmt(sod.getPayingAmt() == null ? BigDecimal.ZERO : sod.getPayingAmt());
                salSoDUpdateDTO.setPayedAmt(sod.getPayedAmt() == null ? BigDecimal.ZERO : sod.getPayedAmt());
                details.forEach(d -> {
                    if (sod.getSoDId().equals(d.getSoDId())) {
                        salSoDUpdateDTO.setPayingAmt(salSoDUpdateDTO.getPayingAmt().subtract(d.getReceiptAmt()));
                        salSoDUpdateDTO.setPayedAmt(salSoDUpdateDTO.getPayedAmt().add(d.getReceiptAmt()));
                    }
                });
                sodUpList.add(salSoDUpdateDTO);
            });
            if (sodUpList.size() > 0) {
                this.rmiOrderSalSoDService.querySalSoDetail(sodUpList);
            }
            ArrayList soList = new ArrayList();
            details.forEach(d -> {
                SalSoReceiptSaveDTO saveDTO = new SalSoReceiptSaveDTO();
                saveDTO.setSoId(d.getSoId());
                saveDTO.setSoNo(d.getSoNo());
                saveDTO.setSoDId(d.getSoDId());
                saveDTO.setSoLineNo(d.getSoLineNo().toString());
                saveDTO.setReceiptType(salReceiptDO.getReceiptType());
                saveDTO.setReceiptMethod(salReceiptDO.getPayMethod());
                saveDTO.setReceiptAmt(d.getReceiptAmt());
                saveDTO.setReceiptTax(d.getReceiptTax());
                saveDTO.setApplyTime(salReceiptDO.getApplyDate());
                saveDTO.setApprTime(salReceiptDO.getApprTime());
                saveDTO.setRelateDocType(salReceiptDO.getDocType());
                saveDTO.setRelateDocId(salReceiptDO.getId());
                saveDTO.setRelateDocNo(salReceiptDO.getDocNo());
                saveDTO.setRelateDocDid(d.getId());
                if (salReceiptDO.getReceiptType().equals("OFF_PRE")) {
                    saveDTO.setType("OFF_PRE");
                }
                soList.add(saveDTO);
            });
            if (soList.size() > 0) {
                // empty if block
            }
            if (salReceiptDO.getReceiptType() == null) return ApiResult.ok();
            if (!salReceiptDO.getReceiptType().equals("OFF_PRE")) return ApiResult.ok();
            List<String> soNoList = details.stream().filter(a -> a.getSoNo() != null).map(SalReceiptdRespVO::getSoNo).collect(Collectors.toList());
            List<BipOrderDO> orderList = this.bipOrderRepo.findAllByDocNoIn(soNoList);
            if (orderList.size() <= 0) return ApiResult.ok();
            orderList.forEach(a -> a.setStatus("shipping"));
            this.bipOrderRepo.saveAll(orderList);
        }
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> updateInvApplyStatus(SalInvApplyCheckDTO param) {
        log.info("\u5f00\u7968\u7533\u8bf7\u5ba1\u6279\u56de\u4f20\u65b9\u6cd5\u5165\u53c2" + JSONUtil.toJsonStr((Object)param));
        Optional optional = this.salInvApplyRepo.findById(param.getId());
        if (optional.isEmpty()) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        SalInvApplyDO salInvApplyDO = (SalInvApplyDO)optional.get();
        if (!salInvApplyDO.getDocStatus().equals(UdcEnum.SAL_BILL_STATUS_APPROVING.getValueCode())) {
            throw new BusinessException("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u5ba1\u6279\u7684\u624d\u80fd\u5ba1\u6279");
        }
        List<Object> soaList = new ArrayList();
        if (salInvApplyDO.getSoaOrSo() != null && "SOA".equals(salInvApplyDO.getSoaOrSo())) {
            List invDs = this.salInvApplydRepoProc.findBymasId(salInvApplyDO.getId()).fetch();
            List<Long> soaId = invDs.stream().map(SalInvApplydRespVO::getSoaId).distinct().collect(Collectors.toList());
            soaList = this.salSoaRepo.findByIdIn(soaId);
            soaList.forEach(soa -> {
                if (soa.getInvApplyingAmt().compareTo(salInvApplyDO.getInvAmt()) < 0 && salInvApplyDO.getOpenType().equals("1")) {
                    throw new BusinessException("\u5bf9\u8d26\u5355" + soa.getDocNo() + "\u7684\u5f00\u7968\u4e2d\u91d1\u989d\u4e0d\u8db3");
                }
            });
        }
        if ("approve".equals(param.getType())) {
            if (salInvApplyDO.getOpenType().equals("1") && (param.getInvSerialList() == null || param.getInvSerialList().size() == 0)) {
                throw new BusinessException("\u5f00\u7968\u901a\u8fc7\u6d41\u7a0b\u5fc5\u987b\u8fd4\u56de\u6d41\u6c34\u53f7\u7b49\u4fe1\u606f");
            }
            salInvApplyDO.setDocStatus(UdcEnum.SAL_BILL_STATUS_INVOICED.getValueCode());
            salInvApplyDO.setInvDate(LocalDateTime.now());
            if (salInvApplyDO.getSoaOrSo() != null && "SOA".equals(salInvApplyDO.getSoaOrSo())) {
                soaList.forEach(soa -> {
                    if ("1".equals(salInvApplyDO.getOpenType())) {
                        soa.setInvApplyingAmt(soa.getInvApplyingAmt().subtract(salInvApplyDO.getInvAmt()));
                        soa.setInvApplyedAmt((soa.getInvApplyedAmt() == null ? BigDecimal.ZERO : soa.getInvApplyedAmt()).add(salInvApplyDO.getInvAmt()));
                    } else {
                        soa.setInvApplyAmt(soa.getInvApplyAmt().subtract(salInvApplyDO.getInvAmt()));
                        soa.setInvApplyedAmt((soa.getInvApplyedAmt() == null ? BigDecimal.ZERO : soa.getInvApplyedAmt()).add(salInvApplyDO.getInvAmt()));
                    }
                });
                this.salSoaRepo.saveAll(soaList);
            }
        } else if ("reject".equals(param.getType())) {
            salInvApplyDO.setDocStatus(UdcEnum.SAL_BILL_STATUS_REJECTED.getValueCode());
            if ("1".equals(salInvApplyDO.getOpenType()) && salInvApplyDO.getSoaOrSo() != null && "SOA".equals(salInvApplyDO.getSoaOrSo())) {
                soaList.forEach(soa -> {
                    soa.setInvApplyingAmt(soa.getInvApplyingAmt().subtract(salInvApplyDO.getInvAmt()));
                    soa.setInvApplyAmt(soa.getInvApplyAmt().add(salInvApplyDO.getInvAmt()));
                    soa.setInvApplyId(null);
                    soa.setInvApplyNo(null);
                });
                this.salSoaRepo.saveAll(soaList);
            }
        } else {
            throw new BusinessException("\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
        }
        salInvApplyDO.setApprTime(LocalDateTime.now());
        if (param.getApprComment() != null) {
            salInvApplyDO.setApprComment(param.getApprComment());
        }
        if (param.getApprUserId() != null) {
            salInvApplyDO.setApprUserId(param.getApprUserId());
        }
        if (param.getApprUserName() != null) {
            salInvApplyDO.setApprUserName(param.getApprUserName());
        }
        this.salInvApplyRepo.save(salInvApplyDO);
        if (param.getInvSerialList() != null && param.getInvSerialList().size() > 0) {
            ArrayList list = new ArrayList();
            param.getInvSerialList().forEach(l -> {
                SalInvSerialDO invSerialDO = new SalInvSerialDO();
                BeanCopyUtil.beanCopy((Object)l, (Object)invSerialDO);
                invSerialDO.setMasId(salInvApplyDO.getId());
                list.add(invSerialDO);
            });
            this.salInvSerialRepo.saveAll(list);
        }
        List details = this.salInvApplydRepoProc.findBymasId(salInvApplyDO.getId()).fetch();
        if ("reject".equals(param.getType()) && salInvApplyDO.getOpenType().equals("1")) {
            List<Long> sodid = details.stream().map(SalInvApplydRespVO::getSoDId).collect(Collectors.toList());
            List<SalSoDetailRespDTO> sodList = this.getSodListBySodId(sodid);
            ArrayList<SalSoDUpdateDTO> sodUpList = new ArrayList<SalSoDUpdateDTO>();
            log.info("\u5f00\u7968\u62d2\u7edd\u53cd\u5199\u5165\u53c2:sodList-" + JSON.toJSONString(sodList) + ";details-" + JSON.toJSONString((Object)details));
            sodList.forEach(sod -> {
                SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                salSoDUpdateDTO.setSodId(sod.getSoDId());
                salSoDUpdateDTO.setInvingAmt(sod.getInvingAmt());
                salSoDUpdateDTO.setInvingQty(sod.getInvingQty());
                salSoDUpdateDTO.setNoinvAmt(sod.getNoinvAmt());
                salSoDUpdateDTO.setNoinvQty(sod.getNoinvQty());
                details.forEach(d -> {
                    if (sod.getSoDId().equals(d.getSoDId())) {
                        salSoDUpdateDTO.setInvingAmt(salSoDUpdateDTO.getInvingAmt().subtract(d.getApplyAmt()));
                        salSoDUpdateDTO.setInvingQty(salSoDUpdateDTO.getInvingQty().subtract(d.getApplyQty()));
                        salSoDUpdateDTO.setNoinvAmt(salSoDUpdateDTO.getNoinvAmt().add(d.getApplyAmt()));
                        salSoDUpdateDTO.setNoinvQty(salSoDUpdateDTO.getNoinvQty().add(d.getApplyQty()));
                    }
                });
                sodUpList.add(salSoDUpdateDTO);
            });
            if (sodUpList.size() > 0) {
                this.rmiOrderSalSoDService.querySalSoDetail(sodUpList);
            }
        } else if ("approve".equals(param.getType())) {
            if (salInvApplyDO.getOpenType().equals("2")) {
                sodIdList = details.stream().map(SalInvApplydRespVO::getSoDId).collect(Collectors.toList());
                List<SalSoDetailRespDTO> sodList = this.getSodListBySodId(sodIdList);
                ArrayList<SalSoDUpdateDTO> sodUpList = new ArrayList<SalSoDUpdateDTO>();
                log.info("\u7ea2\u7968\u901a\u8fc7\u53cd\u5199\u5165\u53c2:sodList-" + JSON.toJSONString(sodList) + ";details-" + JSON.toJSONString((Object)details));
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setInvedAmt(sod.getInvedAmt());
                    salSoDUpdateDTO.setInvedQty(sod.getInvedQty());
                    salSoDUpdateDTO.setNoinvAmt(sod.getNoinvAmt());
                    salSoDUpdateDTO.setNoinvQty(sod.getNoinvQty());
                    salSoDUpdateDTO.setInvDate(salInvApplyDO.getInvDate());
                    details.forEach(d -> {
                        if (sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setInvedAmt(salSoDUpdateDTO.getInvedAmt().add(d.getApplyAmt()));
                            salSoDUpdateDTO.setInvedQty(salSoDUpdateDTO.getInvedQty().add(d.getApplyQty()));
                            salSoDUpdateDTO.setNoinvAmt(salSoDUpdateDTO.getNoinvAmt().subtract(d.getApplyAmt()));
                            salSoDUpdateDTO.setNoinvQty(salSoDUpdateDTO.getNoinvQty().subtract(d.getApplyQty()));
                        }
                    });
                    sodUpList.add(salSoDUpdateDTO);
                });
                if (sodUpList.size() > 0) {
                    this.rmiOrderSalSoDService.querySalSoDetail(sodUpList);
                }
            } else {
                sodIdList = details.stream().map(SalInvApplydRespVO::getSoDId).collect(Collectors.toList());
                List<SalSoDetailRespDTO> sodList = this.getSodListBySodId(sodIdList);
                ArrayList<SalSoDUpdateDTO> sodUpList = new ArrayList<SalSoDUpdateDTO>();
                log.info("\u84dd\u7968\u901a\u8fc7\u53cd\u5199\u5165\u53c2:sodList-" + JSON.toJSONString(sodList) + ";details-" + JSON.toJSONString((Object)details));
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setInvingAmt(sod.getInvingAmt());
                    salSoDUpdateDTO.setInvingQty(sod.getInvingQty());
                    salSoDUpdateDTO.setInvedAmt(sod.getInvedAmt());
                    salSoDUpdateDTO.setInvedQty(sod.getInvedQty());
                    salSoDUpdateDTO.setInvDate(salInvApplyDO.getInvDate());
                    details.forEach(d -> {
                        if (sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setInvedAmt(salSoDUpdateDTO.getInvedAmt().add(d.getApplyAmt()));
                            salSoDUpdateDTO.setInvedQty(salSoDUpdateDTO.getInvedQty().add(d.getApplyQty()));
                            salSoDUpdateDTO.setInvingAmt(salSoDUpdateDTO.getInvingAmt().subtract(d.getApplyAmt()));
                            salSoDUpdateDTO.setInvingQty(salSoDUpdateDTO.getInvingQty().subtract(d.getApplyQty()));
                        }
                    });
                    sodUpList.add(salSoDUpdateDTO);
                });
                if (sodUpList.size() > 0) {
                    this.rmiOrderSalSoDService.querySalSoDetail(sodUpList);
                }
            }
        }
        return ApiResult.ok();
    }

    private List<SalSoDetailRespDTO> getSodListBySodId(List<Long> sodIds) {
        ArrayList<SalSoDetailRespDTO> sodList = new ArrayList<SalSoDetailRespDTO>();
        return sodList;
    }
}

