/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.dto.BipItemCatsDTO;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceTypeQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipItemAppQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipItemRecommendAppQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceTypeRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuAttrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSpecRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountGiftVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BaseBipItemAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemAttrAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemDetailAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemHotAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemListAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemPicAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemRecGoodAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemRecommendAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipReceiptAddrAppRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemExtDO;
import com.elitesland.yst.production.sale.entity.BipItemPicDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.FirstSpecialDO;
import com.elitesland.yst.production.sale.entity.FirstSpecialItemDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDO;
import com.elitesland.yst.production.sale.entity.QFirstSpecialDO;
import com.elitesland.yst.production.sale.entity.QFirstSpecialItemDO;
import com.elitesland.yst.production.sale.entity.QMktDiscountGiftDDO;
import com.elitesland.yst.production.sale.entity.QMktGiftDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.FirstSpecialItemRepo;
import com.elitesland.yst.production.sale.repo.FirstSpecialRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemExtRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemPicRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountGiftRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountOffsetRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BipItemAppServiceImpl
extends BaseServiceImpl
implements BipItemAppService {
    private static final Logger log = LoggerFactory.getLogger(BipItemAppServiceImpl.class);
    private final BipItemRepo itemRepo;
    private final BipItemRepoProc itemRepoProc;
    private final BipItemExtRepo itemExtRepo;
    private final BipItemPicRepoProc itemPicRepoProc;
    private final BipItemSkuRepoProc itemSkuRepoProc;
    private final CrmCustRepoProc custRepoProc;
    private final BipCustUserBindService custUserBindService;
    private final PriSalePriceService salePriceService;
    private final BipOrderRepo bipOrderRepo;
    private final BipOrderDRepo bipOrderDRepo;
    private final FirstSpecialRepo firstSpecialRepo;
    private final FirstSpecialItemRepo firstSpecialItemRepo;
    private final BipItemSkuRepo bipItemSkuRepo;
    private final BipItemSkuRepoProc bipItemSkuRepoProc;
    private final RmiOrgAddrService rmiOrgAddrService;
    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;
    private final MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc;
    private static final BipItemConvert CONVERT = BipItemConvert.INSTANCE;
    private static final QBipItemDO ITEM_DO = QBipItemDO.bipItemDO;

    public ApiResult<PagingVO<BipItemListAppRespVO>> queryForApp(BipItemAppQueryParamVO queryParamVO) {
        queryParamVO.setCurrent(Integer.valueOf(NumberUtil.max((int[])new int[]{1, (Integer)ObjectUtil.defaultIfNull((Object)queryParamVO.getCurrent(), (Object)1)})));
        queryParamVO.setSize(Integer.valueOf(NumberUtil.max((int[])new int[]{1, (Integer)ObjectUtil.defaultIfNull((Object)queryParamVO.getSize(), (Object)10)})));
        PagingVO<BipItemListAppRespVO> pageData = this.searchForAppByDB(queryParamVO);
        if (CollUtil.isEmpty((Collection)pageData.getRecords())) {
            return ApiResult.ok(pageData);
        }
        Long userId = this.currentUserId();
        this.setSupportItem(pageData.getRecords());
        this.setMinPrice(pageData.getRecords(), userId, queryParamVO.getOuId());
        for (BipItemListAppRespVO item : pageData.getRecords()) {
            List<MktDiscountOffsetVO> discountOffset;
            item.setGiftFlag(Boolean.valueOf(false));
            item.setOffsetFlag(Boolean.valueOf(false));
            List<MktDiscountGiftVO> discountGift = this.findDiscountGift(item.getId(), queryParamVO.getOuId());
            if (discountGift != null && discountGift.size() > 0) {
                item.setGiftFlag(Boolean.valueOf(true));
            }
            if ((discountOffset = this.findDiscountOffset(item.getId(), queryParamVO.getOuId())) == null || discountOffset.size() <= 0) continue;
            item.setOffsetFlag(Boolean.valueOf(true));
        }
        return ApiResult.ok(pageData);
    }

    public ApiResult<List<BipItemListAppRespVO>> rotationItem(String offsetCode) {
        List<MktDiscountOffsetVO> offsetVOS = this.mktDiscountOffsetRepoProc.selectForRotation(offsetCode);
        if (offsetVOS.size() == 0) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<BipItemDO> spus = this.bipItemSkuRepoProc.findSkuOnRotation(offsetVOS.get(0).getOuId(), offsetVOS.stream().map(MktDiscountOffsetVO::getItemCode).filter(Objects::nonNull).collect(Collectors.toList()));
        List spuIds = spus.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollUtil.isEmpty(spuIds)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List items = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipItemListAppRespVO.class, (Expression[])new Expression[]{BipItemAppServiceImpl.ITEM_DO.id, BipItemAppServiceImpl.ITEM_DO.mainPicFileCode.as("picFileCode"), BipItemAppServiceImpl.ITEM_DO.mainPicUrl.as("picUrl"), BipItemAppServiceImpl.ITEM_DO.title, BipItemAppServiceImpl.ITEM_DO.itemId, BipItemAppServiceImpl.ITEM_DO.price, BipItemAppServiceImpl.ITEM_DO.numSale, BipItemAppServiceImpl.ITEM_DO.numSale90, BipItemAppServiceImpl.ITEM_DO.rateEvalGood, BipItemAppServiceImpl.ITEM_DO.scoreEval})).from((EntityPath)ITEM_DO)).where((Predicate)BipItemAppServiceImpl.ITEM_DO.id.in(spuIds))).fetch();
        this.setSupportItem(items);
        Long userId = this.currentUserId();
        this.setMinPrice(items, userId, offsetVOS.get(0).getOuId());
        return ApiResult.ok((Object)items);
    }

    public ApiResult<List<BipItemRecommendAppRespVO>> queryForAppRecommend(BipItemRecommendAppQueryParamVO queryParamVO) {
        if (queryParamVO.getBipItemId() == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        BipItemCatsDTO itemCategory = this.itemRepoProc.getItemCategory(queryParamVO.getBipItemId());
        if (itemCategory == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        Integer size = (Integer)ObjectUtil.defaultIfNull((Object)queryParamVO.getSize(), (Object)2);
        List<BipItemRecommendAppRespVO> respVoList = this.searchForRecommendByDb(itemCategory.getCategoryId3(), 3, queryParamVO.getBipItemId(), size);
        if (respVoList.size() < size) {
            Map<Long, BipItemRecommendAppRespVO> respVOMap = respVoList.stream().collect(Collectors.toMap(BaseBipItemAppRespVO::getId, t -> t, (t1, t2) -> t1));
            List<BipItemRecommendAppRespVO> respVoListTemp = this.searchForRecommendByDb(itemCategory.getCategoryId2(), 2, queryParamVO.getBipItemId(), size);
            if (CollUtil.isNotEmpty(respVoListTemp)) {
                for (BipItemRecommendAppRespVO temp : respVoListTemp) {
                    respVOMap.put(temp.getId(), temp);
                }
            }
            if (CollUtil.isNotEmpty(respVoListTemp = this.searchForRecommendByDb(itemCategory.getCategoryId1(), 1, queryParamVO.getBipItemId(), size))) {
                for (BipItemRecommendAppRespVO temp : respVoListTemp) {
                    respVOMap.put(temp.getId(), temp);
                }
            }
            respVoList = new ArrayList<BipItemRecommendAppRespVO>(respVOMap.values());
        }
        if (respVoList.isEmpty()) {
            return ApiResult.ok(respVoList);
        }
        Long userId = this.currentUserId();
        this.setSupportItem(respVoList);
        this.setMinPrice(respVoList, userId, queryParamVO.getOuId());
        for (BipItemRecommendAppRespVO item : respVoList) {
            List<MktDiscountOffsetVO> discountOffset;
            item.setGiftFlag(Boolean.valueOf(false));
            item.setOffsetFlag(Boolean.valueOf(false));
            List<MktDiscountGiftVO> discountGift = this.findDiscountGift(item.getId(), queryParamVO.getOuId());
            if (discountGift != null && discountGift.size() > 0) {
                item.setGiftFlag(Boolean.valueOf(true));
            }
            if ((discountOffset = this.findDiscountOffset(item.getId(), queryParamVO.getOuId())) == null || discountOffset.size() <= 0) continue;
            item.setOffsetFlag(Boolean.valueOf(true));
        }
        return ApiResult.ok(respVoList);
    }

    public ApiResult<PagingVO<BipItemHotAppRespVO>> queryForAppHot(Long ouId) {
        Assert.notNull((Object)ouId, (String)"\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PagingVO<BipItemHotAppRespVO> respVo = this.searchForHotByDb(ouId);
        if (respVo == null || respVo.getRecords() == null || respVo.getRecords().isEmpty()) {
            return ApiResult.ok(respVo);
        }
        CurrentUserDTO user = UserService.currentUser();
        Long userId = user == null ? null : user.getUserId();
        this.setSupportItem(respVo.getRecords());
        this.setMinPrice(respVo.getRecords(), userId, ouId);
        return ApiResult.ok(respVo);
    }

    private void setSupportItem(List<? extends BaseBipItemAppRespVO> vos) {
    }

    private void setMinPrice(List<? extends BaseBipItemAppRespVO> respVOList, Long userId, Long ouId) {
        CustDTO cust = (CustDTO)this.custUserBindService.getCustOfUserBind(userId).getData();
        for (BaseBipItemAppRespVO baseBipItemAppRespVO : respVOList) {
            PriSalePriceTypeQueryParam param;
            if (cust != null && StringUtils.isNotBlank((CharSequence)cust.getCustLevel())) {
                param = new PriSalePriceTypeQueryParam();
                param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode());
                param.setCustLevel(cust.getCustLevel());
                param.setCurrCode(baseBipItemAppRespVO.getCurrCode());
                param.setOuId(cust.getOuId());
                baseBipItemAppRespVO.getSupportItems().stream().map(item -> {
                    param.setItemId(item.getId());
                    param.setUom(item.getUom());
                    PriSalePriceTypeRespVO vo = this.salePriceService.queryPrice(param);
                    log.info("\u5546\u54c1\u6700\u5c0f\u5ba2\u6237\u7b49\u7ea7\u4ef7\u683c\uff1a" + JSON.toJSONString((Object)vo));
                    return vo;
                }).filter(Objects::nonNull).map(PriSalePriceTypeRespVO::getPrice).min(BigDecimal::compareTo).ifPresentOrElse(arg_0 -> ((BaseBipItemAppRespVO)baseBipItemAppRespVO).setPriceCust(arg_0), () -> resp.setPriceCust(null));
            }
            param = new PriSalePriceTypeQueryParam();
            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode());
            Assert.notNull((Object)ouId, (String)"\u5546\u54c1\u67e5\u8be2\u57fa\u7840\u4ef7\u683c\u65f6\uff0c\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            param.setOuId(ouId);
            param.setCurrCode(baseBipItemAppRespVO.getCurrCode());
            param.setCustLevel(null);
            baseBipItemAppRespVO.getSupportItems().stream().map(item -> {
                param.setItemId(item.getId());
                param.setUom(item.getUom());
                PriSalePriceTypeRespVO vo = this.salePriceService.queryPrice(param);
                log.info("\u5546\u54c1\u6700\u5c0f\u57fa\u7840\u4ef7\u683c\uff1a" + JSON.toJSONString((Object)vo));
                return vo;
            }).filter(Objects::nonNull).map(PriSalePriceTypeRespVO::getPrice).min(BigDecimal::compareTo).ifPresentOrElse(arg_0 -> ((BaseBipItemAppRespVO)baseBipItemAppRespVO).setPrice(arg_0), () -> resp.setPrice(null));
        }
    }

    private Map<String, BigDecimal> findSkuCustPriceReMap(String skuCode, Long userId, Long ouId) {
        return null;
    }

    private List<MktDiscountGiftVO> findDiscountGift(Long bipItemId, Long ouId) {
        List<BipItemSkuDO> skuDOList = this.itemSkuRepoProc.queryByBipItemIdFreeze(bipItemId);
        List<Long> skuIds = skuDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        Long userId = this.currentUserId();
        CustDTO cust = (CustDTO)this.custUserBindService.getCustOfUserBind(userId).getData();
        String custLevel = cust == null ? null : cust.getCustLevel();
        QMktGiftDO qMktGiftDO = QMktGiftDO.mktGiftDO;
        QMktDiscountGiftDDO qMktDiscountGiftDDO = QMktDiscountGiftDDO.mktDiscountGiftDDO;
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.mktDiscountGiftRepoProc.findMktDisCountGift(ouId, custLevel, LocalDateTime.now(), skuIds).leftJoin((EntityPath)qMktGiftDO)).on((Predicate)qMktDiscountGiftDDO.discountGiftCode.eq((Expression)qMktGiftDO.discountGiftCode))).where((Predicate)qMktGiftDO.validStime.loe((Comparable)LocalDateTime.now()).and((Predicate)qMktGiftDO.validEtime.goe((Comparable)LocalDateTime.now())).and((Predicate)qMktGiftDO.stockNowNum.gt((Number)0)))).fetch();
    }

    private List<MktDiscountOffsetVO> findDiscountOffset(Long bipItemId, Long ouId) {
        List<BipItemSkuDO> skuDOList = this.itemSkuRepoProc.queryByBipItemIdFreeze(bipItemId);
        List<Long> skuIds = skuDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        Long userId = this.currentUserId();
        CustDTO cust = (CustDTO)this.custUserBindService.getCustOfUserBind(userId).getData();
        String custLevel = cust == null ? null : cust.getCustLevel();
        return this.mktDiscountOffsetRepoProc.findMktDisCountOffsetByLQ(ouId, custLevel, LocalDateTime.now(), skuIds).fetch();
    }

    public ApiResult<List<BipItemRecGoodAppRespVO>> queryForRecGood(Long ouId, Integer size) {
        List<BipItemRecGoodAppRespVO> respVoList = this.searchForRecGoodByDb(ouId, size = (Integer)ObjectUtil.defaultIfNull((Object)size, (Object)10));
        if (respVoList.isEmpty()) {
            return ApiResult.ok(respVoList);
        }
        Long userId = this.currentUserId();
        this.setMinPrice(respVoList, userId, ouId);
        return ApiResult.ok(respVoList);
    }

    public ApiResult<BipItemDetailAppRespVO> getDetail(Long id, Long ouId) {
        BipItemDO item = this.itemRepo.findById(id).orElse(null);
        if (item == null || BooleanUtil.isFalse((Boolean)item.getOnShelf())) {
            return ApiResult.fail((String)"\u5546\u54c1\u5df2\u5931\u6548");
        }
        BipItemExtDO itemExt = (BipItemExtDO)this.itemExtRepo.findById(item.getExtId()).orElseThrow(new BusinessException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"));
        Long userId = this.currentUserId();
        BipItemDetailAppRespVO respVO = new BipItemDetailAppRespVO();
        this.fillBase(respVO, item);
        this.fillPic(respVO, item);
        respVO.setAttr(this.getItemAttr(item.getId()));
        this.fillExt(respVO, itemExt);
        this.fillPrice(respVO, userId, ouId);
        this.fillGiftList(respVO);
        return ApiResult.ok((Object)respVO);
    }

    private void fillPrice(BipItemDetailAppRespVO respVO, Long userId, Long ouId) {
        BaseBipItemAppRespVO vo = new BaseBipItemAppRespVO();
        vo.setId(respVO.getId());
        this.setSupportItem(Collections.singletonList(vo));
        for (BipItemAttrAppRespVO.Sku sku : respVO.getAttr().getSkuList()) {
            Map<String, BigDecimal> prices = this.findSkuCustPriceReMap(sku.getSkuCode(), userId, ouId);
            if (null != prices.get("basePrice")) {
                sku.setPrice(prices.get("basePrice"));
            }
            if (null == prices.get("custPrice")) continue;
            sku.setPriceCust(prices.get("custPrice"));
        }
        respVO.getAttr().getSkuList().stream().map(BipItemAttrAppRespVO.Sku::getPrice).filter(Objects::nonNull).min(BigDecimal::compareTo).ifPresentOrElse(arg_0 -> ((BipItemDetailAppRespVO)respVO).setPrice(arg_0), () -> respVO.setPrice(null));
        respVO.getAttr().getSkuList().stream().map(BipItemAttrAppRespVO.Sku::getPriceCust).filter(Objects::nonNull).min(BigDecimal::compareTo).ifPresentOrElse(arg_0 -> ((BipItemDetailAppRespVO)respVO).setPriceCust(arg_0), () -> respVO.setPriceCust(null));
    }

    public ApiResult<BipItemAttrAppRespVO> getItemSku(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u5546\u54c1\u7684\u6807\u8bc6\u4e3a\u7a7a");
        }
        BipItemAttrAppRespVO sku = this.getItemAttr(id);
        return ApiResult.ok((Object)sku);
    }

    public ApiResult<List<BipReceiptAddrAppRespVO>> queryReceiptAddr() {
        return null;
    }

    public void updateItemSalNumAll(String docNo) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression expression = qBipOrderDO.docNo.eq((Object)docNo);
        Optional optional = this.bipOrderRepo.findOne((Predicate)expression);
        log.info("-----------\u8ba2\u5355\u7f16\u53f7-----------------------", (Object)docNo);
        if (optional.isPresent()) {
            log.info("-----------\u66f4\u65b0\u5546\u54c1\u9500\u91cf\u8ba2\u5355\u7f16\u53f7-----------------------", (Object)docNo);
            BipOrderDO bipOrderDO = (BipOrderDO)optional.get();
            Long orderId = bipOrderDO.getId();
            QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
            BooleanExpression detailExpr = qBipOrderDDO.orderId.eq((Object)orderId);
            Iterable iterables = this.bipOrderDRepo.findAll((Predicate)detailExpr);
            if (!IterUtil.isEmpty((Iterable)iterables)) {
                ArrayList detailList = Lists.newArrayList((Iterable)iterables);
                detailList.stream().forEach(d -> {
                    Long ouId = bipOrderDO.getOuId();
                    Long itemId = d.getItemId();
                    Long buyQty = d.getBuyQty();
                    QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
                    BooleanExpression itemExpr = qBipItemDO.ouId.eq((Object)ouId).and((Predicate)qBipItemDO.id.eq((Object)itemId));
                    Optional itemOption = this.itemRepo.findOne((Predicate)itemExpr);
                    log.info("-----------\u67e5\u8be2\u8ba2\u5355\u5546\u54c1-----------------------");
                    if (!itemOption.isEmpty()) {
                        BipItemDO bipItemDO = (BipItemDO)itemOption.get();
                        log.info("-----------\u5546\u54c1\u4fe1\u606f-----------------------" + JSON.toJSONString((Object)bipItemDO));
                        Long salNum = bipItemDO.getNumSale();
                        if (null != salNum && null != buyQty) {
                            bipItemDO.setNumSale(salNum + buyQty);
                            this.itemRepo.save(bipItemDO);
                            log.info("-----------\u66f4\u65b0\u5546\u54c1\u9500\u91cf\u4fe1\u606f\u6210\u529f-----------------------");
                        }
                    }
                });
            }
        }
    }

    private Long obtainOuId(Long ouId) {
        if (ouId != null) {
            return ouId;
        }
        Long userId = this.currentUserId();
        if (userId == null) {
            return null;
        }
        ApiResult custInfo = this.custUserBindService.getCustOfUserBind(userId);
        return ((CustDTO)custInfo.getData()).getOuId();
    }

    private void fillGiftList(BipItemDetailAppRespVO respVO) {
        ArrayList<Long> itemIds = new ArrayList<Long>();
        itemIds.add(respVO.getId());
        List giftList = this.mktDiscountGiftRepoProc.getGiftListByCode(null, itemIds).fetch();
        if (giftList != null && giftList.size() > 0) {
            respVO.setGiftList(giftList);
        }
    }

    private List<BipReceiptAddrAppRespVO> queryAddrByCust(Long custId) {
        Long addrNo = this.custRepoProc.getAddrNo(custId);
        if (addrNo == null) {
            return Collections.emptyList();
        }
        OrgAddressRpcDtoParam addrQueryParm = new OrgAddressRpcDtoParam();
        addrQueryParm.setAddrNos((List)ListUtil.toList((Object[])new Long[]{addrNo}));
        List<OrgAddressRpcDTO> addrResult = this.rmiOrgAddrService.findAddrAddressListByParam(addrQueryParm);
        if (CollUtil.isEmpty(addrResult)) {
            return Collections.emptyList();
        }
        return addrResult.stream().map(t -> {
            BipReceiptAddrAppRespVO vo = new BipReceiptAddrAppRespVO();
            vo.setId(t.getId());
            vo.setDef(Boolean.valueOf(BooleanUtil.isTrue((Boolean)t.getDefaultFlag())));
            vo.setUsername(t.getContPerson());
            vo.setPhone(t.getMobile());
            vo.setProvince(t.getProvince());
            vo.setProvinceName(t.getProvinceName());
            vo.setCity(t.getCity());
            vo.setCityName(t.getCityName());
            vo.setCounty(t.getCounty());
            vo.setCountyName(t.getCountyName());
            vo.setStreet(t.getStreet());
            vo.setStreetName(t.getAddrName());
            vo.setAddress(t.getDetailAddr());
            return vo;
        }).collect(Collectors.toList());
    }

    private void fillBase(BipItemDetailAppRespVO respVO, BipItemDO itemDO) {
        respVO.setId(itemDO.getId());
        respVO.setItemId(itemDO.getItemId());
        respVO.setTitle(itemDO.getTitle());
        respVO.setPrice(itemDO.getPrice());
        respVO.setNumSale90(itemDO.getNumSale90());
        respVO.setNumSale(itemDO.getNumSale());
    }

    private void fillPic(BipItemDetailAppRespVO respVO, BipItemDO itemDO) {
        List<BipItemPicDO> picDOList = this.itemPicRepoProc.queryByBipItemId(itemDO.getId());
        if (picDOList.isEmpty()) {
            respVO.setPicList(Collections.emptyList());
            return;
        }
        List picList = picDOList.stream().map(t -> {
            BipItemPicAppRespVO vo = CONVERT.itemPic2RespVO((BipItemPicDO)t);
            vo.setImage(Boolean.valueOf(this.isImage(t.getMimeType())));
            return vo;
        }).collect(Collectors.toList());
        respVO.setPicList(picList);
    }

    private boolean isImage(String mimeType) {
        return mimeType != null && mimeType.toLowerCase().startsWith("image/");
    }

    private BipItemAttrAppRespVO getItemAttr(Long bipItemId) {
        List<BipItemSkuDO> skuDOList = this.itemSkuRepoProc.queryByBipItemIdFreeze(bipItemId);
        BipItemAttrAppRespVO attr = new BipItemAttrAppRespVO();
        if (skuDOList.isEmpty()) {
            attr.setAttrList(Collections.emptyList());
            attr.setSkuList(Collections.emptyList());
            return attr;
        }
        List skuList = skuDOList.stream().map(t -> {
            BipItemAttrAppRespVO.Sku vo = CONVERT.skuDO2VO((BipItemSkuDO)t);
            vo.setAttrList(this.convert2List(t.getAttr(), BipItemSkuAttrRespVO.class));
            return vo;
        }).filter(t -> t.getFreeze() == false).collect(Collectors.toList());
        BipItemDO item = this.itemRepo.findById(bipItemId).orElse(null);
        QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq((Object)0).and((Predicate)qFirstSpecialDO.itemId.eq((Object)bipItemId)).and((Predicate)qFirstSpecialDO.ouId.eq((Object)item.getOuId())).and((Predicate)qFirstSpecialDO.status.eq((Object)"ACTIVE"));
        Optional optional = this.firstSpecialRepo.findOne((Predicate)expression);
        if (optional.isPresent()) {
            FirstSpecialDO firstSpecialDO = (FirstSpecialDO)optional.get();
            QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
            BooleanExpression expr = qFirstSpecialItemDO.specialId.eq((Object)firstSpecialDO.getId()).and((Predicate)qFirstSpecialItemDO.deleteFlag.eq((Object)0));
            Iterable speItems = this.firstSpecialItemRepo.findAll((Predicate)expr);
            if (!IterUtil.isEmpty((Iterable)speItems)) {
                ArrayList speItemList = Lists.newArrayList((Iterable)speItems);
                skuList.stream().forEach(sku -> {
                    for (FirstSpecialItemDO itemDO : speItemList) {
                        if (!sku.getId().equals(itemDO.getSkuId())) continue;
                        sku.setPreferentialPrice(itemDO.getPreferentialPrice());
                    }
                });
            }
        }
        if (!skuList.isEmpty()) {
            for (BipItemAttrAppRespVO.Sku sku2 : skuList) {
                if (null == sku2.getAttrList() || sku2.getAttrList().isEmpty()) continue;
                String skuStr = JSON.toJSONString((Object)sku2.getAttrList());
                List skuArray = JSON.parseArray((String)skuStr, BipItemSkuAttrRespVO.class);
                List skuAttrs = skuArray.stream().sorted(Comparator.comparing(BipItemSkuAttrRespVO::getCode)).collect(Collectors.toList());
                sku2.setAttrList(skuAttrs);
            }
        }
        attr.setSkuList(skuList);
        List attrList = skuList.stream().flatMap(t -> ((List)this.objectMapper.convertValue((Object)t.getAttrList(), (TypeReference)new TypeReference<List<BipItemSkuAttrRespVO>>(){})).stream()).collect(Collectors.groupingBy(BipItemSkuAttrRespVO::getCode)).entrySet().stream().map(entry -> {
            BipItemAttrAppRespVO.Attr v = new BipItemAttrAppRespVO.Attr();
            v.setCode((String)entry.getKey());
            v.setName(((BipItemSkuAttrRespVO)((List)entry.getValue()).get(0)).getName());
            v.setValueList(((List)entry.getValue()).stream().map(BipItemSkuAttrRespVO::getValue).distinct().collect(Collectors.toList()));
            return v;
        }).collect(Collectors.toList());
        List<Object> attrs = new ArrayList();
        if (attrList != null && attrList.size() > 0) {
            attrs = attrList.stream().sorted(Comparator.comparing(BipItemAttrAppRespVO.Attr::getCode)).collect(Collectors.toList());
        }
        attr.setAttrList(attrs);
        return attr;
    }

    private void fillExt(BipItemDetailAppRespVO respVO, BipItemExtDO extDO) {
        respVO.setSpecList(this.convert2List(extDO.getSpec(), BipItemSpecRespVO.class));
        respVO.setContentPicList(this.convert2List(extDO.getContent(), BipItemPicAppRespVO.class));
    }

    private List<BipItemRecGoodAppRespVO> searchForRecGoodByDb(Long ouId, Integer size) {
        BooleanExpression condition = (ouId = this.obtainOuId(ouId)) == null ? BipItemAppServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(true)) : BipItemAppServiceImpl.ITEM_DO.ouId.eq((Object)ouId).and((Predicate)BipItemAppServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(true)));
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipItemRecGoodAppRespVO.class, (Expression[])new Expression[]{BipItemAppServiceImpl.ITEM_DO.id, BipItemAppServiceImpl.ITEM_DO.mainPicFileCode.as("picFileCode"), BipItemAppServiceImpl.ITEM_DO.mainPicUrl.as("picUrl"), BipItemAppServiceImpl.ITEM_DO.title, BipItemAppServiceImpl.ITEM_DO.price})).from((EntityPath)ITEM_DO)).where((Predicate)condition)).limit((long)size.intValue())).orderBy(new OrderSpecifier[]{BipItemAppServiceImpl.ITEM_DO.numSale90.desc()})).fetch();
    }

    private PagingVO<BipItemHotAppRespVO> searchForHotByDb(Long ouId) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipItemHotAppRespVO.class, (Expression[])new Expression[]{BipItemAppServiceImpl.ITEM_DO.id, BipItemAppServiceImpl.ITEM_DO.mainPicFileCode.as("picFileCode"), BipItemAppServiceImpl.ITEM_DO.mainPicUrl.as("picUrl"), BipItemAppServiceImpl.ITEM_DO.title, BipItemAppServiceImpl.ITEM_DO.price})).from((EntityPath)ITEM_DO)).where((Predicate)BipItemAppServiceImpl.ITEM_DO.ouId.eq((Object)ouId).and((Predicate)BipItemAppServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(true))));
        long total = query.fetchCount();
        List records = ((JPAQuery)((JPAQuery)query.orderBy(BipItemAppServiceImpl.ITEM_DO.numSale90.desc())).limit(10L)).fetch();
        return PagingVO.builder().total(total).records(records).build();
    }

    private List<BipItemRecommendAppRespVO> searchForRecommendByDb(Long categoryId, Integer categoryLevel, Long excludeItemId, Integer size) {
        NumberPath<Long> categoryIdPath = this.itemRepoProc.getCategory(categoryLevel);
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipItemRecommendAppRespVO.class, (Expression[])new Expression[]{BipItemAppServiceImpl.ITEM_DO.id, BipItemAppServiceImpl.ITEM_DO.mainPicFileCode.as("picFileCode"), BipItemAppServiceImpl.ITEM_DO.mainPicUrl.as("picUrl"), BipItemAppServiceImpl.ITEM_DO.title, BipItemAppServiceImpl.ITEM_DO.price})).from((EntityPath)ITEM_DO)).where((Predicate)categoryIdPath.eq((Object)categoryId).and((Predicate)BipItemAppServiceImpl.ITEM_DO.ouId.eq((Expression)JPAExpressions.select(BipItemAppServiceImpl.ITEM_DO.ouId).from(new EntityPath[]{ITEM_DO}).where(new Predicate[]{BipItemAppServiceImpl.ITEM_DO.id.eq((Object)excludeItemId)}))).and((Predicate)BipItemAppServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(true))).and((Predicate)BipItemAppServiceImpl.ITEM_DO.id.ne((Object)excludeItemId)))).limit((long)size.intValue())).fetch();
    }

    private PagingVO<BipItemListAppRespVO> searchForAppByDB(BipItemAppQueryParamVO queryParamVO) {
        BooleanExpression condition;
        Long ouId = this.obtainOuId(queryParamVO.getOuId());
        BooleanExpression booleanExpression = condition = ouId == null ? BipItemAppServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(true)) : BipItemAppServiceImpl.ITEM_DO.ouId.eq((Object)ouId).and((Predicate)BipItemAppServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(true)));
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getKeyword())) {
            String keyword = "%" + queryParamVO.getKeyword() + "%";
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemAppServiceImpl.ITEM_DO.title.like(keyword).or((Predicate)BipItemAppServiceImpl.ITEM_DO.categoryName3.like(keyword)));
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipItemListAppRespVO.class, (Expression[])new Expression[]{BipItemAppServiceImpl.ITEM_DO.id, BipItemAppServiceImpl.ITEM_DO.mainPicFileCode.as("picFileCode"), BipItemAppServiceImpl.ITEM_DO.mainPicUrl.as("picUrl"), BipItemAppServiceImpl.ITEM_DO.title, BipItemAppServiceImpl.ITEM_DO.itemId, BipItemAppServiceImpl.ITEM_DO.price, BipItemAppServiceImpl.ITEM_DO.numSale, BipItemAppServiceImpl.ITEM_DO.numSale90, BipItemAppServiceImpl.ITEM_DO.rateEvalGood, BipItemAppServiceImpl.ITEM_DO.scoreEval})).from((EntityPath)ITEM_DO)).where((Predicate)condition);
        long count = jpaQuery.fetchCount();
        OrderSpecifier[] order = this.obtainOrder(queryParamVO);
        List dataList = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.orderBy(order)).offset((long)((queryParamVO.getCurrent() - 1) * queryParamVO.getSize()))).limit((long)queryParamVO.getSize().intValue())).fetch();
        return PagingVO.builder().total(count).records(dataList).build();
    }

    private OrderSpecifier[] obtainOrder(BipItemAppQueryParamVO queryParamVO) {
        if (queryParamVO.getOrderSaleDesc() != null) {
            return new OrderSpecifier[]{new OrderSpecifier(queryParamVO.getOrderSaleDesc() != false ? Order.DESC : Order.ASC, BipItemAppServiceImpl.ITEM_DO.numSale90)};
        }
        if (queryParamVO.getOrderPriceDesc() != null) {
            return new OrderSpecifier[]{new OrderSpecifier(queryParamVO.getOrderPriceDesc() != false ? Order.DESC : Order.ASC, BipItemAppServiceImpl.ITEM_DO.price)};
        }
        return new OrderSpecifier[]{new OrderSpecifier(Order.DESC, BipItemAppServiceImpl.ITEM_DO.timeOnShelf)};
    }

    public BipItemAppServiceImpl(BipItemRepo itemRepo, BipItemRepoProc itemRepoProc, BipItemExtRepo itemExtRepo, BipItemPicRepoProc itemPicRepoProc, BipItemSkuRepoProc itemSkuRepoProc, CrmCustRepoProc custRepoProc, BipCustUserBindService custUserBindService, PriSalePriceService salePriceService, BipOrderRepo bipOrderRepo, BipOrderDRepo bipOrderDRepo, FirstSpecialRepo firstSpecialRepo, FirstSpecialItemRepo firstSpecialItemRepo, BipItemSkuRepo bipItemSkuRepo, BipItemSkuRepoProc bipItemSkuRepoProc, RmiOrgAddrService rmiOrgAddrService, MktDiscountGiftRepoProc mktDiscountGiftRepoProc, MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc) {
        this.itemRepo = itemRepo;
        this.itemRepoProc = itemRepoProc;
        this.itemExtRepo = itemExtRepo;
        this.itemPicRepoProc = itemPicRepoProc;
        this.itemSkuRepoProc = itemSkuRepoProc;
        this.custRepoProc = custRepoProc;
        this.custUserBindService = custUserBindService;
        this.salePriceService = salePriceService;
        this.bipOrderRepo = bipOrderRepo;
        this.bipOrderDRepo = bipOrderDRepo;
        this.firstSpecialRepo = firstSpecialRepo;
        this.firstSpecialItemRepo = firstSpecialItemRepo;
        this.bipItemSkuRepo = bipItemSkuRepo;
        this.bipItemSkuRepoProc = bipItemSkuRepoProc;
        this.rmiOrgAddrService = rmiOrgAddrService;
        this.mktDiscountGiftRepoProc = mktDiscountGiftRepoProc;
        this.mktDiscountOffsetRepoProc = mktDiscountOffsetRepoProc;
    }
}

