/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.workflow;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import com.elitesland.yst.production.sale.repo.PriSalePriceAlterRepoProc;
import com.elitesland.yst.production.sale.workflow.ProcDefKey;
import com.elitesland.yst.production.sale.workflow.service.BipOrderBackProcessService;
import com.elitesland.yst.production.sale.workflow.service.PriSalePriceAlterProcessService;
import com.elitesland.yst.production.sale.workflow.service.SalAcceptanceProcessService;
import com.elitesland.yst.production.sale.workflow.service.SalQuotationProcessService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class B2BWorkflowCallBack
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(B2BWorkflowCallBack.class);
    private final PriSalePriceAlterProcessService priSalePriceAlterProcessService;
    private final PriSalePriceAlterRepoProc priSalePriceAlterRepoProc;
    private final SalQuotationProcessService salQuotationProcessService;
    private final SalAcceptanceProcessService salAcceptanceProcessService;
    private final BipOrderBackProcessService bipOrderBackProcessService;

    private Long getId(String businessKey) {
        return Long.valueOf(businessKey);
    }

    public ArrayList<String> taskAssignee(TaskAssigneePayload payload) {
        String procDefKey = payload.getProcDefKey();
        String taskKey = payload.getTaskKey();
        String businessKey = payload.getBusinessKey();
        String customParams = payload.getCustomParams();
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{},\u81ea\u5b9a\u4e49\u53c2\u6570:{}", new Object[]{procDefKey, taskKey, businessKey, customParams});
        if (procDefKey.equals(ProcDefKey.B2B_IN_SETTLE_PRICE.name()) || procDefKey.equals(ProcDefKey.B2B_OUT_SALE_PRICE.name())) {
            List<String> userIds = this.priSalePriceAlterProcessService.taskAssignee(this.getId(businessKey), customParams);
            return CollUtil.newArrayList(userIds);
        }
        if (procDefKey.equals(ProcDefKey.SAL_QUOTATION.name())) {
            List<String> userIds = this.salQuotationProcessService.taskAssignee(this.getId(businessKey), customParams);
            return CollUtil.newArrayList(userIds);
        }
        if (procDefKey.equals(ProcDefKey.SAL_ACCEPTANCE.name())) {
            List<String> userIds = this.salAcceptanceProcessService.taskAssignee(this.getId(businessKey), customParams);
            return CollUtil.newArrayList(userIds);
        }
        if (procDefKey.equals(ProcDefKey.TOB_SALE_RETURN.name())) {
            List<String> userIds = this.bipOrderBackProcessService.taskAssignee(this.getId(businessKey), customParams);
            return CollUtil.newArrayList(userIds);
        }
        return null;
    }

    public void taskCreated(TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{},\u5904\u7406\u4eba:{}" + JSON.toJSONString((Object)payload));
    }

    public void taskCompleted(TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{}\uff0c\u4efb\u52a1\u5904\u7406\u4eba{}" + JSON.toJSONString((Object)payload));
    }

    public void processStatusChange(ProcessStatusChangePayload payload) {
        String procDefKey = payload.getProcDefKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        String businessKey = payload.getBusinessKey();
        log.info("\u6d41\u7a0b\u56de\u8c03 procDefKey:" + procDefKey + " ,procInstStatus:" + procInstStatus + ",businessKey:" + businessKey);
        if (procDefKey.equals(ProcDefKey.B2B_OUT_SALE_PRICE.name()) || procDefKey.equals(ProcDefKey.B2B_IN_SETTLE_PRICE.name())) {
            this.priSalePriceAlterProcessService.processStatusChange(this.getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.SAL_QUOTATION.name())) {
            this.salQuotationProcessService.processStatusChange(this.getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.SAL_ACCEPTANCE.name())) {
            this.salAcceptanceProcessService.processStatusChange(this.getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.TOB_SALE_RETURN.name())) {
            this.bipOrderBackProcessService.processStatusChange(this.getId(businessKey), procInstStatus);
        }
    }

    public B2BWorkflowCallBack(PriSalePriceAlterProcessService priSalePriceAlterProcessService, PriSalePriceAlterRepoProc priSalePriceAlterRepoProc, SalQuotationProcessService salQuotationProcessService, SalAcceptanceProcessService salAcceptanceProcessService, BipOrderBackProcessService bipOrderBackProcessService) {
        this.priSalePriceAlterProcessService = priSalePriceAlterProcessService;
        this.priSalePriceAlterRepoProc = priSalePriceAlterRepoProc;
        this.salQuotationProcessService = salQuotationProcessService;
        this.salAcceptanceProcessService = salAcceptanceProcessService;
        this.bipOrderBackProcessService = bipOrderBackProcessService;
    }
}

