/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.workflow.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.sale.api.service.SalAcceptanceService;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QSalAcceptanceDO;
import com.elitesland.yst.production.sale.repo.SalAcceptanceRepo;
import com.elitesland.yst.production.sale.repo.SalAcceptanceRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserFlowRoleRpcService;
import com.elitesland.yst.production.sale.workflow.service.SalAcceptanceProcessService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SalAcceptanceProcessServiceImpl
implements SalAcceptanceProcessService {
    private static final Logger log = LoggerFactory.getLogger(SalAcceptanceProcessServiceImpl.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final SalAcceptanceRepo salAcceptanceRepo;
    private final SalAcceptanceRepoProc salAcceptanceRepoProc;
    private final SalAcceptanceService salAcceptanceService;
    private final RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        Optional salAcceptanceDO = this.salAcceptanceRepo.findById(id);
        if (!salAcceptanceDO.isPresent()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QSalAcceptanceDO qSalAcceptanceDO = QSalAcceptanceDO.salAcceptanceDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qSalAcceptanceDO).set(qSalAcceptanceDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qSalAcceptanceDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)qSalAcceptanceDO.acStatus, (Object)UdcEnum.SAL_AC_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qSalAcceptanceDO.acStatus, (Object)UdcEnum.SAL_AC_STATUS_DRAFT.getValueCode());
                this.salAcceptanceRepo.updateProcInstId(id, null);
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qSalAcceptanceDO.acStatus, (Object)UdcEnum.SAL_AC_STATUS_REJECTED.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qSalAcceptanceDO.acStatus, (Object)UdcEnum.SAL_AC_STATUS_CL.getValueCode());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qSalAcceptanceDO.acStatus, (Object)UdcEnum.SAL_AC_STATUS_APPROVING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qSalAcceptanceDO.acStatus, (Object)UdcEnum.SAL_AC_STATUS_APPROVED.getValueCode()).set(qSalAcceptanceDO.approvedTime, (Object)LocalDateTime.now());
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            this.salAcceptanceService.apprAcc(Long.valueOf(id), UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode());
        }
        if (procInstStatus.equals((Object)ProcInstStatus.REJECTED) || procInstStatus.equals((Object)ProcInstStatus.NOTSUBMIT) || procInstStatus.equals((Object)ProcInstStatus.INVALID)) {
            this.salAcceptanceService.apprAcc(Long.valueOf(id), UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode());
        }
    }

    @Override
    public List<String> taskAssignee(Long businessKey, String customParams) {
        log.info("\u901a\u8fc7ouId,\u81ea\u5b9a\u4e49\u53c2\u6570\u83b7\u53d6\u7528\u6237\u5217\u8868\uff0c\u65f6\u95f4:{},\u5165\u53c2:{}", (Object)LocalDateTime.now(), (Object)businessKey);
        Long ouId = this.salAcceptanceRepoProc.getOuIdById((long)businessKey);
        try {
            SysUserIdFlowRoleRpcParam sysUserIdFlowRoleRpcParam = new SysUserIdFlowRoleRpcParam();
            sysUserIdFlowRoleRpcParam.setOuIds(Collections.singletonList(ouId));
            List<String> flowRoleCodes = Arrays.asList(customParams.split(","));
            sysUserIdFlowRoleRpcParam.setFlowRoleCodes(flowRoleCodes);
            log.info("\u516c\u53f8\u89d2\u8272\u67e5\u8be2\u4fe1\u606f" + sysUserIdFlowRoleRpcParam);
            List userIdsByFlowRoles = this.rmiSysUserFlowRoleRpcService.findUserIdsByFlowRoles(sysUserIdFlowRoleRpcParam).stream().filter(Objects::nonNull).collect(Collectors.toList());
            List userIds = userIdsByFlowRoles.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)) {
                return CollUtil.newArrayList(userIds);
            }
        }
        catch (Exception e) {
            log.error("findUserIdsByFlowRoles error:", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u652f\u6491\u57df\u67e5\u8be2\u5ba1\u6279\u89d2\u8272\u5bf9\u5e94\u5ba1\u6279\u4eba\u5f02\u5e38" + e, (Throwable)e);
        }
        return null;
    }

    public SalAcceptanceProcessServiceImpl(JPAQueryFactory jpaQueryFactory, SalAcceptanceRepo salAcceptanceRepo, SalAcceptanceRepoProc salAcceptanceRepoProc, SalAcceptanceService salAcceptanceService, RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.salAcceptanceRepo = salAcceptanceRepo;
        this.salAcceptanceRepoProc = salAcceptanceRepoProc;
        this.salAcceptanceService = salAcceptanceService;
        this.rmiSysUserFlowRoleRpcService = rmiSysUserFlowRoleRpcService;
    }
}

