package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipRotationChartService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipRotationChartQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipRetationChartVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipRetationChartSaveVO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;
import lombok.RequiredArgsConstructor;
import lombok.val;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Shadow
 * @since 2021-08-11 16:04:52
 */
@RestController
@RequestMapping("/bip/retationChart")
@Api(value = "轮播图", tags = {"轮播图"})
@RequiredArgsConstructor
public class BipRotationChartController {

    private final BipRotationChartService bipRotationChartService;

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过主键查询单条数据")
    @ApiOperationSupport(order = 1)
    ApiResult<BipRetationChartVO> findIdOne(@PathVariable Long id) {
        return bipRotationChartService.findIdOne(id).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询")
    @ApiOperationSupport(order = 2)
    public ApiResult<PagingVO<BipRetationChartVO>> search(@RequestBody BipRotationChartQueryParamVO param) {
        val ret = bipRotationChartService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    @ApiOperationSupport(order = 4)
    public ApiResult<Object> createOne(@RequestBody BipRetationChartSaveVO param) {
        return ApiResult.ok(bipRotationChartService.createOne(param));
    }

    /**
     * 修改数据
     *
     * @param param 修改对象
     * @return 修改数据详情
     */
    @PutMapping("/update")
    @ApiOperation("修改数据")
    @ApiOperationSupport(order = 5)
    public ApiResult<Object> update(@RequestBody BipRetationChartSaveVO param) {
        bipRotationChartService.update(param);
        return ApiResult.ok();
    }

    /**
     * 逻辑删除
     *
     * @param id 更新数据
     */
    @PutMapping("/updateDeleteFlag/{id}")
    @ApiOperation("逻辑删除")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> updateDeleteFlag(@PathVariable Long id) {
        bipRotationChartService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    /**
     * 批量逻辑删除
     *
     * @param ids 删除数据集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("批量逻辑删除")
    @ApiOperationSupport(order = 7)
    public ApiResult<Object> deleteBatch(@RequestBody List<String> ids) {
        List<Long> list = ids.stream().map(Long::valueOf).collect(Collectors.toList());
        bipRotationChartService.deleteBatch(list);
        return ApiResult.ok();
    }

    /**
     * 批量改变轮播图状态
     * @param ids id列表
     * @param status 状态
     * @return 信息
     */
    @PutMapping("/change/{ids}/{status}")
    @ApiOperation("批量改变状态")
    @ApiOperationSupport(order = 8)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "轮播图ID", required = true),
            @ApiImplicitParam(name = "status", value = "ACTIVE：启用  INACTIVE：停用  DRAFT：草稿", required = true),
    })
    public ApiResult<Object> changeStatus(@PathVariable("ids") List<Long> ids,@PathVariable String status){
        bipRotationChartService.changeStatus(ids,status);
        return ApiResult.ok();
    }

}