package com.elitesland.yst.production.sale.core.convert;

import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.common.model.UserDTO;
import com.elitesland.yst.production.sale.core.mapstruct.CustomMapperConfig;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-10
 */
@Mapper(config = CustomMapperConfig.class)
public interface UserConvert {

    UserConvert INSTANCE = Mappers.getMapper(UserConvert.class);

    /**
     * 转为用户信息
     *
     * @param userDTO 系统用户信息
     * @return 用户信息
     */
    UserDTO convert(SysUserDTO userDTO);

    /**
     * 转为用户信息
     *
     * @param userVO 当前用户
     * @return 用户信息
     */
    CurrentUserDTO convert(GeneralUserDetails userVO);
}
