package com.elitesland.yst.production.sale.core.util;

import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

/**
 * 日期时间工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-11
 */
public class DateTimeUtil {

    private DateTimeUtil() {
    }

    /**
     * 服务器时区
     */
    public static final ZoneOffset SYS_ZONE_OFFSET = ZoneOffset.of("+8");

    /**
     * 日期格式
     */
    public static final DateTimeFormatter FORMATTER_DATETIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final LocalTime MAX_TIME = LocalTime.of(23, 59, 59);

}
