package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "base_area", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "base_area", comment = "地区维护")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BaseAreaDO extends BaseModel implements Serializable {


    @Column(name = "name", columnDefinition = "varchar(256) comment '名称'")
    private String name;

    @Column(name = "pid", columnDefinition = "bigInt(20) not null  comment '父级ID'")
    private Long pid;

}
