package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author :
 * @date : 2023-5-19
 * @desc : 销售业绩统计-门店
 */
@Entity
@Table(name="sale_statistics_store")
@org.hibernate.annotations.Table(appliesTo = "sale_statistics_store", comment = "销售业绩统计-门店")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class SaleStatisticsStoreDO extends BaseModel {

    /**
     * 统计时间
     */
    @Column(name = "doc_time", columnDefinition = "datetime(6) comment '统计时间'")
    private LocalDateTime docTime;

    /**
     * 门店编码
     */
    @Column(name = "store_code", columnDefinition = "varchar(255) comment '门店编码'")
    private String storeCode;

    /**
     * 门店名称
     */
    @Column(name = "store_name", columnDefinition = "varchar(255) comment '门店名称'")
    private String storeName;

    /**
     * 经销商编码
     */
    @Column(name = "dealer_code", columnDefinition = "varchar(255) comment '经销商编码'")
    private String dealerCode;

    /**
     * 经销商名称
     */
    @Column(name = "dealer_name", columnDefinition = "varchar(255) comment '经销商名称'")
    private String dealerName;

    /**
     * 经销商客户号
     */
    @Column(name = "dealer_serial_no", columnDefinition = "varchar(255) comment '经销商客户号'")
    private String dealerSerialNo;

    /**
     * 区域
     */
    @Column(name = "region", columnDefinition = "varchar(255) comment '区域'")
    private String region;

    /**
     * 类型
     */
    @Column(name = "type", columnDefinition = "varchar(255) comment '类型'")
    private String type;

    /**
     * 业务员关系路径
     */
    @Column(name = "salesman_path", columnDefinition = "varchar(2000) comment '业务员关系路径'")
    private String salesmanPath;

    /**
     * 车型
     */
    @Column(name = "vehicle_type", columnDefinition = "varchar(255) comment '车型'")
    private String vehicleType;

    /**
     * 整车类型
     */
    @Column(name = "item_type3", columnDefinition = "varchar(255) comment '整车类型'")
    private String itemType3;

    /**
     * 经营性质
     */
    @Column(name = "store_type2", columnDefinition = "varchar(255) comment '经营性质'")
    private String storeType2;

    /**
     * 门店详细地址
     */
    @Column(name = "detail_addr", columnDefinition = "varchar(255) comment '门店详细地址'")
    private String detailAddr;

    /**
     * 出货量
     */
    @Column(name = "ship_qty", columnDefinition = "decimal(18,2) comment '出货量'")
    private BigDecimal shipQty;


    /**
     * 客服编码
     */
    @Column(name = "emp_code", columnDefinition = "varchar(255) comment '客服编码'")
    private String empCode;


    /**
     * 客服名称
     */
    @Column(name = "emp_Name", columnDefinition = "varchar(255) comment '客服名称'")
    private String empName;

    /**
     * 用户id
     */
    @Column(name = "user_id2", columnDefinition = "bigint(18) default null  comment '用户id2'")
    private Long userId2;

    /**
     * 更新区域失败原因
     */
    @Column(name = "update_region_failure_reason", columnDefinition = "varchar(500) comment '更新区域失败原因'")
    private String updateRegionFailureReason;

    /**
     * 更新业务员失败原因
     */
    @Column(name = "update_salesman_failure_reason", columnDefinition = "varchar(500) comment '更新业务员失败原因'")
    private String updateSalesmanFailureReason;

}