package com.elitesland.yst.production.sale.ext.cpcn.resp;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
/**
 * @author yifansir(jin yan qiang)
 * @date 2021/8/4
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class CPCN5011Resp {
    /**
     * 响应码
     */
    private String code;
    /**
     * 响应信息
     */
    private String message;
    /**
     * 机构编号
     */
    private String institutionID;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 交易流水号
     */
    private String txSN;
    /**
     * 付款金额(单位:分)
     */
    private String amount;
    /**
     * 可分账金额(单位:分)
     */
    private String availableSplitAmount;
    /**
     * 支付状态:
     * 10=未支付
     * 20=支付处理中
     * 30=支付成功
     * 40=支付失败
     * 50=订单关闭
     */
    private String status;
    /**
     * 用信支付URL
     */
    private String creditPayURL;
    /**
     * 收款用户手续费总金额(单位:分)
     */
    private String payeeUserFee;
    /**
     * 付款人手续费总金额(单位:分)
     */
    private String payerUserFee;
    /**
     * 支付URL
     */
    private String eBankPayURL;
    /**
     * 支付宝微信聚合码二维码
     */
    private String qRCodeURL;
    /**
     * 支付宝微信聚合码二维码图片URL
     */
    private String qRImageURL;
    /**
     * 授权码
     */
    private String qRAuthCode;
    /**
     * 付款用户ID
     */
    private String payerID;
    /**
     * 实际支付方式
     */
    private String subOpenID;
    /**
     * 实际支付类型:
     * 10=余额
     * 20=借记卡
     * 30=贷记卡
     * 40=其他
     */
    private String actualCardType;
    /**
     * 转账识别码
     */
    private String udID;
    /**
     * 失效时间
     */
    private String expireTime;
    /**
     * 平台订单号
     */
    private String traceNo;
    /**
     * 支付回单流水号
     */
    private String bankTraceNo;
    /**
     * 支付成功时间
     */
    private String responseTime;
    /**
     * 响应码
     */
    private String responseCode;
    /**
     * 响应信息
     */
    private String responseMessage;
    /**
     * 响应的报文
     */
    private String responsePlainText;
}
