package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.ComSaleFileInfoDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/5/27 13:19
 */
public interface ComSaleFileInfoRepo extends JpaRepository<ComSaleFileInfoDO, Long>, QuerydslPredicateExecutor<ComSaleFileInfoDO> {


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "delete from com_sale_file_info where qualify_no = ?2 and business_type = ?1", nativeQuery = true)
    void deleteByBusinessTypeAndQualifyNo(String businessType, String qualifyNo);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "delete from com_sale_file_info where business_type = ?1 and business_id = ?2", nativeQuery = true)
    void deleteByBusinessTypeAndBusinessId(String businessType, Long businessId);

}