package com.elitesland.yst.production.sale.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExectRecordDtlTempQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordDtlTempRespVO;
import com.elitesland.yst.production.sale.entity.QExectRecordDtlTempDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录明细模板表RepoProc
 */
@Component
public class ExectRecordDtlTempRepoProc {

    private final QExectRecordDtlTempDO qExectRecordDtlTempDO = QExectRecordDtlTempDO.exectRecordDtlTempDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public PagingVO<ExectRecordDtlTempRespVO> page(ExectRecordDtlTempQueryParam exectRecordDtlTempPageParam){
        JPAQuery<ExectRecordDtlTempRespVO> query = select(ExectRecordDtlTempRespVO.class)
                .where(bulidPredicate(exectRecordDtlTempPageParam));
        exectRecordDtlTempPageParam.setPaging(query);
        exectRecordDtlTempPageParam.fillOrders(query, qExectRecordDtlTempDO);
        return PagingVO.<ExectRecordDtlTempRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public Long del(List<Long> ids) {
        Long res = jpaQueryFactory.update(qExectRecordDtlTempDO)
                .set(qExectRecordDtlTempDO.deleteFlag, 1)
                .where(qExectRecordDtlTempDO.id.in(ids))
                .execute();
        return res;
    }


    public ExectRecordDtlTempRespVO get(Long id) {
        ExectRecordDtlTempRespVO exectRecordDtlTempVO = select(ExectRecordDtlTempRespVO.class)
                .where(qExectRecordDtlTempDO.id.eq(id))
                .fetchOne();
        return exectRecordDtlTempVO;
    }


    public List<ExectRecordDtlTempRespVO> getList(ExectRecordDtlTempQueryParam exectRecordDtlTempPageParam) {
        List<ExectRecordDtlTempRespVO> res = select(ExectRecordDtlTempRespVO.class)
                .where(bulidPredicate(exectRecordDtlTempPageParam))
                .orderBy(qExectRecordDtlTempDO.sort.asc())
                .fetch();
        return res;
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qExectRecordDtlTempDO.recordId,
                qExectRecordDtlTempDO.name,
                qExectRecordDtlTempDO.val,
                qExectRecordDtlTempDO.content,
                qExectRecordDtlTempDO.reason,
                qExectRecordDtlTempDO.type,
                qExectRecordDtlTempDO.sort,
                qExectRecordDtlTempDO.id,
                qExectRecordDtlTempDO.createTime,
                qExectRecordDtlTempDO.remark,
                qExectRecordDtlTempDO.creator,
                qExectRecordDtlTempDO.updater,
                qExectRecordDtlTempDO.requiredFlag,
                qExectRecordDtlTempDO.modifyTime
        )).from(qExectRecordDtlTempDO);
    }


    private Predicate bulidPredicate(ExectRecordDtlTempQueryParam exectRecordDtlTempPageParam) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andEq(null != exectRecordDtlTempPageParam.getRecordId(), qExectRecordDtlTempDO.recordId, exectRecordDtlTempPageParam.getRecordId())
                .andEq(StringUtils.isNotBlank(exectRecordDtlTempPageParam.getName()), qExectRecordDtlTempDO.name, exectRecordDtlTempPageParam.getName())
                .andEq(StringUtils.isNotBlank(exectRecordDtlTempPageParam.getVal()), qExectRecordDtlTempDO.val, exectRecordDtlTempPageParam.getVal())
                .andEq(StringUtils.isNotBlank(exectRecordDtlTempPageParam.getContent()), qExectRecordDtlTempDO.content, exectRecordDtlTempPageParam.getContent())
                .andEq(StringUtils.isNotBlank(exectRecordDtlTempPageParam.getReason()), qExectRecordDtlTempDO.reason, exectRecordDtlTempPageParam.getReason())
                .andEq(StringUtils.isNotBlank(exectRecordDtlTempPageParam.getType()), qExectRecordDtlTempDO.type, exectRecordDtlTempPageParam.getType())
                .andEq(null != exectRecordDtlTempPageParam.getSort(), qExectRecordDtlTempDO.sort, exectRecordDtlTempPageParam.getSort())
                .build();
        return predicate;
    }

    public void sourceDel(List<Long> asList) {
        jpaQueryFactory.update(qExectRecordDtlTempDO)
                .set(qExectRecordDtlTempDO.deleteFlag, 1)
                .where(qExectRecordDtlTempDO.recordId.in(asList))
                .execute();
    }
}