package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExecutRecordQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordExportVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.*;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录RepoProc
 */
@Component
public class ExecutRecordRepoProc {

    private final QExecutRecordDO qExecutRecordDO = QExecutRecordDO.executRecordDO;

    private final QExecutRecordDtlDO qExecutRecordDtlDO=QExecutRecordDtlDO.executRecordDtlDO;
    private static final QTaskInfoDO qTaskInfoDO = QTaskInfoDO.taskInfoDO;
    private static final QTaskInfoDtlDO qTaskInfoDtlDO = QTaskInfoDtlDO.taskInfoDtlDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public PagingVO<ExecutRecordRespVO> page(ExecutRecordQueryParam executRecordPageParam) {
        JPAQuery<ExecutRecordRespVO> query = selectInnerJoinTaskDtl()
                .where(bulidPredicate(executRecordPageParam, true));
        executRecordPageParam.setPaging(query);
        executRecordPageParam.fillOrders(query, qExecutRecordDO);
        // 任务编码/名称，模糊查询
        if (StringUtils.isNotBlank(executRecordPageParam.getTaskCodeNameLike())) {
            query.where(qExecutRecordDO.taskCode.like("%" + executRecordPageParam.getTaskCodeNameLike() + "%")
                    .or(qTaskInfoDO.name.like("%" + executRecordPageParam.getTaskCodeNameLike() + "%")));
        }
        // exists
        if (StringUtils.isNotEmpty(executRecordPageParam.getJurisdiction())) {
            QSalesmanRegionDO qSalesmanRegionDO = QSalesmanRegionDO.salesmanRegionDO;
            QSalesmanInfoDO qSalesmanInfoDO = QSalesmanInfoDO.salesmanInfoDO;
            BooleanExpression booleanExpression = JPAExpressions.select(Expressions.ONE)
                    .from(qSalesmanRegionDO)
                    .innerJoin(qSalesmanInfoDO).on(qSalesmanRegionDO.masId.eq(qSalesmanInfoDO.id))
                    .where(qSalesmanInfoDO.salesmanNo.eq(qExecutRecordDO.executUserCode))
                    .where(qSalesmanRegionDO.regionCode.eq(executRecordPageParam.getJurisdiction())).exists();
            query.where(booleanExpression);
        }
        return PagingVO.<ExecutRecordRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public Long del(List<Long> ids) {
        Long res = jpaQueryFactory.update(qExecutRecordDO)
                .set(qExecutRecordDO.deleteFlag, 1)
                .where(qExecutRecordDO.id.in(ids))
                .execute();
        return res;
    }


    public ExecutRecordRespVO get(Long id) {
        ExecutRecordRespVO executRecordVO = selectInnerJoinTaskDtl()
                .where(qExecutRecordDO.id.eq(id))
                .fetchOne();
        return executRecordVO;
    }


    public List<ExecutRecordRespVO> getList(ExecutRecordQueryParam executRecordPageParam) {
        List<ExecutRecordRespVO> res = select(ExecutRecordRespVO.class)
                .where(bulidPredicate(executRecordPageParam, false))
                .fetch();
        return res;
    }

    private JPAQuery<ExecutRecordRespVO> selectInnerJoinTaskDtl() {
        return jpaQueryFactory.select(Projections.bean(ExecutRecordRespVO.class,
                        qExecutRecordDO.code,
                        qExecutRecordDO.taskCode,
                        qExecutRecordDO.taskDtlId,
                        qExecutRecordDO.taskType,
                        qExecutRecordDO.publishUser,
                        qExecutRecordDO.publishUserId,
                        qExecutRecordDO.publishUserCode,
                        qExecutRecordDO.state,
                        qExecutRecordDO.executUser,
                        qExecutRecordDO.businessType,
                        qExecutRecordDO.businessId,
                        qExecutRecordDO.businessCode,
                        qExecutRecordDO.businessName,
                        qExecutRecordDO.startTime,
                        qExecutRecordDO.endTime,
                        qExecutRecordDO.auditDesc,
                        qExecutRecordDO.id,
                        qExecutRecordDO.createTime,
                        qExecutRecordDO.creator,
                        qExecutRecordDO.updater,
                        qExecutRecordDO.modifyTime,
                        qExecutRecordDO.remark,
                        qTaskInfoDtlDO.delayFlag,
                        qTaskInfoDO.id.as("taskId"),
                        qTaskInfoDO.name.as("taskName"),
                        qTaskInfoDtlDO.executUserId,
                        qTaskInfoDtlDO.executUserCode
                )).from(qExecutRecordDO)
                .innerJoin(qTaskInfoDO).on(qTaskInfoDO.code.eq(qExecutRecordDO.taskCode))
                .innerJoin(qTaskInfoDtlDO).on(qTaskInfoDtlDO.id.eq(qExecutRecordDO.taskDtlId));
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qExecutRecordDO.code,
                qExecutRecordDO.taskCode,
                qExecutRecordDO.taskId,
                qExecutRecordDO.taskDtlId,
                qExecutRecordDO.taskName,
                qExecutRecordDO.taskType,
                qExecutRecordDO.publishUser,
                qExecutRecordDO.publishUserId,
                qExecutRecordDO.publishUserCode,
                qExecutRecordDO.state,
                qExecutRecordDO.executUser,
                qExecutRecordDO.executUserId,
                qExecutRecordDO.executUserCode,
                qExecutRecordDO.businessType,
                qExecutRecordDO.businessId,
                qExecutRecordDO.businessCode,
                qExecutRecordDO.businessName,
                qExecutRecordDO.startTime,
                qExecutRecordDO.endTime,
                qExecutRecordDO.auditDesc,
                qExecutRecordDO.id,
                qExecutRecordDO.createTime,
                qExecutRecordDO.creator,
                qExecutRecordDO.updater,
                qExecutRecordDO.modifyTime,
                qExecutRecordDO.remark
        )).from(qExecutRecordDO);
    }


    private Predicate bulidPredicate(ExecutRecordQueryParam executRecordPageParam, boolean innerJoinTaskDtlFlag) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andLike(StringUtils.isNotBlank(executRecordPageParam.getCode()), qExecutRecordDO.code, executRecordPageParam.getCode())
                .andLike(StringUtils.isNotBlank(executRecordPageParam.getTaskCode()), qExecutRecordDO.taskCode, executRecordPageParam.getTaskCode())
                .andEq(null != executRecordPageParam.getTaskId(), qExecutRecordDO.taskId, executRecordPageParam.getTaskId())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getTaskName()), qExecutRecordDO.taskName, executRecordPageParam.getTaskName())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getTaskType()), qExecutRecordDO.taskType, executRecordPageParam.getTaskType())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getPublishUser()), qExecutRecordDO.publishUser, executRecordPageParam.getPublishUser())
                .andEq(null != executRecordPageParam.getPublishUserId(), qExecutRecordDO.publishUserId, executRecordPageParam.getPublishUserId())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getPublishUserCode()), qExecutRecordDO.publishUserCode, executRecordPageParam.getPublishUserCode())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getState()), qExecutRecordDO.state, executRecordPageParam.getState())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getExecutUser()), qExecutRecordDO.executUser, executRecordPageParam.getExecutUser())
                .andEq(null != executRecordPageParam.getExecutUserId(), qExecutRecordDO.executUserId, executRecordPageParam.getExecutUserId())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getExecutUserCode()), qExecutRecordDO.executUserCode, executRecordPageParam.getExecutUserCode())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getBusinessType()), qExecutRecordDO.businessType, executRecordPageParam.getBusinessType())
                .andEq(null != executRecordPageParam.getBusinessId(), qExecutRecordDO.businessId, executRecordPageParam.getBusinessId())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getBusinessCode()), qExecutRecordDO.businessCode, executRecordPageParam.getBusinessCode())
                .andLike(StringUtils.isNotBlank(executRecordPageParam.getBusinessName()), qExecutRecordDO.businessName, executRecordPageParam.getBusinessName())
                .andGoe(null != executRecordPageParam.getStartTime(), qExecutRecordDO.startTime, executRecordPageParam.getStartTime())
                .andLoe(null != executRecordPageParam.getEndTime(), qExecutRecordDO.endTime, executRecordPageParam.getEndTime())
                .andGoe(null != executRecordPageParam.getCreateTimeStart(), qExecutRecordDO.createTime, executRecordPageParam.getCreateTimeStart())
                .andLoe(null != executRecordPageParam.getCreateTimeEnd(), qExecutRecordDO.createTime, executRecordPageParam.getCreateTimeEnd())
                .andEq(StringUtils.isNotBlank(executRecordPageParam.getAuditDesc()), qExecutRecordDO.auditDesc, executRecordPageParam.getAuditDesc())
                .andIn(!CollectionUtils.isEmpty(executRecordPageParam.getIds()),qExecutRecordDO.id,executRecordPageParam.getIds())
                .build();

        if (innerJoinTaskDtlFlag && StringUtils.isNotEmpty(executRecordPageParam.getDelayFlag())) {
            predicate = ExpressionUtils.and(predicate, qTaskInfoDtlDO.delayFlag.eq(executRecordPageParam.getDelayFlag()));
        }

        return predicate;
    }

    public List<ExecutRecordRespVO> queryBylast(String taskType, String businessCode) {
        List<ExecutRecordRespVO> fetch = select(ExecutRecordRespVO.class)
                .where(qExecutRecordDO.taskType.eq(taskType))
                .where(qExecutRecordDO.businessCode.eq(businessCode))
                .where(qExecutRecordDO.state.eq(UdcEnum.EXECT_RECORD_STATUS_CPD.getValueCode()))
                .where(qExecutRecordDO.deleteFlag.eq(0).or(qExecutRecordDO.deleteFlag.isNull()))
                .orderBy(qExecutRecordDO.createTime.desc())
                .fetch();
        return fetch;
    }

    public List<ExecutRecordRespVO> queryByCodes(List<String> codes) {
        List<ExecutRecordRespVO> fetch = select(ExecutRecordRespVO.class)
                .where(qExecutRecordDO.code.in(codes))
                .where(qExecutRecordDO.deleteFlag.eq(0).or(qExecutRecordDO.deleteFlag.isNull()))
                .fetch();
        return fetch;
    }

    public Long updateByCode(List<String> code, String status) {
        Long res = jpaQueryFactory.update(qExecutRecordDO)
                .set(qExecutRecordDO.state, status)
                .where(qExecutRecordDO.code.in(code))
                .execute();
        return res;
    }

    public Long updateById(Long id, String status) {
        Long res = jpaQueryFactory.update(qExecutRecordDO)
                .set(qExecutRecordDO.state, status)
                .where(qExecutRecordDO.id.eq(id))
                .execute();
        return res;
    }


    public PagingVO<ExecutRecordExportVO> pageExport(ExecutRecordQueryParam executRecordPageParam) {
        JPAQuery<ExecutRecordExportVO> query = selectExport()
                .where(bulidPredicate(executRecordPageParam, true));
        executRecordPageParam.setPaging(query);
        executRecordPageParam.fillOrders(query, qExecutRecordDO);
        // 任务编码/名称，模糊查询
        if (StringUtils.isNotBlank(executRecordPageParam.getTaskCodeNameLike())) {
            query.where(qExecutRecordDO.taskCode.like("%" + executRecordPageParam.getTaskCodeNameLike() + "%")
                    .or(qTaskInfoDO.name.like("%" + executRecordPageParam.getTaskCodeNameLike() + "%")));
        }
        // exists
        if (StringUtils.isNotEmpty(executRecordPageParam.getJurisdiction())) {
            QSalesmanRegionDO qSalesmanRegionDO = QSalesmanRegionDO.salesmanRegionDO;
            QSalesmanInfoDO qSalesmanInfoDO = QSalesmanInfoDO.salesmanInfoDO;
            BooleanExpression booleanExpression = JPAExpressions.select(Expressions.ONE)
                    .from(qSalesmanRegionDO)
                    .innerJoin(qSalesmanInfoDO).on(qSalesmanRegionDO.masId.eq(qSalesmanInfoDO.id))
                    .where(qSalesmanInfoDO.salesmanNo.eq(qExecutRecordDO.executUserCode))
                    .where(qSalesmanRegionDO.regionCode.eq(executRecordPageParam.getJurisdiction())).exists();
            query.where(booleanExpression);
        }
        return PagingVO.<ExecutRecordExportVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }
    private JPAQuery<ExecutRecordExportVO> selectExport() {
        return jpaQueryFactory.select(Projections.bean(ExecutRecordExportVO.class,
                        qExecutRecordDO.id,
                        qExecutRecordDO.code,
                        qExecutRecordDO.taskCode,
                        qExecutRecordDO.taskDtlId,
                        qExecutRecordDO.taskType,
                        qExecutRecordDO.publishUser,
                        qExecutRecordDO.publishUserId,
                        qExecutRecordDO.publishUserCode,
                        qExecutRecordDO.state,
                        qExecutRecordDO.executUser,
                        qExecutRecordDO.businessType,
                        qExecutRecordDO.businessId,
                        qExecutRecordDO.businessCode,
                        qExecutRecordDO.businessName,
                        qExecutRecordDO.startTime,
                        qExecutRecordDO.endTime,
                        qExecutRecordDO.auditDesc,
                        qExecutRecordDO.id,
                        qExecutRecordDO.createTime,
                        qExecutRecordDO.creator,
                        qExecutRecordDO.updater,
                        qExecutRecordDO.modifyTime,
                        qExecutRecordDO.remark,
                        qTaskInfoDtlDO.delayFlag,
                        qExecutRecordDtlDO.masId,
                        qExecutRecordDtlDO.entryTime,
                        qExecutRecordDtlDO.leaveTime,
                        qExecutRecordDtlDO.signInPosition,
                        qExecutRecordDtlDO.signInPositionCode,
                        qExecutRecordDtlDO.signOutPosition,
                        qExecutRecordDtlDO.signOutPositionCode,
                        qExecutRecordDtlDO.signDesc,
                        qExecutRecordDtlDO.id,
                        qExecutRecordDtlDO.createTime,
                        qExecutRecordDtlDO.remark,
                        qExecutRecordDtlDO.creator,
                        qExecutRecordDtlDO.updater,
                        qExecutRecordDtlDO.modifyTime,
                        qTaskInfoDO.id.as("taskId"),
                        qTaskInfoDO.name.as("taskName"),
                        qTaskInfoDtlDO.executUserId,
                        qTaskInfoDtlDO.executUserCode
                )).from(qExecutRecordDO)
                .innerJoin(qTaskInfoDO).on(qTaskInfoDO.code.eq(qExecutRecordDO.taskCode))
                .innerJoin(qTaskInfoDtlDO).on(qTaskInfoDtlDO.id.eq(qExecutRecordDO.taskDtlId))
                .innerJoin(qExecutRecordDtlDO).on(qExecutRecordDtlDO.masId.eq(qExecutRecordDO.id));
    }
}