package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.QCrmCustOuDO;
import com.elitesland.yst.production.sale.entity.QSalContractDDO;
import com.elitesland.yst.production.sale.entity.SalContractDDO;
import com.elitesland.yst.production.sale.entity.SalContractDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 11:26 上午
 */
@Repository
public class SalContractDRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QSalContractDDO qSalContractDDO = QSalContractDDO.salContractDDO;


    public List<SalContractDDO> findDDOByMasId(Long Id) {
        Predicate predicate = qSalContractDDO.deleteFlag.eq(0).or(qSalContractDDO.deleteFlag.isNull());
        ExpressionUtils.and(predicate, qSalContractDDO.id.eq(Id));

        return jpaQueryFactory.select(qSalContractDDO)
                .from(qSalContractDDO)
                .where(predicate)
                .fetch();
    }
}
