package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.entity.QSalProjDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 11:26 上午
 */
@Repository
public class SalProjRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QSalProjDO qSalProjDO = QSalProjDO.salProjDO;
    /**
     * 判断客户名称是否已存在
     *
     * @param projName projName
     * @param custCode custCode
     * @return 客户名称
     */
    public Boolean exists(String projName, String custCode) {
        Predicate predicate = qSalProjDO.deleteFlag.eq(0).or(qSalProjDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(projName) ? predicate : ExpressionUtils.and(predicate, qSalProjDO.projName.eq(projName));
        predicate = StringUtils.isEmpty(custCode) ? predicate : ExpressionUtils.and(predicate, qSalProjDO.custCode.eq(custCode));
        return jpaQueryFactory.select(qSalProjDO)
                .from(qSalProjDO)
                .where(predicate)
                .fetchCount() > 0;
    }
    /**
     * 判断公司是否已存在
     *
     * @param projName projName
     * @param bSignOu bSignOu
     * @return 客户名称
     */
    public Boolean exists1(String projName, String bSignOu) {
        Predicate predicate = qSalProjDO.deleteFlag.eq(0).or(qSalProjDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(projName) ? predicate : ExpressionUtils.and(predicate, qSalProjDO.projName.eq(projName));
        predicate = StringUtils.isEmpty(bSignOu) ? predicate : ExpressionUtils.and(predicate, qSalProjDO.ouId.eq(Long.parseLong(bSignOu)));
        return jpaQueryFactory.select(qSalProjDO)
                .from(qSalProjDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    public List<Long> findIdByName(String projName){
        Predicate predicate = qSalProjDO.deleteFlag.eq(0).or(qSalProjDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(projName) ? predicate : ExpressionUtils.and(predicate, qSalProjDO.projName.eq(projName));
        return jpaQueryFactory.select(qSalProjDO.id)
                .from(qSalProjDO)
                .where(predicate)
                .fetch();
    }
}
