package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.QPriSalePriceAlterDO;
import com.elitesland.yst.production.sale.entity.QSalQuotationDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/16 20:10
 */
@Repository
public class SalQuotationRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    private final QSalQuotationDO qSalQuotationDO = QSalQuotationDO.salQuotationDO;

    public Long getOuIdById(Long id) {
        return jpaQueryFactory.select(qSalQuotationDO.ouId)
                .from(qSalQuotationDO)
                .where(qSalQuotationDO.id.eq(id).and(qSalQuotationDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetchOne();
    }
}
