package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.BipItemCategoryDO;
import com.elitesland.yst.production.sale.entity.QBipItemCategoryDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @auther JinXK
 * @date 2021/8/6 14:26
 */
@Repository
public class BipItemCategoryRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QBipItemCategoryDO DO = QBipItemCategoryDO.bipItemCategoryDO;

    public BipItemCategoryRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    /**
     * 更新是否启用
     *
     * @param id     ID
     * @param enable 是否启用
     */
    public void updateEnable(Long id, Boolean enable) {
        jpaQueryFactory.update(DO)
                .set(DO.enable, enable)
                .where(DO.id.eq(id))
                .execute();
    }

    /**
     * 删除数据
     *
     * @param id ID
     */
    public void delete(Long id) {
        jpaQueryFactory.delete(DO)
                .where(DO.id.eq(id))
                .execute();
    }

    /**
     * 根据ID判断是否存在
     *
     * @param id ID
     * @return 是否存在
     */
    public boolean existsById(Long id) {
        return jpaQueryFactory.select(DO.id)
                .from(DO)
                .where(DO.id.eq(id))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 根据编号判断是否存在
     *
     * @param code 编号
     * @return 是否存在
     */
    public boolean existsByCode(String code) {
        return jpaQueryFactory.select(DO.id)
                .from(DO)
                .where(DO.code.eq(code))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 根据编号判断是否存在
     *
     * @param code 编号
     * @param id   ID
     * @return 是否存在
     */
    public boolean existsByCode(String code, Long id) {
        return jpaQueryFactory.select(DO.id)
                .from(DO)
                .where(DO.code.eq(code).and(DO.id.ne(id)))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 判断是否存在子类
     *
     * @param pid 父类
     * @return 是否存在
     */
    public boolean existsByPid(Long pid) {
        return jpaQueryFactory.select(DO.id)
                .from(DO)
                .where(DO.pid.eq(pid))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 判断是否存在顺序号
     *
     * @param pid    父类
     * @param sortNo 顺序号
     * @return 是否存在
     */
    public boolean existsBySortNo(Long pid, Integer sortNo) {
        return jpaQueryFactory.select(DO.id)
                .from(DO)
                .where(DO.pid.eq(pid).and(DO.sortNo.eq(sortNo)))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 判断是否存在顺序号
     *
     * @param ouId   所属公司
     * @param pid    父类
     * @param sortNo 顺序号
     * @return 是否存在
     */
    public boolean existsBySortNo(Long ouId, Long pid, Integer sortNo) {
        return jpaQueryFactory.select(DO.id)
                .from(DO)
                .where(DO.pid.eq(pid).and(DO.ouId.eq(ouId)).and(DO.sortNo.eq(sortNo)))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 判断是否存在顺序号
     *
     * @param pid    父类
     * @param sortNo 顺序号
     * @param id     分类ID
     * @return 是否存在
     */
    public boolean existsBySortNo(Long pid, Integer sortNo, Long id) {
        return jpaQueryFactory.select(DO.id)
                .from(DO)
                .where(DO.pid.eq(pid).and(DO.sortNo.eq(sortNo)).and(DO.id.ne(id)))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 判断是否存在顺序号
     *
     * @param ouId   所属公司
     * @param pid    父类
     * @param sortNo 顺序号
     * @param id     分类ID
     * @return 是否存在
     */
    public boolean existsBySortNo(Long ouId, Long pid, Integer sortNo, Long id) {
        return jpaQueryFactory.select(DO.id)
                .from(DO)
                .where(DO.pid.eq(pid).and(DO.ouId.eq(ouId)).and(DO.sortNo.eq(sortNo)).and(DO.id.ne(id)))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 根据ID获取名称
     *
     * @param id ID
     * @return 名称
     */
    public String getName(Long id) {
        return jpaQueryFactory.select(DO.name)
                .from(DO)
                .where(DO.id.eq(id))
                .limit(1)
                .fetchOne();
    }

    /**
     * 根据ID获取名称
     *
     * @param id ID
     * @return 名称
     */
    public Integer getLevel(Long id) {
        return jpaQueryFactory.select(DO.level)
                .from(DO)
                .where(DO.id.eq(id))
                .limit(1)
                .fetchOne();
    }

    /**
     * 根据ID获取是否启用
     *
     * @param id ID
     * @return 是否启用
     */
    public Boolean getEnable(Long id) {
        return jpaQueryFactory.select(DO.enable)
                .from(DO)
                .where(DO.id.eq(id))
                .limit(1)
                .fetchOne();
    }

    /**
     * 根据上级ID
     *
     * @param id ID
     * @return 是否启用
     */
    public Long getPid(Long id) {
        return jpaQueryFactory.select(DO.pid)
                .from(DO)
                .where(DO.id.eq(id))
                .limit(1)
                .fetchOne();
    }

    /**
     * 根据商品分类编码查询分类
     *
     * @param code 分类编码
     * @return 分类
     */
    public BipItemCategoryDO getByCode(String code) {
        return jpaQueryFactory.select(DO)
                .from(DO)
                .where(DO.code.eq(code))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取公司下的分类
     *
     * @param ouId 公司ID
     * @return 分类
     */
    public List<BipItemCategoryDO> queryByOuId(Long ouId) {
        return jpaQueryFactory.select(DO)
                .from(DO)
                .where(DO.ouId.eq(ouId))
                .fetch();
    }
}
