package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.BipItemEvalDo;
import com.elitesland.yst.production.sale.entity.QBipItemEvalDo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/02
 */
@Repository
public class BipItemEvalRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QBipItemEvalDo DO = QBipItemEvalDo.bipItemEvalDo;

    public BipItemEvalRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    /**
     * 统计商品的评价数量
     *
     * @param itemId 商品ID
     * @return 评价数量
     */
    public Long countItemEvalNum(Long itemId) {
        return jpaQueryFactory.select(DO.count())
                .from(DO)
                .where(DO.itemId.eq(itemId))
                .fetchOne();
    }

    /**
     * 统计商品的评价数量
     *
     * @param itemId   商品ID
     * @param minScore 最低评分
     * @return 评价数量
     */
    public Long countItemEvalNum(Long itemId, Integer minScore) {
        return jpaQueryFactory.select(DO.count())
                .from(DO)
                .where(DO.itemId.eq(itemId).and(DO.itemEvalScore.goe(minScore)))
                .fetchOne();
    }

    /**
     * 统计商品的总评价星数
     *
     * @param itemId 商品ID
     * @return 总评价星数
     */
    public Integer sumItemEval(Long itemId) {
        return jpaQueryFactory.select(DO.itemEvalScore.sum())
                .from(DO)
                .where(DO.itemId.eq(itemId))
                .fetchOne();
    }


    /**
     * 更新评价是否显示
     * @param ids
     * @param isShow
     */
    public void updateItmeEvalShow(List<Long> ids, boolean isShow) {
         jpaQueryFactory.update(DO)
                .set(DO.isShow,isShow)
                .where(DO.id.in(ids)).execute();
    }


    /**
     *
     * @param docNo
     */
    public List<BipItemEvalDo> findItemEvalByDocNo(String docNo) {
        return jpaQueryFactory.select(DO)
                .from(DO)
                .where(DO.docNo.eq(docNo))
                .fetch();
    }


    /**
     *根据订单id查询评价
     * @param id
     */
    public List<BipItemEvalDo> findItemEvalByOrderId(Long id) {
        return jpaQueryFactory.select(DO)
                .from(DO)
                .where(DO.orderId.eq(id))
                .fetch();
    }
}
