package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.BipOrderDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/08/9:02
 * @Description:
 */
public interface BipOrderRepo  extends JpaRepository<BipOrderDO, Long>, QuerydslPredicateExecutor<BipOrderDO>, JpaSpecificationExecutor<BipOrderDO> {

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order set delete_flag = 1 where id in ?1", nativeQuery = true)
    public void deleteOrderByIds(List<Long> ids);


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order set delete_flag = 1 where id = ?1", nativeQuery = true)
    public void deleteOrderById(Long id);

    List<BipOrderDO> findByCustAccountIdAndOuIdAndPayStatus(Long custAccountId, Long ouId, String payStatus);


    List<BipOrderDO> findByCustAccountIdAndPayStatus(Long custAccountId, String payStatus);


    List<BipOrderDO> findByCustAccountId(Long custAccountId);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order set invoice = ?2 , offFlag = ?3 where id = ?1", nativeQuery = true)
    void updateOrderInvoice(Long id,Boolean invoice,Integer offFlag);


    List<BipOrderDO> findAllByDocNoIn(List<String> bipShipMentOrderCodes);

    List<BipOrderDO> findByIdIn(List<Long> ids);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order set isCreateReceipt = 1 where docNo = ?1", nativeQuery = true)
    void updateIsCreateReceipt(String docNo);

    @Transactional//事务的注解
    @Query(value = "select s.doc_no from sal_so s inner join sal_so_d sd1 \n" +
            "on s.id = sd1.mas_id and s.doc_status = ?2 and s.doc_type2 = ?3 and s.doc_cls = ?4\n" +
            "and (s.doc_type = ?5 or s.doc_type = ?6) inner join ( select sd.mas_id,max(ship_confirm_time) ship_time\n" +
            "from \n" +
            "sal_so_d sd \n" +
            "group by sd.mas_id ) sd \n" +
            "on s.id = sd.mas_id and sd1.ship_confirm_time  = sd.ship_time \n" +
            "and sd.ship_time <= DATE_SUB(CURDATE(), INTERVAL ?1 DAY)", nativeQuery = true)
    public List<String> findAoOrders(Integer date,String docStatus,String docType2,String docCls,String docType01,String docType02);
}
