package com.elitesland.yst.production.sale.rmi.ystsupport;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/3 10:05
 */
@Slf4j
@Component
public class RmiOrgEmpService {

    @Autowired
    private OrgEmpRpcService orgEmpRpcService;

    public List<OrgEmpRpcDTO> findEmpListByParam(OrgEmpRpcDtoParam param) {
        try {
            List<OrgEmpRpcDTO> empDtoByParam = orgEmpRpcService.findEmpDtoByParam(param);
            return CollUtil.isNotEmpty(empDtoByParam) ? empDtoByParam : new ArrayList<>(0);
        } catch (Exception e) {
            log.error("远程调用支撑域员工相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域员工查询相关服务异常" + e, e);
        }
    }

    public List<OrgEmpRpcDTO> findEmpDtoList(List<Long> agentEmpIds, List<String> agentEmpCodes) {
        var orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
        orgEmpRpcDtoParam.setEmpCodes(agentEmpCodes);
        return this.findEmpListByParam(orgEmpRpcDtoParam);
    }

    /**
     * 根据userId获取用户员工信息
     *
     * @param userId 用户ID
     * @return 用户员工信息 (存在null)
     */
    public OrgUserEmpInfoRpcDTO findUserEmpInfo(Long userId) {
        try {
            return orgEmpRpcService.findUserEmpInfo(userId);
        } catch (Exception e) {
            log.error("远程调用支撑域员工相关服务异常:根据userId获取用户员工信息。{}", e.getMessage());
            throw new BusinessException("远程调用支撑域员工查询相关服务异常:根据userId获取用户员工信息。" + e, e);
        }
    }

}
