package com.elitesland.yst.production.sale.search.store.bean;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.sale.search.bean.BasicsBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author wz
 * @Date 2023/07/12
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "门店销售业绩附表")
@SearchBean(tables = "sale_statistics_store sd left join sale_statistics_store_dtl ssd on sd.id = ssd.mas_id",
        autoMapTo = "sd"
        ,groupBy = "sd.id"
)
public class StatisticsStoreDtlSearchBean extends BasicsBean {

    private static final long serialVersionUID = -8241516457215431658L;

    @ApiModelProperty("id")
    @DbField("sd.id")
    private Long id;

    @ApiModelProperty("关联id")
    @DbField("ssd.mas_id")
    private Long masId;

    @ApiModelProperty("层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值")
    @DbField("ssd.level")
    private String level;

    @ApiModelProperty("业务员编码")
    @DbField("ssd.code")
    private String code;

    @ApiModelProperty("业务员名称")
    @DbField("ssd.name")
    private String name;

    @ApiModelProperty("用户id")
    @DbField("ssd.user_id")
    private Long userId;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-sale", mod = "SALESMAN_TYPE")
    @DbField("ssd.type")
    private String type;
    @DbIgnore
    private String typeName;
}
