package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONObject;

import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrAddressRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.CrmScustService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmEmpAssignParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmScustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.save.*;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.CrmScustConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.CrmScustDO;
import com.elitesland.yst.production.sale.entity.QCrmScustDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.CrmScustRepo;
import com.elitesland.yst.production.sale.repo.CrmScustRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.system.vo.SysUdcComboVO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/4 13:17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmScustServiceImpl extends BaseServiceImpl implements CrmScustService {

    private final QCrmScustDO qCrmScustDO = QCrmScustDO.crmScustDO;

    private final RmiOrgAddrService rmiOrgAddrService;

    private final RmiOrgEmpService rmiOrgEmpService;

    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final CrmScustRepo crmScustRepo;

    private final CrmScustRepoProc crmScustRepoProc;

    private final CrmCustRepoProc crmCustRepoProc;

    private final CrmCustService crmCustService;

    private final RmiOrgOuService rmiOrgOuService;

    private final RmiOrgBuService rmiOrgBuService;


    @Override
    @SysCodeProc
    public PagingVO<CrmScustPageRespVO> search(CrmScustQueryParamVO searchParam) {
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        orgAddressRpcDtoParam.setContPerson(searchParam.getContPerson());
        orgAddressRpcDtoParam.setMobile(searchParam.getMobile());
        List<Long> addrNos = new ArrayList<>();
        if (!ObjectUtils.isEmpty(orgAddressRpcDtoParam)) {
            try {
                List<OrgAddressRpcDTO> addrAddressRpcDtoByParam = rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
                addrNos = addrAddressRpcDtoByParam.stream().map(OrgAddressRpcDTO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            } catch (Exception e) {
                log.error("dubbo访问地址查询接口失败：" + e.getMessage());
                throw new BusinessException("dubbo服务调用支撑域域地址接口出错");
            }
            searchParam.setAddrNos(addrNos);
        }
        PagingVO<CrmScustPageRespVO> respVOPagingVO = this.searching(searchParam);
        List<CrmScustPageRespVO> scustPageRespVOS = respVOPagingVO.getRecords();
        this.translatePage(scustPageRespVOS);
        return new PagingVO<CrmScustPageRespVO>()
                .setTotal(respVOPagingVO.getTotal())
                .setRecords(scustPageRespVOS);
    }

    /**
     * 补充分页查询数据
     **/
    private void translatePage(List<CrmScustPageRespVO> respVOList) {
        List<Long> agentEmpIds = respVOList.stream().map(CrmScustPageRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empDtoByParam = new ArrayList<>();
        if (!org.springframework.util.CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            try {
                empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
            } catch (Exception e) {
                log.error("dubbo访问emp查询接口失败：" + e.getMessage());
                throw new BusinessException("dubbo服务调用支持域查询员工接口出错");
            }
        }
        List<Long> addrNos = respVOList.stream().map(CrmScustPageRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        List<OrgAddressRpcDTO> addressRpcDto = new ArrayList<>();
        if (!org.springframework.util.CollectionUtils.isEmpty(addrNos)) {
            orgAddressRpcDtoParam.setAddrNos(addrNos);
            try {
                addressRpcDto = rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
            } catch (Exception e) {
                log.error("dubbo访问地址查询接口失败：" + e.getMessage());
                throw new BusinessException("dubbo服务调用支持域地址接口出错");
            }
        }
        // 主要是用来数据补充
        List<OrgEmpRpcDTO> finalEmpDtoByParam = empDtoByParam;
        List<OrgAddressRpcDTO> finalAddressRpcDto = addressRpcDto;
        respVOList.forEach(respVo -> {
            if (!org.springframework.util.StringUtils.isEmpty(respVo.getAddrNo())) {
                finalAddressRpcDto.stream().filter(addr -> addr.getAddrNo().equals(respVo.getAddrNo()))
                        .findFirst()
                        .ifPresent(addrDto -> {
                            respVo.setContPerson(addrDto.getContPerson());
                            respVo.setEmail(addrDto.getEmail());
                            respVo.setMobile(addrDto.getMobile());
                            respVo.setDetailAddr(addrDto.getDetailAddr());
                        });
            }
            if (!org.springframework.util.StringUtils.isEmpty(respVo.getAgentEmpId())) {
                finalEmpDtoByParam.stream().filter(emp -> emp.getId().equals(respVo.getAgentEmpId()))
                        .findFirst()
                        .ifPresent(agentEmp -> respVo.setAgentEmpName(agentEmp.getEmpName()));
            }
            respVo.setAddrDetail(respVo.getDetailAddr());
        });
    }

    private PagingVO<CrmScustPageRespVO> searching(CrmScustQueryParamVO paramVO) {

        var jpaQuery = jpaQueryFactory.select(
                qCrmScustDO.id, qCrmScustDO.custCode,
                qCrmScustDO.custName, qCrmScustDO.custName2, qCrmScustDO.custAbbr,
                qCrmScustDO.addrNo, qCrmScustDO.custType, qCrmScustDO.custStatus,
                qCrmScustDO.agentEmpId, qCrmScustDO.ouId, qCrmScustDO.buId,
                qCrmScustDO.custIndustry, qCrmScustDO.custSource, qCrmScustDO.intentLevel,
                qCrmScustDO.lastFollowupDate, qCrmScustDO.region, qCrmScustDO.agentEmpId,
                qCrmScustDO.compScale, qCrmScustDO.compTurnover, qCrmScustDO.taxRegNo,
                qCrmScustDO.icRegisterNo, qCrmScustDO.buName, qCrmScustDO.ouName, qCrmScustDO.es2
        )
                .from(qCrmScustDO)
                .where(searchWhere(paramVO));
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            // 没有符合的数据，则直接返回
            return PagingVO.<CrmScustPageRespVO>builder().build();
        }
        // 添加分页和排序
        PageRequest pageRequest = wrapperPageRequest(paramVO.getPageRequest(), Sort.by(Sort.Direction.ASC, qCrmScustDO.modifyTime.getMetadata().getName()));
        appendPageAndSort(jpaQuery, pageRequest, qCrmScustDO);

        List<CrmScustPageRespVO> voList = jpaQuery.fetch().stream()
                .map(tuple -> {
                    CrmScustPageRespVO vo = new CrmScustPageRespVO();
                    vo.setId(tuple.get(qCrmScustDO.id));
                    vo.setCustCode(tuple.get(qCrmScustDO.custCode));
                    vo.setCustName(tuple.get(qCrmScustDO.custName));
                    vo.setCustName2(tuple.get(qCrmScustDO.custName2));
                    vo.setAddrNo(tuple.get(qCrmScustDO.addrNo));
//                    vo.setCustCode2(tuple.get(qCrmScustDO.custCode2));
                    vo.setOuId(tuple.get(qCrmScustDO.ouId));
                    vo.setBuId(tuple.get(qCrmScustDO.buId));
                    vo.setIcRegisterNo(tuple.get(qCrmScustDO.icRegisterNo));
                    vo.setTaxRegNo(tuple.get(qCrmScustDO.taxRegNo));
                    vo.setCustAbbr(tuple.get(qCrmScustDO.custAbbr));
                    vo.setCustType(tuple.get(qCrmScustDO.custType));
                    vo.setCustSource(tuple.get(qCrmScustDO.custSource));
                    vo.setCustStatus(tuple.get(qCrmScustDO.custStatus));
                    vo.setCustIndustry(tuple.get(qCrmScustDO.custIndustry));
                    vo.setIntentLevel(tuple.get(qCrmScustDO.intentLevel));
                    vo.setLastFollowupDate(tuple.get(qCrmScustDO.lastFollowupDate));
                    vo.setRegion(tuple.get(qCrmScustDO.region));
                    vo.setAgentEmpId(tuple.get(qCrmScustDO.agentEmpId));
                    vo.setCompScale(tuple.get(qCrmScustDO.compScale));
                    vo.setCompTurnover(tuple.get(qCrmScustDO.compTurnover));
                    vo.setBuName(tuple.get(qCrmScustDO.buName));
                    vo.setOuName(tuple.get(qCrmScustDO.ouName));
                    vo.setEs2(tuple.get(qCrmScustDO.es2));
                    return vo;
                }).collect(Collectors.toList());

        return PagingVO.<CrmScustPageRespVO>builder()
                .records(voList)
                .total(jpaQuery.fetchCount())
                .build();
    }

    public Predicate searchWhere(CrmScustQueryParamVO param) {

        Predicate predicate = qCrmScustDO.deleteFlag.eq(0).or(qCrmScustDO.deleteFlag.isNull());
        //品牌
        predicate = StringUtils.isEmpty(param.getCustIds()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.id.in(param.getCustIds()));
        //组织
        predicate = StringUtils.isEmpty(param.getBuId()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.buId.eq(param.getBuId()));
        //业务员
        predicate = StringUtils.isEmpty(param.getAgentEmpId()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.agentEmpId.eq(param.getAgentEmpId()));
        //简称
        predicate = StringUtils.isEmpty(param.getCustAbbr()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.custAbbr.like("%" + param.getCustAbbr() + "%"));
        //外部客户编码
//        predicate = StringUtils.isEmpty(param.getCustCode2()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.custCode2.like("%" + param.getCustCode2() + "%"));
        //客户编码
        predicate = StringUtils.isEmpty(param.getCustCode()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.custCode.like("%" + param.getCustCode() + "%"));
        //客户名称
        predicate = StringUtils.isEmpty(param.getCustName()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.custName.like("%" + param.getCustName() + "%"));
        //公司
        predicate = StringUtils.isEmpty(param.getOuId()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.ouId.eq(param.getOuId()));
        //地址号
        predicate = CollectionUtils.isEmpty(param.getAddrNos()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.addrNo.in(param.getAddrNos()));
        //税务登记号
        predicate = StringUtils.isEmpty(param.getTaxRegNo()) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.taxRegNo.like("%" + param.getTaxRegNo() + "%"));

//        // 添加权限信息
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qCrmScustDO.getMetadata()));
        return predicate;
    }

    /**
     * 分配业务员
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void empAssign(CrmEmpAssignParamVO crmEmpAssignParamVO) {
        Assert.notNull(crmEmpAssignParamVO, "更新信息为空");
        crmScustRepo.updateScustAgentEmp(crmEmpAssignParamVO.getAgentEmpId(), crmEmpAssignParamVO.getCustIds());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<CrmScustDetailRespVO> save(CrmScustSaveVO saveVO) {
        /*
         * 第一步数据校验:
         *   1.必填校验: 客户名称、销售组织、公司、区域、客户管理专员、客户分类
         *   2.字段重复校验: 客户名称(1.新增的时候检查客户名称是否存在 2.修改的时候如果是当前客户修改信息则通过,其他用户修改同名称报错)
         */
        if (StringUtils.isEmpty(saveVO.getCustCode())) {
            try {
                String custCode = rmiSysNextNumberService.generateCode("yst-sale","C", new ArrayList<>());
                saveVO.setCustCode(custCode);
            } catch (Exception e) {
                log.error("dubbo访问发号器接口失败：" + e.getMessage());
                return ApiResult.fail("dubbo访问发号器接口失败");
            }
        }
        checkForSave(saveVO);
        log.info("测试3");
        /*
         * 第二步地址簿信息存储:(原因:保存成功需要把地址号存在客户主表,故优于主表存储)
         *   1.删除原先的地址簿信息: 针对于修改操作(通过地址号)
         *   2.批量处理地址簿信息(包括客户信息列表、身份信息(含附件)) 附件 本地建中间表存关联关系
         */
        //如果地址号不为null则删除对应的地址簿信息
        OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
        //批量处理地址簿信息
        /*******************************批量处理地址簿信息***********************************/
        param.setAddrNo(saveVO.getAddrNo());
        param.setAddrName(saveVO.getCustName());
        param.setAddrType(UdcEnum.ORG_ADDR_TYPE_SCUST.getValueCode());
        List<OrgAddrAddressRpcSaveParam> addrAddressRpcSaveParams = new ArrayList<>();
        OrgAddrAddressRpcSaveParam orgAddrAddressRpcSaveParam = new OrgAddrAddressRpcSaveParam();
        orgAddrAddressRpcSaveParam.setEmail(saveVO.getEmail());
        orgAddrAddressRpcSaveParam.setMobile(saveVO.getMobile());
        orgAddrAddressRpcSaveParam.setContPerson(saveVO.getContPerson());
        orgAddrAddressRpcSaveParam.setDetailAddr(saveVO.getDetailAddr());
        orgAddrAddressRpcSaveParam.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode());
        orgAddrAddressRpcSaveParam.setDefaultFlag(true);
        addrAddressRpcSaveParams.add(orgAddrAddressRpcSaveParam);
        param.setOrgAddrAddressSaveParams(addrAddressRpcSaveParams);
        log.info("测试4");
        /*
         * 第三步数据保存
         *   1.地址簿信息保存,这里先转换为DO
         *   2.地址簿信息保存,会返回adderNo地址号(需要保存到客户主表)
         *   3.新增时设置状态为潜在用户
         */
        if (StringUtils.isEmpty(saveVO.getId())) {
            saveVO.setCustStatus(UdcEnum.CRM_SCUST_STATUS_A.getValueCode());
        }
        CrmScustDO crmScustDO = saveVoDo(saveVO);
        // 权限字段设置
        crmScustDO.setSecBuId(saveVO.getBuId());
        crmScustDO.setSecOuId(saveVO.getOuId());
        crmScustDO.setSecUserId(saveVO.getAgentEmpId());
        ApiResult<Long> addrNo1 = rmiOrgAddrService.orgAddrSaveOrUpdate(param);
        log.info("地址保存返回参数:{}", JSONObject.toJSONString(addrNo1));
        Assert.isFalse(!addrNo1.isSuccess(), addrNo1.getMsg());
        Long addrNo = addrNo1.getData();
        crmScustDO.setAddrNo(addrNo);
        log.info("测试5");

        CrmScustConvert crmScustConvert = CrmScustConvert.INSTANCE;
        CrmScustDetailRespVO crmScustDetailRespVO = crmScustConvert.doToDetailRespVO(crmScustRepo.save(crmScustDO));
        return ApiResult.ok(crmScustDetailRespVO);
    }

    @Override
    @SysCodeProc
    public CrmScustDetailRespVO findScustById(Long id) {
        if (id == null) {
            return null;
        }
        CrmScustDO crmScustDO = crmScustRepo.findById(id).orElse(null);
        if (crmScustDO == null) {
            throw new BusinessException("该客户信息不存在");
        }
        CrmScustDetailRespVO respVO = CrmScustConvert.INSTANCE.doToDetailRespVO(crmScustDO);
        this.translateDetail(respVO);
        return respVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateScustStatus(Long id) {
        List<Long> ids = new ArrayList<>();
        ids.add(id);
        String scuteStatus = UdcEnum.CRM_SCUST_STATUS_B.getValueCode();
        crmScustRepo.updateScustStatus(scuteStatus, ids);
        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> conScustImportData(List<CrmScustImportSaveVO> parseData) {
        importDataHadle(parseData);
        List<CrmScustDO> crmScustDOS = parseData.stream().map(CrmScustConvert.INSTANCE::importToDO).collect(Collectors.toList());
        List<CrmScustDO> crmScustDOS1 = new ArrayList<>();
        parseData.forEach(i ->{
            String custCode = rmiSysNextNumberService.generateCode("yst-sale","C", new ArrayList<>());
            CrmScustDO crmScustDO = crmScustDOS.stream().filter(cust -> cust.getCustName().equals(i.getCustName()))
                    .findFirst().get();
            OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
            //批量处理地址簿信息
            /*******************************批量处理地址簿信息***********************************/
            param.setAddrNo(i.getAddrNo());
            param.setAddrName(i.getCustName());
            param.setAddrType(UdcEnum.ORG_ADDR_TYPE_SCUST.getValueCode());
            List<OrgAddrAddressRpcSaveParam> addrAddressRpcSaveParams = new ArrayList<>();
            OrgAddrAddressRpcSaveParam orgAddrAddressRpcSaveParam = new OrgAddrAddressRpcSaveParam();
            orgAddrAddressRpcSaveParam.setEmail(i.getEmail());
            orgAddrAddressRpcSaveParam.setMobile(i.getMobile());
            orgAddrAddressRpcSaveParam.setContPerson(i.getContPerson());
            orgAddrAddressRpcSaveParam.setDetailAddr(i.getDetailAddr());
            orgAddrAddressRpcSaveParam.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode());
            orgAddrAddressRpcSaveParam.setDefaultFlag(true);
            addrAddressRpcSaveParams.add(orgAddrAddressRpcSaveParam);
            param.setOrgAddrAddressSaveParams(addrAddressRpcSaveParams);
            ApiResult<Long> addrNo1 = rmiOrgAddrService.orgAddrSaveOrUpdate(param);
            log.info("地址保存返回参数:{}", JSONObject.toJSONString(addrNo1));
            Assert.isFalse(!addrNo1.isSuccess(), addrNo1.getMsg());
            Long addrNo = addrNo1.getData();
            crmScustDO.setAddrNo(addrNo);
            crmScustDO.setCustCode(custCode);
            crmScustDO.setSecBuId(i.getBuId());
            crmScustDO.setSecOuId(i.getOuId());
            crmScustDO.setSecUserId(i.getAgentEmpId());
            crmScustDO.setLastFollowupDate(i.getLastFollowupDate() == null ? null : i.getLastFollowupDate().atStartOfDay());
            if (!ObjectUtils.isEmpty(crmScustDO.getEs2()) && crmScustDO.getEs2().equals("是")){
                crmScustDO.setEs2("1");
            }else if (!ObjectUtils.isEmpty(crmScustDO.getEs2()) && crmScustDO.getEs2().equals("否")){
                crmScustDO.setEs2("0");
            }
            crmScustDOS1.add(crmScustDO);
        });
        crmScustRepo.saveAll(crmScustDOS1);
        return ApiResult.ok();
    }

    private void importDataHadle(List<CrmScustImportSaveVO> parseData) {
//        List<SysUdcComboVO> custTypeUdcList = sysUdcService.listCodeCombos("CRM", "CUST_TYPE");
//        List<SysUdcComboVO> scustIntentLevelList = sysUdcService.listCodeCombos("CRM", "SCUST_INTENT_LEVEL");
//        List<SysUdcComboVO> custSourceUdcList = sysUdcService.listCodeCombos("CRM", "CUST_SOURCE");
//        List<SysUdcComboVO> ouRegionUdcList = sysUdcService.listCodeCombos("ORG", "OU_REGION");
//        List<SysUdcComboVO> industryUdcList = sysUdcService.listCodeCombos("COM", "INDUSTRY");
//        // 处理校验数据
//        List<String> ouCodes = parseData.stream().map(CrmScustImportSaveVO::getOuCode).filter(Objects::nonNull).collect(Collectors.toList());
//        List<String> buCodes = parseData.stream().map(CrmScustImportSaveVO::getBuCode).filter(Objects::nonNull).collect(Collectors.toList());
//        List<String> agentEmpCodes = parseData.stream().map(CrmScustImportSaveVO::getAgentEmpCode).filter(Objects::nonNull).collect(Collectors.toList());
//        List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(null, ouCodes);
//        List<OrgBuRpcDTO> buDtoList = rmiOrgBuService.findBuDtoList(null, buCodes);
//        List<OrgEmpRpcDTO> empDtoList = rmiOrgEmpService.findEmpDtoList(null, agentEmpCodes);
//        parseData.forEach(importVo -> {
//            // 必填校验
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getCustName()), "excel中存在潜在客户名称为空");
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getTaxRegNo()), "潜在客户名称为" + importVo.getCustName() + "的数据税务登记号为空");
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getCustIndustryName()), "潜在客户名称为" + importVo.getCustName() + "的数据客户行业为空");
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getCompScale()), "潜在客户名称为" + importVo.getCustName() + "的数据客户规模为空");
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getCustSourceName()), "潜在客户名称为" + importVo.getCustName() + "的数据客户来源为空");
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getCustTypeName()), "潜在客户名称为" + importVo.getCustName() + "的数据客户分类为空");
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getOuCode()), "潜在客户名称为" + importVo.getCustName() + "的数据公司编码为空");
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getBuCode()), "潜在客户名称为" + importVo.getCustName() + "的数据组织编码为空");
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getRegionName()), "潜在客户名称为" + importVo.getCustName() + "的数据地区为空");
//            Assert.isFalse(org.springframework.util.StringUtils.isEmpty(importVo.getAgentEmpCode()), "潜在客户名称为" + importVo.getCustName() + "的数据业务员编码为空");
//            // 查询校验
//            // 2.判断该客户是否存在
//            List<CrmCustSimpleVO> byName = crmCustRepoProc.findIdByNameAndTaxRegNo(importVo.getCustName(), null);
//            List<CrmCustSimpleVO> byTaxRegNo = crmCustRepoProc.findIdByNameAndTaxRegNo(null, importVo.getTaxRegNo());
//            if (!CollectionUtils.isEmpty(byName) || !CollectionUtils.isEmpty(byTaxRegNo)){
//                throw new BusinessException("客户名称:"+importVo.getCustName()+",税务登记号为"+importVo.getTaxRegNo()+"的客户,客户名称或者是税务登记号已经存在于正式客户表,请检查");
//            }
//            List<CrmScustPageRespVO> idByName = crmScustRepoProc.findIdByNameAndTaxRegNo(importVo.getCustName(),null);
//            List<CrmScustPageRespVO> idByTaxRegNo = crmScustRepoProc.findIdByNameAndTaxRegNo(null,importVo.getTaxRegNo());
//            if (!CollectionUtils.isEmpty(idByName) || !CollectionUtils.isEmpty(idByTaxRegNo)){
//                throw new BusinessException("客户名称:"+importVo.getCustName()+",税务登记号为"+importVo.getTaxRegNo()+"的客户,客户名称或者是税务登记号已经存在于潜在客户表,请检查");
//            }
//            // 3.判断该业务员是否存在
//            OrgEmpRpcDTO orgEmpRpcDTO = empDtoList.stream().filter(emp -> emp.getEmpCode().equals(importVo.getAgentEmpCode()))
//                    .findFirst().orElseThrow(
//                            new BusinessException("客户名称为:" + importVo.getCustName() + "的数据业务员不存在于本系统中请检查")
//                    );
//            importVo.setAgentEmpId(orgEmpRpcDTO.getId());
//            importVo.setAgentEmpName(orgEmpRpcDTO.getEmpName());
//            // 4.判断该签约公司是否存在
//            OrgOuRpcDTO orgOuRpcDTO = ouDtoList.stream().filter(ou -> ou.getOuCode().equals(importVo.getOuCode()))
//                    .findFirst().orElseThrow(
//                            new BusinessException("客户名称为:" + importVo.getCustName() + "的数据签约公司不存在于本系统中请检查")
//                    );
//            importVo.setOuId(orgOuRpcDTO.getId());
//            importVo.setOuName(orgOuRpcDTO.getOuName());
//            // 5.判断该签约部门是否存在
//            OrgBuRpcDTO orgBuRpcDTO = buDtoList.stream().filter(bu -> bu.getBuCode().equals(importVo.getBuCode()))
//                    .findFirst().orElseThrow(
//                            new BusinessException("客户名称为:" + importVo.getCustName() + "的数据签约部门不存在于本系统中请检查")
//                    );
//            importVo.setBuId(orgBuRpcDTO.getId());
//            importVo.setBuName(orgBuRpcDTO.getBuName());
//
//            // udc反查补充
//            if (!ObjectUtils.isEmpty(importVo.getCustTypeName())){
//                String udcVal = this.udcDataHandle(custTypeUdcList, importVo.getCustName(), importVo.getCustTypeName(), "客户分类");
//                importVo.setCustType(udcVal);
//            }
//            if (!ObjectUtils.isEmpty(importVo.getIntentLevelName())){
//                String udcVal = this.udcDataHandle(scustIntentLevelList, importVo.getCustName(),  importVo.getIntentLevelName(), "意向等级");
//                importVo.setIntentLevel(udcVal);
//            }
//            if (!ObjectUtils.isEmpty(importVo.getCustIndustryName())){
//                String udcVal = this.udcDataHandle(industryUdcList,  importVo.getCustName(), importVo.getCustIndustryName(), "客户行业");
//                importVo.setCustIndustry(udcVal);
//            }
//            if (!ObjectUtils.isEmpty(importVo.getCustSourceName())){
//                String udcVal = this.udcDataHandle(custSourceUdcList, importVo.getCustName(),  importVo.getCustSourceName(), "客户来源");
//                importVo.setCustSource(udcVal);
//            }
//            if (!ObjectUtils.isEmpty(importVo.getRegionName())){
//                String udcVal = this.udcDataHandle(ouRegionUdcList,  importVo.getCustName(), importVo.getRegionName(), "区域");
//                importVo.setRegion(udcVal);
//            }
//        });
//        // 数据重复性校验
//        Map<String, List<CrmScustImportSaveVO>> taxRegNoMaps = parseData.stream().collect(Collectors.groupingBy(CrmScustImportSaveVO::getTaxRegNo));
//        Map<String, List<CrmScustImportSaveVO>> custNameMaps = parseData.stream().collect(Collectors.groupingBy(CrmScustImportSaveVO::getCustName));
//        StringBuilder taxRegNoMsg = new StringBuilder();
//        StringBuilder custNameMsg = new StringBuilder();
//        for (String taxReg:taxRegNoMaps.keySet()) {
//            List<CrmScustImportSaveVO> crmScustImportSaveVOS = taxRegNoMaps.get(taxReg);
//            if (crmScustImportSaveVOS.size() > 1){
//                taxRegNoMsg.append("【"+taxReg+"】,");
//            }
//        }
//        for (String custName:custNameMaps.keySet()) {
//            List<CrmScustImportSaveVO> crmScustImportSaveVOS = custNameMaps.get(custName);
//            if (crmScustImportSaveVOS.size() > 1){
//                custNameMsg.append("【"+custName+"】,");
//            }
//        }
//        if (taxRegNoMsg.length() > 0){
//            throw new BusinessException("导入的EXCEL中多条数据,税务登记号为:"+taxRegNoMsg+"数据重复");
//        }
//        if (custNameMsg.length() > 0){
//            throw new BusinessException("导入的EXCEL中多条数据,客户名称为:"+custNameMsg+"数据重复");
//        }
    }

    private String udcDataHandle(List<SysUdcComboVO> sysUdcComboVOS, String custName, String udcField, String msg){
        return sysUdcComboVOS.stream().filter( install -> install.getValDesc().equals(udcField))
                .findFirst().orElseThrow(
                        new BusinessException("导入数据,客户名称为:"+custName+"的数据"+msg+"填写错误请检查")
                ).getUdcVal();
    }

    private void translateDetail(CrmScustDetailRespVO respVO) {

        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empDtoByParam;
        if (!org.springframework.util.StringUtils.isEmpty(respVO.getAgentEmpId())) {
            List<Long> agentEmpId = new ArrayList<>();
            agentEmpId.add(respVO.getAgentEmpId());
            orgEmpRpcDtoParam.setEmpIds(agentEmpId);

            try {
                empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
            } catch (Exception e) {
                log.error("dubbo访问emp查询接口失败：" + e.getMessage());
                throw new BusinessException("dubbo服务调用支持域查询员工接口出错");
            }
            empDtoByParam.stream().filter(emp -> emp.getId().equals(respVO.getAgentEmpId()))
                    .findFirst().ifPresent(empD -> respVO.setAhentEmpIdName(empD.getEmpName()));
        }
        // 主要是用来数据补充
        if (!org.springframework.util.StringUtils.isEmpty(respVO.getAddrNo())) {
            ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo;
            try {
                rpcDtoByAddrNo = rmiOrgAddrService.findAddrByAddrNo(respVO.getAddrNo());
                Assert.isFalse(!rpcDtoByAddrNo.isSuccess(), rpcDtoByAddrNo.getMsg());
            } catch (Exception e) {
                log.error("dubbo访问地址簿查询接口失败：" + e.getMessage());
                throw new BusinessException("dubbo服务调用支撑域地址接口出错");
            }
            OrgAddrDetailsRpcDTO orgAddr = rpcDtoByAddrNo.getData();
            if (!ObjectUtils.isEmpty(orgAddr) && !CollectionUtils.isEmpty(orgAddr.getOrgAddrAddressVos())) {
                //地址信息补充
                orgAddr.getOrgAddrAddressVos().stream().findFirst()
                        .ifPresent(addr -> {
                            respVO.setContPerson(addr.getContPerson());
                            respVO.setEmail(addr.getEmail());
                            respVO.setMobile(addr.getMobile());
                            respVO.setDetailAddr(addr.getDetailAddr());
                        });
            }
        }
    }

    private void checkForSave(CrmScustSaveVO saveVO) {
        Assert.notNull(saveVO, "保存信息为空");
        Assert.isFalse(org.springframework.util.StringUtils.isEmpty(saveVO.getCustName()), "保存数据客户名称为空");
        Assert.isFalse(org.springframework.util.StringUtils.isEmpty(saveVO.getBuId()), "保存数据销售组织为空");
        Assert.isFalse(org.springframework.util.StringUtils.isEmpty(saveVO.getOuId()), "保存数据公司为空");
        Assert.isFalse(org.springframework.util.StringUtils.isEmpty(saveVO.getRegion()), "保存数据区域为空");
//        Assert.isFalse(org.springframework.util.StringUtils.isEmpty(saveVO.getAgentEmpId()), "保存数据客户管理专员为空");

        //验证客户名称是否重复
        if (!org.springframework.util.StringUtils.isEmpty(saveVO.getCustName())) {
            Boolean exists = crmScustRepoProc.exists(saveVO.getCustName(), saveVO.getId());
            Assert.isFalse(exists, "客户名称已存在于潜在客户表,请在潜在客户查询页面查询此客户");
            Boolean exists2 = crmCustRepoProc.exists(saveVO.getCustName(), null);
            Assert.isFalse(exists2, "客户名称已存在于正式客户表中,请在正式客户查询界面查询此客户");
        }
        //验证税务登记号是否在正式/潜在客户表中存在
        if (!org.springframework.util.StringUtils.isEmpty(saveVO.getTaxRegNo())) {
            Boolean exists = crmCustRepoProc.existsTaxRegNo(saveVO.getTaxRegNo(), null,null);
            Assert.isFalse(exists, "该税务号所属客户已存在正式客户表中,请在正式客户查询页面查询该客户");
            Boolean exists2 = crmScustRepoProc.existsTaxRegNo(saveVO.getTaxRegNo(), saveVO.getId());
            Assert.isFalse(exists2, "该税务号所属客户已存在潜在客户表中,请在潜在客户查询页面查询该客户");
        }
        //验证客户编码是否重复
        if (!org.springframework.util.StringUtils.isEmpty(saveVO.getCustCode())) {
            Boolean aBoolean = crmScustRepoProc.existsCode(saveVO.getCustCode(), saveVO.getId());
            Assert.isFalse(aBoolean, "客户编码已存在潜在客户表中,请在潜在客户查询查询该客户");
        }
    }

    private CrmScustDO saveVoDo(CrmScustSaveVO saveVO) {
        CrmScustDO crmScustDO = saveVO.getId() == null ? new CrmScustDO() : crmScustRepo.findById(saveVO.getId()).orElseThrow();
        CrmScustConvert.INSTANCE.copyVoToDo(saveVO, crmScustDO);
        return crmScustDO;
    }
}
