package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAddrFindParam;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.*;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsDealerDtlSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsStoreDtlSaveVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.convert.SaleSatisticsConvert;
import com.elitesland.yst.production.sale.convert.StatisticsDealerDtlConvert;
import com.elitesland.yst.production.sale.convert.StatisticsStoreDtlConvert;
import com.elitesland.yst.production.sale.dto.CrmCustRespDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDtlDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDtlDO;
import com.elitesland.yst.production.sale.repo.*;
import com.elitesland.yst.production.sale.rmi.ystaftersale.RmiAfterSaleRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiEmployeeRpcService;
import lombok.AllArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

/**
 * @author wz
 * @title SalesmanInfoServiceImpl
 * @Date2023/2/21 16:08
 */
@Log4j2
@Service
@AllArgsConstructor
public class SaleStatisticsServiceImpl implements SaleStatisticsService {


    private final SaleStatisticsStoreRepo saleStatisticsRepo;
    private final SaleStatisticsStoreDtlRepo saleStatisticsStoreDtlRepo;
    private final SaleStatisticsStoreDtlRepoProc saleStatisticsStoreDtlRepoProc;
    private final RmiAfterSaleRpcService rmiAfterSaleRpcService;

    private final SysUdcProxyService sysUdcProxyService;

    private final SaleStatisticsStoreRepoProc saleStatisticsRepoProc;
    private final SaleStatisticsStoreRepoSqlProc saleStatisticsStoreRepoSqlProc;

    private final RmiEmployeeRpcService rmiEmployeeRpcService;
    private final  CrmCustService custService;
    private final SalesmanInfoService salesmanInfoService;

    @Override
    public PagingVO<SaleStatisticsStoreRespVO> pcPage(SaleStatisticsStoreQueryVO paramVO) {
        assembleDocTime(paramVO);
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.checkLevel(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return PagingVO.<SaleStatisticsStoreRespVO>builder().total(0).records(new ArrayList<>()).build();
            }

            List<Long> ids = CollectionUtils.isEmpty(paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List<Long> idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }

        PagingVO<SaleStatisticsStoreRespVO> page = saleStatisticsRepoProc.pcPage(paramVO);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        sysUdcProxyService.translate(page.getRecords());
        this.translateDealer(page.getRecords());

        return page;
    }

    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsStoreRespVO> appPage(SaleStatisticsStoreQueryVO paramVO) {
        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(paramVO);
        if (StringUtils.isBlank(paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "业务员编码为空!");
        }
        //检查业务员编码是否是当前登录人自己以及所属下级
        if(!checkOneselfAndSub(paramVO.getAgentEmp())){
            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())){
                paramVO.setSeeSelf(true);
            }
            if(paramVO.getSeeSelf()){
                //此业务员的个人业绩列表，根据level='0'，匹配code
                queryVO.setLevel(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_0);
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return PagingVO.<SaleStatisticsStoreRespVO>builder().total(0).records(new ArrayList<>()).build();
            }
            List<Long> ids = CollectionUtils.isEmpty(paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List<Long> idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }

        PagingVO<SaleStatisticsStoreRespVO> page = saleStatisticsRepoProc.appPage(paramVO);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        sysUdcProxyService.translate(page.getRecords());
        this.translateDealer(page.getRecords());
        return page;
    }

//    @Override
//    public PagingVO<SaleStatisticsStoreRespVO> export(SaleStatisticsStoreQueryVO queryVO) {
//        PagingVO<SaleStatisticsStoreRespVO> page = this.pcPage(queryVO);
//        return page;
//    }

    @Override
    public List<SaleStatisticsStoreRespVO> detail(SaleStatisticsStoreQueryVO paramVO) {
        //查询详情入参校验
        this.checkDetail(paramVO);

        if (StringUtils.isNotEmpty(paramVO.getAgentEmp()) ) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())){
                paramVO.setSeeSelf(true);
            }
            if(paramVO.getSeeSelf()){
                //此业务员的个人业绩列表，根据level='0'，匹配code
                queryVO.setLevel(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_0);
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return null;
            }
            paramVO.setIds(longs);
        }else{
            paramVO.setSalesmanPath(null);
        }

        List<SaleStatisticsStoreRespVO> query = saleStatisticsRepoProc.query(paramVO);
        this.translateDealer(query);
        sysUdcProxyService.translate(query);
        return query;
    }

    @Override
    public StatisticsStoreSumRespVO querySum(SaleStatisticsStoreQueryVO paramVO) {
        assembleDocTime(paramVO);
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.checkLevel(queryVO);
            if (CollectionUtils.isEmpty(longs)) {return null;}

            List<Long> ids = CollectionUtils.isEmpty(paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List<Long> idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);

        }

        StatisticsStoreSumRespVO statisticsStoreSumRespVO = saleStatisticsStoreRepoSqlProc.pageSum(paramVO);
        return statisticsStoreSumRespVO;
    }

    @Override
    public List<String> storeQuery(SaleStatisticsStoreQueryVO paramVO) {
        assembleDocTime(paramVO);
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.checkLevel(queryVO);
            //
            if (CollectionUtils.isEmpty(longs)) {
                return new ArrayList<>();
            }
            List<Long> ids = CollectionUtils.isEmpty(paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List<Long> idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }

        return saleStatisticsRepoProc.storeQuery(paramVO).stream().distinct().map(SaleStatisticsStoreRespVO::getStoreCode).collect(Collectors.toList());

    }

    @Override
    public StatisticsStoreSumRespVO appQerySum(SaleStatisticsStoreQueryVO paramVO) {
        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(paramVO);
        if (StringUtils.isBlank(paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "业务员编码为空!");
        }
        //检查业务员编码是否是当前登录人自己以及所属下级
        if(!checkOneselfAndSub(paramVO.getAgentEmp())){
            return null;
        }
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())){
                paramVO.setSeeSelf(true);
            }
            if(paramVO.getSeeSelf()){
                //此业务员的个人业绩列表，根据level='0'，匹配code
                queryVO.setLevel(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_0);
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {return null;}
            List<Long> ids = CollectionUtils.isEmpty(paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List<Long> idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }

        StatisticsStoreSumRespVO statisticsStoreSumRespVO = saleStatisticsStoreRepoSqlProc.pageSum(paramVO);
        return statisticsStoreSumRespVO;
    }

    /**
     * 业务员团队业绩：根据业务员编码匹配Salesman_path，只要包含这个业务员的编码都算作团队业绩。
     * <p>
     * 业务员个人业绩：根据业务员编码匹配Salesman_path，第一层级的业务员（level=‘0’）的编码等于业务员的编码，算作业务员个人业绩。
     *
     * @param paramVO
     * @return
     */
    @Override
    public List<SaleStatisticsTeamRespVO> queryByCodes(SaleStatisticsStoreQueryVO paramVO) {
        List<String> empCodes = paramVO.getAgentEmpList();
        String docMonth = paramVO.getDocMonth();
        if (CollectionUtils.isEmpty(empCodes)) {
            return Collections.EMPTY_LIST;
        }
        if(paramVO.getDocTimeStart() != null){
            paramVO.setDocTimeStart(LocalDateTime.of(paramVO.getDocTimeStart().toLocalDate(),LocalTime.MIN));
        }
        if(paramVO.getDocTimeEnd() != null){
            paramVO.setDocTimeEnd(LocalDateTime.of(paramVO.getDocTimeEnd().toLocalDate(),ConstantsSale.LOCAL_TIME_MAX));
        }
        //默认为当月
        if(paramVO.getDocTimeStart() == null&& paramVO.getDocTimeEnd() == null&&StringUtils.isBlank(docMonth)){
//            docMonth = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM"));
            paramVO.setDocTimeStart(LocalDateTime.of(LocalDate.now(),LocalTime.MIN));
            paramVO.setDocTimeEnd(LocalDateTime.of(LocalDate.now(),ConstantsSale.LOCAL_TIME_MAX));
        }

        //个人业绩统计
        SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
        queryVO.setCodes(empCodes);
        queryVO.setDocMonth(docMonth);
        queryVO.setDocTimeStart(paramVO.getDocTimeStart());
        queryVO.setDocTimeEnd(paramVO.getDocTimeEnd());
        queryVO.setLevel(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_0);
        List<SaleStatisticsTeamRespVO> listByCodes = this.getListByCodes(queryVO);

        //团队业绩统计
        SaleStatisticsStoreDtlQueryVO teamVO = new SaleStatisticsStoreDtlQueryVO();
        teamVO.setCodes(empCodes);
        teamVO.setDocMonth(docMonth);
        teamVO.setDocTimeStart(paramVO.getDocTimeStart());
        teamVO.setDocTimeEnd(paramVO.getDocTimeEnd());
        List<SaleStatisticsTeamRespVO> teamRespVOS = this.getListByCodes(teamVO);


        List<SaleStatisticsTeamRespVO> respVOList = new ArrayList<>();
        for (String code : empCodes) {
            SaleStatisticsTeamRespVO appSumRespVO = new SaleStatisticsTeamRespVO();
            appSumRespVO.setAgentEmp(code);
            appSumRespVO.setTeamPerformance(BigDecimal.ZERO);
            appSumRespVO.setPersonalPerformance(BigDecimal.ZERO);

            Optional<SaleStatisticsTeamRespVO> myOptional = listByCodes.stream().filter(respVO -> Objects.equals(respVO.getAgentEmp(), code)).findFirst();
            if (myOptional.isPresent()) {
                appSumRespVO.setPersonalPerformance(myOptional.get().getShipTotalQty());
            }
            Optional<SaleStatisticsTeamRespVO> teamOptional = teamRespVOS.stream().filter(respVO -> Objects.equals(respVO.getAgentEmp(), code)).findFirst();
            if (teamOptional.isPresent()) {
                appSumRespVO.setTeamPerformance(teamOptional.get().getShipTotalQty());
            }
            respVOList.add(appSumRespVO);
        }

        return respVOList;
    }

    @Override
    public   PagingVO<SaleStatisticsStoreRespVO> leaderPage(SaleStatisticsStoreQueryVO paramVO) {
        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(paramVO);
        if (StringUtils.isBlank(paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "业务员编码为空!");
        }
//        //检查业务员编码是否是当前登录人自己以及所属下级
//        if(!checkOneselfAndSub(paramVO.getAgentEmp())){
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }

        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())){
                paramVO.setSeeSelf(true);
            }
            if(paramVO.getSeeSelf()){
                //此业务员的个人业绩列表，根据level='0'，匹配code
                queryVO.setLevel(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_0);
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return PagingVO.<SaleStatisticsStoreRespVO>builder().total(0).records(new ArrayList<>()).build();
            }
            List<Long> ids = CollectionUtils.isEmpty(paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List<Long> idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }

        PagingVO<SaleStatisticsStoreRespVO> page = saleStatisticsRepoProc.appPage(paramVO);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        sysUdcProxyService.translate(page.getRecords());
        this.translateDealer(page.getRecords());
        return page;
    }

    @Override
    public StatisticsStoreSumRespVO leaderPageSum(SaleStatisticsStoreQueryVO paramVO) {
        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(paramVO);
        if (StringUtils.isBlank(paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "业务员编码为空!");
        }
//        //检查业务员编码是否是当前登录人自己以及所属下级
//        if(!checkOneselfAndSub(paramVO.getAgentEmp())){
//            return BigDecimal.ZERO;
//        }
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())){
                paramVO.setSeeSelf(true);
            }
            if(paramVO.getSeeSelf()){
                //此业务员的个人业绩列表，根据level='0'，匹配code
                queryVO.setLevel(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_0);
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {return null;}
            List<Long> ids = CollectionUtils.isEmpty(paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List<Long> idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }

        StatisticsStoreSumRespVO statisticsStoreSumRespVO = saleStatisticsStoreRepoSqlProc.pageSum(paramVO);
        return statisticsStoreSumRespVO;
    }

    /**
     * 勾选的数据区域字段是否为空，有值则报错：请勾选没有区域的数据进行更新
     * 根据客户编码，获取客户表里对应的区域存表，如果获取有问题，则把保存信息保存至更新区域失败原因中，展示在前端
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Object updateRegion(List<Long> ids) {
        Assert.notEmpty(ids, "入参数据为空！");
        List<SaleStatisticsStoreDO> dtlDOList = new ArrayList<>();

        List<SaleStatisticsStoreRespVO> list = this.queryLisl(ids);
        Assert.notEmpty(list, "未查询到有效数据！");
        log.info("updateRegion查询数据："+list);
//        现在去掉非空校验
//        list.stream().forEach(t -> {
//            if(StringUtils.isNotEmpty(t.getRegion())){
//                throw new BusinessException("此门店:"+t.getStoreCode()+"/"+t.getStoreName()+"勾选的数据区域字段不为空:");
//            }
//        });
        List<String> collect = list.stream().map(SaleStatisticsStoreRespVO::getDealerCode).filter(Objects::nonNull).collect(Collectors.toList());
        Assert.notEmpty(collect, "客户编码为空！");

        CustAddrFindParam custAddrFindParam = new CustAddrFindParam();
        custAddrFindParam.setCustCodes(collect);
        List<LmSaveCustRespVO> custInfoByParam = custService.getCustInfoByParam(custAddrFindParam);
        log.info("updateRegion查询客户数据："+custInfoByParam);


        //数据组装
        list.stream().forEach(t -> {
            SaleStatisticsStoreQueryVO saleStatisticsStoreQueryVO = new SaleStatisticsStoreQueryVO();
            saleStatisticsStoreQueryVO.setStoreCode(t.getStoreCode());
            saleStatisticsStoreQueryVO.setDealerCode(t.getDealerCode());
            saleStatisticsStoreQueryVO.setSalesmanPath(t.getSalesmanPath());
            saleStatisticsStoreQueryVO.setDocTime(t.getDocTime());
//            saleStatisticsStoreQueryVO.setDocMonth(t.getDocTime().format(DateTimeFormatter.ofPattern("yyyy-MM")));
            Iterable<SaleStatisticsStoreDO> storeDOIterable = saleStatisticsRepo.findAll(saleStatisticsRepoProc.querySumDetailWhere(saleStatisticsStoreQueryVO));

            List<SaleStatisticsStoreDO> saleStatisticsStoreDOSList = StreamSupport.stream(storeDOIterable.spliterator(), false).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(saleStatisticsStoreDOSList)) {
                this.assembleStatisticsStoreRegion(saleStatisticsStoreDOSList, custInfoByParam);
                dtlDOList.addAll(saleStatisticsStoreDOSList);
            }
        });

        //数据保存
        log.info("updateRegion保存数据："+dtlDOList);
        if(!CollectionUtils.isEmpty(dtlDOList)){
            saleStatisticsRepo.saveAll(dtlDOList);
        }
        return null;
    }

    /**
     * 勾选的数据业务员关系路径字段是否为空，有值则报错：请勾选没有业务员的数据进行更新
     * 根据客户编码，获取客户表里对应的业务员ID，然后根据业务员ID调用王天昊的接口，获取业务员关系路径存表
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Object updateSalesman(List<Long> ids) {
        Assert.notEmpty(ids, "入参数据为空！");
        List<SaleStatisticsStoreDO> storeDOList = new ArrayList<>();
        Map<String, Long> custCodeAndAgentEmpMap = new HashMap<>();

        List<SaleStatisticsStoreRespVO> list = this.queryLisl(ids);
        Assert.notEmpty(list, "未查询到有效数据！");

        log.info("查询数据："+list);
//        现在去掉非空校验
//        list.stream().forEach(t -> {
//            if(StringUtils.isNotEmpty(t.getSalesmanPath())){
//                throw new BusinessException("勾选的数据业务员字段不为空:"+t.getStoreCode()+"/"+t.getStoreName());
//            }
//        });
        List<String> collect = list.stream().map(SaleStatisticsStoreRespVO::getDealerCode).filter(Objects::nonNull).collect(Collectors.toList());
        Assert.notEmpty(collect, "客户编码为空！");

        CustAddrFindParam custAddrFindParam = new CustAddrFindParam();
        custAddrFindParam.setCustCodes(collect);
        List<LmSaveCustRespVO> custInfoByParam = custService.getCustInfoByParam(custAddrFindParam);
        Assert.notEmpty(custInfoByParam, "客户信息为空！");

        log.info("客户数据："+custInfoByParam);
        custInfoByParam.stream().forEach(t -> {
            custCodeAndAgentEmpMap.put(t.getCustCode(),t.getAgentEmpId());
        });

        //业务员关系路径查询
        List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOS = selectSalesmanLevelByIds(custInfoByParam);
        log.info("业务员数据："+salesmanLevelInfoDTOS);

        //数据组装
        list.stream().forEach(t -> {
            SaleStatisticsStoreQueryVO saleStatisticsStoreQueryVO = new SaleStatisticsStoreQueryVO();
            saleStatisticsStoreQueryVO.setRegion(t.getRegion());
            saleStatisticsStoreQueryVO.setStoreCode(t.getStoreCode());
            saleStatisticsStoreQueryVO.setDealerCode(t.getDealerCode());
            saleStatisticsStoreQueryVO.setDocTime(t.getDocTime());
//            saleStatisticsStoreQueryVO.setDocMonth(t.getDocTime().format(DateTimeFormatter.ofPattern("yyyy-MM")));
            Iterable<SaleStatisticsStoreDO> storeDOIterable = saleStatisticsRepo.findAll(saleStatisticsRepoProc.querySumDetailWhere(saleStatisticsStoreQueryVO));


            List<SaleStatisticsStoreDO> saleStatisticsStoreDOSList = StreamSupport.stream(storeDOIterable.spliterator(), false).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(saleStatisticsStoreDOSList)) {
                this.assembleStatisticsStoreSalesman(saleStatisticsStoreDOSList, custInfoByParam,custCodeAndAgentEmpMap,salesmanLevelInfoDTOS);
                storeDOList.addAll(saleStatisticsStoreDOSList);
            }
        });

        //数据保存
        log.info("updateSalesman保存数据："+storeDOList);
        if(!CollectionUtils.isEmpty(storeDOList)){
            List<Long> collect1 = saleStatisticsRepo.saveAll(storeDOList).stream().map(SaleStatisticsStoreDO::getId).collect(Collectors.toList());
            this.saveSaleStatisticsStoreDtl(storeDOList);
            return collect1;
        }

        return null;
    }

    public void saveSaleStatisticsStoreDtl(List<SaleStatisticsStoreDO> storeDOList){
        List<SaleStatisticsStoreDtlSaveVO> dealerDtlSaveVOList = new ArrayList<>();
        List<Long> collect = storeDOList.stream().map(SaleStatisticsStoreDO::getId).distinct().collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(collect)){
            saleStatisticsStoreDtlRepo.deleteByMasIdIn(storeDOList.stream().map(SaleStatisticsStoreDO::getId).distinct().collect(Collectors.toList()));
        }

        storeDOList.forEach(saveVO -> {
            if (Objects.nonNull(saveVO.getSalesmanPath())) {
                List<SaleStatisticsStoreDtlSaveVO> dtlSaveVOList = JSONObject.parseArray(saveVO.getSalesmanPath(), SaleStatisticsStoreDtlSaveVO.class);
                if (!CollectionUtils.isEmpty(dtlSaveVOList)) {
                    dtlSaveVOList.forEach(dtlSaveVO -> {
                        dtlSaveVO.setMasId(saveVO.getId());
                    });
                    dealerDtlSaveVOList.addAll(dtlSaveVOList);
                }
            }
        });

        //保存业务员对应的用户ID,用于数据权限
        if (!CollectionUtils.isEmpty(dealerDtlSaveVOList)) {
            Set<String> employeeCodes = dealerDtlSaveVOList.stream().map(SaleStatisticsStoreDtlSaveVO::getCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List<SysEmployeeBasicDTO> basicDTOList = rmiEmployeeRpcService.findEmployeeByCodes(employeeCodes);
            dealerDtlSaveVOList.forEach(saveVO -> {
                Optional<SysEmployeeBasicDTO> optional = basicDTOList.stream().filter(employeeBasicDTO -> Objects.equals(saveVO.getCode(), employeeBasicDTO.getCode())).findFirst();
                optional.ifPresent(employeeBasicDTO -> saveVO.setUserId(employeeBasicDTO.getUserId()));
            });

            List<SaleStatisticsStoreDtlDO> dtlDOList = dealerDtlSaveVOList.stream().map(StatisticsStoreDtlConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
            saleStatisticsStoreDtlRepo.saveAll(dtlDOList);
        }
    }
    /**
     * 查询入参数据
     * @param ids
     * @return
     */
    public List<SaleStatisticsStoreRespVO>  queryLisl(List<Long> ids){
        SaleStatisticsStoreQueryVO saleStatisticsStoreQueryVO = new SaleStatisticsStoreQueryVO();
        saleStatisticsStoreQueryVO.setIds(ids);
        List<SaleStatisticsStoreRespVO> list = saleStatisticsRepoProc.getList(saleStatisticsStoreQueryVO);
        return list;
    }

    public void assembleStatisticsStoreRegion(List<SaleStatisticsStoreDO> saleStatisticsStoreDOSList,List<LmSaveCustRespVO> custInfoByParam){
        saleStatisticsStoreDOSList.stream().forEach(t -> {
            t.setUpdateRegionFailureReason(null);
            if (CollectionUtils.isEmpty(custInfoByParam)) {
                t.setUpdateRegionFailureReason("没有查询到客户信息");
            }else{
                Optional<LmSaveCustRespVO> first = custInfoByParam.stream().filter(cust -> t.getDealerCode().equals(cust.getCustCode())).findFirst();
                if(first.isPresent()){
                    if (StringUtils.isBlank(first.get().getRegion())) {
                        t.setUpdateRegionFailureReason("此客户的区域信息为空");
                    } else {
                        t.setRegion(first.get().getRegion());
                    }
                }else {
                    t.setUpdateRegionFailureReason("此客户没有区域信息");
                }
            }
        });

    }

    public void assembleStatisticsStoreSalesman(List<SaleStatisticsStoreDO> saleStatisticsStoreDOSList,List<LmSaveCustRespVO> custInfoByParam,Map<String, Long> custCodeAndAgentEmpMap,List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOS){
        saleStatisticsStoreDOSList.stream().forEach(saleStatisticsStoreDO -> {
            saleStatisticsStoreDO.setUpdateSalesmanFailureReason(null);
            if (CollectionUtils.isEmpty(custInfoByParam)) {
                saleStatisticsStoreDO.setUpdateSalesmanFailureReason("未查询到客户数据");
            } else {
                Optional<LmSaveCustRespVO> custOptional = custInfoByParam.stream().filter(custRespVO -> Objects.equals(saleStatisticsStoreDO.getDealerCode(), custRespVO.getCustCode())).findFirst();
                if (custOptional.isPresent()) {
                    if (CollectionUtils.isEmpty(custCodeAndAgentEmpMap) || Objects.isNull(custCodeAndAgentEmpMap.get(custOptional.get().getCustCode()))){
                        saleStatisticsStoreDO.setUpdateSalesmanFailureReason("此客户的业务员ID信息为空");
                    }else {
                        if (CollectionUtils.isEmpty(salesmanLevelInfoDTOS)){
                            saleStatisticsStoreDO.setUpdateSalesmanFailureReason("未查询到业务员数据");
                        }else {
                            Long agentEmpId =  custCodeAndAgentEmpMap.get(custOptional.get().getCustCode());
                            Optional<SalesmanLevelInfoDTO> salesmanOptional = salesmanLevelInfoDTOS.stream().filter(salesmanLevelInfo -> Objects.equals(agentEmpId,salesmanLevelInfo.getId())).findFirst();
                            if (salesmanOptional.isPresent()){
                                if (CollectionUtils.isEmpty(salesmanOptional.get().getSalesman_path())){
                                    saleStatisticsStoreDO.setUpdateSalesmanFailureReason("此客户的业务员的业务员路径信息为空");
                                }else {
                                    saleStatisticsStoreDO.setSalesmanPath(JSON.toJSONString(salesmanOptional.get().getSalesman_path()));
                                }

                            }else {
                                saleStatisticsStoreDO.setUpdateSalesmanFailureReason("未查询到此客户的业务员主信息");
                            }
                        }
                    }
                } else {
                    saleStatisticsStoreDO.setUpdateSalesmanFailureReason("客户接口无此业务员信息");
                }
            }
            });
    }

    private List<SalesmanLevelInfoDTO> selectSalesmanLevelByIds(List<LmSaveCustRespVO> custRespVOList) {
        if (CollectionUtils.isEmpty(custRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> agentEmpIds = custRespVOList.stream().map(LmSaveCustRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(agentEmpIds)) {
            return Collections.EMPTY_LIST;
        }

        //查询业务员关系路径
        List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOList = agentEmpIds.stream().map(t -> salesmanInfoService.queryLevelInfo(t)).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(salesmanLevelInfoDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return salesmanLevelInfoDTOList;
    }

    public List<SaleStatisticsTeamRespVO> getListByCodes (SaleStatisticsStoreDtlQueryVO queryVO) {
        List<SaleStatisticsTeamRespVO> listByCodes = saleStatisticsStoreDtlRepoProc.getListByCodes(queryVO);
        if (CollectionUtils.isEmpty(listByCodes)) {
            return Collections.EMPTY_LIST;
        }

        return listByCodes;
    }

    /**
     * 根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
     *
     * @param pageParam 查询入参
     */
    public void assembleDocTime(SaleStatisticsStoreQueryVO pageParam) {
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计日期为空!");
        }
        if (Objects.nonNull(pageParam.getDocTimeStart())) {
            // 获取第一天的最小时间
            LocalDate localDateStart = pageParam.getDocTimeStart().toLocalDate();
            LocalDateTime minTime = LocalDateTime.of(localDateStart, LocalTime.MIN);
            pageParam.setDocTimeStart(minTime);
        }
        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
            // 获取最后一天的最大时间
            LocalDate localDateEnd = pageParam.getDocTimeEnd().toLocalDate();
            LocalDateTime maxTime = LocalDateTime.of(localDateEnd, ConstantsSale.LOCAL_TIME_MAX);
            pageParam.setDocTimeEnd(maxTime);
        }
    }


    public void checkDetail(SaleStatisticsStoreQueryVO paramVO) {
//        if (Objects.isNull(paramVO.getDocMonth())) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计月份为空!");
//        }

        if (Objects.isNull(paramVO.getDocTimeStart())||Objects.isNull(paramVO.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计时间为空!");
        }
        if (StringUtils.isEmpty(paramVO.getStoreCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,"门店编码不能为空");
        }
        if (StringUtils.isEmpty(paramVO.getDealerCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,"客户编码不能为空");
        }
//        if (StringUtils.isEmpty(paramVO.getRegion())) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,"区域不能为空");
//        }
        if (StringUtils.isEmpty(paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,"业务员不能为空");
        }

    }

    public List<Long> checkLevel(SaleStatisticsStoreDtlQueryVO queryVO) {
        //此业务员的个人业绩列表，根据level='0'，匹配code

        List<SaleStatisticsStoreDtlRespVO> levelList = saleStatisticsStoreDtlRepoProc.getQueryDtl(queryVO);
        if (CollectionUtils.isEmpty(levelList)) {
            return null;
        }
        return levelList.stream().distinct().map(SaleStatisticsStoreDtlRespVO::getMasId).collect(Collectors.toList());
    }

    public List<Long> queryDtl(SaleStatisticsStoreDtlQueryVO queryVO) {
        //此业务员的个人业绩列表，根据level='0'，匹配code

        List<SaleStatisticsStoreDtlRespVO> levelList = saleStatisticsStoreDtlRepoProc.getLevelList(queryVO);
        if (CollectionUtils.isEmpty(levelList)) {
            return null;
        }
        return levelList.stream().distinct().map(SaleStatisticsStoreDtlRespVO::getMasId).collect(Collectors.toList());
    }



    /**
     * 组装填充门店销售业绩的相关信息
     *
     * @param respVOList 主表数据信息
     * @return
     */
    private void translateDealer(List<SaleStatisticsStoreRespVO> respVOList) {
        //根据主表ID查询附表信息
        List<Long> collect = respVOList.stream().map(SaleStatisticsStoreRespVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SaleStatisticsStoreDtlRespVO> dtlRespVOList = saleStatisticsStoreDtlRepoProc.getMasIds(collect);
        respVOList.forEach(respVO -> {
            //查询附件信息
            List<SaleStatisticsStoreDtlRespVO> dtlRespVOS = dtlRespVOList.stream().filter(dtlRespVO -> Objects.equals(dtlRespVO.getMasId(), respVO.getId())).collect(Collectors.toList());
            respVO.setDtlRespVOS(dtlRespVOS);
            String docMonth = respVO.getDocTime().format(DateTimeFormatter.ofPattern("yyyy-MM"));
            respVO.setDocMonth(docMonth);
            sysUdcProxyService.translate(dtlRespVOS);

            dtlRespVOS.stream().forEach(dtlRespVO -> {
                StringJoiner spliceName = new StringJoiner(" ").add(dtlRespVO.getTypeName()).add(dtlRespVO.getName());
                if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_0, dtlRespVO.getLevel())) {
                    respVO.setAgentEmp(dtlRespVO.getCode());
                    respVO.setAgentEmpName(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_1, dtlRespVO.getLevel())) {
                    respVO.setLevelOne(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_2, dtlRespVO.getLevel())) {
                    respVO.setLevelTwo(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_3, dtlRespVO.getLevel())) {
                    respVO.setLevelThree(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_4, dtlRespVO.getLevel())) {
                    respVO.setLevelFour(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_5, dtlRespVO.getLevel())) {
                    respVO.setLevelFive(spliceName.toString());
                }
            });

        });
    }
    /**
     * 检查业务员编码是否是当前登录人自己以及所属下级
     *
     * @param agentEmp 所属业务员编码
     * @return true 是 false 否
     */
    private boolean checkOneselfAndSub(String agentEmp){
        //获取当前用户信息
        SysUserDTO sysUserDTO = this.getSysUser();
        //根据当前用户查询所属员工信息
        SysEmployeeBasicDTO employeeBasicDTO = this.getEmployeeByUser(sysUserDTO);
        //获取下属员工
        List<String> subEmployeeCodeList = this.queryAllSubEmployeeByCode(employeeBasicDTO.getCode());
        if (CollectionUtils.isEmpty(subEmployeeCodeList)) {
            return false;
        }

        return subEmployeeCodeList.contains(agentEmp);
    }

    /**
     * 获取当前用户
     *
     * @param
     * @return 当前用户信息
     */
    private SysUserDTO getSysUser() {
        //获取当前用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "获取当前用户信息失败");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if (ObjectUtils.isEmpty(sysUser)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "用户信息获取失败");
        }

        return sysUser;
    }

    /**
     * 根据当前用户查询所属员工信息
     *
     * @param sysUserDTO 当前用户信息
     * @return 所属员工信息
     */
    private SysEmployeeBasicDTO getEmployeeByUser(SysUserDTO sysUserDTO) {
        if (Objects.isNull(sysUserDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户信息为空!");
        }
        //根据用户ID获取所属员工
        SysEmployeeBasicDTO employeeBasicDTO = rmiEmployeeRpcService.findEmployeeByUserId(sysUserDTO.getId());
        if (Objects.isNull(employeeBasicDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户所属员工信息为空!");
        }
        return employeeBasicDTO;
    }

    private List<String> queryAllSubEmployeeByCode(String salesmanNo){
        Set<String> codeList = new HashSet<>();
        //包含当前登陆人
        codeList.add(salesmanNo);
        List<EmployeeUnderlingDTO> resultData = rmiEmployeeRpcService.getUnderlingByCode(salesmanNo,Boolean.TRUE,Boolean.TRUE);
        if (CollectionUtils.isEmpty(resultData)) {
            return codeList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }

        if (!CollectionUtils.isEmpty(resultData)) {
            List<EmployeeUnderlingDTO> listEmp = new ArrayList<>();
            List<EmployeeUnderlingDTO> res = this.queryAllSubTreeToList(resultData,listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }

        return codeList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
    private List<EmployeeUnderlingDTO> queryAllSubTreeToList(List<EmployeeUnderlingDTO> source ,List<EmployeeUnderlingDTO> obj){
        source.stream().forEach(v ->{
            EmployeeUnderlingDTO t = new EmployeeUnderlingDTO();
            BeanUtils.copyProperties(v,t);
            t.setUnderlingList(new ArrayList<>());
            obj.add(t);
            if(CollectionUtil.isNotEmpty(v.getUnderlingList())){
                queryAllSubTreeToList(v.getUnderlingList(),obj);
            }
        });
        return obj;
    }
}
