package com.elitesland.yst.production.sale.service.shop;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackToOmsServicei;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalReceiptSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptdRespVO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.BipOrderBackDDO;
import com.elitesland.yst.production.sale.entity.BipOrderBackDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiSalSoReturnRpcService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgBankAccRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/09/29/14:39
 * @Description:
 */
@Service
@Slf4j
public class BipOrderBackToOmsServiceimpl extends BaseServiceImpl implements BipOrderBackToOmsServicei {
    @Autowired
    private BipOrderBackRepo bipOrderBackRepo;
    @Autowired
    private CrmCustRepo crmCustRepo;
    @Autowired
    private RmiOrgEmpService rmiOrgEmpService;

    @Autowired
    private RmiOrgOuService rmiOrgOuService;

    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;

    @Autowired
    private CrmCustService crmCustService;

    @Autowired
    private BipAddressRepo bipAddressRepo;

    @Autowired
    private BipOrderBackDRepo bipOrderBackDRepo;

//    @Autowired
//    private PriSalePriceServiceImpl priSalePriceService;

    @Autowired
    private BipOrderRepo bipOrderRepo;

    @Autowired
    private BipOrderDRepo bipOrderDRepo;
    @Autowired
    private BipOrderBackRepoProc bipOrderBackRepoProc;
//    @Autowired
//    private SalReceiptService salReceiptService;

    @Autowired
    private RmiOrgAddrService rmiOrgAddrService;



    @Autowired
    private RmiSalSoReturnRpcService rmiSalSoReturnRpcService;
//    @Autowired
//    private RmiItemService rmiItemService;

//    @Autowired
//    private RmiOrderSalSoService rmiOrderSalSoService;




    private final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_TIME;


    /**
     * 同步订单中心
     *
     * @param orderBackIds
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sendToOms(List<Long> orderBackIds) {
//
//        List<ToBRSalSoSaveDTO> list=new ArrayList();
//        for(Long orderBackId:orderBackIds){
//            ToBRSalSoSaveDTO toBRSalSoSaveDTO = new ToBRSalSoSaveDTO();
//
//            BipOrderBackDO bipOrderBackDO = bipOrderBackRepo.findById(orderBackId).get();
//
//            buildDtoInfo(toBRSalSoSaveDTO, bipOrderBackDO);
//            toBRSalSoSaveDTO.setDocStatus(bipOrderBackDO.getStatus());
//            toBRSalSoSaveDTO.setReturnReasonCode(bipOrderBackDO.getBackReason());
//
//            List<BipOrderBackDDO> bipOrderBackDDOS = bipOrderBackDRepo.findByOrderBackId(orderBackId);
//            List<ToBSalSoDSaveDTO> toBSalSoDSaveDTOs = new ArrayList<>();
//
//            bipOrderBackDDOS.stream().forEach(bipOrderBackDDO -> {
//                ToBSalSoDSaveDTO toBSalSoDSaveDTO = new ToBSalSoDSaveDTO();
//                buildDDtoItemInfo(toBSalSoDSaveDTO, bipOrderBackDDO);
//                BipItemSkuDO bipItemSkuDO=bipItemSkuRepo.findById(bipOrderBackDDO.getSkuId()).get();
//                toBSalSoDSaveDTO.setItemCode(bipItemSkuDO.getSkuCode());
//                toBSalSoDSaveDTO.setItemName(bipItemSkuDO.getItemName());
//                toBSalSoDSaveDTO.setRelateDocId(bipOrderBackDDO.getOrderId());
//                toBSalSoDSaveDTO.setRelateDocDid(bipOrderBackDDO.getOrderDId());
//                toBSalSoDSaveDTOs.add(toBSalSoDSaveDTO);
//            });
//
//            toBRSalSoSaveDTO.setSalSoDSaveDTOList(toBSalSoDSaveDTOs);
//
//            list.add(toBRSalSoSaveDTO);
//        }
//


//        log.info("退货单同步参数:"+ JSON.toJSONString(list));
//        ApiResult<Object> result= rmiSalSoReturnRpcService.toBRSOOrderSave(list);
//        log.info("退货单响应信息:"+JSON.toJSONString(result));
//        if(!result.isSuccess()){
//            throw new BusinessException("退货单同步异常!");
//        }
    }


    /**
     * 构造公司信息
     *
     * @param toBRSalSoSaveDTO
     * @param bipOrderBackDO
     */
//    public void buildDtoOuInfo(ToBRSalSoSaveDTO toBRSalSoSaveDTO, BipOrderBackDO bipOrderBackDO) {
//        toBRSalSoSaveDTO.setOuId(bipOrderBackDO.getOuId());
//        toBRSalSoSaveDTO.setBuId(bipOrderBackDO.getBuId());
//        toBRSalSoSaveDTO.setDocCls("RSO");
//        toBRSalSoSaveDTO.setDocNo(bipOrderBackDO.getOrderBackDocNo());
//
//        toBRSalSoSaveDTO.setDocType("RSOB");
//
//        toBRSalSoSaveDTO.setDocTime(bipOrderBackDO.getBackTime());
//
//        toBRSalSoSaveDTO.setSoScene("RJ");
//
//        toBRSalSoSaveDTO.setDocType2("B");
//        toBRSalSoSaveDTO.setPayStatus("0");
//
//        toBRSalSoSaveDTO.setReturnType(bipOrderBackDO.getBackType());
//
//        toBRSalSoSaveDTO.setSoSource("WX");
//        toBRSalSoSaveDTO.setOuterNo(bipOrderBackDO.getOrderBackDocNo());
//
//        toBRSalSoSaveDTO.setRelateDocId(bipOrderBackDO.getOrderId());
//        toBRSalSoSaveDTO.setRelateDocNo(bipOrderBackDO.getOrderDocNo());
//        toBRSalSoSaveDTO.setRelateDocCls("SO");
//
//        Long orderId=bipOrderBackDO.getOrderId();
//
//        BipOrderDO bipOrderDO=bipOrderRepo.findById(orderId).get();
//        String docType="SOB1";
//        if("offline".equals(bipOrderDO.getPayMethodName())){
//            docType="SOB2";
//        }
//
//        if("online".equals(bipOrderDO.getPayMethodName())){
//            docType="SOB1";
//        }
//        toBRSalSoSaveDTO.setRelateDocType(docType);
//
//        toBRSalSoSaveDTO.setCreateTime(bipOrderBackDO.getCreateTime());
//        toBRSalSoSaveDTO.setModifyTime(bipOrderBackDO.getModifyTime());
//        toBRSalSoSaveDTO.setCreateUserId(bipOrderBackDO.getCustAccountId());
//    }
//



    /**
     * 构造客户信息
     *
     * @param toBRSalSoSaveDTO
     * @param bipOrderBackDO
     */
//    public void buildDtoCustInfo(ToBRSalSoSaveDTO toBRSalSoSaveDTO, BipOrderBackDO bipOrderBackDO) {
//        CrmCustDetailRespVO crmCustDetailRespVO = crmCustService.get(bipOrderBackDO.getCustId());
//        toBRSalSoSaveDTO.setCustId(bipOrderBackDO.getCustId());
//        toBRSalSoSaveDTO.setCustCode(crmCustDetailRespVO.getCustCode());
//        toBRSalSoSaveDTO.setCustName(crmCustDetailRespVO.getCustName());
//        toBRSalSoSaveDTO.setCustContactTel(crmCustDetailRespVO.getContactPhone());
//
//        toBRSalSoSaveDTO.setOuId(bipOrderBackDO.getOuId());
//        toBRSalSoSaveDTO.setOuCode(bipOrderBackDO.getOuCode());
//        toBRSalSoSaveDTO.setOuName(bipOrderBackDO.getOuName());
//
//        toBRSalSoSaveDTO.setBuCode(bipOrderBackDO.getBuCode());
//        toBRSalSoSaveDTO.setBuName(bipOrderBackDO.getBuName());
////        toBSalSoSaveDTO.setCustContactEmail(crmCustDetailRespVO.getm);
//        // 获取业务员
//        toBRSalSoSaveDTO.setAgentEmpId(bipOrderBackDO.getAgentEmpId());
//        OrgEmpRpcDtoParam param = new OrgEmpRpcDtoParam();
//        param.setEmpIds(Arrays.asList(bipOrderBackDO.getAgentEmpId()));
//        List<OrgEmpRpcDTO> emp = rmiOrgEmpService.findEmpListByParam(param);
//
//        emp.stream().filter(emp1 -> emp1.getId().equals(bipOrderBackDO.getAgentEmpId()))
//                .findFirst()
//                .ifPresent(oo -> {
//                    toBRSalSoSaveDTO.setEmpCode(oo.getEmpCode());
//                    toBRSalSoSaveDTO.setEmpName(oo.getEmpName());
//                });
//
//        // 获取本地币种
//        if (!StringUtils.isEmpty(bipOrderBackDO.getOuId())) {
//            List<Long> ouIds = new ArrayList<>();
//            ouIds.add(bipOrderBackDO.getOuId());
//            List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
//            ouDtoList.stream().filter(ou -> ou.getId().equals(bipOrderBackDO.getOuId()))
//                    .findFirst()
//                    .ifPresent(ou2 -> {
//                        toBRSalSoSaveDTO.setHomeCurr(ou2.getOuCurr());
//                        toBRSalSoSaveDTO.setCurrCode(ou2.getOuCurr());
//                            }
//                    );
//
//        }
//
//    }

    /**
     * 构造固定值信息
     *
     * @param toBRSalSoSaveDTO
     */
//    public void buildDtoFinalInfo(ToBRSalSoSaveDTO toBRSalSoSaveDTO) {
//
//        toBRSalSoSaveDTO.setCurrRate(BigDecimal.ONE);
//        toBRSalSoSaveDTO.setCouponAmt(BigDecimal.ZERO);
//        toBRSalSoSaveDTO.setCardAmt(BigDecimal.ZERO);
//        toBRSalSoSaveDTO.setUsePointAmt(BigDecimal.ZERO);
//        toBRSalSoSaveDTO.setDiscNetAmt(BigDecimal.ZERO);
//        toBRSalSoSaveDTO.setOpenAmt(BigDecimal.ZERO);
//        toBRSalSoSaveDTO.setTaxInclFlag("1");
//    }


    /**
     * 构造订单信息
     *
     * @param toBRSalSoSaveDTO
     * @param bipOrderBackDO
     */
//    public void buildDtoInfo(ToBRSalSoSaveDTO toBRSalSoSaveDTO, BipOrderBackDO bipOrderBackDO) {
//        buildDtoOuInfo(toBRSalSoSaveDTO, bipOrderBackDO);
//        buildDtoCustInfo(toBRSalSoSaveDTO, bipOrderBackDO);
//        buildDtoFinalInfo(toBRSalSoSaveDTO);
//
//    }

    ;


    /**
     * 构造订单商品行信息
     *
     * @param toBSalSoDSaveDTO
     * @param bipOrderBackDDO
     */
   /* public void buildDDtoItemInfo(ToBSalSoDSaveDTO toBSalSoDSaveDTO, BipOrderBackDDO bipOrderBackDDO) {

//        BipItemSkuDO bipItemSkuDO=bipItemSkuRepo.findById(bipOrderBackDDO.getSkuId()).get();
//        log.info("商品sku信息:"+JSON.toJSONString(bipItemSkuDO));
//
//        Long orderId=bipOrderBackDDO.getOrderId();
//        BipOrderDO bipOrderDO=bipOrderRepo.findById(orderId).get();
//
//        Long orderDId=bipOrderBackDDO.getOrderDId();
//        BipOrderDDO bipOrderDDO=bipOrderDRepo.findById(orderDId).get();
//
//
//        String skuCode=bipOrderDDO.getSkuCode();
//        List<String> itemCodes=new ArrayList<>();
//        itemCodes.add(skuCode);
//        ItmItemRpcDtoParam itmItemRpcDtoParam=new ItmItemRpcDtoParam();
//        itmItemRpcDtoParam.setItemCodes(itemCodes);
//
//        log.info("同步订单中心查询供应商参数---itmItemRpcDtoParam"+ JSON.toJSONString(itmItemRpcDtoParam));
//
//        List<ItmItemRpcDTO> itmItemRpcDTOList=rmiItemService.findItemListByParam(itmItemRpcDtoParam);
//
//        log.info("调用供应商返回信息:"+JSON.toJSONString(itmItemRpcDTOList));
//        ItmItemRpcDTO itmItemRpcDTO=itmItemRpcDTOList.get(0);
//
//        toBSalSoDSaveDTO.setUom(itmItemRpcDTO.getUom());
//        log.info("是否一件代发:"+itmItemRpcDTO.getAllocType());
//        if("SUPP".equals(itmItemRpcDTO.getAllocType())){
//            toBSalSoDSaveDTO.setSuppFlag("1");
////            toBSalSoDSaveDTO.setSuppId(bipOrderDO.getSupplier());
//            if(itmItemRpcDTO.getSuppId()==null){
//                throw new BusinessException("商品的供应商id为空!");
//            }
//
//            toBSalSoDSaveDTO.setSuppId(itmItemRpcDTO.getSuppId());
//            toBSalSoDSaveDTO.setSuppCode(itmItemRpcDTO.getSuppCode());
//        }else{
//            toBSalSoDSaveDTO.setSuppFlag("0");
//        }
//
//        if("10".equals(itmItemRpcDTO.getItemType())){
//            if("10".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("101");
//            }
//            if("30".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("102");
//
//            }else{
//                toBSalSoDSaveDTO.setLineType("101");
//
//            }
//
//        }
//
//        if("20".equals(itmItemRpcDTO.getItemType())){
//            if("10".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("201");
//
//            }
//            if("30".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("202");
//
//            }else{
//                toBSalSoDSaveDTO.setLineType("201");
//
//            }
//        }
//
//        if("30".equals(itmItemRpcDTO.getItemType())){
//            if("10".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("301");
//
//            }
//            if("30".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("302");
//
//            }else{
//                toBSalSoDSaveDTO.setLineType("301");
//
//            }
//        }
//        if(toBSalSoDSaveDTO.getLineType()==null){
//            toBSalSoDSaveDTO.setLineType("999");
//
//        }
//
////        if(bipItemSkuDO.getShipOne()){
////            toBSalSoDSaveDTO.setSuppFlag("1");
//////            toBSalSoDSaveDTO.setSuppId(bipOrderDO.getSupplier());
////            if(itmItemRpcDTOList.isEmpty()){
////                throw new BusinessException("商品中心查询数据为空!");
////            }
////            ItmItemRpcDTO itmItemRpcDTO=itmItemRpcDTOList.get(0);
////            if(itmItemRpcDTO.getSuppId()==null){
////                throw new BusinessException("商品的供应商id为空!");
////            }
////
////            toBSalSoDSaveDTO.setSuppId(itmItemRpcDTO.getSuppId());
////        }else{
////            toBSalSoDSaveDTO.setSuppFlag("0");
////        }
////
////        if("10".equals(bipItemSkuDO.getType())){
////            if("10".equals(bipItemSkuDO.getMateriel())){
////                toBSalSoDSaveDTO.setLineType("101");
////            }
////            if("30".equals(bipItemSkuDO.getMateriel())){
////                toBSalSoDSaveDTO.setLineType("102");
////            }
////
////        }
////
////        if("20".equals(bipItemSkuDO.getType())){
////            if("10".equals(bipItemSkuDO.getMateriel())){
////                toBSalSoDSaveDTO.setLineType("201");
////
////            }
////            if("30".equals(bipItemSkuDO.getMateriel())){
////                toBSalSoDSaveDTO.setLineType("202");
////
////            }
////        }
////
////        if("30".equals(bipItemSkuDO.getType())){
////            if("10".equals(bipItemSkuDO.getMateriel())){
////                toBSalSoDSaveDTO.setLineType("301");
////
////            }
////            if("30".equals(bipItemSkuDO.getMateriel())){
////                toBSalSoDSaveDTO.setLineType("302");
////
////            }
////        }
//
//        toBSalSoDSaveDTO.setPrice(bipOrderBackDDO.getPayAmt());
//        toBSalSoDSaveDTO.setOuterNo(bipOrderBackDDO.getOrderDocNo());
//        toBSalSoDSaveDTO.setOuterLineno(String.valueOf(bipOrderBackDDO.getLineNo()));
//
//
//        toBSalSoDSaveDTO.setItemCode(skuCode);
//        toBSalSoDSaveDTO.setItemName(bipOrderBackDDO.getItemName());
//
//        toBSalSoDSaveDTO.setQty(BigDecimal.valueOf(bipOrderBackDDO.getBackNum()));
//
//        toBSalSoDSaveDTO.setLineStatus("N");
//        toBSalSoDSaveDTO.setBasePrice(bipOrderDDO.getCustPrice());
//        toBSalSoDSaveDTO.setCouponAmt(BigDecimal.ZERO);
//        toBSalSoDSaveDTO.setDiscAmt(BigDecimal.ZERO);
//        toBSalSoDSaveDTO.setUsePointAmt(BigDecimal.ZERO);
//        toBSalSoDSaveDTO.setPayingAmt(BigDecimal.ZERO);
//        toBSalSoDSaveDTO.setPayStatus("0");
//        toBSalSoDSaveDTO.setInvStatus(bipOrderDO.getInvoice().toString());
//
//        toBSalSoDSaveDTO.setOrignNetAmt(BigDecimal.ZERO);
//        toBSalSoDSaveDTO.setOrignAmt(BigDecimal.ZERO);
//        toBSalSoDSaveDTO.setAllocQty(BigDecimal.ZERO);
//        toBSalSoDSaveDTO.setAllocStatus("NONEED");
//        toBSalSoDSaveDTO.setLogisStatus("0");
//        toBSalSoDSaveDTO.setConfirmStatus("0");
//
//        toBSalSoDSaveDTO.setRelateDocNo(bipOrderBackDDO.getOrderDocNo());
//
//        toBSalSoDSaveDTO.setRelateDocDid(bipOrderBackDDO.getOrderDId());
//        toBSalSoDSaveDTO.setRelateDocCls("SO");
//
//        String docType="SOB1";
//        if("offline".equals(bipOrderDO.getPayMethodName())){
//            docType="SOB2";
//        }
//
//        if("online".equals(bipOrderDO.getPayMethodName())){
//            docType="SOB1";
//        }
//        toBSalSoDSaveDTO.setRelateDocType(docType);
////        toBSalSoDSaveDTO.setRelateDocDid(bipOrderBackDDO.getOrderDId());
////        toBSalSoDSaveDTO.setRelateDocNo(bipOrderBackDDO.getOrderDocNo());
//
//        toBSalSoDSaveDTO.setRelateDocDid(bipOrderBackDDO.getId());
//        toBSalSoDSaveDTO.setRelateDocNo(bipOrderBackDDO.getOrderBackDocNo());
//
//        log.info("退货单子单信息:"+JSON.toJSONString(toBSalSoDSaveDTO));
    }*/


    /**
     * 更新退货单金额信息
     * @param bipOrderBackDDOS 退款单明细
     * @param status 状态
     */
    public void updateBackOrder(List<BipOrderBackDDO> bipOrderBackDDOS, String status) {

//        Assert.notBlank(status,"退款单状态不能为空！");
//
//        List<String> docNoList=bipOrderBackDDOS.stream().map(BipOrderBackDDO::getOrderBackDocNo).distinct().collect(Collectors.toList());
//        log.info("退货单单号--"+JSON.toJSONString(docNoList));
//
//        if(docNoList.size() != 1){
//            throw new BusinessException("退货单信息不一致!");
//        }
//
//        // 退款单主表
//        BipOrderBackDO orderBackByDocNo = bipOrderBackRepoProc.findOrderBackByDocNo(docNoList.get(0));
//        Assert.notNull(orderBackByDocNo,"未根据退货单单号"+docNoList.get(0)+"找到退款单");
//
//        // 主表
//        ToBRSalSoSaveDTO master = new ToBRSalSoSaveDTO();
//
//        // 退货单单号
//        master.setDocNo(docNoList.get(0));
//        master.setRelateDocNo(orderBackByDocNo.getOrderDocNo());
//        master.setReturnType(orderBackByDocNo.getBackType());
//        master.setDocStatus(status);
//
//        // 构建退款主单金额信息
//        List<ToBSalSoDSaveDTO> details = buildBackAmtInfo(bipOrderBackDDOS, status);
//
//        buildBackSumInfo(details, master);
//
//        // 明细
//        master.setSalSoDSaveDTOList(details);
//
//        var result=rmiSalSoReturnRpcService.toBsave(Collections.singletonList(master));
//
//        if(!result.isSuccess()){
//            throw new BusinessException("退货单更细失败!");
//        }

    }


    /**
     * 构建退款单同步OMS明细列表
     * @param bipOrderBackDDOS 退款单明细
     */
 /*   public List<ToBSalSoDSaveDTO> buildBackAmtInfo(List<BipOrderBackDDO> bipOrderBackDDOS, String status){
//        List<ToBSalSoDSaveDTO> toBSalSoDSaveDTOS=new ArrayList<>();
//
//        for(BipOrderBackDDO biporderbackDDo:bipOrderBackDDOS){
//
//            ToBSalSoDSaveDTO toBSalSoDSaveDTO = new ToBSalSoDSaveDTO();
//            BigDecimal backAmt = biporderbackDDo.getApproveBackAmt();
//            if(backAmt==null||backAmt.compareTo(BigDecimal.ZERO)<=0){
//                throw new BusinessException("退款金额必须大于0");
//            }
//            Long skuId = biporderbackDDo.getSkuId();
//            BipItemSkuDO bipItemSkuDO = bipItemSkuRepo.findById(skuId).orElse(null);
//            if(bipItemSkuDO==null){
//                throw new BusinessException("商品sku不存在!");
//            }
//
//            String skuCode = bipItemSkuDO.getSkuCode();
//
//            log.info("调用价格表参数信息:"+JSON.toJSONString(skuCode));
//            List<BipInvItemDTO> bipInvItemDTOList = priSalePriceService.queryBasePriceByItemCode(skuCode);
//            log.info("调用价格表返回信息:"+JSON.toJSONString(bipInvItemDTOList));
//
//            if(bipInvItemDTOList==null||bipInvItemDTOList.isEmpty()){
//                throw new BusinessException("商品价格不存在!");
//            }
//
//            BipInvItemDTO bipInvItemDTO = bipInvItemDTOList.get(0);
//            BigDecimal taxRate = bipInvItemDTO.getTaxRate();
//            BigDecimal netAmt = backAmt.divide((taxRate.add(BigDecimal.ONE)), 2, BigDecimal.ROUND_HALF_DOWN);
//
//            toBSalSoDSaveDTO.setNetAmt(netAmt);
//            toBSalSoDSaveDTO.setTaxAmt(backAmt.subtract(netAmt));
//            if ("CL".equals(status)){
//                toBSalSoDSaveDTO.setReturnedQty(BigDecimal.ZERO);
//            }
//
//            toBSalSoDSaveDTO.setApAmt(backAmt);
//            toBSalSoDSaveDTO.setOpenAmt(backAmt);
//            toBSalSoDSaveDTO.setAmt(backAmt);
//
//            toBSalSoDSaveDTO.setOuterNo(biporderbackDDo.getOrderDocNo());
//            toBSalSoDSaveDTO.setOuterLineno(String.valueOf(biporderbackDDo.getLineNo()));
//
//            toBSalSoDSaveDTOS.add(toBSalSoDSaveDTO);
//        }
//
//        return toBSalSoDSaveDTOS;
        return null;
    }*/


    /**
     * 构建退款主单金额信息
     * @param toBSalSoDSaveDTOs
     * @param toBRSalSoSaveDTO
     */
//    public void buildBackSumInfo(List<ToBSalSoDSaveDTO> toBSalSoDSaveDTOs,ToBRSalSoSaveDTO toBRSalSoSaveDTO){
//        BigDecimal amt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getAmt();
//        }).reduce(BigDecimal::add).orElse(null);
//        toBRSalSoSaveDTO.setAmt(amt);
//
//        BigDecimal netAMt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getNetAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getNetAmt();
//        }).reduce(BigDecimal::add).orElse(null);
//        toBRSalSoSaveDTO.setNetAmt(netAMt);
//
//        BigDecimal taxAmt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getTaxAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getTaxAmt();
//        }).reduce(BigDecimal::add).orElse(null);
//        toBRSalSoSaveDTO.setTaxAmt(taxAmt);
//
//        BigDecimal apAmt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getApAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getApAmt();
//        }).reduce(BigDecimal::add).orElse(null);
//        toBRSalSoSaveDTO.setApAmt(apAmt);
//
//        BigDecimal openAmt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getOpenAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getOpenAmt();
//        }).reduce(BigDecimal::add).orElse(null);
//        toBRSalSoSaveDTO.setOpenAmt(openAmt);
//
//    }


    /**
     * 收款单明细
     * @param docNo
     */
    public SalReceiptSaveParam buildReceiptInfo(String docNo){
        SalReceiptSaveParam salReceiptSaveParam=new SalReceiptSaveParam();
        SalReceiptRespVO salReceiptRespVO=new SalReceiptRespVO();

        List<SalReceiptdRespVO> salReceiptdRespVOS=new ArrayList<>();

        BipOrderBackDO bipOrderBackDO=bipOrderBackRepoProc.findOrderBackByDocNo(docNo);
        if(bipOrderBackDO==null||bipOrderBackDO.getId()==null){
            throw new BusinessException("退货单不存在!");
        }
        salReceiptRespVO.setReceiptSerial(bipOrderBackDO.getTxsn());
//        salReceiptSaveParam.setOffFlag("");
        salReceiptSaveParam.setSaveFlag("SUBMIT");

        salReceiptRespVO.setDocType("RSOB");
        salReceiptRespVO.setReceiptType("ONLINE_PRE");

//        CurrentUserDTO currentUserDTO= UserService.currentUser();
//        salReceiptRespVO.setCreateUserId(bipOrderBackDO.getAgentEmpId());
        salReceiptRespVO.setCreateUserId(bipOrderBackDO.getCreateUserId());
        salReceiptRespVO.setCreator(bipOrderBackDO.getCreator());


        salReceiptRespVO.setApplyDate(LocalDateTime.now());

        salReceiptRespVO.setAmt(bipOrderBackDO.getApproveBackAmt());

        CrmCustDetailRespVO crmCustDetailRespVO = crmCustService.get(bipOrderBackDO.getCustId());
        salReceiptRespVO.setCustId(bipOrderBackDO.getCustId());
        salReceiptRespVO.setCustCode(crmCustDetailRespVO.getCustCode());
        salReceiptRespVO.setCustName(crmCustDetailRespVO.getCustName());

        salReceiptRespVO.setOuId(bipOrderBackDO.getOuId());
        salReceiptRespVO.setOuCode(bipOrderBackDO.getOuCode());
        salReceiptRespVO.setOuName(bipOrderBackDO.getOuName());

        salReceiptRespVO.setBuId(bipOrderBackDO.getBuId());
        salReceiptRespVO.setBuName(bipOrderBackDO.getBuName());
        salReceiptRespVO.setApplyDate(bipOrderBackDO.getBackTime());
        // 获取业务员
        salReceiptRespVO.setApplyEmpId(bipOrderBackDO.getAgentEmpId());
//        salReceiptRespVO.setCreateUserId(bipOrderBackDO.getAgentEmpId());
        OrgEmpRpcDtoParam param = new OrgEmpRpcDtoParam();
        param.setEmpIds(Arrays.asList(bipOrderBackDO.getAgentEmpId()));
        List<OrgEmpRpcDTO> emp = rmiOrgEmpService.findEmpListByParam(param);

        emp.stream().filter(emp1 -> emp1.getId().equals(bipOrderBackDO.getAgentEmpId()))
                .findFirst()
                .ifPresent(oo -> {
                    salReceiptRespVO.setApplyName(oo.getEmpName());
                    salReceiptRespVO.setCreator(oo.getEmpName());
                });

        // 获取本地币种
        if (!StringUtils.isEmpty(bipOrderBackDO.getOuId())) {
            List<Long> ouIds = new ArrayList<>();
            ouIds.add(bipOrderBackDO.getOuId());
            List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
            ouDtoList.stream().filter(ou -> ou.getId().equals(bipOrderBackDO.getOuId()))
                    .findFirst()
                    .ifPresent(ou2 -> {
                        salReceiptRespVO.setCurrCode(ou2.getOuCurr());
                            }
                    );
        }


        BigDecimal amt=BigDecimal.ZERO;
        BigDecimal taxAmt=BigDecimal.ZERO;

        List<BipOrderBackDDO> bipOrderBackDDOS=bipOrderBackDRepo.findByOrderBackId(bipOrderBackDO.getId());
        for(BipOrderBackDDO bipOrderBackDDO:bipOrderBackDDOS){
            SalReceiptdRespVO salReceiptdRespVO= buildReceiptInfo(bipOrderBackDDO);
            log.info("退款单明细信息--"+JSON.toJSONString(salReceiptdRespVO));
            salReceiptdRespVOS.add(salReceiptdRespVO);
            amt=amt.add(salReceiptdRespVO.getAmt());
            taxAmt=taxAmt.add(salReceiptdRespVO.getReceiptTax());
        }

        salReceiptRespVO.setAmt(amt);
//        salReceiptRespVO.settax
        salReceiptRespVO.setSalReceiptdRespVOS(salReceiptdRespVOS);
        log.info("退款单主表信息--"+JSON.toJSONString(salReceiptRespVO));

        salReceiptSaveParam.setSalReceiptRespVO(salReceiptRespVO);
        log.info("退款单参数信息信息--"+JSON.toJSONString(salReceiptSaveParam));

        return salReceiptSaveParam;
    }


    /**
     * 收款单明细
     * @param bipOrderBackDDO
     */
    public SalReceiptdRespVO buildReceiptInfo(BipOrderBackDDO bipOrderBackDDO){
//        SalReceiptdRespVO salReceiptdRespVO=new SalReceiptdRespVO();
////        salReceiptdRespVO.setItemCode(bipOrderBackDDO.getItemCode());
////        salReceiptdRespVO.setItemName(bipOrderBackDDO.getItemName());
//
//        //receiptAmt
//        salReceiptdRespVO.setSoNo(bipOrderBackDDO.getOrderBackDocNo());
//        salReceiptdRespVO.setSoLineNo(BigDecimal.valueOf(bipOrderBackDDO.getLineNo()));
//        salReceiptdRespVO.setSoId(bipOrderBackDDO.getOrderBackId());
//        salReceiptdRespVO.setSoDId(bipOrderBackDDO.getId());
//        salReceiptdRespVO.setRelateDocId(bipOrderBackDDO.getOrderId());
//        salReceiptdRespVO.setRelateDocDId(bipOrderBackDDO.getOrderDId());
//        salReceiptdRespVO.setSoUom(bipOrderBackDDO.getUom());
//
//        BigDecimal backAmt=bipOrderBackDDO.getApproveBackAmt();
//        if(backAmt==null||backAmt.compareTo(BigDecimal.ZERO)<=0){
//            throw new BusinessException("退款金额必须大于0");
//        }
//        Long skuId = bipOrderBackDDO.getSkuId();
//        BipItemSkuDO bipItemSkuDO=bipItemSkuRepo.findById(skuId).get();
//        if(bipItemSkuDO==null){
//            throw new BusinessException("商品sku不存在!");
//        }
//        String skuCode=bipItemSkuDO.getSkuCode();
//        //通过SKUID查询 SKUID 这里要存的itemCode实际就是skuCode
//        salReceiptdRespVO.setItemCode(skuCode);
//        salReceiptdRespVO.setItemName(bipItemSkuDO.getItemName());
//        List skuList = Arrays.asList(skuCode);
//
//        log.info("调用价格表参数信息:"+JSON.toJSONString(skuList));
//
//        List<BipInvItemDTO> bipInvItemDTOList = priSalePriceService.queryBasePriceByItemCode(skuCode);
//        log.info("调用价格表返回信息:"+JSON.toJSONString(bipInvItemDTOList));
//
//        if(bipInvItemDTOList==null||bipInvItemDTOList.isEmpty()){
//            throw new BusinessException("商品价格不存在!");
//        }
//        BipInvItemDTO bipInvItemDTO=bipInvItemDTOList.get(0);
//        BigDecimal taxRate = bipInvItemDTO.getTaxRate();
//
//        salReceiptdRespVO.setAmt(backAmt);
//        salReceiptdRespVO.setReceiptAmt(backAmt);
//        BigDecimal netAmt=backAmt.divide((taxRate.add(BigDecimal.ONE)), 2, BigDecimal.ROUND_HALF_UP);
//
//        salReceiptdRespVO.setReceiptTax(backAmt.subtract(netAmt));
//
//        return salReceiptdRespVO;
        return null;
    }


    /**
     * 生成退款单
     * @param docNo
     */
    @Override
    public void createSalReceiptService(String docNo){
//        SalReceiptSaveParam salReceiptSaveParam=buildReceiptInfo(docNo);
//        SalReceiptRespVO salReceiptRespVO = salReceiptSaveParam.getSalReceiptRespVO();
//        //类型  RD：退款
//        salReceiptRespVO.setDocType("RD");
//        //退款类型
//        salReceiptRespVO.setReceiptType("40");
//        //收款方式：第三方支付平台收款
//        salReceiptRespVO.setPayMethod("CNCR");
//        salReceiptSaveParam.setSalReceiptRespVO(salReceiptRespVO);
//        SalReceiptSaveParam resParam = salReceiptSaveParam;
//        SalReceiptRespVO respVo = resParam.getSalReceiptRespVO();
//        respVo.setAmt(null == respVo.getAmt() || respVo.getAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : respVo.getAmt().abs().negate());
//        respVo.setReturnAmt(null == respVo.getReturnAmt() || respVo.getReturnAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : respVo.getReturnAmt().abs().negate());
//        respVo.setReturningAmt(null == respVo.getReturningAmt() || respVo.getReturningAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : respVo.getReturningAmt().abs().negate());
//        respVo.setPayMethod("CNCP");
//        RmiOrgBankAccRpcVO bankAccRpcVO = getVirtualInfo(respVo.getOuId());
//        if(null != bankAccRpcVO){ //方式，账号 主数据 ouBankAcc ouHolderName payMethod
//            //收款账号
//            respVo.setOuBankAcc(bankAccRpcVO.getBankAcc());
//            //开户人姓名
//            respVo.setOuHolderName(bankAccRpcVO.getHolderName());
//        }
//
//        List<SalReceiptdRespVO> salReceiptdRespVOS = respVo.getSalReceiptdRespVOS();
//        if(salReceiptdRespVOS != null && !salReceiptdRespVOS.isEmpty()){
//            salReceiptdRespVOS.stream().forEach(receipt ->{
//                receipt.setQty(null == receipt.getQty() || receipt.getQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : receipt.getQty().abs().negate());
//                receipt.setConfirmQty(null == receipt.getConfirmQty() || receipt.getConfirmQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : receipt.getConfirmQty().abs().negate());
//                receipt.setAmt(null == receipt.getAmt() || receipt.getAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : receipt.getAmt().abs().negate());
//                receipt.setConfirmAmt(null == receipt.getConfirmAmt() || receipt.getConfirmAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : receipt.getConfirmAmt().abs().negate());
//                receipt.setRefundAmt(null == receipt.getRefundAmt() || receipt.getRefundAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : receipt.getRefundAmt().abs().negate());
//                receipt.setPayingAmt(null == receipt.getPayingAmt() || receipt.getPayingAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : receipt.getPayingAmt().abs().negate());
//                receipt.setPayedAmt(null == receipt.getPayedAmt() || receipt.getPayedAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : receipt.getPayedAmt().abs().negate());
//                receipt.setOpenAmt(null == receipt.getOpenAmt() || receipt.getOpenAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : receipt.getOpenAmt().abs().negate());
//                receipt.setReceiptAmt(null == receipt.getReceiptAmt() || receipt.getReceiptAmt().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : receipt.getReceiptAmt().abs().negate());
//                //查询oms订单ID和明细ID
//                ToBGetSalRSoIdDTO toBGetSalRSoIdDTO = new ToBGetSalRSoIdDTO();
//                toBGetSalRSoIdDTO.setDocNo(docNo);
//                toBGetSalRSoIdDTO.setItemCode(receipt.getItemCode());
//                log.info("查询oms退款单id参数---------:"+JSON.toJSONString(toBGetSalRSoIdDTO));
//                ApiResult<Object> omsId = rmiOrderSalSoService.GetRsoIdAndDid(toBGetSalRSoIdDTO);
//                log.info("查询oms退款单id参数返回---------:"+JSON.toJSONString(omsId));
//                if(null != omsId && omsId.getCode() == 200){
//                    if(null != omsId.getData()){
//                        Map<String,Long> map = (Map<String, Long>) omsId.getData();
//                        receipt.setSoId(map.get("id"));
//                        receipt.setSoDId(map.get("did"));
//                    }
//                }
//
//
////                if(null == receipt.getSoId() || null == receipt.getSoDId()){
////                    ToBGetSalRSoIdDTO toBGetSalRSoIdDTO = new ToBGetSalRSoIdDTO();
////                    toBGetSalRSoIdDTO.setDocNo(docNo);
////                    toBGetSalRSoIdDTO.setItemCode(receipt.getItemCode());
////                    log.info("查询oms退款单id参数---------:"+JSON.toJSONString(toBGetSalRSoIdDTO));
////                    ApiResult<Object> omsId = rmiOrderSalSoService.GetRsoIdAndDid(toBGetSalRSoIdDTO);
////                    log.info("查询oms退款单id参数返回---------:"+JSON.toJSONString(omsId));
////                    if(null != omsId && omsId.getCode() == 200){
////                        if(null != omsId.getData()){
////                            Map<String,Long> map = (Map<String, Long>) omsId.getData();
////                            receipt.setSoId(map.get("id"));
////                            receipt.setSoDId(map.get("did"));
////                        }
////                    }
////                }
//            });
//        }
//        log.info("退款生成参数信息---"+JSON.toJSONString(salReceiptSaveParam));
//        log.info("退款单生成参数信息---"+JSON.toJSONString(resParam));
//        try {
//            ApiResult<Object> result=salReceiptService.saveOrSubmit(resParam);
//            log.info("退款单生成响应信息---"+JSON.toJSONString(result));
//        }catch (Exception e){
//            throw new BusinessException("退款单生成失败:"+e.getMessage());
//        }
    }


    //查询虚拟账号信息
    public RmiOrgBankAccRpcVO getVirtualInfo(Long ouId){
        //查询虚拟用户ID和账户
        List<RmiOrgBankAccRpcVO> resList = new ArrayList<>();
        log.info("订单公司ID:---"+ouId);
        List<Long> ouIds = new ArrayList<>();
        ouIds.add(ouId);
        OrgOuRpcDtoParam orgOuRpcDtoParam=new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouIds);
        List<OrgOuRpcDTO> orgOuRpcDTOS = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        log.info("根据公司的信息获取到公司对应的地址号信息:-----"+JSON.toJSONString(orgOuRpcDTOS));
        if(null != orgOuRpcDTOS && !orgOuRpcDTOS.isEmpty()){
            OrgOuRpcDTO orgOuRpcDTO=orgOuRpcDTOS.get(0);
            OrgBankAccRpcDtoParam orgBankAccRpcDtoParam = new OrgBankAccRpcDtoParam();
            if(null != orgOuRpcDTO.getAddrNo()){
                List<Long> addNos = new ArrayList<>();
                addNos.add(orgOuRpcDTO.getAddrNo());
                orgBankAccRpcDtoParam.setAddrNos(addNos);
                log.info("根据地址信息获取银行信息参数:-----"+JSON.toJSONString(orgBankAccRpcDtoParam));
                List<RmiOrgBankAccRpcVO> list = rmiOrgAddrService.findBankAccRpcDtoByParam(orgBankAccRpcDtoParam);
                log.info("根据地址信息获取银行信息:-----"+JSON.toJSONString(list));
                if(null != list && !list.isEmpty()){
                    list.stream().forEach(l ->{
                        //收款账号
                        if(org.apache.commons.lang3.StringUtils.isNotBlank(l.getAccType()) && "IN".equals(l.getAccType()) && org.apache.commons.lang3.StringUtils.isNotBlank(l.getThirdpartyVirtualUserId()) && org.apache.commons.lang3.StringUtils.isNotBlank(l.getThirdpartyVirtualAcc())){
                            resList.add(l);
                        }
                    });
                }else {
                    throw new BusinessException("银行账户信息获取异常，参数:------"+JSON.toJSONString(orgBankAccRpcDtoParam));
                }
            }else {
                throw new BusinessException("支付时获取的参数:--------"+JSON.toJSONString(orgBankAccRpcDtoParam));
            }
        }
        if(null == resList || resList.isEmpty()){
            return null;
        }
        return resList.get(0);
    }


}
