/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.shop;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.BusFirstMenuConfService;
import com.elitesland.yst.production.sale.api.service.ZoneSettingService;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipCouponService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.service.shop.BipRotationChartService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCompanyManageParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponOrderVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHomeMenuPageVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouPonIndexShowVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHomeDetailVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHomeMenuVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipRetationChartVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemListAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneRecParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bip/home"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u9996\u9875(app)"})
public class BipHomePageController {
    private static final Logger log = LoggerFactory.getLogger(BipHomePageController.class);
    private final BipCouponService bipCouponService;
    private final BipItemAppService bipItemAppService;
    private final ZoneSettingService zoneSettingService;
    private final BipRotationChartService bipRotationChartService;
    private final BusFirstMenuConfService busFirstMenuConfService;
    private final BipCompanyManageService bipCompanyManageService;

    @GetMapping(value={"/homeSlideshow/{id}"})
    @ApiOperation(value="\u9996\u9875\u8f6e\u64ad\u56fe")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u516c\u53f8ID")})
    public ApiResult<List<BipRetationChartVO>> homeRotation(@PathVariable Long id) {
        List ret = this.bipRotationChartService.homeRotation(id);
        return ApiResult.ok((Object)ret);
    }

    @GetMapping(value={"/rotationItem/{offsetCode}"})
    @ApiOperation(value="\u8f6e\u64ad\u56fe\u5546\u54c1\u5217\u8868")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="offsetCode", value="\u6ee1\u51cf\u7f16\u7801")})
    public ApiResult<List<BipItemListAppRespVO>> rotationItem(@PathVariable String offsetCode) {
        return this.bipItemAppService.rotationItem(offsetCode);
    }

    @GetMapping(value={"/findHomeCurrentCoupon"})
    @ApiOperation(value="\u9996\u9875\u67e5\u8be2\u672a\u9886\u53d6\u4f18\u60e0\u5238")
    @ApiOperationSupport(order=3)
    ApiResult<BipCouPonIndexShowVO> findHomeCoupon() {
        return ApiResult.ok((Object)this.bipCouponService.findHomeCoupon());
    }

    @GetMapping(value={"/homeMenus/{id}"})
    @ApiOperation(value="\u83dc\u5355\u5217\u8868")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u516c\u53f8ID")})
    public ApiResult<List<BipHomeMenuVO>> findHomeMenu(@PathVariable Long id) {
        List menu = this.busFirstMenuConfService.findHomeMenu(id);
        return ApiResult.ok((Object)menu);
    }

    @PostMapping(value={"/homeMenuDetails"})
    @ApiOperation(value="\u83dc\u5355\u8be6\u60c5")
    @ApiOperationSupport(order=5)
    public ApiResult<PagingVO<BipHomeDetailVO>> findHomeMenuDetails(@RequestBody BipHomeMenuPageVO bipHomeMenuPageVO) {
        PagingVO menu = this.busFirstMenuConfService.findHomeMenuDetails(bipHomeMenuPageVO);
        return ApiResult.ok((Object)menu);
    }

    @ApiOperation(value="\u9996\u9875\u4e13\u533a")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/recommend"})
    public ApiResult<List<ZoneSettingVO>> queryRecGood(@Valid @RequestBody ZoneRecParam param) {
        return ApiResult.ok((Object)this.zoneSettingService.homeRecommend(param));
    }

    @ApiOperation(value="\u4e13\u533a\u8be6\u60c5")
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/zoneMore"})
    public ApiResult<ZoneSettingVO> zoneMore(@Valid @RequestBody ZoneRecParam param) {
        return ApiResult.ok((Object)this.zoneSettingService.getRecommendForMore(param));
    }

    @PostMapping(value={"/sortingSearch"})
    @ApiOperation(value="\u4f18\u60e0\u5238\u4e2d\u5fc3-\u6392\u5e8f\u67e5\u8be2")
    @ApiOperationSupport(order=8)
    @ApiImplicitParams(value={@ApiImplicitParam(name="param", required=true, dataType="BipCouponOrderVO")})
    public ApiResult<PagingVO<BipCouponVO>> sortingSearch(@RequestBody BipCouponOrderVO param) {
        PagingVO ret = this.bipCouponService.sortingSearch(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/searchCompany"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5546\u57ce\u516c\u53f8")
    @ApiOperationSupport(order=9)
    public ApiResult<PagingVO<BipCompanyManageRespVO>> search(@RequestBody BipCompanyManageParamVO searchParam) {
        return ApiResult.ok((Object)this.bipCompanyManageService.search(searchParam));
    }

    public BipHomePageController(BipCouponService bipCouponService, BipItemAppService bipItemAppService, ZoneSettingService zoneSettingService, BipRotationChartService bipRotationChartService, BusFirstMenuConfService busFirstMenuConfService, BipCompanyManageService bipCompanyManageService) {
        this.bipCouponService = bipCouponService;
        this.bipItemAppService = bipItemAppService;
        this.zoneSettingService = zoneSettingService;
        this.bipRotationChartService = bipRotationChartService;
        this.busFirstMenuConfService = busFirstMenuConfService;
        this.bipCompanyManageService = bipCompanyManageService;
    }
}

