/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.event.listener;

import cn.hutool.core.util.BooleanUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.shop.BipItemMngService;
import com.elitesland.yst.production.sale.event.ItemStockUpdateEvent;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class AutoOffShelfListener
implements ApplicationListener<ItemStockUpdateEvent> {
    private static final Logger log = LoggerFactory.getLogger(AutoOffShelfListener.class);
    private final BipItemMngService itemMngService;

    public AutoOffShelfListener(BipItemMngService itemMngService) {
        this.itemMngService = itemMngService;
    }

    public void onApplicationEvent(@NonNull ItemStockUpdateEvent event) {
        if (BooleanUtil.isTrue((Boolean)event.getIncrement())) {
            return;
        }
        log.debug("\u76d1\u542c\u5230sku\u3010{}\u3011\u53d8\u66f4\uff0c\u68c0\u67e5\u5e93\u5b58\u662f\u5426\u5145\u8db3\u6765\u5bf9\u5546\u54c1\u81ea\u52a8\u4e0b\u67b6", (Object)event.getBipItemSkuId());
        CompletableFuture.runAsync(() -> this.checkStock(event.getBipItemSkuId())).exceptionally(e -> {
            log.error("\u68c0\u67e5\u5e93\u5b58\u662f\u5426\u5145\u8db3\u6765\u5bf9\u5546\u54c1\u81ea\u52a8\u4e0b\u67b6\u53d1\u751f\u5f02\u5e38", e);
            return null;
        });
    }

    private void checkStock(Long skuId) {
        ApiResult itemId = this.itemMngService.getIdBySkuId(skuId);
        this.itemMngService.executeCheckStock((Long)itemId.getData());
    }
}

