/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.dto.BipCartDTO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartItemRespVO;
import com.elitesland.yst.production.sale.entity.QBipCartDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.entity.QBipItemSkuDO;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BipCartRepoProc {
    @Autowired
    private BipCartRepo bipCartRepo;
    private final QBipItemDO qBipItemDo = QBipItemDO.bipItemDO;
    private final QBipCartDO qBipCartDo = QBipCartDO.bipCartDO;
    private final QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public JPAQuery<BipCartItemRespVO> findUserCartItemInfo(Long userId, String isEnabled) {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipCartItemRespVO.class, (Expression[])new Expression[]{this.qBipCartDo.id, this.qBipCartDo.itemNum, this.qBipCartDo.putAmt, this.qBipCartDo.userId, this.qBipCartDo.itemId, this.qBipCartDo.skuCode, this.qBipCartDo.skuId, this.qBipCartDo.firstItemFlag})).from((EntityPath)this.qBipCartDo)).where(this.where(userId, isEnabled));
    }

    public Predicate where(Long userId, String isEnabled) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (!Objects.isNull(userId)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipCartDo.userId.eq((Object)userId));
        }
        if (StringUtils.isNotBlank((CharSequence)isEnabled)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipCartDo.isEabled.eq((Object)isEnabled));
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipCartDo.deleteFlag.eq((Object)0));
        return predicate;
    }

    public void deleteCartByIds(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)this.qBipCartDo).where(new Predicate[]{this.qBipCartDo.id.in(ids)}).execute();
    }

    public List<BipCartDTO> searchCart(Long skuId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipCartDTO.class, (Expression[])new Expression[]{this.qBipCartDo.id, this.qBipCartDo.itemId, this.qBipCartDo.userId, this.qBipCartDo.skuId, this.qBipCartDo.stockEnough})).from((EntityPath)this.qBipCartDo)).where((Predicate)this.qBipCartDo.skuId.eq((Object)skuId).and((Predicate)this.qBipCartDo.stockEnough.eq(Boolean.valueOf(false))))).fetch();
    }

    public List<BipCartDTO> searchCartByCode(Long skuId, String priceType) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipCartDTO.class, (Expression[])new Expression[]{this.qBipCartDo.id, this.qBipCartDo.itemId, this.qBipCartDo.userId, this.qBipCartDo.skuId, this.qBipCartDo.stockEnough})).from((EntityPath)this.qBipCartDo)).where((Predicate)this.qBipCartDo.skuId.eq((Object)skuId).and((Predicate)this.qBipCartDo.priceType.eq((Object)priceType)))).fetch();
    }
}

