/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.PriSalePrice2Service;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePricePagingParam;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceExportVO;
import com.elitesland.yst.production.sale.convert.PriSalePriceConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PriSalePrice2ServiceImpl
extends BaseServiceImpl
implements PriSalePrice2Service {
    private static final Logger log = LoggerFactory.getLogger(PriSalePrice2ServiceImpl.class);
    private final PriSalePriceService priSalePriceService;

    public ApiResult<PagingVO<PriSalePriceExportVO>> searchForExport(PriSalePricePagingParam paramVO) {
        PagingVO pageRespVOPagingVO = this.priSalePriceService.query(paramVO);
        List<PriSalePriceExportVO> salePriceExportVoS = pageRespVOPagingVO.getRecords().stream().map(PriSalePriceConvert.INSTANCE::respVoToExport).collect(Collectors.toList());
        long total = pageRespVOPagingVO.getTotal();
        this.transactionExport(salePriceExportVoS);
        return ApiResult.ok((Object)PagingVO.builder().total(total).records(salePriceExportVoS).build());
    }

    private void transactionExport(List<PriSalePriceExportVO> salePriceExportVoS) {
        salePriceExportVoS.forEach(sale -> {
            sale.setMarketPrice(sale.getMarketPrice() == null ? null : sale.getMarketPrice().setScale(4, 1));
            sale.setPrice(sale.getPrice() == null ? null : sale.getPrice().setScale(4, 1));
            sale.setGuidePrice(sale.getGuidePrice() == null ? null : sale.getGuidePrice().setScale(4, 1));
            sale.setPromotionPrice(sale.getPromotionPrice() == null ? null : sale.getPromotionPrice().setScale(4, 1));
            sale.setPromotionNetPrice(sale.getPromotionNetPrice() == null ? null : sale.getPromotionNetPrice().setScale(4, 1));
            sale.setTaxRate(sale.getTaxRate() == null ? null : sale.getTaxRate().setScale(2, 1));
            sale.setValidToLD(sale.getValidTo() == null ? null : sale.getValidTo().toString());
            sale.setValidFromLD(sale.getValidFrom() == null ? null : sale.getValidFrom().toString());
            sale.setModifyTimeLD(sale.getModifyTime() == null ? null : sale.getModifyTime().toString());
            sale.setCreateTimeLD(sale.getCreateTime() == null ? null : sale.getCreateTime().toString());
            sale.setPromDateFLD(sale.getPromDateF() == null ? null : sale.getPromDateF().toString());
            sale.setPromDateTLD(sale.getPromDateT() == null ? null : sale.getPromDateT().toString());
        });
    }

    public PriSalePrice2ServiceImpl(PriSalePriceService priSalePriceService) {
        this.priSalePriceService = priSalePriceService;
    }
}

