/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SalCommissionRuleService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionBatchParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleImportVO;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalCommissionRuleVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.SalCommissionRuleConvert;
import com.elitesland.yst.production.sale.entity.QSalCommissionRuleDO;
import com.elitesland.yst.production.sale.entity.SalCommissionRuleDO;
import com.elitesland.yst.production.sale.repo.SalCommissionRuleRepo;
import com.elitesland.yst.production.sale.repo.SalCommissionRuleRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalCommissionRuleServiceImpl
implements SalCommissionRuleService {
    private final RmiOrgOuService rmiOrgOuService;
    private final SalCommissionRuleRepo salCommissionRuleRepo;
    private final SalCommissionRuleRepoProc salCommissionRuleRepoProc;
    private final String RETURN = UdcEnum.SAL_COMMISSION_RULE_RETURN.getValueCode();
    private final String PROFIT = UdcEnum.SAL_COMMISSION_RULE_PROFIT.getValueCode();
    private final String PIECE = UdcEnum.SAL_COMMISSION_RULE_PIECE.getValueCode();
    private final Map<String, String> ruleMap = new HashMap<String, String>();
    private final Map<String, String> ruleNameMap;

    public ApiResult<SalCommissionRuleVO> findIdOne(Long id) {
        return ApiResult.ok();
    }

    public PagingVO<SalCommissionRuleVO> search(SalCommissionRuleParam param) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createOne(SalCommissionRuleCreateParam param) {
        if (StringUtils.isEmpty((CharSequence)param.getItemCode()) && StringUtils.isEmpty((CharSequence)param.getItemCateCode())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u5546\u54c1\u4fe1\u606f\uff01");
        }
        if (!StringUtils.isEmpty((CharSequence)param.getItemCode()) && !StringUtils.isEmpty((CharSequence)param.getItemCateCode())) {
            throw new BusinessException("\u5546\u54c1\u7f16\u7801\u548c\u5546\u54c1\u54c1\u7c7b\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getCommissionRule())) {
            throw new BusinessException("\u63d0\u6210\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.PIECE.equals(param.getCommissionRule())) {
            Assert.notNull((Object)param.getPieceWage(), (String)"\u9009\u62e9\u8ba1\u4ef6\u89c4\u5219\u65f6\uff0c\u8ba1\u4ef6\u63d0\u6210\u5fc5\u586b\uff01", (Object[])new Object[0]);
            Assert.isNull((Object)param.getPercentage(), (String)"\u9009\u62e9\u8ba1\u4ef6\u89c4\u5219\u65f6\uff0c\u4e0d\u80fd\u586b\u5199\u63d0\u6210\u767e\u5206\u6bd4\uff01", (Object[])new Object[0]);
            Assert.isTrue((BigDecimal.ZERO.compareTo(param.getPieceWage()) < 0 ? 1 : 0) != 0, (String)"\u9009\u62e9\u673a\u4ef6\u89c4\u5219\u65f6\uff0c\u8ba1\u4ef6\u63d0\u6210\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        } else if (this.RETURN.equals(param.getCommissionRule()) || this.PROFIT.equals(param.getCommissionRule())) {
            Assert.notNull((Object)param.getPercentage(), (String)"\u9009\u62e9\u56de\u6b3e\u6216\u6bdb\u5229\u89c4\u5219\u65f6\uff0c\u63d0\u6210\u767e\u5206\u6bd4\u5fc5\u586b\uff01", (Object[])new Object[0]);
            Assert.isNull((Object)param.getPieceWage(), (String)"\u9009\u62e9\u56de\u6b3e\u6216\u6bdb\u5229\u89c4\u5219\u65f6\uff0c\u4e0d\u80fd\u586b\u5199\u8ba1\u4ef6\u63d0\u6210\uff01", (Object[])new Object[0]);
            Assert.isTrue((BigDecimal.ZERO.compareTo(param.getPercentage()) < 0 ? 1 : 0) != 0, (String)"\u9009\u62e9\u56de\u6b3e\u6216\u6bdb\u5229\u89c4\u5219\u65f6\uff0c\u63d0\u6210\u767e\u5206\u6bd4\u5fc5\u586b\uff0c\u8ba1\u4ef6\u63d0\u6210\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        } else {
            throw new BusinessException("\u63d0\u6210\u89c4\u5219\u4f20\u53c2\u9519\u8bef\uff01");
        }
        List<SalCommissionRuleVO> unique = this.salCommissionRuleRepoProc.checkUnique(param);
        if (unique != null && unique.size() > 0) {
            SalCommissionRuleVO data = (SalCommissionRuleVO)this.findIdOne(unique.get(0).getId()).getData();
            String error = StringUtils.isNotBlank((CharSequence)data.getCateCodeName()) ? "\u5546\u54c1\u54c1\u7c7b\uff1a" + data.getCateCodeName() : "\u5546\u54c1\u7f16\u7801\uff1a" + data.getItemCode();
            throw new BusinessException(error + "\u8bb0\u5f55\u5df2\u5b58\u5728\uff01\u4e0d\u80fd\u6dfb\u52a0\uff01");
        }
        SalCommissionRuleDO salCommissionRuleDO = SalCommissionRuleConvert.INSTANCE.creatParamToDo(param);
        return ((SalCommissionRuleDO)this.salCommissionRuleRepo.save(salCommissionRuleDO)).getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void createBatch(SalCommissionBatchParam param) {
        Assert.notNull((Object)param.getOuId(), (String)"\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getOuCode(), (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getOuName(), (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getCommissionList(), (String)"\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((param.getCommissionList().size() > 0 ? 1 : 0) != 0, (String)"\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = param.getCommissionList();
        for (SalCommissionRuleCreateParam createParam : list) {
            createParam.setOuId(param.getOuId());
            createParam.setOuCode(param.getOuCode());
            createParam.setOuName(param.getOuName());
            this.createOne(createParam);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(SalCommissionBatchParam param) {
        Assert.notNull((Object)param.getOuId(), (String)"\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getOuCode(), (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getOuName(), (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getCommissionList(), (String)"\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((param.getCommissionList().size() > 0 ? 1 : 0) != 0, (String)"\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = param.getCommissionList();
        List update = list.stream().filter(r -> Objects.nonNull(r.getId())).collect(Collectors.toList());
        List create = list.stream().filter(r -> !Objects.nonNull(r.getId())).collect(Collectors.toList());
        for (SalCommissionRuleCreateParam uParam : update) {
            uParam.setOuId(param.getOuId());
            uParam.setOuCode(param.getOuCode());
            uParam.setOuName(param.getOuName());
            SalCommissionRuleDO objDo = SalCommissionRuleConvert.INSTANCE.creatParamToDo(uParam);
            this.checkData(objDo);
            this.salCommissionRuleRepo.save(objDo);
        }
        if (create.size() > 0) {
            param.setCommissionList(create);
            this.createBatch(param);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        QSalCommissionRuleDO jpaQDo = QSalCommissionRuleDO.salCommissionRuleDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.salCommissionRuleRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SalCommissionRuleDO do1 = (SalCommissionRuleDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.salCommissionRuleRepo.save(do1);
    }

    @Transactional(rollbackFor={Exception.class})
    public void importData(List<SalCommissionRuleImportVO> importData) {
    }

    private void checkData(SalCommissionRuleDO param) {
        if (StringUtils.isEmpty((CharSequence)param.getItemCode()) && StringUtils.isEmpty((CharSequence)param.getItemCateCode())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u5546\u54c1\u4fe1\u606f\uff01");
        }
        if (!StringUtils.isEmpty((CharSequence)param.getItemCode()) && !StringUtils.isEmpty((CharSequence)param.getItemCateCode())) {
            throw new BusinessException("\u5546\u54c1\u7f16\u7801\u548c\u5546\u54c1\u54c1\u7c7b\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)param.getCommissionRule())) {
            throw new BusinessException("\u63d0\u6210\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.PIECE.equals(param.getCommissionRule())) {
            Assert.notNull((Object)param.getPieceWage(), (String)"\u9009\u62e9\u8ba1\u4ef6\u89c4\u5219\u65f6\uff0c\u8ba1\u4ef6\u63d0\u6210\u5fc5\u586b\uff01", (Object[])new Object[0]);
            Assert.isNull((Object)param.getPercentage(), (String)"\u9009\u62e9\u8ba1\u4ef6\u89c4\u5219\u65f6\uff0c\u4e0d\u80fd\u586b\u5199\u63d0\u6210\u767e\u5206\u6bd4\uff01", (Object[])new Object[0]);
            Assert.isTrue((BigDecimal.ZERO.compareTo(param.getPieceWage()) < 0 ? 1 : 0) != 0, (String)"\u9009\u62e9\u673a\u4ef6\u89c4\u5219\u65f6\uff0c\u8ba1\u4ef6\u63d0\u6210\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        } else if (this.RETURN.equals(param.getCommissionRule()) || this.PROFIT.equals(param.getCommissionRule())) {
            Assert.notNull((Object)param.getPercentage(), (String)"\u9009\u62e9\u56de\u6b3e\u6216\u6bdb\u5229\u89c4\u5219\u65f6\uff0c\u63d0\u6210\u767e\u5206\u6bd4\u5fc5\u586b\uff01", (Object[])new Object[0]);
            Assert.isNull((Object)param.getPieceWage(), (String)"\u9009\u62e9\u56de\u6b3e\u6216\u6bdb\u5229\u89c4\u5219\u65f6\uff0c\u4e0d\u80fd\u586b\u5199\u8ba1\u4ef6\u63d0\u6210\uff01", (Object[])new Object[0]);
            Assert.isTrue((BigDecimal.ZERO.compareTo(param.getPercentage()) < 0 ? 1 : 0) != 0, (String)"\u9009\u62e9\u56de\u6b3e\u6216\u6bdb\u5229\u89c4\u5219\u65f6\uff0c\u63d0\u6210\u767e\u5206\u6bd4\u5fc5\u586b\uff0c\u8ba1\u4ef6\u63d0\u6210\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        } else {
            throw new BusinessException("\u63d0\u6210\u89c4\u5219\u4f20\u53c2\u9519\u8bef\uff01");
        }
    }

    private void checkImportData(SalCommissionRuleImportVO param) {
        Object matchCateName = "";
        if (StringUtils.isNotBlank((CharSequence)param.getCate1())) {
            matchCateName = param.getCate1() + param.getCate2() + param.getCate3();
        }
        String metaError = "\u516c\u53f8\u540d\u79f0\u4e3a\u3010" + param.getOuName() + "\u3011";
        if (StringUtils.isEmpty((CharSequence)param.getItemCode()) && StringUtils.isEmpty((CharSequence)matchCateName)) {
            throw new BusinessException(metaError + "\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)param.getOuCode())) {
            throw new BusinessException(metaError + "\u7684\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.isEmpty((CharSequence)param.getItemCode()) && !StringUtils.isEmpty((CharSequence)matchCateName)) {
            throw new BusinessException(metaError + "\u7684\u5546\u54c1\u7f16\u7801\u548c\u5546\u54c1\u54c1\u7c7b\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\uff01");
        }
        if (this.PIECE.equals(param.getCommissionRule())) {
            Assert.notNull((Object)param.getPieceWage(), (String)(metaError + "\u9009\u62e9\u8ba1\u4ef6\u89c4\u5219\u65f6\uff0c\u8ba1\u4ef6\u63d0\u6210\u5fc5\u586b\uff01"), (Object[])new Object[0]);
            Assert.isNull((Object)param.getPercentage(), (String)(metaError + "\u9009\u62e9\u8ba1\u4ef6\u89c4\u5219\u65f6\uff0c\u4e0d\u80fd\u586b\u5199\u63d0\u6210\u767e\u5206\u6bd4\uff01"), (Object[])new Object[0]);
            Assert.isTrue((BigDecimal.ZERO.compareTo(param.getPieceWage()) < 0 ? 1 : 0) != 0, (String)"\u9009\u62e9\u673a\u4ef6\u89c4\u5219\u65f6\uff0c\u8ba1\u4ef6\u63d0\u6210\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        } else if (this.RETURN.equals(param.getCommissionRule()) || this.PROFIT.equals(param.getCommissionRule())) {
            Assert.notNull((Object)param.getPercentage(), (String)(metaError + "\u9009\u62e9\u56de\u6b3e\u6216\u6bdb\u5229\u89c4\u5219\u65f6\uff0c\u63d0\u6210\u767e\u5206\u6bd4\u5fc5\u586b\uff01"), (Object[])new Object[0]);
            Assert.isNull((Object)param.getPieceWage(), (String)(metaError + "\u9009\u62e9\u56de\u6b3e\u6216\u6bdb\u5229\u89c4\u5219\u65f6\uff0c\u4e0d\u80fd\u586b\u5199\u8ba1\u4ef6\u63d0\u6210\uff01"), (Object[])new Object[0]);
            Assert.isTrue((BigDecimal.ZERO.compareTo(param.getPercentage()) < 0 ? 1 : 0) != 0, (String)(metaError + "\u9009\u62e9\u56de\u6b3e\u6216\u6bdb\u5229\u89c4\u5219\u65f6\uff0c\u63d0\u6210\u767e\u5206\u6bd4\u5fc5\u586b\uff0c\u8ba1\u4ef6\u63d0\u6210\u5fc5\u987b\u5927\u4e8e0\uff01"), (Object[])new Object[0]);
        } else {
            throw new BusinessException(metaError + "\u63d0\u6210\u89c4\u5219\u8f93\u5165\u9519\u8bef\uff01");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> list) {
        list.forEach(this::updateDeleteFlag);
    }

    public SalCommissionRuleServiceImpl(RmiOrgOuService rmiOrgOuService, SalCommissionRuleRepo salCommissionRuleRepo, SalCommissionRuleRepoProc salCommissionRuleRepoProc) {
        this.ruleMap.put(this.RETURN, UdcEnum.SAL_COMMISSION_RULE_RETURN.getValueCodeName());
        this.ruleMap.put(this.PROFIT, UdcEnum.SAL_COMMISSION_RULE_PROFIT.getValueCodeName());
        this.ruleMap.put(this.PIECE, UdcEnum.SAL_COMMISSION_RULE_PIECE.getValueCodeName());
        this.ruleNameMap = new HashMap<String, String>();
        this.ruleNameMap.put(UdcEnum.SAL_COMMISSION_RULE_RETURN.getValueCodeName(), this.RETURN);
        this.ruleNameMap.put(UdcEnum.SAL_COMMISSION_RULE_PROFIT.getValueCodeName(), this.PROFIT);
        this.ruleNameMap.put(UdcEnum.SAL_COMMISSION_RULE_PIECE.getValueCodeName(), this.PIECE);
        this.rmiOrgOuService = rmiOrgOuService;
        this.salCommissionRuleRepo = salCommissionRuleRepo;
        this.salCommissionRuleRepoProc = salCommissionRuleRepoProc;
    }
}

