/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.yst.production.pur.dto.PurPriceBaseDTO;
import com.elitesland.yst.production.pur.dto.PurPriceBatchParamDTO;
import com.elitesland.yst.production.pur.dto.PurPriceDetailParamDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.SalQuotationDService;
import com.elitesland.yst.production.sale.api.service.SalQuotationService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalQuotationQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationDRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationExportVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationPageRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.SalQuotationConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.QSalQuotationDDO;
import com.elitesland.yst.production.sale.entity.QSalQuotationDO;
import com.elitesland.yst.production.sale.entity.SalQuotationDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.SalQuotationRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCompanyManageRepoProc;
import com.elitesland.yst.production.sale.rmi.ystinv.RmiInvWhProviderService;
import com.elitesland.yst.production.sale.rmi.ystpur.RmiPurPriceService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiCityCodeService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiPriMainPriceService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.workflow.ProcDefKey;
import com.elitesland.yst.production.support.provider.item.param.ItmCheckBusinessStatusRpcParam;
import com.elitesland.yst.production.support.provider.item.param.ItmCheckLifeStatusRpcParam;
import com.elitesland.yst.production.support.provider.item.service.ItmItemRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgBuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.yst.production.support.provider.price.dto.PriMainPriceRpcDTO;
import com.google.common.collect.Sets;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="salQuotationServiceImpl")
public class SalQuotationServiceImpl
extends BaseServiceImpl
implements SalQuotationService {
    private static final Logger log = LoggerFactory.getLogger(SalQuotationServiceImpl.class);
    private static final QSalQuotationDO salQuotationDO = QSalQuotationDO.salQuotationDO;
    private static final QSalQuotationDDO salQuotationDDO = QSalQuotationDDO.salQuotationDDO;
    private final RmiInvWhProviderService rmiInvWhProviderService;
    private final RmiOrgEmpService rmiOrgEmpService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiOrgBuService rmiOrgBuService;
    private final SalQuotationDService salQuotationDService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final SalQuotationRepo salQuotationRepo;
    private final CrmCustRepoProc crmCustRepoProc;
    private final RmiCommonService rmiCommonService;
    private final RmiOrgAddrService rmiOrgAddrService;
    private final CrmCustService crmCustService;
    private final TransactionTemplate transactionTemplate;
    private final RmiPurPriceService rmiPurPriceService;
    private final RmiPriMainPriceService rmiPriMainPriceService;
    private final RmiCityCodeService rmiCityCodeService;
    private final BipCompanyManageRepoProc bipCompanyManageRepoProc;
    private final SysCurrencyRpcService sysCurrencyRpcService;
    private final ItmItemRpcService itemRpcService;
    private final WorkflowService workflowService;
    private final UdcProvider udcProvider;

    @SysCodeProc
    public PagingVO<SalQuotationPageRespVO> search(SalQuotationQueryParamVO searchParam) {
        JPAQuery<SalQuotationPageRespVO> jpaQuery = this.select(searchParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(searchParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, salQuotationDO);
        List respVOS = jpaQuery.fetch();
        this.translatePage(respVOS);
        return PagingVO.builder().total(total).records(respVOS).build();
    }

    public JPAQuery<SalQuotationPageRespVO> select(SalQuotationQueryParamVO searchParam) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalQuotationPageRespVO.class, (Expression[])new Expression[]{SalQuotationServiceImpl.salQuotationDO.id, SalQuotationServiceImpl.salQuotationDO.qtCustType, SalQuotationServiceImpl.salQuotationDO.custCode, SalQuotationServiceImpl.salQuotationDO.custName, SalQuotationServiceImpl.salQuotationDO.ouId, SalQuotationServiceImpl.salQuotationDO.buId, SalQuotationServiceImpl.salQuotationDO.agentEmpId, SalQuotationServiceImpl.salQuotationDO.quotationDate, SalQuotationServiceImpl.salQuotationDO.quotationStatus, SalQuotationServiceImpl.salQuotationDO.approvedTime, SalQuotationServiceImpl.salQuotationDO.apprUserId, SalQuotationServiceImpl.salQuotationDO.whId, SalQuotationServiceImpl.salQuotationDO.netAmt, SalQuotationServiceImpl.salQuotationDO.amt, SalQuotationServiceImpl.salQuotationDO.payMethod, SalQuotationServiceImpl.salQuotationDO.custContactName, SalQuotationServiceImpl.salQuotationDO.custContactTel, SalQuotationServiceImpl.salQuotationDO.demandTimespan, SalQuotationServiceImpl.salQuotationDO.deliverMethod, SalQuotationServiceImpl.salQuotationDO.recvAddrNo, SalQuotationServiceImpl.salQuotationDO.recvDetailaddr, SalQuotationServiceImpl.salQuotationDO.currCode, SalQuotationServiceImpl.salQuotationDO.taxAmt, SalQuotationServiceImpl.salQuotationDO.docNo, SalQuotationServiceImpl.salQuotationDO.remark, SalQuotationServiceImpl.salQuotationDO.saleRegion})).from((EntityPath)salQuotationDO);
        if (searchParam != null) {
            jpaQuery.where(this.where(searchParam));
        }
        return jpaQuery;
    }

    private void translatePage(List<SalQuotationPageRespVO> respVOS) {
        if (CollectionUtils.isEmpty(respVOS)) {
            return;
        }
        List agentEmpIds = respVOS.stream().map(SalQuotationPageRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List apprAppIds = respVOS.stream().map(SalQuotationPageRespVO::getApprUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<Object> empDtoByParam = new ArrayList();
        agentEmpIds.addAll(apprAppIds);
        List empIds = agentEmpIds.stream().distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(empIds)) {
            orgEmpRpcDtoParam.setEmpIds(empIds);
            empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        List buIds = respVOS.stream().map(SalQuotationPageRespVO::getBuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Object> buDtoByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(buIds)) {
            orgBuRpcDtoParam.setBuIds(buIds);
            buDtoByParam = this.rmiOrgBuService.findBuDtoByParam(orgBuRpcDtoParam);
        }
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        List ouIds = respVOS.stream().map(SalQuotationPageRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Object> ouDtoListByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(ouIds)) {
            orgOuRpcDtoParam.setOuIds(ouIds);
            ouDtoListByParam = this.rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        }
        List<Long> whIds = respVOS.stream().map(SalQuotationPageRespVO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Object> dtoByPara = new ArrayList();
        if (!CollectionUtils.isEmpty(whIds)) {
            dtoByPara = this.rmiInvWhProviderService.findBuDtoByParam(whIds);
        }
        Set currCodes = respVOS.stream().map(SalQuotationPageRespVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
        List currDtoList = new ArrayList();
        if (!CollectionUtils.isEmpty(currCodes)) {
            ApiResult sysCurrencyRespDTOListApiResult = this.sysCurrencyRpcService.listByCodes(currCodes);
            Assert.notNull((Object)sysCurrencyRespDTOListApiResult, (String)"\u6839\u636e\u7f16\u7801\u67e5\u8be2\u5e01\u79cd\u5931\u8d25", (Object[])new Object[0]);
            Assert.isTrue((boolean)sysCurrencyRespDTOListApiResult.isSuccess(), (String)"\u6839\u636e\u7f16\u7801\u67e5\u8be2\u5e01\u79cd\u5931\u8d25", (Object[])new Object[0]);
            currDtoList = (List)this.sysCurrencyRpcService.listByCodes(currCodes).getData();
        }
        List<Object> finalEmpDtoByParam = empDtoByParam;
        List<Object> finalBuDtoByParam = buDtoByParam;
        List<Object> finalOuDtoListByParam = ouDtoListByParam;
        List<Object> finalDtoByPara = dtoByPara;
        ArrayList finalCurrDtoList = currDtoList;
        for (SalQuotationPageRespVO quo : respVOS) {
            if (!StringUtils.isEmpty((Object)quo.getAgentEmpId())) {
                finalEmpDtoByParam.stream().filter(salQuo -> quo.getAgentEmpId().equals(salQuo.getId())).findFirst().ifPresent(sal -> quo.setAgentEmpName(sal.getEmpName()));
            }
            if (!StringUtils.isEmpty((Object)quo.getBuId())) {
                finalBuDtoByParam.stream().filter(salQuo -> quo.getBuId().equals(salQuo.getId())).findFirst().ifPresent(sal -> quo.setBuName(sal.getBuName()));
            }
            if (!StringUtils.isEmpty((Object)quo.getOuId())) {
                finalOuDtoListByParam.stream().filter(salQuo -> quo.getOuId().equals(salQuo.getId())).findFirst().ifPresent(sal -> quo.setOuName(sal.getOuName()));
            }
            if (!StringUtils.isEmpty((Object)quo.getWhId())) {
                finalDtoByPara.stream().filter(salQuo -> quo.getWhId().equals(salQuo.getWhId())).findFirst().ifPresent(sal -> quo.setWhName(sal.getWhName()));
            }
            if (!StringUtils.isEmpty((Object)quo.getCurrCode())) {
                finalCurrDtoList.stream().filter(salQuo -> quo.getCurrCode().equals(salQuo.getCurrCode())).findFirst().ifPresent(sal -> quo.setCurrCodeName(sal.getCurrName()));
            }
            if (StringUtils.isEmpty((Object)quo.getApprUserId())) continue;
            finalEmpDtoByParam.stream().filter(salQuo -> quo.getApprUserId().equals(salQuo.getId())).findFirst().ifPresent(sal -> quo.setApprUserName(sal.getEmpName()));
        }
    }

    public Predicate where(SalQuotationQueryParamVO param) {
        BooleanExpression predicate = salQuotationDO.isNotNull();
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.deleteFlag.ne((Object)1));
        if (!StringUtils.isEmpty((Object)param.getId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.id.eq((Object)param.getId()));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.id.in((Collection)param.getIds()));
        }
        if (!StringUtils.isEmpty((Object)param.getQtCustType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.qtCustType.eq((Object)param.getQtCustType()));
        }
        if (!StringUtils.isEmpty((Object)param.getCustCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.custCode.like("%" + param.getCustCode() + "%"));
        }
        if (!StringUtils.isEmpty((Object)param.getCustName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.custName.like("%" + param.getCustName() + "%"));
        }
        if (!StringUtils.isEmpty((Object)param.getOuId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.ouId.eq((Object)param.getOuId()));
        }
        if (!StringUtils.isEmpty((Object)param.getBuId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.buId.eq((Object)param.getBuId()));
        }
        if (!StringUtils.isEmpty((Object)param.getAgentEmpId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.agentEmpId.eq((Object)param.getAgentEmpId()));
        }
        if (!StringUtils.isEmpty((Object)param.getBeginQuotationDate())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.quotationDate.eq((Object)param.getBeginQuotationDate()).or((Predicate)SalQuotationServiceImpl.salQuotationDO.quotationDate.after((Comparable)param.getBeginQuotationDate())));
        }
        if (!StringUtils.isEmpty((Object)param.getEndQuotationDate())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.quotationDate.eq((Object)param.getEndQuotationDate()).or((Predicate)SalQuotationServiceImpl.salQuotationDO.quotationDate.before((Comparable)param.getEndQuotationDate())));
        }
        if (!StringUtils.isEmpty((Object)param.getQuotationStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.quotationStatus.eq((Object)param.getQuotationStatus()));
        }
        if (!StringUtils.isEmpty((Object)param.getBeginApprTime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.approvedTime.eq((Object)param.getBeginApprTime()).or((Predicate)SalQuotationServiceImpl.salQuotationDO.approvedTime.after((Comparable)param.getBeginApprTime())));
        }
        if (!StringUtils.isEmpty((Object)param.getEndApprTime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.approvedTime.eq((Object)param.getEndApprTime()).or((Predicate)SalQuotationServiceImpl.salQuotationDO.approvedTime.before((Comparable)param.getBeginApprTime())));
        }
        if (!StringUtils.isEmpty((Object)param.getApprUserId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.apprUserId.eq((Object)param.getApprUserId()));
        }
        if (!StringUtils.isEmpty((Object)param.getDocNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.docNo.eq((Object)param.getDocNo()));
        }
        if (!StringUtils.isEmpty((Object)param.getSaleRegion())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.saleRegion.eq((Object)param.getSaleRegion()));
        }
        if (!ObjectUtils.isEmpty((Object)param.getIfCheckApprovalFlag()) && param.getIfCheckApprovalFlag().equals(Boolean.TRUE)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.quotationStatus.eq((Object)UdcEnum.SAL_QUOTATION_STATUS_APPROVED.getValueCode()).or((Predicate)SalQuotationServiceImpl.salQuotationDO.quotationStatus.eq((Object)UdcEnum.SAL_QUOTATION_STATUS_REJECTED.getValueCode())));
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)salQuotationDO.getMetadata()));
        return predicate;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long submitSalQuotation(SalQuotationDetailRespVO salQuotationDetailRespVO) {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        this.checkFreeze(salQuotationDetailRespVO);
        this.transactionTemplate.setPropagationBehavior(3);
        SalQuotationDO quotationDO1 = (SalQuotationDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                Long salQuotationId = this.createSalQuotation(salQuotationDetailRespVO);
                return (SalQuotationDO)this.salQuotationRepo.findById(salQuotationId).get();
            }
            catch (Exception e) {
                transactionStatus.setRollbackOnly();
                throw e;
            }
        });
        quotationDO1.setQuotationStatus(UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode());
        SalQuotationDO quotationDO = (SalQuotationDO)this.salQuotationRepo.save(quotationDO1);
        if (StringUtils.isEmpty((Object)quotationDO1.getId()) || StringUtils.isEmpty((Object)quotationDO1.getProcInstId()) || WorkflowConstant.CAN_START_PROC_STATUSES.contains(quotationDO1.getProcInstStatus())) {
            String procInstName = null;
            ProcDefKey procDefKey = null;
            procInstName = "B\u7aef\u9500\u552e\u62a5\u4ef7\u5355";
            procDefKey = ProcDefKey.SAL_QUOTATION;
            HashMap<String, Integer> variables = new HashMap<String, Integer>();
            Boolean aBoolean = this.processBranchControl(salQuotationDetailRespVO);
            if (aBoolean.equals(Boolean.TRUE)) {
                variables.put("belowPrice", 1);
            } else {
                variables.put("belowPrice", 0);
            }
            WorkflowResult processInfo = this.workflowService.startProcess(StartProcessPayload.of((String)procDefKey.name(), (String)(procInstName + "-" + quotationDO1.getDocNo()), (String)("" + quotationDO1.getId()), variables));
            if (ObjectUtils.isEmpty((Object)processInfo)) {
                throw new BusinessException("\u5de5\u4f5c\u6d41\u542f\u52a8\u670d\u52a1\u5931\u8d25,\u8bf7\u68c0\u67e5");
            }
            Assert.isTrue((boolean)processInfo.isSuccess(), (String)"\u5de5\u4f5c\u6d41\u542f\u52a8\u670d\u52a1\u5931\u8d25,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            log.info("\u5de5\u4f5c\u6d41\u542f\u52a8\u8fd4\u56de\u53c2\u6570{}", (Object)JSON.toJSONString((Object)processInfo));
            QSalQuotationDO qSalQuotationDO = QSalQuotationDO.salQuotationDO;
            JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qSalQuotationDO).set((Path)qSalQuotationDO.procInstId, (Object)((ProcessInfo)processInfo.getData()).getProcInstId()).set(qSalQuotationDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qSalQuotationDO.id.eq((Object)quotationDO1.getId())});
            if (!Objects.equals(((ProcessInfo)processInfo.getData()).getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(qSalQuotationDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                jpaUpdateClause.set((Path)qSalQuotationDO.quotationStatus, (Object)UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode());
            }
            jpaUpdateClause.execute();
        }
        return quotationDO.getId();
    }

    private Boolean processBranchControl(SalQuotationDetailRespVO salQuotationDetailRespVO) {
        List salQuotationDRespVO = salQuotationDetailRespVO.getSalQuotationDRespVO();
        if (!CollectionUtils.isEmpty((Collection)salQuotationDRespVO)) {
            BigDecimal amt = salQuotationDRespVO.stream().map(SalQuotationDRespVO::getAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            PurPriceBatchParamDTO purPriceParam = new PurPriceBatchParamDTO();
            purPriceParam.setOuId(salQuotationDetailRespVO.getOuId());
            purPriceParam.setValidDate(LocalDate.now());
            List collect = salQuotationDRespVO.stream().map(vi -> {
                PurPriceDetailParamDTO detail = new PurPriceDetailParamDTO();
                detail.setItemId(vi.getItemId());
                detail.setUom(vi.getUom());
                detail.setCurrCode(salQuotationDetailRespVO.getCurrCode());
                return detail;
            }).collect(Collectors.toList());
            purPriceParam.setPurPriceDetailParamDtoList(collect);
            List<PurPriceBaseDTO> purPriRpcResult = this.rmiPurPriceService.getPriceListByParam(purPriceParam);
            log.info("\u67e5\u8be2\u91c7\u8d2d\u4ef7\u683c\u7ed3\u679c{}", (Object)JSON.toJSONString(purPriRpcResult));
            List<Long> itemIds = salQuotationDRespVO.stream().map(SalQuotationDRespVO::getItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            List<Object> mainPriceDtoList = new ArrayList();
            if (!CollectionUtils.isEmpty(itemIds)) {
                mainPriceDtoList = this.rmiPriMainPriceService.findMainPriceDtoList(itemIds, null);
            }
            log.info("\u67e5\u8be2B\u7aef\u6bdb\u5229\u63a7\u5236\u7387\u7ed3\u679c{}", (Object)JSON.toJSONString(mainPriceDtoList));
            List<Object> priMainPriceRpcDTOS = mainPriceDtoList;
            ArrayList grossPrices = new ArrayList();
            BigDecimal floorPrice = salQuotationDRespVO.stream().map(sal -> {
                Optional<PriMainPriceRpcDTO> priMainPriceRpcDTO;
                BigDecimal purPrice = BigDecimal.ZERO;
                BigDecimal grossProfit = BigDecimal.ZERO;
                Optional<PurPriceBaseDTO> purPriceBaseDTO = purPriRpcResult.stream().filter(pur -> sal.getItemId().equals(pur.getItemId()) && sal.getUom().equals(pur.getToUom())).findFirst();
                if (purPriceBaseDTO.isPresent() && !ObjectUtils.isEmpty((Object)purPriceBaseDTO.get()) && !ObjectUtils.isEmpty((Object)purPriceBaseDTO.get().getPrice())) {
                    purPrice = purPriceBaseDTO.get().getPrice();
                }
                if ((priMainPriceRpcDTO = priMainPriceRpcDTOS.stream().filter(itm -> itm.getItemId().equals(sal.getItemId())).findFirst()).isPresent()) {
                    grossProfit = priMainPriceRpcDTO.get().getPrice4();
                }
                BigDecimal grossPrice = purPrice.divide(BigDecimal.ONE.subtract(grossProfit), 4, RoundingMode.HALF_UP);
                grossPrices.add(grossPrice);
                return grossPrice.multiply(BigDecimal.valueOf(sal.getQty()));
            }).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("\u5546\u54c1\u7684\u9500\u552e\u5e95\u4ef7\u6253\u5370{}", (Object)JSON.toJSONString(grossPrices));
            log.info("\u5546\u54c1\u7684\u9500\u552e\u5e95\u4ef7\u603b\u91d1\u989d{}", (Object)floorPrice);
            if (amt.compareTo(floorPrice) == -1) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    private void checkFreeze(SalQuotationDetailRespVO saveVO) {
        log.info("\u62a5\u4ef7\u5355\u51bb\u7ed3\u68c0\u9a8c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saveVO));
        Assert.notNull((Object)saveVO.getOuCode(), (String)"\u51bb\u7ed3\u6821\u9a8c\u65f6\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ItmCheckLifeStatusRpcParam param = new ItmCheckLifeStatusRpcParam();
        param.setBusinessCode("S004");
        param.setItemLifeStatus("SALE_FREEZE");
        param.setStatusTime(LocalDateTime.now());
        ArrayList<ItmCheckBusinessStatusRpcParam> businessList = new ArrayList<ItmCheckBusinessStatusRpcParam>();
        for (SalQuotationDRespVO respVO : saveVO.getSalQuotationDRespVO()) {
            ItmCheckBusinessStatusRpcParam business = new ItmCheckBusinessStatusRpcParam();
            business.setBuCode(saveVO.getOuCode());
            business.setItemCode(respVO.getItemCode());
            businessList.add(business);
        }
        param.setBusinessList(businessList);
        log.info("\u652f\u6491\u57df\u62a5\u4ef7\u5355\u51bb\u7ed3\u68c0\u9a8c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)param));
        this.itemRpcService.checkItemLifeStatusConfigByParam(param);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createSalQuotation(SalQuotationDetailRespVO saveVO) {
        SalQuotationConvert salQuotationConvert = SalQuotationConvert.INSTANCE;
        if (StringUtils.isEmpty((Object)saveVO.getId()) && StringUtils.isEmpty((Object)saveVO.getDocNo())) {
            String salQuoDocNo = this.rmiSysNextNumberService.generateCode("yst-sale", "QT", null);
            saveVO.setDocNo(salQuoDocNo);
        }
        this.checkForSave(saveVO);
        this.checkFreeze(saveVO);
        if (StringUtils.isEmpty((Object)saveVO.getId())) {
            saveVO.setQuotationStatus(UdcEnum.SAL_QUOTATION_STATUS_DRAFT.getValueCode());
        }
        SalQuotationDO save = (SalQuotationDO)this.salQuotationRepo.save(salQuotationConvert.detailRespVOToDo(saveVO));
        save.setSecBuId(saveVO.getBuId());
        save.setSecOuId(saveVO.getOuId());
        save.setSecUserId(saveVO.getAgentEmpId());
        List salQuotationDRespVo = saveVO.getSalQuotationDRespVO();
        if (!StringUtils.isEmpty((Object)salQuotationDRespVo)) {
            salQuotationDRespVo.forEach(sal -> sal.setMasId(save.getId()));
            this.salQuotationDService.createSalQuotationD(salQuotationDRespVo, saveVO.getId());
        }
        return save.getId();
    }

    @SysCodeProc
    public ApiResult<PagingVO<SalQuotationExportVO>> searchForExport(SalQuotationQueryParamVO paramVO) {
        JPAQuery<SalQuotationExportVO> jpaQuery = this.selectForExport(paramVO);
        ((JPAQuery)((JPAQuery)jpaQuery.orderBy(SalQuotationServiceImpl.salQuotationDO.docNo.desc())).offset((long)Math.multiplyExact(paramVO.getCurrent(), (int)paramVO.getSize()))).limit((long)paramVO.getSize().intValue());
        long total = jpaQuery.fetchCount();
        List respVOList = jpaQuery.fetch();
        this.translateForExport(respVOList);
        return ApiResult.ok((Object)PagingVO.builder().total(total).records(respVOList).build());
    }

    @SysCodeProc
    public SalQuotationDetailRespVO findSalQuotationById(Long id) {
        SalQuotationDetailRespVO salQuotationDetailRespVO;
        SalQuotationQueryParamVO salQuotationQueryParamVO = new SalQuotationQueryParamVO();
        salQuotationQueryParamVO.setId(id);
        List salQuotationDetailRespVOS = this.selectDetail(salQuotationQueryParamVO).fetch();
        if (!CollectionUtils.isEmpty((Collection)salQuotationDetailRespVOS)) {
            salQuotationDetailRespVO = (SalQuotationDetailRespVO)salQuotationDetailRespVOS.get(0);
            if (!StringUtils.isEmpty((Object)salQuotationDetailRespVO.getAmt())) {
                salQuotationDetailRespVO.setAmt(salQuotationDetailRespVO.getAmt().setScale(2, 1));
            }
            if (!StringUtils.isEmpty((Object)salQuotationDetailRespVO.getTaxAmt())) {
                salQuotationDetailRespVO.setTaxAmt(salQuotationDetailRespVO.getTaxAmt().setScale(2, 1));
            }
            if (!StringUtils.isEmpty((Object)salQuotationDetailRespVO.getNetAmt())) {
                salQuotationDetailRespVO.setNetAmt(salQuotationDetailRespVO.getNetAmt().setScale(2, 1));
            }
        } else {
            throw new BusinessException("\u8be5\u9500\u552e\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        List salQuotationD = this.salQuotationDService.findSalQuotationdByMasId(id);
        this.amountProcess(salQuotationD);
        salQuotationDetailRespVO.setSalQuotationDRespVO(salQuotationD);
        this.translateDetail(salQuotationDetailRespVO);
        return salQuotationDetailRespVO;
    }

    private void translateDetail(SalQuotationDetailRespVO salQuotationDetailRespVO) {
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        if (!StringUtils.isEmpty((Object)salQuotationDetailRespVO.getAgentEmpId())) {
            ArrayList<Long> agentEmpIds = new ArrayList<Long>();
            agentEmpIds.add(salQuotationDetailRespVO.getAgentEmpId());
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            List<OrgEmpRpcDTO> empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
            empDtoByParam.stream().findFirst().ifPresent(emp -> salQuotationDetailRespVO.setAgentEmpName(emp.getEmpName()));
        }
        OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        if (!StringUtils.isEmpty((Object)salQuotationDetailRespVO.getBuId())) {
            ArrayList<Long> buIds = new ArrayList<Long>();
            buIds.add(salQuotationDetailRespVO.getBuId());
            orgBuRpcDtoParam.setBuIds(buIds);
            List<OrgBuRpcDTO> buDtoByParam = this.rmiOrgBuService.findBuDtoByParam(orgBuRpcDtoParam);
            buDtoByParam.stream().findFirst().ifPresent(bu -> salQuotationDetailRespVO.setBuName(bu.getBuName()));
        }
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        if (!StringUtils.isEmpty((Object)salQuotationDetailRespVO.getOuId())) {
            ArrayList<Long> ouIds = new ArrayList<Long>();
            ouIds.add(salQuotationDetailRespVO.getOuId());
            orgOuRpcDtoParam.setOuIds(ouIds);
            List<OrgOuRpcDTO> ouDtoListByParam = this.rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
            ouDtoListByParam.stream().findFirst().ifPresent(ou -> {
                salQuotationDetailRespVO.setOuName(ou.getOuName());
                salQuotationDetailRespVO.setOuCode(ou.getOuCode());
            });
        }
        if (!StringUtils.isEmpty((Object)salQuotationDetailRespVO.getCurrCode())) {
            HashSet<String> currCodes = new HashSet<String>();
            currCodes.add(salQuotationDetailRespVO.getCurrCode());
            ApiResult sysCurrencyRespDTOListApiResult = this.sysCurrencyRpcService.listByCodes(currCodes);
            ((List)sysCurrencyRespDTOListApiResult.getData()).stream().filter(salQuo -> salQuotationDetailRespVO.getCurrCode().equals(salQuo.getCurrCode())).findFirst().ifPresent(sal -> salQuotationDetailRespVO.setCurrCodeName(sal.getCurrName()));
        }
        OrgEmpRpcDtoParam orgEmpRpcDtoParam1 = new OrgEmpRpcDtoParam();
        if (!StringUtils.isEmpty((Object)salQuotationDetailRespVO.getApprUserId())) {
            ArrayList<Long> agentEmpIds = new ArrayList<Long>();
            agentEmpIds.add(salQuotationDetailRespVO.getApprUserId());
            orgEmpRpcDtoParam1.setEmpIds(agentEmpIds);
            List<OrgEmpRpcDTO> empDtoByParam1 = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam1);
            empDtoByParam1.stream().findFirst().ifPresent(emp -> salQuotationDetailRespVO.setApprUserName(emp.getEmpName()));
        }
        if (!ObjectUtils.isEmpty((Object)salQuotationDetailRespVO.getContractCity())) {
            String[] cityCodes = salQuotationDetailRespVO.getContractCity().split("/");
            SysAreaQueryDTO sysAreaQueryDTO = new SysAreaQueryDTO();
            HashSet<String> cityCodeLists = new HashSet<String>();
            for (int i = 0; i < cityCodes.length; ++i) {
                cityCodeLists.add(cityCodes[i]);
            }
            sysAreaQueryDTO.setAreaCodes(cityCodeLists);
            List<SysAreaRespDTO> cityCodeListByParam = this.rmiCityCodeService.findCityCodeListByParam(sysAreaQueryDTO);
            StringBuilder cityNames = new StringBuilder();
            for (int k = 0; k < cityCodes.length; ++k) {
                String finalK = cityCodes[k];
                cityCodeListByParam.stream().filter(city -> city.getAreaCode().equals(finalK)).findFirst().ifPresent(c -> cityNames.append(c.getAreaName()));
                if (k == cityCodes.length - 1) continue;
                cityNames.append("/");
            }
            salQuotationDetailRespVO.setContractCityName(cityNames.toString());
        }
    }

    private void amountProcess(List<SalQuotationDRespVO> salQuotationDRespVo) {
        salQuotationDRespVo.forEach(sal -> {
            if (!StringUtils.isEmpty((Object)sal.getPrice())) {
                sal.setPrice(sal.getPrice().setScale(4, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getAmt())) {
                sal.setAmt(sal.getAmt().setScale(2, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getNetAmt())) {
                sal.setNetAmt(sal.getNetAmt().setScale(2, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getNetPrice())) {
                sal.setNetPrice(sal.getNetPrice().setScale(4, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getTaxAmt())) {
                sal.setTaxAmt(sal.getTaxAmt().setScale(2, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getTaxRate())) {
                sal.setTaxRate(sal.getTaxRate().setScale(2, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getDiscRatio())) {
                sal.setDiscRatio(sal.getDiscRatio().setScale(2, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getDiscAmt())) {
                sal.setDiscAmt(sal.getDiscAmt().setScale(2, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getPriceOrig())) {
                sal.setPriceOrig(sal.getPriceOrig().setScale(4, 1));
            }
        });
    }

    public JPAQuery<SalQuotationDetailRespVO> selectDetail(SalQuotationQueryParamVO searchParam) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalQuotationDetailRespVO.class, (Expression[])new Expression[]{SalQuotationServiceImpl.salQuotationDO.id, SalQuotationServiceImpl.salQuotationDO.qtCustType, SalQuotationServiceImpl.salQuotationDO.custCode, SalQuotationServiceImpl.salQuotationDO.custName, SalQuotationServiceImpl.salQuotationDO.ouId, SalQuotationServiceImpl.salQuotationDO.buId, SalQuotationServiceImpl.salQuotationDO.agentEmpId, SalQuotationServiceImpl.salQuotationDO.quotationDate, SalQuotationServiceImpl.salQuotationDO.quotationStatus, SalQuotationServiceImpl.salQuotationDO.approvedTime, SalQuotationServiceImpl.salQuotationDO.apprUserId, SalQuotationServiceImpl.salQuotationDO.whId, SalQuotationServiceImpl.salQuotationDO.netAmt, SalQuotationServiceImpl.salQuotationDO.amt, SalQuotationServiceImpl.salQuotationDO.payMethod, SalQuotationServiceImpl.salQuotationDO.custContactName, SalQuotationServiceImpl.salQuotationDO.custContactTel, SalQuotationServiceImpl.salQuotationDO.demandTimespan, SalQuotationServiceImpl.salQuotationDO.deliverMethod, SalQuotationServiceImpl.salQuotationDO.recvAddrNo, SalQuotationServiceImpl.salQuotationDO.recvDetailaddr, SalQuotationServiceImpl.salQuotationDO.currCode, SalQuotationServiceImpl.salQuotationDO.taxAmt, SalQuotationServiceImpl.salQuotationDO.docNo, SalQuotationServiceImpl.salQuotationDO.remark, SalQuotationServiceImpl.salQuotationDO.saleRegion, SalQuotationServiceImpl.salQuotationDO.contractCity, SalQuotationServiceImpl.salQuotationDO.projId, SalQuotationServiceImpl.salQuotationDO.projName, SalQuotationServiceImpl.salQuotationDO.projNo, SalQuotationServiceImpl.salQuotationDO.custId, SalQuotationServiceImpl.salQuotationDO.procInstId})).from((EntityPath)salQuotationDO);
        if (searchParam != null) {
            jpaQuery.where(this.detailWhere(searchParam));
        }
        return jpaQuery;
    }

    public Predicate detailWhere(SalQuotationQueryParamVO param) {
        BooleanExpression predicate = salQuotationDO.isNotNull();
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.deleteFlag.ne((Object)1));
        if (!StringUtils.isEmpty((Object)param.getId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.id.eq((Object)param.getId()));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.id.in((Collection)param.getIds()));
        }
        if (!StringUtils.isEmpty((Object)param.getQtCustType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.qtCustType.eq((Object)param.getQtCustType()));
        }
        if (!StringUtils.isEmpty((Object)param.getCustCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.custCode.like("%" + param.getCustCode() + "%"));
        }
        if (!StringUtils.isEmpty((Object)param.getCustName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.custName.like("%" + param.getCustName() + "%"));
        }
        if (!StringUtils.isEmpty((Object)param.getOuId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.ouId.eq((Object)param.getOuId()));
        }
        if (!StringUtils.isEmpty((Object)param.getBuId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.buId.eq((Object)param.getBuId()));
        }
        if (!StringUtils.isEmpty((Object)param.getAgentEmpId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.agentEmpId.eq((Object)param.getAgentEmpId()));
        }
        if (!StringUtils.isEmpty((Object)param.getBeginQuotationDate())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.quotationDate.eq((Object)param.getBeginQuotationDate()).or((Predicate)SalQuotationServiceImpl.salQuotationDO.quotationDate.after((Comparable)param.getBeginQuotationDate())));
        }
        if (!StringUtils.isEmpty((Object)param.getEndQuotationDate())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.quotationDate.eq((Object)param.getEndQuotationDate()).or((Predicate)SalQuotationServiceImpl.salQuotationDO.quotationDate.before((Comparable)param.getEndQuotationDate())));
        }
        if (!StringUtils.isEmpty((Object)param.getQuotationStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.quotationStatus.eq((Object)param.getQuotationStatus()));
        }
        if (!StringUtils.isEmpty((Object)param.getBeginApprTime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.approvedTime.eq((Object)param.getBeginApprTime()).or((Predicate)SalQuotationServiceImpl.salQuotationDO.approvedTime.after((Comparable)param.getBeginApprTime())));
        }
        if (!StringUtils.isEmpty((Object)param.getEndApprTime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.approvedTime.eq((Object)param.getEndApprTime()).or((Predicate)SalQuotationServiceImpl.salQuotationDO.approvedTime.before((Comparable)param.getBeginApprTime())));
        }
        if (!StringUtils.isEmpty((Object)param.getApprUserId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.apprUserId.eq((Object)param.getApprUserId()));
        }
        if (!StringUtils.isEmpty((Object)param.getDocNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.docNo.eq((Object)param.getDocNo()));
        }
        if (!StringUtils.isEmpty((Object)param.getSaleRegion())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalQuotationServiceImpl.salQuotationDO.saleRegion.eq((Object)param.getSaleRegion()));
        }
        return predicate;
    }

    private void translateForExport(List<SalQuotationExportVO> respVOList) {
        if (CollectionUtils.isEmpty(respVOList)) {
            return;
        }
        List sysUdcDTOList = this.udcProvider.listByUdcCode("yst-supp", (Set)Sets.newHashSet((Object[])new String[]{"UOM"}));
        List agentEmpIds = respVOList.stream().map(SalQuotationExportVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<Object> empDtoByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        List ouIds = respVOList.stream().map(SalQuotationExportVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Object> ouDtoListByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(ouIds)) {
            orgOuRpcDtoParam.setOuIds(ouIds);
            ouDtoListByParam = this.rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        }
        ArrayList finalOuDtoListByParam = ouDtoListByParam;
        List<Object> finalEmpDtoByParam = empDtoByParam;
        respVOList.forEach(sal -> {
            finalOuDtoListByParam.stream().filter(ou -> sal.getOuId().equals(ou.getId())).findFirst().ifPresent(salOu -> sal.setOuName(salOu.getOuName()));
            finalEmpDtoByParam.stream().filter(emp -> sal.getAgentEmpId().equals(emp.getId())).findFirst().ifPresent(salEmp -> sal.setAgentEmpName(salEmp.getEmpName()));
            if (!StringUtils.isEmpty((Object)sal.getUom())) {
                sysUdcDTOList.stream().filter(uom -> sal.getUom().equals(uom.getUdcCode())).findFirst().ifPresent(uomUdc -> sal.setUomName(uomUdc.getUdcDescribe()));
            }
            if (!StringUtils.isEmpty((Object)sal.getPrice())) {
                sal.setPrice(sal.getPrice().setScale(4, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getTaxRate())) {
                BigDecimal decimal = sal.getTaxRate().setScale(2, 1);
                BigDecimal decimal1 = decimal.multiply(BigDecimal.valueOf(100L));
                sal.setTaxRate2(decimal1 + "%");
            }
            if (!StringUtils.isEmpty((Object)sal.getAmt())) {
                sal.setAmt(sal.getAmt().setScale(2, 1));
            }
            if (!StringUtils.isEmpty((Object)sal.getQuotationDate())) {
                LocalDate localDate = sal.getQuotationDate().toLocalDate();
                sal.setQuotationDate2(localDate);
            }
        });
    }

    @SysCodeProc
    public JPAQuery<SalQuotationExportVO> selectForExport(SalQuotationQueryParamVO queryParam) {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalQuotationExportVO.class, (Expression[])new Expression[]{SalQuotationServiceImpl.salQuotationDO.ouId, SalQuotationServiceImpl.salQuotationDO.agentEmpId, SalQuotationServiceImpl.salQuotationDO.docNo, SalQuotationServiceImpl.salQuotationDO.quotationDate, SalQuotationServiceImpl.salQuotationDO.currCode, SalQuotationServiceImpl.salQuotationDO.custCode, SalQuotationServiceImpl.salQuotationDO.custName, SalQuotationServiceImpl.salQuotationDO.custContactName, SalQuotationServiceImpl.salQuotationDO.custContactTel, SalQuotationServiceImpl.salQuotationDDO.itemCode, SalQuotationServiceImpl.salQuotationDDO.itemName, SalQuotationServiceImpl.salQuotationDDO.itemSpec, SalQuotationServiceImpl.salQuotationDDO.qty, SalQuotationServiceImpl.salQuotationDDO.uom, SalQuotationServiceImpl.salQuotationDDO.price, SalQuotationServiceImpl.salQuotationDDO.amt, SalQuotationServiceImpl.salQuotationDDO.taxRate, SalQuotationServiceImpl.salQuotationDDO.remark})).from((EntityPath)salQuotationDO)).leftJoin((EntityPath)salQuotationDDO)).on((Predicate)SalQuotationServiceImpl.salQuotationDDO.masId.eq(SalQuotationServiceImpl.salQuotationDO.id))).where(this.where(queryParam));
    }

    private void checkForSave(SalQuotationDetailRespVO saveVO) {
        Assert.notNull((Object)saveVO, (String)"\u4fdd\u5b58\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getQtCustType()), (String)"\u4fdd\u5b58\u6570\u636e\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getCustCode()), (String)"\u4fdd\u5b58\u6570\u636e\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getCustName()), (String)"\u4fdd\u5b58\u6570\u636e\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getContractCity()), (String)"\u4fdd\u5b58\u6570\u636e\u7701\u5e02\u533a\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getOuId()), (String)"\u4fdd\u5b58\u6570\u636e\u516c\u53f8\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getPayMethod()), (String)"\u4fdd\u5b58\u4ed8\u6b3e\u65b9\u5f0f\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getAgentEmpId()), (String)"\u4fdd\u5b58\u6570\u636e\u5ba2\u6237\u7ba1\u7406\u4e13\u5458\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getCustContactName()), (String)"\u4fdd\u5b58\u6570\u636e\u5ba2\u6237\u8054\u7cfb\u4eba\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getCustContactTel()), (String)"\u4fdd\u5b58\u6570\u636e\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getDemandTimespan()), (String)"\u4fdd\u5b58\u6570\u636e\u8981\u6c42\u53d1\u8d27\u65e5\u671f\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getDeliverMethod()), (String)"\u4fdd\u5b58\u6570\u636e\u8d27\u8fd0\u65b9\u6cd5\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public SalQuotationServiceImpl(RmiInvWhProviderService rmiInvWhProviderService, RmiOrgEmpService rmiOrgEmpService, RmiOrgOuService rmiOrgOuService, RmiOrgBuService rmiOrgBuService, SalQuotationDService salQuotationDService, RmiSysNextNumberService rmiSysNextNumberService, SalQuotationRepo salQuotationRepo, CrmCustRepoProc crmCustRepoProc, RmiCommonService rmiCommonService, RmiOrgAddrService rmiOrgAddrService, CrmCustService crmCustService, TransactionTemplate transactionTemplate, RmiPurPriceService rmiPurPriceService, RmiPriMainPriceService rmiPriMainPriceService, RmiCityCodeService rmiCityCodeService, BipCompanyManageRepoProc bipCompanyManageRepoProc, SysCurrencyRpcService sysCurrencyRpcService, ItmItemRpcService itemRpcService, WorkflowService workflowService, UdcProvider udcProvider) {
        this.rmiInvWhProviderService = rmiInvWhProviderService;
        this.rmiOrgEmpService = rmiOrgEmpService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiOrgBuService = rmiOrgBuService;
        this.salQuotationDService = salQuotationDService;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.salQuotationRepo = salQuotationRepo;
        this.crmCustRepoProc = crmCustRepoProc;
        this.rmiCommonService = rmiCommonService;
        this.rmiOrgAddrService = rmiOrgAddrService;
        this.crmCustService = crmCustService;
        this.transactionTemplate = transactionTemplate;
        this.rmiPurPriceService = rmiPurPriceService;
        this.rmiPriMainPriceService = rmiPriMainPriceService;
        this.rmiCityCodeService = rmiCityCodeService;
        this.bipCompanyManageRepoProc = bipCompanyManageRepoProc;
        this.sysCurrencyRpcService = sysCurrencyRpcService;
        this.itemRpcService = itemRpcService;
        this.workflowService = workflowService;
        this.udcProvider = udcProvider;
    }
}

