/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitesland.yst.production.order.param.SalDoDQueryDTO;
import com.elitesland.yst.production.order.param.SalDoDRPCRespDTO;
import com.elitesland.yst.production.order.param.SalSoDetailQueryDTO;
import com.elitesland.yst.production.order.param.SalSoDetailRespDTO;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.SalSoaService;
import com.elitesland.yst.production.sale.api.vo.param.pri.RmiDoDParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalSoaExportPageParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalSoaPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiDoDVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalSoaDRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalSoaExportPageVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalSoaRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.QSalSoaDO;
import com.elitesland.yst.production.sale.entity.SalSoaDDO;
import com.elitesland.yst.production.sale.entity.SalSoaDO;
import com.elitesland.yst.production.sale.repo.SalSoaDRepo;
import com.elitesland.yst.production.sale.repo.SalSoaDRepoProc;
import com.elitesland.yst.production.sale.repo.SalSoaRepo;
import com.elitesland.yst.production.sale.repo.SalSoaRepoProc;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoDRpcService;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Valid
public class SalSoaServiceImpl
extends BaseServiceImpl
implements SalSoaService {
    private static final Logger log = LoggerFactory.getLogger(SalSoaServiceImpl.class);
    private final SalSoaRepo salSoaRepo;
    private final SalSoaDRepo salSoaDRepo;
    private final SalSoaRepoProc salSoaRepoProc;
    private final SalSoaDRepoProc salSoaDRepoProc;
    private final RmiDoDRpcService rmiDoDRpcService;
    private final RmiCommonService rmiCommonService;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final RmiItemService rmiItemService;
    private final RmiOrderSalSoService rmiOrderSalSoService;
    @Autowired(required=false)
    private RedissonClient redissonClient;

    @SysCodeProc
    public PagingVO<SalSoaRespVO> query(SalSoaPageParam pagingParam) {
        JPAQuery<SalSoaRespVO> jpaQuery = this.salSoaRepoProc.select(pagingParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        if ("EXPORT_MARK".equals(pagingParam.getExportMark())) {
            Long total1 = total;
            pagingParam.setSize(Integer.valueOf(total1.intValue()));
        }
        PageRequest pageRequest = this.wrapperPageRequest(pagingParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, QSalSoaDO.salSoaDO);
        List result = jpaQuery.fetch();
        List<Long> masIds = result.stream().map(SalSoaRespVO::getId).collect(Collectors.toList());
        List soaDs = this.salSoaDRepoProc.findAllBymasIds(masIds).fetch();
        Set<String> currCodes = result.stream().map(r -> r.getCurrCode()).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        List<SysCurrencyRespDTO> currRpcResult = this.rmiCommonService.listByCodes(currCodes);
        List sodIds = soaDs.stream().filter(sod -> sod.getSoDId() != null).map(SalSoaDRespVO::getSoDId).distinct().collect(Collectors.toList());
        List allItemCodes = soaDs.stream().map(SalSoaDRespVO::getItemCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        ItmItemRpcDtoParam rpcParam = new ItmItemRpcDtoParam();
        rpcParam.setItemCodes(allItemCodes);
        Map<String, List> itemRpcDTOS = this.rmiItemService.findItemListByParam(rpcParam).stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, ItmItemRpcDTO::getItemCatePathName, (t1, t2) -> t1));
        if (sodIds.size() > 0) {
            SalSoDetailQueryDTO salSoDetailQueryDTO = new SalSoDetailQueryDTO();
            salSoDetailQueryDTO.setSoDIdList(sodIds);
            salSoDetailQueryDTO.setSize(Integer.valueOf(10000));
            ApiResult<PagingVO<SalSoDetailRespDTO>> apiResult = this.rmiOrderSalSoService.querySalSoDetail(salSoDetailQueryDTO);
            if (apiResult.getCode() != 200) {
                throw new BusinessException(apiResult.getMsg());
            }
            List sodList = ((PagingVO)apiResult.getData()).getRecords();
            soaDs.forEach(d -> sodList.stream().filter(sod -> d.getSoDId() != null && d.getSoDId().equals(sod.getSoDId())).forEach(sod -> {
                d.setApAmt(sod.getApAmt() == null ? BigDecimal.ZERO : sod.getApAmt());
                d.setPayedAmt(sod.getPayedAmt() == null ? BigDecimal.ZERO : sod.getPayedAmt());
                d.setPayingAmt(sod.getPayingAmt() == null ? BigDecimal.ZERO : sod.getPayingAmt());
                d.setOpenAmt(sod.getOpenAmt() == null ? BigDecimal.ZERO : sod.getOpenAmt());
                d.setInvedAmt(sod.getInvedAmt() == null ? BigDecimal.ZERO : sod.getInvedAmt());
                d.setInvingAmt(sod.getInvingAmt() == null ? BigDecimal.ZERO : sod.getInvingAmt());
                d.setNoinvAmt(sod.getNoinvAmt() == null ? BigDecimal.ZERO : sod.getNoinvAmt());
                d.setInvedQty(sod.getInvedQty() == null ? BigDecimal.ZERO : sod.getInvedQty());
                d.setInvingQty(sod.getInvingQty() == null ? BigDecimal.ZERO : sod.getInvingQty());
                d.setNoinvQty(sod.getNoinvQty() == null ? BigDecimal.ZERO : sod.getNoinvQty());
                List cateList = (List)itemRpcDTOS.get(d.getItemCode());
                d.setThirdCateName((String)cateList.get(2));
            }));
        }
        result.forEach(r -> {
            currRpcResult.stream().filter(c -> StrUtil.isNotBlank((CharSequence)r.getCurrCode()) && r.getCurrCode().equals(c.getCurrCode())).findFirst().ifPresent(curr -> r.setCurrName(curr.getCurrName()));
            ArrayList salSoaDRespVOS = new ArrayList();
            soaDs.forEach(soad -> {
                if (r.getId().equals(soad.getMasId())) {
                    salSoaDRespVOS.add(soad);
                }
            });
            r.setSalSoaDRespVOList(salSoaDRespVOS);
        });
        PagingVO pageRespVO = PagingVO.builder().total(total).records(result).build();
        return pageRespVO;
    }

    @SysCodeProc
    public SalSoaRespVO getById(Long id) {
        SalSoaPageParam pagingParam = new SalSoaPageParam();
        pagingParam.setId(id);
        List list = this.salSoaRepoProc.select(pagingParam).fetch();
        SalSoaRespVO salSoaRespVO = new SalSoaRespVO();
        if (list.size() <= 0) {
            throw new BusinessException("\u67e5\u8be2Id\u4e0d\u5b58\u5728");
        }
        salSoaRespVO = (SalSoaRespVO)list.get(0);
        List details = this.salSoaDRepoProc.findBymasId(salSoaRespVO.getId()).fetch();
        List dodIds = details.stream().map(SalSoaDRespVO::getDodId).distinct().collect(Collectors.toList());
        salSoaRespVO.setSalSoaDRespVOList(details);
        List comSFCList = this.comSaleFileInfoService.findFileByBusinessId("SAL_SOA", salSoaRespVO.getId());
        salSoaRespVO.setAttachFiles(comSFCList);
        return salSoaRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> save(SalSoaRespVO param) {
        SalSoaDO salSoaDO;
        try {
            salSoaDO = this.checkParam(param);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        String docNo = StringUtils.isEmpty((Object)salSoaDO) ? this.rmiSysNextNumberService.generateCode("yst-sale", "SA", new ArrayList<String>()) : salSoaDO.getDocNo();
        RLock rLock = this.redissonClient.getLock(docNo);
        try {
            boolean lock = rLock.tryLock(0L, 5L, TimeUnit.MINUTES);
            if (!lock) {
                throw new BusinessException("\u8ba2\u5355" + docNo + "\u6b63\u5728\u64cd\u4f5c\u4e2d");
            }
            this.insertOrUpdate(salSoaDO, param, docNo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
        finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> insertOrUpdate(SalSoaDO salSoaDO, SalSoaRespVO param, String docNo) {
        boolean isNew = false;
        if (StringUtils.isEmpty((Object)salSoaDO)) {
            isNew = true;
            salSoaDO = new SalSoaDO();
            BeanCopyUtil.beanCopy((Object)param, (Object)salSoaDO);
            salSoaDO.setDocNo(docNo);
            salSoaDO.setApplyDate(LocalDateTime.now());
            salSoaDO.setSoaStatus(UdcEnum.SAL_SOA_STATUS_10.getValueCode());
            salSoaDO.setSoaInvStatus(UdcEnum.SAL_SOA_INV_STATUS_10.getValueCode());
            salSoaDO.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_10.getValueCode());
        } else {
            BeanCopyUtil.beanCopy((Object)param, (Object)salSoaDO);
            this.salSoaDRepo.deleteAllByMasId(salSoaDO.getId());
        }
        salSoaDO.setInvApplyAmt(salSoaDO.getSoaAmt());
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u5f02\u5e38");
        }
        salSoaDO.setCreateUserId(currentUserDTO.getDetail().getId());
        salSoaDO.setCreator(currentUserDTO.getDetail().getUsername());
        salSoaDO.setSecOuId(param.getOuId());
        salSoaDO.setSecBuId(param.getBuId());
        salSoaDO.setSecUserId(param.getApplyEmpId());
        this.salSoaRepo.save(salSoaDO);
        Long masId = salSoaDO.getId();
        ArrayList detailList = new ArrayList();
        ArrayList idList = new ArrayList();
        param.getSalSoaDRespVOList().forEach(detail -> {
            SalSoaDDO salSoaDDO = new SalSoaDDO();
            BeanCopyUtil.beanCopy((Object)detail, (Object)salSoaDDO);
            salSoaDDO.setMasId(masId);
            salSoaDDO.setSecOuId(param.getOuId());
            salSoaDDO.setSecBuId(param.getBuId());
            salSoaDDO.setSecUserId(param.getApplyEmpId());
            detailList.add(salSoaDDO);
            idList.add(detail.getDodId());
        });
        this.salSoaDRepo.saveAll(detailList);
        if (param.getAttachFiles() != null && param.getAttachFiles().size() > 0) {
            this.comSaleFileInfoService.comSaleFileHardSave("SAL_SOA", salSoaDO.getId(), param.getAttachFiles());
        }
        if (!isNew || idList.size() > 0) {
            // empty if block
        }
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> affirm(Long id) {
        Optional optional = this.salSoaRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        SalSoaDO salSoaDO = (SalSoaDO)optional.get();
        if (!salSoaDO.getSoaStatus().equals(UdcEnum.SAL_SOA_STATUS_10.getValueCode())) {
            throw new BusinessException("\u53ea\u6709\u65b0\u5efa\u7c7b\u578b\u7684\u5355\u636e\u53ef\u4ee5\u786e\u8ba4");
        }
        salSoaDO.setSoaStatus(UdcEnum.SAL_SOA_STATUS_20.getValueCode());
        this.salSoaRepo.save(salSoaDO);
        return ApiResult.ok();
    }

    @SysCodeProc
    public PagingVO<RmiDoDVO> selectDo(RmiDoDParam param) {
        SalDoDQueryDTO salDoDQueryDTO = this.getSalDoDQueryDTO(param);
        salDoDQueryDTO.setSoaStatus("10");
        salDoDQueryDTO.setDocStatus("DONE");
        PagingVO<SalDoDRPCRespDTO> salDoDRPCRespDTOPagingVO = this.rmiDoDRpcService.queryDodForInvoice(salDoDQueryDTO);
        List data = salDoDRPCRespDTOPagingVO.getRecords();
        Set<String> currCodes = data.stream().map(r -> r.getCurrCode()).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        List<SysCurrencyRespDTO> currRpcResult = this.rmiCommonService.listByCodes(currCodes);
        List itemCodes = data.stream().map(r -> r.getItemCode()).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
        itemRpcDtoParam.setItemCodes(itemCodes);
        List<ItmItemRpcDTO> itemRpcResult = this.rmiItemService.findItemListByParam(itemRpcDtoParam);
        List list = data.stream().map(l -> {
            RmiDoDVO rmiDoDVO = new RmiDoDVO();
            BeanCopyUtil.beanCopy((Object)l, (Object)rmiDoDVO);
            if (l.getDocCls() != null && l.getDocCls().equals("RDO")) {
                rmiDoDVO.setConfirmAmt(rmiDoDVO.getConfirmAmt() == null ? BigDecimal.ZERO : rmiDoDVO.getConfirmAmt().abs().negate());
                rmiDoDVO.setSoAmt(rmiDoDVO.getSoAmt() == null ? BigDecimal.ZERO : rmiDoDVO.getSoAmt().abs().negate());
                rmiDoDVO.setConfirmNetAmt(rmiDoDVO.getConfirmNetAmt() == null ? BigDecimal.ZERO : rmiDoDVO.getConfirmNetAmt().abs().negate());
                rmiDoDVO.setConfirmTaxAmt(rmiDoDVO.getConfirmTaxAmt() == null ? BigDecimal.ZERO : rmiDoDVO.getConfirmTaxAmt().abs().negate());
                rmiDoDVO.setSoNetAmt(rmiDoDVO.getSoNetAmt() == null ? BigDecimal.ZERO : rmiDoDVO.getSoNetAmt().abs().negate());
                rmiDoDVO.setSoTaxAmt(rmiDoDVO.getSoTaxAmt() == null ? BigDecimal.ZERO : rmiDoDVO.getSoTaxAmt().abs().negate());
                rmiDoDVO.setQty(rmiDoDVO.getQty() == null ? BigDecimal.ZERO : rmiDoDVO.getQty().abs().negate());
                rmiDoDVO.setConfirmQty(rmiDoDVO.getConfirmQty() == null ? BigDecimal.ZERO : rmiDoDVO.getConfirmQty().abs().negate());
                rmiDoDVO.setSoQty(rmiDoDVO.getSoQty() == null ? BigDecimal.ZERO : rmiDoDVO.getSoQty().abs().negate());
            }
            currRpcResult.stream().filter(c -> StrUtil.isNotBlank((CharSequence)rmiDoDVO.getCurrCode()) && rmiDoDVO.getCurrCode().equals(c.getCurrCode())).findFirst().ifPresent(curr -> rmiDoDVO.setCurrName(curr.getCurrName()));
            itemRpcResult.stream().filter(c -> StrUtil.isNotBlank((CharSequence)rmiDoDVO.getItemCode()) && rmiDoDVO.getItemCode().equals(c.getItemCode())).findFirst().ifPresent(curr -> {
                rmiDoDVO.setItemId(curr.getId());
                rmiDoDVO.setTaxClass(curr.getTaxType());
                rmiDoDVO.setThirdCateName((String)curr.getItemCatePathName().get(2));
            });
            return rmiDoDVO;
        }).collect(Collectors.toList());
        PagingVO pageRespVO = PagingVO.builder().total(salDoDRPCRespDTOPagingVO.getTotal()).records(list).build();
        return pageRespVO;
    }

    public SalDoDQueryDTO getSalDoDQueryDTO(RmiDoDParam param) {
        SalDoDQueryDTO salDoDQueryDTO = new SalDoDQueryDTO();
        if (!StringUtils.isEmpty((Object)param.getDocNo())) {
            salDoDQueryDTO.setDocNo(param.getDocNo());
        }
        if (!StringUtils.isEmpty((Object)param.getCustCode())) {
            salDoDQueryDTO.setCustCode(param.getCustCode());
        }
        if (!StringUtils.isEmpty((Object)param.getCustId())) {
            salDoDQueryDTO.setCustId(param.getCustId());
        }
        if (!StringUtils.isEmpty((Object)param.getDocTimeStart())) {
            salDoDQueryDTO.setDocTimeStart(param.getDocTimeStart());
        }
        if (!StringUtils.isEmpty((Object)param.getDocTimeEnd())) {
            salDoDQueryDTO.setDocTimeEnd(param.getDocTimeEnd());
        }
        if (!StringUtils.isEmpty((Object)param.getConfirmTimeStart())) {
            salDoDQueryDTO.setConfirmTimeStart(param.getConfirmTimeStart());
        }
        if (!StringUtils.isEmpty((Object)param.getConfirmTimeEnd())) {
            salDoDQueryDTO.setConfirmTimeEnd(param.getConfirmTimeEnd());
        }
        if (!StringUtils.isEmpty((Object)param.getDocStatus())) {
            salDoDQueryDTO.setDocStatus(param.getDocStatus());
        }
        if (!StringUtils.isEmpty((Object)param.getSoaStatus())) {
            salDoDQueryDTO.setSoaStatus(param.getSoaStatus());
        }
        if (!StringUtils.isEmpty((Object)param.getSize())) {
            salDoDQueryDTO.setSize(param.getSize());
        }
        if (!StringUtils.isEmpty((Object)param.getCurrent())) {
            if (param.getCurrent() > 0) {
                salDoDQueryDTO.setCurrent(Integer.valueOf(param.getCurrent() - 1));
            } else {
                salDoDQueryDTO.setCurrent(param.getCurrent());
            }
        }
        return salDoDQueryDTO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> obsolete(Long id) {
        Optional optional = this.salSoaRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        SalSoaDO salSoaDO = (SalSoaDO)optional.get();
        if (salSoaDO.getSoaStatus().equals(UdcEnum.SAL_SOA_STATUS_20.getValueCode())) {
            throw new BusinessException("\u5ba2\u6237\u5df2\u786e\u8ba4\u7684\u5355\u636e\u4e0d\u80fd\u4f5c\u5e9f");
        }
        salSoaDO.setSoaStatus(UdcEnum.SAL_SOA_STATUS_30.getValueCode());
        this.salSoaRepo.save(salSoaDO);
        List list = this.salSoaDRepoProc.findBymasId(salSoaDO.getId()).fetch();
        List idList = list.stream().map(SalSoaDRespVO::getDodId).collect(Collectors.toList());
        if (idList.size() > 0) {
            // empty if block
        }
        return ApiResult.ok();
    }

    public PagingVO<SalSoaExportPageVO> searchForSalsoaExport(SalSoaExportPageParam pageParam) {
        LocalDateTime timeS = LocalDateTime.now();
        log.info("\u5bf9\u8d26\u5355\u5bfc\u51fa\u6570\u636e\u5904\u7406......start:{}", (Object)timeS);
        ArrayList<SalSoaPageParam> salSoaPageParams = new ArrayList<SalSoaPageParam>();
        if (!CollectionUtils.isEmpty((Collection)pageParam.getIds())) {
            pageParam.getIds().forEach(t -> {
                SalSoaPageParam salSoaPageParam = new SalSoaPageParam();
                this.salExportParm(salSoaPageParam, pageParam);
                salSoaPageParam.setId(t);
                salSoaPageParams.add(salSoaPageParam);
            });
        } else {
            SalSoaPageParam salSoaPageParam = new SalSoaPageParam();
            this.salExportParm(salSoaPageParam, pageParam);
            salSoaPageParams.add(salSoaPageParam);
        }
        log.info("\u5bf9\u8d26\u5355\u5bfc\u51fa\u6570\u636e\u5904\u7406......\u67e5\u8be2\u53c2\u6570:{}", salSoaPageParams);
        ArrayList<SalSoaRespVO> salSoaRespVOS = new ArrayList<SalSoaRespVO>();
        if (!CollectionUtils.isEmpty(salSoaPageParams)) {
            salSoaPageParams.forEach(parm -> {
                parm.setExportMark("EXPORT_MARK");
                PagingVO<SalSoaRespVO> query = this.query((SalSoaPageParam)parm);
                List records = query.getRecords();
                records.forEach(r -> salSoaRespVOS.add((SalSoaRespVO)r));
            });
        }
        log.info("\u5bf9\u8d26\u5355\u5bfc\u51fa\u6570\u636e\u5904\u7406......\u67e5\u8be2\u7ed3\u679c1:{}", salSoaRespVOS);
        long total = salSoaRespVOS.size();
        List<SalSoaExportPageVO> salSoaExportPageVOS = this.convertSalSoaRespVOForExport(salSoaRespVOS);
        LocalDateTime timeE = LocalDateTime.now();
        log.info("\u5bf9\u8d26\u5355\u5bfc\u51fa\u6570\u636e\u5904\u7406......end:{}", (Object)timeE);
        return PagingVO.builder().total(total).records(salSoaExportPageVOS).build();
    }

    private List<SalSoaExportPageVO> convertSalSoaRespVOForExport(List<SalSoaRespVO> pageResult) {
        ArrayList<SalSoaExportPageVO> salSoaExportPageVOS = new ArrayList<SalSoaExportPageVO>();
        log.info("\u5bf9\u8d26\u5355\u5bfc\u51fa\u6570\u636e\u5904\u7406......\u67e5\u8be2\u7ed3\u679c3:{}", pageResult);
        pageResult.forEach(page -> {
            List salSoaDRespVOList = page.getSalSoaDRespVOList();
            salSoaDRespVOList.forEach(t -> {
                SalSoaExportPageVO sal = new SalSoaExportPageVO();
                sal.setDocNo(page.getDocNo());
                sal.setSoaDate(page.getSoaDate());
                sal.setOuName(page.getOuName());
                sal.setCustName(page.getCustName());
                sal.setCustPic(page.getCustPic());
                sal.setCustPicTel(page.getCustPicTel());
                sal.setSoaAmt(page.getSoaAmt());
                sal.setApplyName(page.getApplyName());
                sal.setApplyEmpTel(page.getApplyEmpTel());
                sal.setLineNo(t.getLineNo());
                sal.setDodId(t.getDodId());
                sal.setDocTime(t.getDocTime());
                sal.setConfirmTime(t.getConfirmTime());
                sal.setItemName(t.getItemName());
                sal.setItemSpec(t.getItemSpec());
                sal.setDoQty2(t.getDoQty2());
                sal.setConfirmQty(t.getConfirmQty());
                sal.setConfirmAmt(t.getConfirmAmt());
                sal.setSoUom(t.getSoUom());
                if (t.getConfirmAmt() != null && t.getConfirmQty() != null) {
                    BigDecimal doPrice = t.getConfirmQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : t.getConfirmAmt().divide(t.getConfirmQty());
                    sal.setDoPrice(doPrice);
                }
                salSoaExportPageVOS.add(sal);
            });
        });
        log.info("\u5bf9\u8d26\u5355\u5bfc\u51fa\u6570\u636e\u5904\u7406......\u521b\u5efa\u5bfc\u51fa\u6570\u636e:{}", salSoaExportPageVOS);
        return salSoaExportPageVOS;
    }

    public void salExportParm(SalSoaPageParam page, SalSoaExportPageParam export) {
        if (!StringUtils.isEmpty((Object)export.getDocNo())) {
            page.setDocNo(export.getDocNo());
        }
        if (!StringUtils.isEmpty((Object)export.getSoaDateStart())) {
            page.setSoaDateStart(export.getSoaDateStart());
        }
        if (!StringUtils.isEmpty((Object)export.getSoaDateEnd())) {
            page.setSoaDateEnd(export.getSoaDateEnd());
        }
        if (!StringUtils.isEmpty((Object)export.getOuId())) {
            page.setOuId(export.getOuId());
        }
        if (!StringUtils.isEmpty((Object)export.getOuCode())) {
            page.setOuCode(export.getOuCode());
        }
        if (!StringUtils.isEmpty((Object)export.getCustName())) {
            page.setCustName(export.getCustName());
        }
        if (!StringUtils.isEmpty((Object)export.getApplyName())) {
            page.setApplyName(export.getApplyName());
        }
        if (!StringUtils.isEmpty((Object)export.getSoaStatus())) {
            page.setSoaStatus(export.getSoaStatus());
        }
        if (!StringUtils.isEmpty((Object)export.getSoaReceiptStatus())) {
            page.setSoaReceiptStatus(export.getSoaReceiptStatus());
        }
        if (!StringUtils.isEmpty((Object)export.getSoaInvStatus())) {
            page.setSoaInvStatus(export.getSoaInvStatus());
        }
        if (!StringUtils.isEmpty((Object)export.getDoDocNo())) {
            page.setDoDocNo(export.getDoDocNo());
        }
        if (!StringUtils.isEmpty((Object)export.getSoNo())) {
            page.setSoNo(export.getSoNo());
        }
        if (!StringUtils.isEmpty((Object)export.getTaxRate())) {
            page.setTaxRate(export.getTaxRate());
        }
    }

    private SalSoaDO checkParam(SalSoaRespVO param) {
        if (StringUtils.isEmpty((Object)param.getSalSoaDRespVOList())) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)param.getOuId())) {
            throw new BusinessException("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)param.getBuId())) {
            throw new BusinessException("\u9500\u552e\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)param.getApplyEmpId())) {
            throw new BusinessException("\u7533\u8bf7\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)param.getId())) {
            return null;
        }
        Optional alterOptional = this.salSoaRepo.findById(param.getId());
        if (alterOptional.isEmpty()) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25,\u67e5\u8be2\u4e0d\u5230\u8be5id\u6570\u636e");
        }
        return (SalSoaDO)alterOptional.get();
    }

    public String getApplyCode() {
        String time = "SA" + FastDateFormat.getInstance((String)"yyMMdd").format(new Date());
        int count = this.salSoaRepo.countByDocNoLike(time + "%");
        String applyCode = time + String.format("%07d", count);
        return applyCode;
    }

    public SalSoaServiceImpl(SalSoaRepo salSoaRepo, SalSoaDRepo salSoaDRepo, SalSoaRepoProc salSoaRepoProc, SalSoaDRepoProc salSoaDRepoProc, RmiDoDRpcService rmiDoDRpcService, RmiCommonService rmiCommonService, ComSaleFileInfoService comSaleFileInfoService, RmiSysNextNumberService rmiSysNextNumberService, RmiItemService rmiItemService, RmiOrderSalSoService rmiOrderSalSoService) {
        this.salSoaRepo = salSoaRepo;
        this.salSoaDRepo = salSoaDRepo;
        this.salSoaRepoProc = salSoaRepoProc;
        this.salSoaDRepoProc = salSoaDRepoProc;
        this.rmiDoDRpcService = rmiDoDRpcService;
        this.rmiCommonService = rmiCommonService;
        this.comSaleFileInfoService = comSaleFileInfoService;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.rmiItemService = rmiItemService;
        this.rmiOrderSalSoService = rmiOrderSalSoService;
    }
}

