/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.dto.BipItemDTO;
import com.elitesland.yst.production.sale.api.dto.BipItemSkuDTO;
import com.elitesland.yst.production.sale.api.service.shop.BipItemService;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.event.ItemStockUpdateEvent;
import com.elitesland.yst.production.sale.repo.shop.BipItemCategoryRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemExtRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemExtRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemPicRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemPicRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BipItemServiceImpl
extends BaseServiceImpl
implements BipItemService {
    private static final Logger log = LoggerFactory.getLogger(BipItemServiceImpl.class);
    private final BipItemRepo itemRepo;
    private final BipItemRepoProc itemRepoProc;
    private final BipItemExtRepo itemExtRepo;
    private final BipItemExtRepoProc itemExtRepoProc;
    private final BipItemPicRepo itemPicRepo;
    private final BipItemPicRepoProc itemPicRepoProc;
    private final BipItemSkuRepo itemSkuRepo;
    private final BipItemSkuRepoProc itemSkuRepoProc;
    private final BipItemCategoryRepoProc itemCategoryRepoProc;
    private static final BipItemConvert CONVERT = BipItemConvert.INSTANCE;
    private static final QBipItemDO ITEM_DO = QBipItemDO.bipItemDO;
    private final RedissonClient redissonClient;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateStock(Long skuId, Integer stock) {
        try {
            this.stockLockAndUpdate(skuId, stock, this.itemSkuRepoProc::updateStock);
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u5546\u54c1\u5e93\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (Throwable)e);
        }
        this.publishEventSync(new ItemStockUpdateEvent(this, skuId, stock > 0));
        return ApiResult.ok((Object)skuId);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> incrementStock(Long skuId, Integer increment) {
        try {
            this.stockLockAndUpdate(skuId, increment, this.itemSkuRepoProc::incrementStock);
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u5546\u54c1\u5e93\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (Throwable)e);
        }
        this.publishEventSync(new ItemStockUpdateEvent(this, skuId, increment > 0));
        return ApiResult.ok((Object)skuId);
    }

    public ApiResult<List<BipItemSkuDTO>> querySku(List<Long> skuIds) {
        List<BipItemSkuDTO> skuList = this.listSku(skuIds);
        return ApiResult.ok(skuList);
    }

    public ApiResult<List<BipItemDTO>> querySkuWithItem(List<Long> skuIds) {
        List skus = this.itemSkuRepo.findAllById(skuIds);
        if (skus.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List itemIds = skus.parallelStream().map(BipItemSkuDO::getBipItemId).collect(Collectors.toList());
        List items = this.itemRepo.findAllById(itemIds);
        List<BipItemDTO> itemDTOs = this.convertItem(items, skus);
        return ApiResult.ok(itemDTOs);
    }

    public ApiResult<List<BipItemDTO>> queryItem(List<Long> itemIds) {
        List<BipItemDTO> items = this.listItem(itemIds, true);
        return ApiResult.ok(items);
    }

    public ApiResult<List<BipItemDTO>> queryItemWithoutSku(List<Long> itemIds) {
        List<BipItemDTO> items = this.listItem(itemIds, false);
        return ApiResult.ok(items);
    }

    private List<BipItemDTO> listItem(List<Long> itemIds, boolean withSku) {
        List items = this.itemRepo.findAllById(itemIds);
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        List<BipItemSkuDO> skus = withSku ? this.itemSkuRepoProc.queryByBipItemId(itemIds) : null;
        return this.convertItem(items, skus);
    }

    private List<BipItemDTO> convertItem(List<BipItemDO> items, List<BipItemSkuDO> skus) {
        Map<Long, List<BipItemSkuDTO>> skuMap = null;
        if (CollUtil.isNotEmpty(skus)) {
            skuMap = this.convertSku(skus).stream().collect(Collectors.groupingBy(BipItemSkuDTO::getBipItemId));
        }
        Map<Long, List<BipItemSkuDTO>> finalSkuMap = skuMap;
        return items.stream().map(t -> {
            BipItemDTO dto = CONVERT.do2DTO((BipItemDO)t);
            if (finalSkuMap != null) {
                dto.setSkuList((List)finalSkuMap.get(t.getId()));
            }
            return dto;
        }).collect(Collectors.toList());
    }

    private List<BipItemSkuDTO> listSku(List<Long> skuIds) {
        List skus = this.itemSkuRepo.findAllById(skuIds);
        return this.convertSku(skus);
    }

    private List<BipItemSkuDTO> convertSku(List<BipItemSkuDO> skus) {
        if (skus.isEmpty()) {
            return Collections.emptyList();
        }
        return skus.stream().sorted(Comparator.comparingInt(BipItemSkuDO::getSortNo)).map(t -> {
            BipItemSkuDTO dto = CONVERT.skuDO2DTO((BipItemSkuDO)t);
            dto.setAttrList(this.convert2List(t.getAttr(), BipItemSkuDTO.Attr.class));
            return dto;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stockLockAndUpdate(Long skuId, Integer value, BiConsumer<Long, Integer> consumer) throws Exception {
        RLock lock = null;
        try {
            lock = this.redissonClient.getLock("yst_sale_item_stock_" + skuId.toString());
            if (lock.tryLock(1L, 1L, TimeUnit.MINUTES)) {
                consumer.accept(skuId, value);
                lock.unlock();
            }
        }
        finally {
            if (lock != null && lock.isLocked()) {
                lock.unlock();
            }
        }
    }

    public BipItemServiceImpl(BipItemRepo itemRepo, BipItemRepoProc itemRepoProc, BipItemExtRepo itemExtRepo, BipItemExtRepoProc itemExtRepoProc, BipItemPicRepo itemPicRepo, BipItemPicRepoProc itemPicRepoProc, BipItemSkuRepo itemSkuRepo, BipItemSkuRepoProc itemSkuRepoProc, BipItemCategoryRepoProc itemCategoryRepoProc, RedissonClient redissonClient) {
        this.itemRepo = itemRepo;
        this.itemRepoProc = itemRepoProc;
        this.itemExtRepo = itemExtRepo;
        this.itemExtRepoProc = itemExtRepoProc;
        this.itemPicRepo = itemPicRepo;
        this.itemPicRepoProc = itemPicRepoProc;
        this.itemSkuRepo = itemSkuRepo;
        this.itemSkuRepoProc = itemSkuRepoProc;
        this.itemCategoryRepoProc = itemCategoryRepoProc;
        this.redissonClient = redissonClient;
    }
}

