/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackToOmsServicei;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.dto.save.BipOrderBackRpcDto;
import com.elitesland.yst.production.sale.entity.BipOrderBackDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.BipSendOrderErrLogRepo;
import com.elitesland.yst.production.sale.service.BipOrderBackRpcService;
import com.elitesland.yst.production.sale.service.shop.BipOrderBackServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/cloudt/sale/orderback"})
public class BipOrderBackRpcServiceImpl
implements BipOrderBackRpcService {
    private static final Logger log = LoggerFactory.getLogger(BipOrderBackRpcServiceImpl.class);
    @Autowired
    private BipOrderBackRepo bipOrderBackRepo;
    @Autowired
    private BipOrderBackRepoProc bipOrderBackRepoProc;
    @Autowired
    private BipOrderBackServiceImpl bipOrderBackService;
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipSendOrderErrLogRepo bipSendOrderErrLogRepo;
    @Autowired
    private BipOrderBackToOmsServicei bipOrderBackToOmsServicei;

    @Override
    public ApiResult updateOrderBackStatus(List<BipOrderBackRpcDto> bipOrderBackRpcDtos) {
        log.info("\u8c03\u7528\u901a\u8fc7\u6216\u8005\u9a73\u56de\u5ba1\u6279\u7684\u53c2\u6570:----" + JSON.toJSONString(bipOrderBackRpcDtos));
        ArrayList<BipOrderBackDO> bipOrderBackDOS = new ArrayList<BipOrderBackDO>();
        ArrayList<String> docNos = new ArrayList<String>();
        for (BipOrderBackRpcDto bipOrderBackRpcDto : bipOrderBackRpcDtos) {
            JSONObject jsonObject = new JSONObject();
            if (bipOrderBackRpcDto.getDocNo() == null) {
                throw new BusinessException("\u4e3b\u8868ID\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (StringUtils.isBlank((CharSequence)bipOrderBackRpcDto.getStatus())) {
                throw new BusinessException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!---");
            }
            log.info("\u67e5\u8be2\u9000\u8d27\u5355\u4fe1\u606f:----");
            BipOrderBackDO bipOrderBackDO = this.bipOrderBackRepoProc.findOrderBackByDocNo(bipOrderBackRpcDto.getDocNo());
            log.info("\u9000\u8d27\u5355\u7684\u4fe1\u606f" + JSON.toJSONString((Object)bipOrderBackDO));
            bipOrderBackDO.setStatus(bipOrderBackRpcDto.getStatus());
            log.info("\u8bbe\u7f6e\u9000\u8d27\u5355\u72b6\u6001:----");
            if (bipOrderBackDO.getOrderId() == null) {
                throw new BusinessException("\u9000\u8d27\u5355\u672a\u5173\u8054\u8ba2\u5355");
            }
            log.info("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f:----");
            BipOrderDO bipOrderDo = (BipOrderDO)this.bipOrderRepo.findById(bipOrderBackDO.getOrderId()).get();
            log.info("\u8ba2\u5355\u4fe1\u606f:----" + JSON.toJSONString((Object)bipOrderDo));
            if ("WP".equals(bipOrderBackRpcDto.getStatus())) {
                log.info("\u9000\u6b3e\u4e2d\u72b6\u6001:----");
                if (UdcEnum.SO_BACK_TYPE_10.getValueCode().equals(bipOrderBackDO.getBackType()) || UdcEnum.SO_BACK_TYPE_20.getValueCode().equals(bipOrderBackDO.getBackType()) || UdcEnum.SO_BACK_TYPE_30.equals(bipOrderBackDO.getBackType())) {
                    log.info("\u9500\u552e\u8ba2\u5355\u9000\u8d27\u7c7b\u578b\u4e3a10\u6216\u800520");
                    if ("online".equals(bipOrderDo.getPayMethodName())) {
                        log.info("\u662f\u5728\u7ebf\u8ba2\u5355");
                        docNos.add(bipOrderBackRpcDto.getDocNo());
                        bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_DONE.getValueCode());
                    }
                }
            }
            bipOrderBackDOS.add(bipOrderBackDO);
        }
        log.info("\u9000\u8d27\u5355\u6570\u636e:---" + JSON.toJSONString(bipOrderBackDOS));
        this.bipOrderBackRepo.saveAll(bipOrderBackDOS);
        if (null == docNos || !docNos.isEmpty()) {
            // empty if block
        }
        return ApiResult.ok();
    }
}

