package com.elitesland.yst.production.sale.config.cas;

import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;

import java.util.List;

/**
 * 用户来源服务.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/29
 */
public interface UserSourceService {

    /**
     * 根据用户账号获取用户信息
     *
     * @param username 用户账号
     * @return 用户信息
     */
    SysUserDTO loadUserByUsername(String username);

    /**
     * 根据用户账号获取用户信息
     *
     * @param mobile 手机号
     * @return 用户信息
     */
    SysUserDTO loadUserByMobile(String mobile);

    SysUserDTO loadUserById(Long userId);

    /**
     * 查询待同步的用户列表
     *
     * @param size 查询数量
     * @return 用户列表
     */
    List<AuthUserDTO> queryUser(int size);

    /**
     * 更新本地的统一身份认证用户ID
     *
     * @param username 用户账号
     * @param userId   统一身份认证服务的用户ID
     */
    void updateCasUserId(String username, long userId);
}
