package com.elitesland.yst.production.sale.config.cas.support;

import com.elitescloud.cloudt.authorization.sdk.cas.UserSourceProvider;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitesland.yst.production.sale.config.cas.UserSourceService;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 用户同步provider.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/29
 */
public class UserSyncProvider implements UserSourceProvider {

    private final UserSourceService userSourceService;

    public UserSyncProvider(UserSourceService userSourceService) {
        this.userSourceService = userSourceService;
    }

    /**
     * 查询待同步的账号
     *
     * @param size 查询数量
     * @return 账号列表
     */
    @Override
    public List<AuthUserDTO> queryUser(int size) {
        if (userSourceService == null) {
            return Collections.emptyList();
        }
        return userSourceService.queryUser(size);
    }

    /**
     * 同步成功后的回调
     * <p>
     * 用来将认证服务的用户ID回写到本地
     *
     * @param map username与id的关联
     */
    @Override
    public void successCallback(Map<String, Long> map) {
        if (userSourceService == null) {
            return;
        }

        for (Map.Entry<String, Long> entry : map.entrySet()) {
            userSourceService.updateCasUserId(entry.getKey(), entry.getValue());
        }
    }
}
