package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipInvService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvViewAndDownParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipInvVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Joker (Xing Shixiang)
 * @since 2021-09-06 13:48:05
 */
@RestController
@RequestMapping("/bip/inv")
@Api(value = "发票", tags = {"小程序-发票"})
@RequiredArgsConstructor
public class BipInvController {

    private final BipInvService bipInvService;

    @PostMapping(value = "/create")
    @ApiOperation(value = "(小程序端)开票并保存信息到数据库")
    @ApiOperationSupport(order = 1)
    public ApiResult<List<String>> create(@RequestBody BipInvCreateParam param) {
        return bipInvService.createInv(param);
    }
    @PostMapping(value = "/FindAllByID")
    @ApiOperation(value = "(小程序端)根据userID分页查询所有发票")
    @ApiOperationSupport(order = 2)
    public ApiResult<PagingVO<BipInvVO>> queryByUserId(@RequestBody BipInvQueryParam param) {
        return ApiResult.ok(bipInvService.appFindAll(param));
    }

    @GetMapping(value = "/findByInvId/{invId}")
    @ApiOperation(value = "根据InvId查询发票信息")
    @ApiOperationSupport(order = 3)
    public ApiResult<BipInvVO> query(@PathVariable Long invId) {
        return ApiResult.ok(bipInvService.findByInvId(invId));
    }

    @PostMapping(value = "/findAll")
    @ApiOperation(value = "(管理端)根据条件分页查询所有发票")
    @ApiOperationSupport(order = 4)
    public ApiResult<PagingVO<BipInvVO>> findAllByParam(@RequestBody BipInvQueryParam param) {
        return ApiResult.ok(bipInvService.findAllByParam(param));
    }
    @GetMapping(value = "/findAll/{orderId}")
    @ApiOperation(value = "根据订单id查该订单下的发票")
    @ApiOperationSupport(order = 5)
    public ApiResult<List<BipInvVO>> findInvByOrderId(@PathVariable Long orderId) {
        return ApiResult.ok(bipInvService.findInvByOrderId(orderId));
    }
    @GetMapping(value = "/creditInv/{orderId}")
    @ApiOperation(value = "红冲并开具新的发票")
    @ApiOperationSupport(order = 6)
    public ApiResult<Long> creditInv(@PathVariable Long orderId) {
        return ApiResult.ok(bipInvService.creditInv(orderId));
    }

    @GetMapping(value = "/uReditInv/{orderId}")
    @ApiOperation(value = "红冲并更改订单标记")
    @ApiOperationSupport(order = 6)
    public ApiResult<Long> uReditInv(@PathVariable Long orderId) {
        return ApiResult.ok(bipInvService.uReditInv(orderId));
    }

    @GetMapping(value = "/send/{to}/{invId}")
    @ApiOperation(value = "发送邮件")
    @ApiOperationSupport(order = 7)
    public ApiResult<Long> sendEmail(@PathVariable String to , @PathVariable Long invId ) {
        return bipInvService.sendEmail(to,invId);
    }
    @PostMapping(value = "/viewAndDownload/invoice")
    @ApiOperation(value = "查看并下载发票")
    @ApiOperationSupport(order = 8)
    public ApiResult<List<String>> viewAndDownload(@RequestBody BipInvViewAndDownParam bipInvViewAndDownParam){
        return bipInvService.viewAndDownload(bipInvViewAndDownParam);
    }

    @PostMapping(value = "/findInvByInvSerialNum/{invSerialNum}")
    @ApiOperation(value = "根据发票流水号查看发票")
    @ApiOperationSupport(order = 9)
    public ApiResult<String> findInvByInvSerialNum(@PathVariable String invSerialNum){
        return bipInvService.findInvByInvSerialNum(invSerialNum);
    }

}


