package com.elitesland.yst.production.sale.convert.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftDSaveVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftSaveVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktGiftSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountGiftRespVO;
import com.elitesland.yst.production.sale.core.mapstruct.CustomMapperConfig;
import com.elitesland.yst.production.sale.entity.MktDiscountGiftDDO;
import com.elitesland.yst.production.sale.entity.MktDiscountGiftDO;
import com.elitesland.yst.production.sale.entity.MktGiftDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 满减赠促销对象转换类
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@Mapper(config = CustomMapperConfig.class)
public interface MktDiscountGiftConvert {

    MktDiscountGiftConvert INSTANCE = Mappers.getMapper(MktDiscountGiftConvert.class);

    /**
     * doToVo
     *
     * @param mktDiscountGiftDO 满减赠促销对象主表do
     * @return 满减赠促销对象主表Vo
     */
    MktDiscountGiftRespVO doToVo(MktDiscountGiftDO mktDiscountGiftDO);

    /**
     * saveVoTodo(主表转换)
     *
     * @param mktDiscountGiftSaveVO 满减赠促销保存对象主表vo
     * @return 满减赠促销对象主表do
     */
    MktDiscountGiftDO saveVoToDo(MktDiscountGiftSaveVO mktDiscountGiftSaveVO);

    /**
     * dsaveVoToDo(明细表转换)
     *
     * @param mktDiscountGiftSaveDVO 满减赠促销保存对象明细表vo
     * @return 满减赠促销对象明细表do
     */
    MktDiscountGiftDDO dsaveVoToDo(MktDiscountGiftDSaveVO mktDiscountGiftSaveDVO);

    /**
     * gsaveVoToDo(赠品明细表转换)
     *
     * @param mktGiftSaveVO 满减赠促销保存对象赠品明细表vo
     * @return 满减赠促销对象赠品明细表do
     */
    MktGiftDO gsaveVoToDo(MktGiftSaveVO mktGiftSaveVO);
}
